/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.wireprotocol;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Comparator;
import org.netbeans.lib.profiler.client.RuntimeProfilingPoint;
import org.netbeans.lib.profiler.wireprotocol.Command;

public class InitiateInstrumentationCommand
extends Command {
    private String[] classNames;
    private String[] profilingPointHandlers;
    private int[] profilingPointIDs;
    private String[] profilingPointInfos;
    private boolean instrSpawnedThreads;
    private boolean startProfilingPointsActive;
    private int instrType;

    public InitiateInstrumentationCommand(int n, String string, boolean bl, boolean bl2) {
        super(13);
        this.instrType = n;
        if (string == null) {
            string = " ";
        }
        this.classNames = new String[1];
        this.classNames[0] = string;
        this.instrSpawnedThreads = bl;
        this.startProfilingPointsActive = bl2;
    }

    public InitiateInstrumentationCommand(int n, String[] stringArray, boolean bl, boolean bl2) {
        super(13);
        if (stringArray == null) {
            stringArray = new String[]{" "};
        } else if (stringArray[0] == null) {
            stringArray[0] = " ";
        }
        this.instrType = n;
        this.classNames = stringArray;
        this.instrSpawnedThreads = bl;
        this.startProfilingPointsActive = bl2;
    }

    public InitiateInstrumentationCommand(int n, String string, boolean bl) {
        super(13);
        this.instrType = n;
        this.classNames = new String[1];
        this.classNames[0] = string;
        this.instrSpawnedThreads = false;
        this.startProfilingPointsActive = bl;
    }

    InitiateInstrumentationCommand() {
        super(13);
    }

    public boolean getInstrSpawnedThreads() {
        return this.instrSpawnedThreads;
    }

    public void setInstrType(int n) {
        this.instrType = n;
    }

    public int getInstrType() {
        return this.instrType;
    }

    public String[] getProfilingPointHandlers() {
        return this.profilingPointHandlers;
    }

    public int[] getProfilingPointIDs() {
        return this.profilingPointIDs;
    }

    public String[] getProfilingPointInfos() {
        return this.profilingPointInfos;
    }

    public void setProfilingPoints(RuntimeProfilingPoint[] runtimeProfilingPointArray) {
        this.profilingPointHandlers = new String[runtimeProfilingPointArray.length];
        this.profilingPointInfos = new String[runtimeProfilingPointArray.length];
        this.profilingPointIDs = new int[runtimeProfilingPointArray.length];
        Arrays.sort(runtimeProfilingPointArray, new ByIdComparator());
        for (int i = 0; i < runtimeProfilingPointArray.length; ++i) {
            RuntimeProfilingPoint runtimeProfilingPoint = runtimeProfilingPointArray[i];
            this.profilingPointIDs[i] = runtimeProfilingPoint.getId();
            this.profilingPointHandlers[i] = runtimeProfilingPoint.getServerHandlerClass();
            this.profilingPointInfos[i] = runtimeProfilingPoint.getServerInfo();
        }
    }

    public String getRootClassName() {
        return this.classNames[0];
    }

    public String[] getRootClassNames() {
        return this.classNames;
    }

    public boolean isStartProfilingPointsActive() {
        return this.startProfilingPointsActive;
    }

    public String toString() {
        return super.toString() + ", instrType = " + this.instrType;
    }

    void readObject(ObjectInputStream objectInputStream) throws IOException {
        this.instrType = objectInputStream.readInt();
        int n = objectInputStream.readInt();
        this.classNames = new String[n];
        for (int i = 0; i < n; ++i) {
            this.classNames[i] = objectInputStream.readUTF().intern();
        }
        this.instrSpawnedThreads = objectInputStream.readBoolean();
        this.startProfilingPointsActive = objectInputStream.readBoolean();
        try {
            this.profilingPointIDs = (int[])objectInputStream.readObject();
            this.profilingPointHandlers = (String[])objectInputStream.readObject();
            this.profilingPointInfos = (String[])objectInputStream.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            IOException iOException = new IOException();
            iOException.initCause(classNotFoundException);
            throw iOException;
        }
    }

    void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.instrType);
        objectOutputStream.writeInt(this.classNames.length);
        for (int i = 0; i < this.classNames.length; ++i) {
            objectOutputStream.writeUTF(this.classNames[i]);
        }
        objectOutputStream.writeBoolean(this.instrSpawnedThreads);
        objectOutputStream.writeBoolean(this.startProfilingPointsActive);
        objectOutputStream.writeObject(this.profilingPointIDs);
        objectOutputStream.writeObject(this.profilingPointHandlers);
        objectOutputStream.writeObject(this.profilingPointInfos);
    }

    private static final class ByIdComparator
    implements Comparator {
        private ByIdComparator() {
        }

        public int compare(Object object, Object object2) {
            return ((RuntimeProfilingPoint)object).getId() - ((RuntimeProfilingPoint)object2).getId();
        }
    }
}

