/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.instrumentation;

import java.util.ArrayList;
import java.util.Enumeration;
import org.netbeans.lib.profiler.classfile.ClassRepository;
import org.netbeans.lib.profiler.classfile.DynamicClassInfo;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.instrumentation.ClassManager;
import org.netbeans.lib.profiler.instrumentation.RootMethods;
import org.netbeans.lib.profiler.utils.MiscUtils;

public class MiscInstrumentationOps
extends ClassManager {
    private ArrayList instrClasses = new ArrayList();
    private int nInstrClasses;
    private int nInstrMethods;

    public MiscInstrumentationOps(ProfilingSessionStatus profilingSessionStatus) {
        super(profilingSessionStatus);
    }

    public Object[] getOrigCodeForAllInstrumentedMethods() {
        this.nInstrMethods = 0;
        this.nInstrClasses = 0;
        Enumeration enumeration = ClassRepository.getClassEnumerationWithAllVersions();
        while (enumeration.hasMoreElements()) {
            DynamicClassInfo dynamicClassInfo;
            Object e = enumeration.nextElement();
            if (!(e instanceof DynamicClassInfo) || !(dynamicClassInfo = (DynamicClassInfo)e).isLoaded() || !dynamicClassInfo.hasInstrumentedMethods()) continue;
            this.instrClasses.add(dynamicClassInfo);
            int n = dynamicClassInfo.getMethodNames().length;
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                if (!dynamicClassInfo.isMethodInstrumented(i) || dynamicClassInfo.isMethodUnscannable(i)) continue;
                ++n2;
            }
            ++this.nInstrClasses;
            this.nInstrMethods += n2;
        }
        return this.createInstrumentedMethodPack();
    }

    Object[] getOrigCodeForSingleInstrumentedMethod(RootMethods rootMethods) {
        String string = rootMethods.classNames[0];
        String string2 = rootMethods.methodNames[0];
        String string3 = rootMethods.methodSignatures[0];
        ArrayList arrayList = ClassRepository.getAllClassVersions(string);
        if (arrayList == null) {
            return null;
        }
        string2 = string2.intern();
        string3 = string3.intern();
        this.nInstrMethods = 0;
        this.nInstrClasses = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            DynamicClassInfo dynamicClassInfo = (DynamicClassInfo)arrayList.get(i);
            int n = dynamicClassInfo.getMethodIndex(string2, string3);
            if (n == -1) continue;
            this.instrClasses.add(dynamicClassInfo);
            ++this.nInstrClasses;
            ++this.nInstrMethods;
        }
        if (this.nInstrClasses == 0) {
            MiscUtils.printErrorMessage("got zero classes when attempting to deinstrument a single instrumented method");
            return null;
        }
        return this.createInstrumentedMethodPack();
    }

    protected Object[] createInstrumentedMethodPack() {
        if (this.nInstrMethods == 0) {
            return null;
        }
        return this.createInstrumentedMethodPack15();
    }

    private Object[] createInstrumentedMethodPack15() {
        String[] stringArray = new String[this.nInstrClasses];
        int[] nArray = new int[this.nInstrClasses];
        byte[][] byArrayArray = new byte[this.nInstrClasses][];
        for (int i = 0; i < this.nInstrClasses; ++i) {
            DynamicClassInfo dynamicClassInfo = (DynamicClassInfo)this.instrClasses.get(i);
            stringArray[i] = dynamicClassInfo.getName().replace('/', '.');
            nArray[i] = dynamicClassInfo.getLoaderId();
        }
        return new Object[]{stringArray, nArray, byArrayArray};
    }
}

