/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Collections;
import java.util.List;
import org.netbeans.lib.profiler.heap.NumberList;

class LongMap {
    private final int KEY_SIZE;
    private final int VALUE_SIZE;
    private final int ENTRY_SIZE;
    private final int ID_SIZE;
    private final int FOFFSET_SIZE;
    private File tempFile;
    private Data dumpBuffer;
    private NumberList referenceList;
    private long fileSize;
    private long keys;
    static final /* synthetic */ boolean $assertionsDisabled;

    LongMap(int n, int n2, int n3) throws FileNotFoundException, IOException {
        if (!$assertionsDisabled && n2 != 4 && n2 != 8) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n3 != 4 && n3 != 8) {
            throw new AssertionError();
        }
        this.keys = (long)n * 4L / 3L;
        this.ID_SIZE = n2;
        this.FOFFSET_SIZE = n3;
        this.KEY_SIZE = this.ID_SIZE;
        this.VALUE_SIZE = this.FOFFSET_SIZE + 4 + 1 + this.ID_SIZE;
        this.ENTRY_SIZE = this.KEY_SIZE + this.VALUE_SIZE;
        this.fileSize = this.keys * (long)this.ENTRY_SIZE;
        this.tempFile = File.createTempFile("NBProfiler", ".map");
        byte[] byArray = new byte[524288];
        RandomAccessFile randomAccessFile = new RandomAccessFile(this.tempFile, "rw");
        while (randomAccessFile.length() < this.fileSize) {
            randomAccessFile.write(byArray);
        }
        randomAccessFile.setLength(this.fileSize);
        this.setDumpBuffer(randomAccessFile);
        this.tempFile.deleteOnExit();
        this.referenceList = new NumberList(this.ID_SIZE);
    }

    protected void finalize() throws Throwable {
        this.tempFile.delete();
        super.finalize();
    }

    Entry get(long l) {
        long l2 = this.getIndex(l);
        long l3;
        while ((l3 = this.getID(l2)) != l) {
            if (l3 == 0L) {
                return null;
            }
            l2 = this.getNextIndex(l2);
        }
        return new Entry(l2);
    }

    void put(long l, long l2) {
        long l3 = this.getIndex(l);
        while (true) {
            if (this.getID(l3) == 0L) {
                this.putID(l3, l);
                this.putFoffset(l3 + (long)this.KEY_SIZE, l2);
                return;
            }
            l3 = this.getNextIndex(l3);
        }
    }

    private void setDumpBuffer(RandomAccessFile randomAccessFile) throws IOException {
        long l = randomAccessFile.length();
        try {
            this.dumpBuffer = l > Integer.MAX_VALUE ? new FileData(randomAccessFile, l) : new MemoryMappedData(randomAccessFile, l);
        }
        catch (IOException iOException) {
            if (iOException.getCause() instanceof OutOfMemoryError) {
                this.dumpBuffer = new FileData(randomAccessFile, l);
            }
            throw iOException;
        }
    }

    private long getID(long l) {
        if (this.ID_SIZE == 4) {
            return (long)this.dumpBuffer.getInt(l) & 0xFFFFFFFFL;
        }
        return this.dumpBuffer.getLong(l);
    }

    private void putID(long l, long l2) {
        if (this.ID_SIZE == 4) {
            this.dumpBuffer.putInt(l, (int)l2);
        } else {
            this.dumpBuffer.putLong(l, l2);
        }
    }

    private long getFoffset(long l) {
        if (this.FOFFSET_SIZE == 4) {
            return this.dumpBuffer.getInt(l);
        }
        return this.dumpBuffer.getLong(l);
    }

    private void putFoffset(long l, long l2) {
        if (this.FOFFSET_SIZE == 4) {
            this.dumpBuffer.putInt(l, (int)l2);
        } else {
            this.dumpBuffer.putLong(l, l2);
        }
    }

    private long getIndex(long l) {
        long l2 = l & Long.MAX_VALUE;
        return l2 % this.keys * (long)this.ENTRY_SIZE;
    }

    private long getNextIndex(long l) {
        if ((l += (long)this.ENTRY_SIZE) >= this.fileSize) {
            l = 0L;
        }
        return l;
    }

    static {
        $assertionsDisabled = !LongMap.class.desiredAssertionStatus();
    }

    private class MemoryMappedData
    implements Data {
        MappedByteBuffer buf;

        MemoryMappedData(RandomAccessFile randomAccessFile, long l) throws IOException {
            FileChannel fileChannel = randomAccessFile.getChannel();
            this.buf = fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, l);
            fileChannel.close();
        }

        public byte getByte(long l) {
            return this.buf.get((int)l);
        }

        public int getInt(long l) {
            return this.buf.getInt((int)l);
        }

        public long getLong(long l) {
            return this.buf.getLong((int)l);
        }

        public void putByte(long l, byte by) {
            this.buf.put((int)l, by);
        }

        public void putInt(long l, int n) {
            this.buf.putInt((int)l, n);
        }

        public void putLong(long l, long l2) {
            this.buf.putLong((int)l, l2);
        }
    }

    private class FileData
    implements Data {
        RandomAccessFile file;
        byte[] buf;
        boolean bufferModified;
        long offset;
        final int BUFFER_SIZE = 128;

        FileData(RandomAccessFile randomAccessFile, long l) throws IOException {
            this.file = randomAccessFile;
            this.buf = new byte[LongMap.this.ENTRY_SIZE * 128];
        }

        public synchronized byte getByte(long l) {
            int n = this.loadBufferIfNeeded(l);
            return this.buf[n];
        }

        public synchronized int getInt(long l) {
            int n = this.loadBufferIfNeeded(l);
            int n2 = this.buf[n++] & 0xFF;
            int n3 = this.buf[n++] & 0xFF;
            int n4 = this.buf[n++] & 0xFF;
            int n5 = this.buf[n] & 0xFF;
            return (n2 << 24) + (n3 << 16) + (n4 << 8) + (n5 << 0);
        }

        public synchronized long getLong(long l) {
            int n = this.loadBufferIfNeeded(l);
            return ((long)this.buf[n++] << 56) + ((long)(this.buf[n++] & 0xFF) << 48) + ((long)(this.buf[n++] & 0xFF) << 40) + ((long)(this.buf[n++] & 0xFF) << 32) + ((long)(this.buf[n++] & 0xFF) << 24) + (long)((this.buf[n++] & 0xFF) << 16) + (long)((this.buf[n++] & 0xFF) << 8) + (long)((this.buf[n++] & 0xFF) << 0);
        }

        public synchronized void putByte(long l, byte by) {
            int n = this.loadBufferIfNeeded(l);
            this.buf[n] = by;
            this.bufferModified = true;
        }

        public synchronized void putInt(long l, int n) {
            int n2 = this.loadBufferIfNeeded(l);
            this.buf[n2++] = (byte)(n >>> 24);
            this.buf[n2++] = (byte)(n >>> 16);
            this.buf[n2++] = (byte)(n >>> 8);
            this.buf[n2++] = (byte)(n >>> 0);
            this.bufferModified = true;
        }

        public synchronized void putLong(long l, long l2) {
            int n = this.loadBufferIfNeeded(l);
            this.buf[n++] = (byte)(l2 >>> 56);
            this.buf[n++] = (byte)(l2 >>> 48);
            this.buf[n++] = (byte)(l2 >>> 40);
            this.buf[n++] = (byte)(l2 >>> 32);
            this.buf[n++] = (byte)(l2 >>> 24);
            this.buf[n++] = (byte)(l2 >>> 16);
            this.buf[n++] = (byte)(l2 >>> 8);
            this.buf[n++] = (byte)(l2 >>> 0);
            this.bufferModified = true;
        }

        private int loadBufferIfNeeded(long l) {
            int n = (int)(l % (long)(LongMap.this.ENTRY_SIZE * 128));
            long l2 = l - (long)n;
            if (this.offset != l2) {
                try {
                    if (this.bufferModified) {
                        this.file.seek(this.offset);
                        this.file.write(this.buf, 0, this.getBufferSize(this.offset));
                        this.bufferModified = false;
                    }
                    this.file.seek(l2);
                    this.file.readFully(this.buf, 0, this.getBufferSize(l2));
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                this.offset = l2;
            }
            return n;
        }

        private int getBufferSize(long l) {
            int n = this.buf.length;
            if (LongMap.this.fileSize - l < (long)this.buf.length) {
                n = (int)(LongMap.this.fileSize - l);
            }
            return n;
        }
    }

    private static interface Data {
        public byte getByte(long var1);

        public int getInt(long var1);

        public long getLong(long var1);

        public void putByte(long var1, byte var3);

        public void putInt(long var1, int var3);

        public void putLong(long var1, long var3);
    }

    class Entry {
        private static final byte NUMBER_LIST = 1;
        private static final byte GC_ROOT = 2;
        private long offset;

        private Entry(long l) {
            this.offset = l;
        }

        void setIndex(int n) {
            LongMap.this.dumpBuffer.putInt(this.offset + (long)LongMap.this.KEY_SIZE + (long)LongMap.this.FOFFSET_SIZE, n);
        }

        int getIndex() {
            return LongMap.this.dumpBuffer.getInt(this.offset + (long)LongMap.this.KEY_SIZE + (long)LongMap.this.FOFFSET_SIZE);
        }

        void setNearestGCRootPointer(long l) {
            byte by = (byte)(this.getFlags() | 2);
            this.setFlags(by);
            if ((by & 1) != 0) {
                try {
                    LongMap.this.referenceList.putFirst(this.getReferencesPointer(), l);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }

        long getNearestGCRootPointer() {
            try {
                byte by = this.getFlags();
                if ((by & 2) != 0) {
                    long l = this.getReferencesPointer();
                    if ((by & 1) != 0) {
                        return LongMap.this.referenceList.getFirstNumber(l);
                    }
                    return l;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return 0L;
        }

        void addReference(long l) {
            try {
                byte by = this.getFlags();
                long l2 = this.getReferencesPointer();
                if ((by & 1) == 0) {
                    if (l2 == 0L) {
                        this.setReferencesPointer(l);
                    } else if (l2 != l) {
                        this.setFlags((byte)(by | 1));
                        long l3 = LongMap.this.referenceList.addFirstNumber(l2, l);
                        this.setReferencesPointer(l3);
                    }
                } else {
                    long l4 = LongMap.this.referenceList.addNumber(l2, l);
                    if (l4 != l2) {
                        this.setReferencesPointer(l4);
                    }
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        List getReferences() {
            byte by = this.getFlags();
            long l = this.getReferencesPointer();
            if ((by & 1) == 0) {
                if (l == 0L) {
                    return Collections.EMPTY_LIST;
                }
                return Collections.singletonList(new Long(l));
            }
            try {
                return LongMap.this.referenceList.getNumbers(l);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return Collections.EMPTY_LIST;
            }
        }

        long getOffset() {
            return LongMap.this.getFoffset(this.offset + (long)LongMap.this.KEY_SIZE);
        }

        private void setReferencesPointer(long l) {
            LongMap.this.putID(this.offset + (long)LongMap.this.KEY_SIZE + (long)LongMap.this.FOFFSET_SIZE + 4L + 1L, l);
        }

        private long getReferencesPointer() {
            return LongMap.this.getID(this.offset + (long)LongMap.this.KEY_SIZE + (long)LongMap.this.FOFFSET_SIZE + 4L + 1L);
        }

        private void setFlags(byte by) {
            LongMap.this.dumpBuffer.putByte(this.offset + (long)LongMap.this.KEY_SIZE + (long)LongMap.this.FOFFSET_SIZE + 4L, by);
        }

        private byte getFlags() {
            return LongMap.this.dumpBuffer.getByte(this.offset + (long)LongMap.this.KEY_SIZE + (long)LongMap.this.FOFFSET_SIZE + 4L);
        }
    }
}

