/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.model.impl;

import java.util.List;
import java.util.Map;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.events.ChangeEvent;
import org.netbeans.modules.bpel.model.api.events.EntityInsertEvent;
import org.netbeans.modules.bpel.model.api.events.EntityUpdateEvent;
import org.netbeans.modules.bpel.model.api.support.UniqueId;
import org.netbeans.modules.bpel.model.impl.BpelEntityImpl;
import org.netbeans.modules.bpel.model.impl.BpelModelImpl;
import org.netbeans.modules.bpel.model.impl.UniqueIdImpl;
import org.netbeans.modules.bpel.model.impl.events.BuildEvent;
import org.netbeans.modules.bpel.model.impl.events.CopyEvent;
import org.netbeans.modules.bpel.model.impl.events.CutEvent;
import org.netbeans.modules.bpel.model.impl.events.TreeCreatedEvent;
import org.netbeans.modules.bpel.model.impl.services.InnerEventDispatcherAdapter;

public class UIDCreationService
extends InnerEventDispatcherAdapter {
    public boolean isApplicable(ChangeEvent changeEvent) {
        if (changeEvent instanceof TreeCreatedEvent) {
            return true;
        }
        BpelEntity bpelEntity = changeEvent.getParent();
        if (bpelEntity != null) {
            return bpelEntity.getBpelModel().inSync() && (changeEvent instanceof EntityInsertEvent || changeEvent instanceof EntityUpdateEvent);
        }
        return false;
    }

    public void preDispatch(ChangeEvent changeEvent) {
        if (changeEvent.getClass().equals(EntityInsertEvent.class)) {
            this.createUid(null, (BpelEntity)((EntityInsertEvent)changeEvent).getValue(), null);
        }
        if (changeEvent.getClass().equals(EntityUpdateEvent.class)) {
            this.createUid(null, (BpelEntity)((EntityUpdateEvent)changeEvent).getNewValue(), null);
        }
    }

    public void postDispatch(ChangeEvent changeEvent) {
        BpelEntity bpelEntity = null;
        BpelEntity bpelEntity2 = null;
        Map map = null;
        if (changeEvent.getClass().equals(CutEvent.class)) {
            bpelEntity = changeEvent.getParent();
            bpelEntity2 = ((CutEvent)changeEvent).getOutOfModelEntity();
        } else if (changeEvent.getClass().equals(CopyEvent.class)) {
            bpelEntity = changeEvent.getParent();
            bpelEntity2 = ((CopyEvent)changeEvent).getOutOfModelEntity();
            map = (Map)bpelEntity2.getCookie(BpelEntityImpl.IdMapKey.class);
        } else if (changeEvent.getClass().equals(TreeCreatedEvent.class)) {
            bpelEntity2 = changeEvent.getParent();
        } else if (changeEvent.getClass().equals(BuildEvent.class)) {
            bpelEntity2 = ((BuildEvent)changeEvent).getParent();
        } else {
            return;
        }
        this.createUid(bpelEntity, bpelEntity2, map);
    }

    private void createUid(BpelEntity bpelEntity, BpelEntity bpelEntity2, Map map) {
        Object object;
        if (bpelEntity == null || map != null) {
            if (bpelEntity2.getUID() != null) {
                assert (bpelEntity2.getBpelModel().inSync());
                return;
            }
            object = (BpelModelImpl)bpelEntity2.getBpelModel();
            long l = ((BpelModelImpl)object).getNextID();
            UniqueIdImpl uniqueIdImpl = new UniqueIdImpl((BpelEntityImpl)bpelEntity2, l);
            ((BpelEntityImpl)bpelEntity2).setUID(uniqueIdImpl);
            if (map != null) {
                assert (bpelEntity != null);
                Object object2 = bpelEntity.getUID();
                map.put(object2, uniqueIdImpl);
            }
        } else {
            object = bpelEntity.getUID();
            ((BpelEntityImpl)bpelEntity2).setUID((UniqueId)object);
            ((UniqueIdImpl)object).setEntity((BpelEntityImpl)bpelEntity2);
        }
        object = bpelEntity2;
        BpelEntity[] bpelEntityArray = null;
        if (bpelEntity != null) {
            List list = bpelEntity.getChildren();
            bpelEntityArray = list.toArray(new BpelEntity[list.size()]);
        }
        int n = 0;
        for (Object object2 : object.getChildren()) {
            if (bpelEntity != null) {
                assert (bpelEntityArray != null);
                this.createUid(bpelEntityArray[n], (BpelEntity)object2, map);
            } else {
                this.createUid(null, (BpelEntity)object2, map);
            }
            ++n;
        }
    }
}

