/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.model.impl;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.ContentElement;
import org.netbeans.modules.bpel.model.api.NamedElement;
import org.netbeans.modules.bpel.model.api.Process;
import org.netbeans.modules.bpel.model.api.events.ChangeEvent;
import org.netbeans.modules.bpel.model.api.events.PropertyUpdateEvent;
import org.netbeans.modules.bpel.model.api.events.VetoException;
import org.netbeans.modules.bpel.model.api.references.BpelReferenceable;
import org.netbeans.modules.bpel.model.api.support.ExpressionUpdater;
import org.netbeans.modules.bpel.model.impl.BpelEntityImpl;
import org.netbeans.modules.bpel.model.impl.services.InnerEventDispatcherAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionConsistencyService
extends InnerEventDispatcherAdapter {
    private ThreadLocal<Map<ChangeEvent, Map<ContentElement, String>>> myMap = new ThreadLocal<Map<ChangeEvent, Map<ContentElement, String>>>(){

        @Override
        protected Map<ChangeEvent, Map<ContentElement, String>> initialValue() {
            return new WeakHashMap<ChangeEvent, Map<ContentElement, String>>();
        }
    };

    @Override
    public boolean isApplicable(ChangeEvent changeEvent) {
        BpelEntity bpelEntity = changeEvent.getParent();
        if (bpelEntity instanceof BpelEntityImpl && changeEvent instanceof PropertyUpdateEvent) {
            if (!((BpelEntityImpl)bpelEntity).isInTree()) {
                return false;
            }
            return !bpelEntity.getBpelModel().inSync() && bpelEntity instanceof BpelReferenceable && "name".equals(changeEvent.getName());
        }
        return false;
    }

    @Override
    public void preDispatch(ChangeEvent changeEvent) {
        BpelEntity bpelEntity = ((PropertyUpdateEvent)changeEvent).getParent();
        String string = (String)((PropertyUpdateEvent)changeEvent).getNewValue();
        if (!(bpelEntity instanceof NamedElement) || string == null) {
            return;
        }
        Process process = bpelEntity.getBpelModel().getProcess();
        IdentityHashMap<ContentElement, String> identityHashMap = new IdentityHashMap<ContentElement, String>();
        this.myMap.get().put(changeEvent, identityHashMap);
        this.collectExpressions(process, (NamedElement)((Object)bpelEntity), string, identityHashMap);
    }

    @Override
    public void postDispatch(ChangeEvent changeEvent) {
        BpelEntity bpelEntity = ((PropertyUpdateEvent)changeEvent).getParent();
        Process process = bpelEntity.getBpelModel().getProcess();
        this.update(process, this.myMap.get().get(changeEvent));
        this.reset(changeEvent);
    }

    @Override
    public void reset(ChangeEvent changeEvent) {
        Map<ChangeEvent, Map<ContentElement, String>> map = this.myMap.get();
        map.remove(changeEvent);
    }

    private void collectExpressions(BpelEntity bpelEntity, NamedElement namedElement, String string, Map<ContentElement, String> map) {
        Object object;
        Object object2;
        Object object3;
        if (bpelEntity instanceof ContentElement) {
            object3 = ((ContentElement)((Object)bpelEntity)).getContent();
            object2 = ((String)object3).trim();
            object = ExpressionUpdater.getInstance().update((String)object2, namedElement, string);
            if (map != null && object != null) {
                int n = ((String)object3).indexOf((String)object2);
                String string2 = ((String)object3).substring(0, n);
                String string3 = ((String)object3).substring(n + ((String)object2).length());
                object = string2 + (String)object + string3;
                map.put((ContentElement)((Object)bpelEntity), (String)object);
            }
        }
        object3 = bpelEntity.getChildren();
        object2 = object3.iterator();
        while (object2.hasNext()) {
            object = (BpelEntity)object2.next();
            this.collectExpressions((BpelEntity)object, namedElement, string, map);
        }
    }

    private void update(BpelEntity bpelEntity, Map<ContentElement, String> map) {
        block5: {
            if (map == null) {
                return;
            }
            String string = map.remove(bpelEntity);
            if (string != null) {
                try {
                    ((ContentElement)((Object)bpelEntity)).setContent(string);
                }
                catch (VetoException vetoException) {
                    if ($assertionsDisabled) break block5;
                    throw new AssertionError();
                }
            }
        }
        List list = bpelEntity.getChildren();
        for (BpelEntity bpelEntity2 : list) {
            this.update(bpelEntity2, map);
        }
    }
}

