/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.model.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.spring.api.beans.model.SpringBean;
import org.netbeans.modules.spring.api.beans.model.SpringBeanProperty;
import org.netbeans.modules.spring.beans.editor.ContextUtilities;
import org.netbeans.modules.spring.beans.editor.SpringXMLConfigEditorUtils;
import org.netbeans.modules.spring.beans.model.SpringBeanSource;
import org.netbeans.modules.spring.beans.model.impl.ConfigFileLocation;
import org.netbeans.modules.spring.beans.model.impl.ConfigFileSpringBean;
import org.netbeans.modules.spring.beans.model.impl.ConfigFileSpringBeanProperty;
import org.netbeans.modules.spring.beans.utils.StringUtils;
import org.netbeans.modules.xml.text.syntax.dom.Tag;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigFileSpringBeanSource
implements SpringBeanSource {
    private static final Logger LOGGER = Logger.getLogger(ConfigFileSpringBeanSource.class.getName());
    private final Map<String, ConfigFileSpringBean> id2Bean = new HashMap<String, ConfigFileSpringBean>();
    private final Map<String, ConfigFileSpringBean> name2Bean = new HashMap<String, ConfigFileSpringBean>();
    private final Map<String, String> alias2Name = new HashMap<String, String>();
    private final List<ConfigFileSpringBean> beans = new ArrayList<ConfigFileSpringBean>();

    public void parse(BaseDocument baseDocument) throws IOException {
        FileObject fileObject = NbEditorUtilities.getFileObject((Document)baseDocument);
        if (fileObject == null) {
            LOGGER.log(Level.WARNING, "Could not get a FileObject for document {0}", baseDocument);
            return;
        }
        LOGGER.log(Level.FINE, "Parsing {0}", fileObject);
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file == null) {
            LOGGER.log(Level.WARNING, "{0} resolves to a null File, aborting", fileObject);
            return;
        }
        new DocumentParser(file, (Document)baseDocument).run();
        LOGGER.log(Level.FINE, "Parsed {0}", fileObject);
    }

    @Override
    public List<SpringBean> getBeans() {
        return Collections.unmodifiableList(this.beans);
    }

    @Override
    public SpringBean findBeanByID(String string) {
        return this.id2Bean.get(string);
    }

    @Override
    public SpringBean findBean(String string) {
        SpringBean springBean = this.findBeanByID(string);
        if (springBean == null) {
            springBean = this.name2Bean.get(string);
        }
        return springBean;
    }

    @Override
    public String findAliasName(String string) {
        return this.alias2Name.get(string);
    }

    @Override
    public Set<String> getAliases() {
        return this.alias2Name.keySet();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class DocumentParser
    implements Runnable {
        private final File file;
        private final Document document;
        private static final String REF_SUFFIX = "-ref";

        public DocumentParser(File file, Document document) {
            this.file = file;
            this.document = document;
        }

        @Override
        public void run() {
            ConfigFileSpringBeanSource.this.id2Bean.clear();
            ConfigFileSpringBeanSource.this.name2Bean.clear();
            ConfigFileSpringBeanSource.this.beans.clear();
            ConfigFileSpringBeanSource.this.alias2Name.clear();
            Tag tag = SpringXMLConfigEditorUtils.getDocumentRoot(this.document);
            if (tag == null) {
                return;
            }
            NodeList nodeList = tag.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                String string = node.getNodeName();
                if ("alias".equals(string)) {
                    this.parseAlias(node);
                    continue;
                }
                if (!"bean".equals(string)) continue;
                this.parseBean(node);
            }
        }

        private void parseAlias(Node node) {
            String string = this.getTrimmedAttr(node, "name");
            String string2 = this.getTrimmedAttr(node, "alias");
            if (StringUtils.hasText(string) && StringUtils.hasText(string2)) {
                ConfigFileSpringBeanSource.this.alias2Name.put(string2, string);
            }
        }

        private void parseBean(Node node) {
            String string = this.getTrimmedAttr(node, "id");
            String string2 = this.getTrimmedAttr(node, "name");
            List<String> list = string2 != null ? Collections.unmodifiableList(StringUtils.tokenize(string2, ",; ")) : Collections.emptyList();
            String string3 = this.getTrimmedAttr(node, "class");
            String string4 = this.getTrimmedAttr(node, "parent");
            String string5 = this.getTrimmedAttr(node, "factory-bean");
            String string6 = this.getTrimmedAttr(node, "factory-method");
            Tag tag = (Tag)node;
            ConfigFileLocation configFileLocation = new ConfigFileLocation(this.file, tag.getElementOffset());
            Set<SpringBeanProperty> set = this.parseBeanProperties(node);
            ConfigFileSpringBean configFileSpringBean = new ConfigFileSpringBean(string, list, string3, string4, string5, string6, set, configFileLocation);
            if (string != null) {
                this.addBeanID(string, configFileSpringBean);
            }
            for (String string7 : list) {
                this.addBeanName(string7, configFileSpringBean);
            }
            ConfigFileSpringBeanSource.this.beans.add(configFileSpringBean);
        }

        private Set<SpringBeanProperty> parseBeanProperties(Node node) {
            Object object;
            HashMap<String, ConfigFileSpringBeanProperty> hashMap = new HashMap<String, ConfigFileSpringBeanProperty>();
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String string;
                object = nodeList.item(i);
                if (!"property".equals(object.getNodeName()) || !StringUtils.hasText(string = this.getTrimmedAttr((Node)object, "name")) || hashMap.containsKey(string)) continue;
                hashMap.put(string, new ConfigFileSpringBeanProperty(string));
            }
            String string = SpringXMLConfigEditorUtils.getPNamespacePrefix(this.document, ((Tag)node).getElementOffset());
            if (string != null) {
                object = node.getAttributes();
                for (int i = 0; i < object.getLength(); ++i) {
                    Node node2 = object.item(i);
                    String string2 = node2.getNodeName();
                    if (string2.length() <= string.length() + 1 || !string.equals(ContextUtilities.getPrefixFromNodeName(string2))) continue;
                    int n = string2.endsWith(REF_SUFFIX) ? string2.lastIndexOf(REF_SUFFIX) : string2.length();
                    String string3 = string2.substring(string.length() + 1, n);
                    if (!StringUtils.hasText(string3) || hashMap.containsKey(string3)) continue;
                    hashMap.put(string3, new ConfigFileSpringBeanProperty(string3));
                }
            }
            return Collections.unmodifiableSet(new HashSet(hashMap.values()));
        }

        private void addBeanID(String string, ConfigFileSpringBean configFileSpringBean) {
            if (ConfigFileSpringBeanSource.this.id2Bean.get(string) == null) {
                ConfigFileSpringBeanSource.this.id2Bean.put(string, configFileSpringBean);
            }
        }

        private void addBeanName(String string, ConfigFileSpringBean configFileSpringBean) {
            if (ConfigFileSpringBeanSource.this.name2Bean.get(string) == null) {
                ConfigFileSpringBeanSource.this.name2Bean.put(string, configFileSpringBean);
            }
        }

        private String getTrimmedAttr(Node node, String string) {
            String string2 = SpringXMLConfigEditorUtils.getAttribute(node, string);
            if (string2 != null) {
                string2 = string2.trim();
            }
            return string2;
        }
    }
}

