/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.jumpto;

import java.io.File;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.spring.api.Action;
import org.netbeans.modules.spring.api.beans.SpringScope;
import org.netbeans.modules.spring.api.beans.model.FileSpringBeans;
import org.netbeans.modules.spring.api.beans.model.SpringBean;
import org.netbeans.modules.spring.api.beans.model.SpringConfigModel;
import org.netbeans.modules.spring.beans.ProjectSpringScopeProvider;
import org.netbeans.modules.spring.beans.jumpto.AbstractBeanTypeDescriptor;
import org.netbeans.modules.spring.beans.jumpto.BeanAliasTypeDescriptor;
import org.netbeans.modules.spring.beans.jumpto.BeanTypeDescriptor;
import org.netbeans.spi.jumpto.type.SearchType;
import org.netbeans.spi.jumpto.type.TypeProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class SpringBeansTypeProvider
implements TypeProvider {
    private Set<AbstractBeanTypeDescriptor> cache;
    private String lastRefreshText;
    private SearchType lastRefreshSearchType;
    private static Pattern camelCaseBlock = Pattern.compile("(\\p{javaUpperCase}(?:\\p{javaLowerCase}|\\d|\\.|\\-)*)");

    public String name() {
        return "springbeans";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(SpringBeansTypeProvider.class, (String)"LBL_SpringBeansType");
    }

    /*
     * WARNING - void declaration
     */
    public void computeTypeNames(TypeProvider.Context context, TypeProvider.Result result) {
        AbstractCollection abstractCollection;
        SearchType searchType;
        assert (context.getProject() == null);
        boolean bl = false;
        String string = context.getText();
        final Matcher matcher = this.getMatcher(string, searchType = context.getSearchType());
        if (matcher == null) {
            return;
        }
        if (this.lastRefreshText == null || this.lastRefreshSearchType == null || !string.startsWith(this.lastRefreshText) || this.lastRefreshSearchType != searchType || this.cache == null) {
            void var9_11;
            bl = true;
            abstractCollection = new HashSet();
            Future future = OpenProjects.getDefault().openProjects();
            Object object = null;
            try {
                Project[] projectArray = (Project[])future.get();
            }
            catch (InterruptedException interruptedException) {
                Exceptions.printStackTrace((Throwable)interruptedException);
            }
            catch (ExecutionException executionException) {
                Exceptions.printStackTrace((Throwable)executionException);
            }
            if (var9_11 == null) {
                return;
            }
            for (void var13_19 : var9_11) {
                SpringScope springScope;
                ProjectSpringScopeProvider projectSpringScopeProvider = (ProjectSpringScopeProvider)var13_19.getLookup().lookup(ProjectSpringScopeProvider.class);
                if (projectSpringScopeProvider == null || (springScope = projectSpringScopeProvider.getSpringScope()) == null) continue;
                final HashSet hashSet = new HashSet();
                List<SpringConfigModel> list = springScope.getAllConfigModels();
                for (SpringConfigModel springConfigModel : list) {
                    try {
                        springConfigModel.runDocumentAction(new Action<SpringConfigModel.DocumentAccess>((Set)((Object)abstractCollection)){
                            final /* synthetic */ Set val$currCache;
                            {
                                this.val$currCache = set2;
                            }

                            @Override
                            public void run(SpringConfigModel.DocumentAccess documentAccess) {
                                File file = documentAccess.getFile();
                                if (hashSet.contains(file)) {
                                    return;
                                }
                                hashSet.add(file);
                                FileObject fileObject = documentAccess.getFileObject();
                                FileSpringBeans fileSpringBeans = documentAccess.getSpringBeans().getFileBeans(fileObject);
                                List<SpringBean> list = fileSpringBeans.getBeans();
                                for (SpringBean object : list) {
                                    String string = object.getId();
                                    if (string != null && matcher.match(string)) {
                                        this.val$currCache.add(new BeanTypeDescriptor(string, object));
                                    }
                                    for (String string2 : object.getNames()) {
                                        if (!matcher.match(string2)) continue;
                                        this.val$currCache.add(new BeanTypeDescriptor(string2, object));
                                    }
                                }
                                for (String string : fileSpringBeans.getAliases()) {
                                    if (!matcher.match(string)) continue;
                                    this.val$currCache.add(new BeanAliasTypeDescriptor(string, fileObject));
                                }
                            }
                        });
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                }
            }
            this.cache = abstractCollection;
            this.lastRefreshText = string;
            this.lastRefreshSearchType = searchType;
        }
        abstractCollection = new ArrayList(this.cache.size());
        for (AbstractBeanTypeDescriptor abstractBeanTypeDescriptor : this.cache) {
            if (!bl && !matcher.match(abstractBeanTypeDescriptor.getSimpleName())) continue;
            ((ArrayList)abstractCollection).add((AbstractBeanTypeDescriptor)abstractBeanTypeDescriptor);
        }
        result.addResult(abstractCollection);
    }

    public void cancel() {
        assert (false);
    }

    public void cleanup() {
        this.cache = null;
        this.lastRefreshText = null;
        this.lastRefreshSearchType = null;
    }

    private Matcher getMatcher(String string, SearchType searchType) {
        switch (searchType) {
            case EXACT_NAME: {
                return new StringMatcher(string, false, true);
            }
            case CASE_INSENSITIVE_EXACT_NAME: {
                return new StringMatcher(string, false, false);
            }
            case PREFIX: {
                return new StringMatcher(string, true, true);
            }
            case CASE_INSENSITIVE_PREFIX: {
                return new StringMatcher(string, true, false);
            }
            case REGEXP: {
                String string2 = string + "*";
                string2 = string2.replace("*", ".*").replace('?', '.');
                return new RegExpMatcher(string2, true);
            }
            case CASE_INSENSITIVE_REGEXP: {
                String string3 = string + "*";
                string3 = string3.replace("*", ".*").replace('?', '.');
                return new RegExpMatcher(string3, false);
            }
            case CAMEL_CASE: {
                java.util.regex.Matcher matcher = camelCaseBlock.matcher(string);
                StringBuilder stringBuilder = new StringBuilder();
                while (matcher.find()) {
                    stringBuilder.append(matcher.group()).append("(?:\\p{javaLowerCase}|\\d|\\.|\\-)*");
                }
                stringBuilder.append(".*");
                return new RegExpMatcher(stringBuilder.toString(), false);
            }
        }
        assert (false);
        return null;
    }

    private static final class StringMatcher
    implements Matcher {
        private final String searchText;
        private final boolean prefix;
        private final boolean caseSensitive;

        public StringMatcher(String string, boolean bl, boolean bl2) {
            this.searchText = string;
            this.prefix = bl;
            this.caseSensitive = bl2;
        }

        public boolean match(String string) {
            int n = this.prefix ? this.searchText.length() : Math.max(string.length(), this.searchText.length());
            return string.regionMatches(this.caseSensitive, 0, this.searchText, 0, n);
        }
    }

    private static final class RegExpMatcher
    implements Matcher {
        private final String regex;
        private final boolean caseSensitive;
        private final Pattern pattern;

        public RegExpMatcher(String string, boolean bl) {
            this.regex = string;
            this.caseSensitive = bl;
            this.pattern = bl ? Pattern.compile(string) : Pattern.compile(string, 2);
        }

        public boolean match(String string) {
            return this.pattern.matcher(string).matches();
        }
    }

    private static interface Matcher {
        public boolean match(String var1);
    }
}

