/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.hyperlink;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenItem;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.spring.beans.editor.ContextUtilities;
import org.netbeans.modules.spring.beans.editor.DocumentContext;
import org.netbeans.modules.spring.beans.editor.SpringXMLConfigEditorUtils;
import org.netbeans.modules.xml.text.syntax.dom.Tag;
import org.openide.filesystems.FileObject;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HyperlinkEnv {
    private BaseDocument baseDocument;
    private String attribName;
    private String valueString;
    private int offset;
    private FileObject fileObject;
    private Map<String, String> declaredNamespaces;
    private int tokenStartOffset;
    private int tokenEndOffset;
    private String tokenImage;
    private int beanTagOffset;
    private String tagName;
    private Map<String, String> beanAttribs;
    private Type type = Type.NONE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HyperlinkEnv(Document document, int n) {
        this.baseDocument = (BaseDocument)document;
        this.fileObject = NbEditorUtilities.getFileObject((Document)this.baseDocument);
        this.offset = n;
        this.baseDocument.readLock();
        try {
            this.initialize();
        }
        finally {
            this.baseDocument.readUnlock();
        }
    }

    private void initialize() {
        Tag tag = null;
        DocumentContext documentContext = DocumentContext.create((Document)this.baseDocument, this.offset);
        if (documentContext == null) {
            return;
        }
        this.declaredNamespaces = documentContext.getDeclaredNamespacesMap();
        TokenItem tokenItem = documentContext.getCurrentToken();
        if (tokenItem == null) {
            return;
        }
        this.tokenStartOffset = tokenItem.getOffset();
        this.tokenEndOffset = this.tokenStartOffset + tokenItem.getImage().length();
        this.tokenImage = tokenItem.getImage();
        if (ContextUtilities.isValueToken(tokenItem) || ContextUtilities.isAttributeToken(documentContext.getCurrentToken())) {
            tag = (Tag)documentContext.getCurrentElement();
            Tag tag2 = (Tag)SpringXMLConfigEditorUtils.getBean((Node)tag);
            if (tag2 != null) {
                this.beanTagOffset = tag2.getElementOffset();
                this.beanAttribs = this.collectAttributes(tag2);
            }
            this.tagName = tag.getNodeName();
        }
        if (ContextUtilities.isValueToken(tokenItem)) {
            this.type = Type.ATTRIB_VALUE;
            this.attribName = ContextUtilities.getAttributeTokenImage(documentContext);
            this.valueString = tokenItem.getImage();
            this.valueString = this.valueString.substring(1, this.valueString.length() - 1);
        } else if (ContextUtilities.isAttributeToken(documentContext.getCurrentToken())) {
            this.type = Type.ATTRIB;
            this.attribName = tokenItem.getImage();
        }
    }

    private Map<String, String> collectAttributes(Tag tag) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        NamedNodeMap namedNodeMap = tag.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node = namedNodeMap.item(i);
            hashMap.put(node.getNodeName(), node.getNodeValue());
        }
        return Collections.unmodifiableMap(hashMap);
    }

    public String getAttribName() {
        return this.attribName;
    }

    public String getTagName() {
        return this.tagName;
    }

    public String getValueString() {
        return this.valueString;
    }

    public Type getType() {
        return this.type;
    }

    public int getOffset() {
        return this.offset;
    }

    public FileObject getFileObject() {
        return this.fileObject;
    }

    public int getTokenStartOffset() {
        return this.tokenStartOffset;
    }

    public int getTokenEndOffset() {
        return this.tokenEndOffset;
    }

    public String getTokenImage() {
        return this.tokenImage;
    }

    public Map<String, String> getBeanAttributes() {
        return this.beanAttribs;
    }

    public int getBeanTagOffset() {
        return this.beanTagOffset;
    }

    public String lookupNamespacePrefix(String string) {
        return this.declaredNamespaces.get(string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        ATTRIB_VALUE,
        ATTRIB,
        TEXT,
        NONE;


        public boolean isValueHyperlink() {
            return this == ATTRIB_VALUE;
        }

        public boolean isAttributeHyperlink() {
            return this == ATTRIB;
        }
    }
}

