/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.refactoring;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.Line;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static ClasspathInfo getClasspathInfoFor(FileObject ... classPath) {
        Project project;
        FileObject fileObject2;
        assert (((FileObject[])classPath).length > 0);
        HashSet<URL> hashSet = new HashSet<URL>();
        for (FileObject fileObject2 : classPath) {
            project = null;
            if (fileObject2 != null) {
                project = FileOwnerQuery.getOwner((FileObject)fileObject2);
            }
            if (project != null) {
                URL uRL = URLMapper.findURL((FileObject)ClassPath.getClassPath((FileObject)fileObject2, (String)"classpath/source").findOwnerRoot(fileObject2), (int)0);
                hashSet.addAll(SourceUtils.getDependentRoots((URL)uRL));
                for (SourceGroup sourceGroup : ProjectUtils.getSources((Project)project).getSourceGroups("java")) {
                    hashSet.add(URLMapper.findURL((FileObject)sourceGroup.getRootFolder(), (int)0));
                }
                continue;
            }
            for (SourceGroup[] sourceGroupArray : GlobalPathRegistry.getDefault().getPaths("classpath/source")) {
                for (FileObject fileObject3 : sourceGroupArray.getRoots()) {
                    hashSet.add(URLMapper.findURL((FileObject)fileObject3, (int)0));
                }
            }
        }
        ClassPath classPath2 = ClassPathSupport.createClassPath((URL[])hashSet.toArray(new URL[hashSet.size()]));
        ClassPath classPath3 = ClassPathSupport.createClassPath((FileObject[])new FileObject[0]);
        ClassPath classPath4 = classPath[0] != null ? ClassPath.getClassPath((FileObject)classPath[0], (String)"classpath/boot") : classPath3;
        fileObject2 = classPath[0] != null ? ClassPath.getClassPath((FileObject)classPath[0], (String)"classpath/compile") : classPath3;
        project = ClasspathInfo.create((ClassPath)classPath4, (ClassPath)fileObject2, (ClassPath)classPath2);
        return project;
    }

    public static List<FileObject> getGroovyFilesInProject(FileObject fileObject) {
        ClasspathInfo classpathInfo = Utils.getClasspathInfoFor(fileObject);
        ClassPath classPath = classpathInfo.getClassPath(ClasspathInfo.PathKind.SOURCE);
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>(100);
        for (ClassPath.Entry entry : classPath.entries()) {
            FileObject fileObject2 = entry.getRoot();
            Utils.addGroovyFiles(arrayList, fileObject2);
        }
        return arrayList;
    }

    private static void addGroovyFiles(List<FileObject> list, FileObject fileObject) {
        if (fileObject.isFolder()) {
            for (FileObject fileObject2 : fileObject.getChildren()) {
                Utils.addGroovyFiles(list, fileObject2);
            }
        } else if (Utils.isGroovyFile(fileObject)) {
            list.add(fileObject);
        }
    }

    public static boolean isGroovyFile(FileObject fileObject) {
        return "text/x-groovy".equals(fileObject.getMIMEType());
    }

    public static boolean isGspFile(FileObject fileObject) {
        return false;
    }

    public static boolean isGroovyOrGspFile(FileObject fileObject) {
        return Utils.isGroovyFile(fileObject) || Utils.isGspFile(fileObject);
    }

    private static LineCookie getLineCookie(FileObject fileObject) {
        LineCookie lineCookie = null;
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            if (dataObject != null) {
                lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            // empty catch block
        }
        return lineCookie;
    }

    public static Line getLine(FileObject fileObject, int n) {
        LineCookie lineCookie = Utils.getLineCookie(fileObject);
        assert (lineCookie != null);
        try {
            return lineCookie.getLineSet().getCurrent(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public static CloneableEditorSupport findCloneableEditorSupport(FileObject fileObject) {
        DataObject dataObject = null;
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
        }
        return Utils.findCloneableEditorSupport(dataObject);
    }

    public static CloneableEditorSupport findCloneableEditorSupport(DataObject dataObject) {
        Node.Cookie cookie = dataObject.getCookie(OpenCookie.class);
        if (cookie instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)cookie;
        }
        cookie = dataObject.getCookie(EditorCookie.class);
        if (cookie instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)cookie;
        }
        return null;
    }

    public static BaseDocument getDocument(CompilationInfo compilationInfo, FileObject fileObject) {
        BaseDocument baseDocument = null;
        try {
            DataObject dataObject;
            EditorCookie editorCookie;
            if (compilationInfo != null) {
                baseDocument = (BaseDocument)compilationInfo.getDocument();
            }
            if (baseDocument == null && (editorCookie = (EditorCookie)(dataObject = DataObject.find((FileObject)fileObject)).getCookie(EditorCookie.class)) != null) {
                baseDocument = (BaseDocument)editorCookie.openDocument();
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return baseDocument;
    }
}

