/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.ejb.util;

import java.util.ArrayList;
import org.netbeans.modules.visualweb.ejb.datamodel.MethodInfo;
import org.netbeans.modules.visualweb.ejb.datamodel.MethodParam;
import org.netbeans.modules.visualweb.ejb.util.InvalidParameterNameException;
import org.netbeans.modules.visualweb.ejb.util.JavaKeywords;
import org.openide.util.NbBundle;

public class MethodParamValidator {
    public static void validate(String string) throws InvalidParameterNameException {
        MethodParamValidator.validate(string, null, -1);
    }

    public static void validate(String string, MethodInfo methodInfo, int n) throws InvalidParameterNameException {
        char c;
        if (JavaKeywords.isKeyword(string)) {
            throw new InvalidParameterNameException(NbBundle.getMessage(MethodParamValidator.class, (String)"PARAMETER_NAME_IS_KEYWORD", (Object)string));
        }
        for (int i = 0; i < string.length(); ++i) {
            c = string.charAt(i);
            if (i == 0) {
                if (Character.isJavaIdentifierStart(c)) continue;
                throw new InvalidParameterNameException(NbBundle.getMessage(MethodParamValidator.class, (String)"INVALID_FIRST_CHAR", (Object)string));
            }
            if (Character.isJavaIdentifierPart(c)) continue;
            if (Character.isSpaceChar(c)) {
                throw new InvalidParameterNameException(NbBundle.getMessage(MethodParamValidator.class, (String)"NO_SPACE_IN_PARAMETER_NAME", (Object)string));
            }
            throw new InvalidParameterNameException(NbBundle.getMessage(MethodParamValidator.class, (String)"INVALID_CHAR", (Object)string, (Object)new Character(c).toString()));
        }
        if (methodInfo != null && n >= 0) {
            ArrayList arrayList = methodInfo.getParameters();
            for (c = '\u0000'; c < arrayList.size(); ++c) {
                MethodParam methodParam;
                if (c == n || !(methodParam = (MethodParam)arrayList.get(c)).getName().equals(string)) continue;
                throw new InvalidParameterNameException(NbBundle.getMessage(MethodParamValidator.class, (String)"PARAMETER_NAME_IS_DUPLICATE", (Object)string));
            }
        }
    }
}

