/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.ejb.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.modules.visualweb.ejb.datamodel.EjbDataModel;
import org.netbeans.modules.visualweb.ejb.datamodel.EjbGroup;
import org.openide.util.NbBundle;

public class ModifyEjbGroupPanel
extends JPanel {
    private String orgName;
    private String orgHost;
    private int orgPort;
    private JLabel groupNameLabel;
    private JTextField groupNameTextField;
    private JLabel iiopPortLabel;
    private JTextField iiopPortTextField;
    private JPanel paddingPanel;
    private JLabel serverHostLabel;
    private JTextField serverHostTextField;

    public ModifyEjbGroupPanel(EjbGroup ejbGroup) {
        this.initComponents();
        this.orgName = ejbGroup.getName();
        this.orgHost = ejbGroup.getServerHost();
        this.orgPort = ejbGroup.getIIOPPort();
        this.groupNameTextField.setText(ejbGroup.getName());
        this.serverHostTextField.setText(ejbGroup.getServerHost());
        this.iiopPortTextField.setText(Integer.toString(ejbGroup.getIIOPPort()));
    }

    public ModifyEjbGroupPanel() {
        this((EjbGroup)null);
    }

    public String getGroupName() {
        return this.groupNameTextField.getText().trim();
    }

    public String getServerHost() {
        return this.serverHostTextField.getText().trim();
    }

    public String getIIOPPort() {
        return this.iiopPortTextField.getText().trim();
    }

    public boolean validateData(StringBuffer stringBuffer) {
        boolean bl = true;
        if (this.getGroupName() == null || this.getGroupName().length() == 0) {
            if (bl) {
                this.groupNameTextField.requestFocus();
                bl = false;
            }
            stringBuffer.append(NbBundle.getMessage(ModifyEjbGroupPanel.class, (String)"EMPTY_GROUP_NAME"));
            stringBuffer.append("\n");
        } else if (!this.orgName.equals(this.getGroupName()) && EjbDataModel.getInstance().getEjbGroup(this.getGroupName()) != null) {
            if (bl) {
                this.groupNameTextField.requestFocus();
                this.groupNameTextField.selectAll();
                bl = false;
            }
            stringBuffer.append(NbBundle.getMessage(ModifyEjbGroupPanel.class, (String)"NAME_NOT_UNIQUE", (Object)("'" + this.getGroupName() + "'")));
            stringBuffer.append("\n");
        }
        if (this.getServerHost() == null || this.getServerHost().length() == 0) {
            if (bl) {
                this.serverHostTextField.requestFocus();
                bl = false;
            }
            stringBuffer.append(NbBundle.getMessage(ModifyEjbGroupPanel.class, (String)"EMPTY_SERVER_HOST"));
            stringBuffer.append("\n");
        } else if (!this.orgHost.equals(this.getServerHost()) && this.getServerHost().indexOf(32) != -1) {
            if (bl) {
                this.serverHostTextField.requestFocus();
                this.serverHostTextField.selectAll();
                bl = false;
            }
            stringBuffer.append(NbBundle.getMessage(ModifyEjbGroupPanel.class, (String)"SPACES_IN_SERVER_HOST", (Object)("'" + this.getServerHost() + "'")));
            stringBuffer.append("\n");
        }
        if (this.getIIOPPort() == null || this.getIIOPPort().length() == 0) {
            if (bl) {
                this.iiopPortTextField.requestFocus();
                bl = false;
            }
            stringBuffer.append(NbBundle.getMessage(ModifyEjbGroupPanel.class, (String)"EMPTY_IIOP_PORT"));
            stringBuffer.append("\n");
        } else {
            try {
                int n = Integer.parseInt(this.getIIOPPort());
            }
            catch (NumberFormatException numberFormatException) {
                if (bl) {
                    this.iiopPortTextField.requestFocus();
                    this.iiopPortTextField.selectAll();
                    bl = false;
                }
                stringBuffer.append(NbBundle.getMessage(ModifyEjbGroupPanel.class, (String)"IIOP_PORT_NOT_NUMBER"));
                stringBuffer.append("\n");
            }
        }
        return bl;
    }

    private void initComponents() {
        this.groupNameLabel = new JLabel();
        this.groupNameTextField = new JTextField();
        this.serverHostLabel = new JLabel();
        this.serverHostTextField = new JTextField();
        this.iiopPortTextField = new JTextField();
        this.iiopPortLabel = new JLabel();
        this.paddingPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(350, 120));
        this.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("MODIFY_EJB_GROUP"));
        this.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("MODIFY_EJB_GROUP"));
        this.groupNameLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("EJB_GROUP_NAME_MNEMONIC").charAt(0));
        this.groupNameLabel.setLabelFor(this.groupNameTextField);
        this.groupNameLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("EJB_GROUP_NAME_LABEL"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.groupNameLabel, gridBagConstraints);
        this.groupNameLabel.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("EJB_GROUP_NAME_DESC"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 5, 0, 12);
        this.add((Component)this.groupNameTextField, gridBagConstraints);
        this.groupNameTextField.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("EJB_GROUP_NAME_DESC"));
        this.serverHostLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("SERVER_HOST_MNEMONIC").charAt(0));
        this.serverHostLabel.setLabelFor(this.serverHostTextField);
        this.serverHostLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("SERVER_HOST_LABEL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.serverHostLabel, gridBagConstraints);
        this.serverHostLabel.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("SERVER_HOST_DESC"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 5, 0, 12);
        this.add((Component)this.serverHostTextField, gridBagConstraints);
        this.serverHostTextField.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("SERVER_HOST_DESC"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 5, 0, 12);
        this.add((Component)this.iiopPortTextField, gridBagConstraints);
        this.iiopPortTextField.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("IIOP_PORT_DESC"));
        this.iiopPortLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("IIOP_PORT_MNEMONIC_R").charAt(0));
        this.iiopPortLabel.setLabelFor(this.iiopPortTextField);
        this.iiopPortLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("IIOP_PORT_LABEL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 12, 0, 0);
        this.add((Component)this.iiopPortLabel, gridBagConstraints);
        this.iiopPortLabel.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("IIOP_PORT_DESC"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.paddingPanel, gridBagConstraints);
    }
}

