/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.ejb.datamodel;

import java.util.ArrayList;
import java.util.Iterator;
import org.netbeans.modules.visualweb.ejb.datamodel.MethodParam;
import org.netbeans.modules.visualweb.ejb.datamodel.MethodReturn;

public class MethodInfo
implements Cloneable,
Comparable {
    private boolean isBusinessMethod = true;
    private String name;
    private String description;
    private ArrayList parameters;
    private MethodReturn returnType;
    private ArrayList exceptions;
    private String dataprovider;

    public MethodInfo(String string, String string2, ArrayList arrayList, MethodReturn methodReturn, ArrayList arrayList2) {
        this.isBusinessMethod = true;
        this.name = string;
        this.description = string2;
        this.parameters = arrayList;
        this.returnType = methodReturn;
        this.exceptions = arrayList2;
    }

    public MethodInfo(boolean bl, String string, String string2, ArrayList arrayList, MethodReturn methodReturn, ArrayList arrayList2) {
        this.isBusinessMethod = bl;
        this.name = string;
        this.description = string2;
        this.parameters = arrayList;
        this.returnType = methodReturn;
        this.exceptions = arrayList2;
    }

    public MethodInfo() {
        this(null, null, null, null, null);
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setParameters(ArrayList arrayList) {
        this.parameters = arrayList;
    }

    public void addParameter(MethodParam methodParam) {
        if (this.parameters == null) {
            this.parameters = new ArrayList();
        }
        this.parameters.add(methodParam);
    }

    public boolean isParamNameUnique(String string) {
        for (int i = 0; i < this.parameters.size(); ++i) {
            MethodParam methodParam = (MethodParam)this.parameters.get(i);
            if (!methodParam.getName().equals(string)) continue;
            return false;
        }
        return true;
    }

    public boolean hasNoParameters() {
        return this.parameters == null || this.parameters.isEmpty();
    }

    public void setReturnType(MethodReturn methodReturn) {
        this.returnType = methodReturn;
    }

    public void addException(String string) {
        if (this.exceptions == null) {
            this.exceptions = new ArrayList();
        }
        this.exceptions.add(string);
    }

    public void setExceptions(ArrayList arrayList) {
        this.exceptions = arrayList;
    }

    public void setIsBusinessMethod(boolean bl) {
        this.isBusinessMethod = bl;
    }

    public void setDataProvider(String string) {
        this.dataprovider = string;
    }

    public boolean isMethodConfigurable() {
        if (!this.isBusinessMethod()) {
            return false;
        }
        return this.getParameters() != null && !this.getParameters().isEmpty() || this.getReturnType().isCollection();
    }

    public boolean isBusinessMethod() {
        return this.isBusinessMethod;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public ArrayList getParameters() {
        if (this.parameters == null) {
            return new ArrayList();
        }
        return this.parameters;
    }

    public String getDataProvider() {
        return this.dataprovider;
    }

    public MethodReturn getReturnType() {
        return this.returnType;
    }

    public ArrayList getExceptions() {
        return this.exceptions;
    }

    public String getParametersAsOneStr() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.parameters != null && !this.parameters.isEmpty()) {
            boolean bl = true;
            for (MethodParam methodParam : this.parameters) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(methodParam.toString());
            }
        }
        return stringBuffer.toString();
    }

    public Class[] getParameterTypes() {
        if (this.parameters == null) {
            return null;
        }
        Class[] classArray = new Class[this.parameters.size()];
        for (int i = 0; i < this.parameters.size(); ++i) {
            MethodParam methodParam = (MethodParam)this.parameters.get(i);
            try {
                Class<?> clazz;
                classArray[i] = clazz = Class.forName(methodParam.getType());
                continue;
            }
            catch (Exception exception) {
                classArray[i] = null;
            }
        }
        return classArray;
    }

    public String getExceptionsAsOneStr() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.exceptions != null && !this.exceptions.isEmpty()) {
            boolean bl = true;
            for (String string : this.exceptions) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    public Object clone() {
        try {
            ArrayList<Object> arrayList;
            MethodInfo methodInfo = (MethodInfo)super.clone();
            if (this.parameters != null) {
                arrayList = new ArrayList<Object>();
                for (MethodParam methodParam : this.parameters) {
                    arrayList.add(new MethodParam(methodParam.getName(), methodParam.getType()));
                }
                methodInfo.setParameters(arrayList);
            }
            if (this.exceptions != null) {
                arrayList = new ArrayList();
                Iterator iterator = this.exceptions.iterator();
                while (iterator.hasNext()) {
                    arrayList.add(new String((String)iterator.next()));
                }
                methodInfo.setExceptions(arrayList);
            }
            return methodInfo;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String getSignature() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("public ");
        stringBuffer.append(this.getReturnType().getClassName());
        stringBuffer.append(" ");
        stringBuffer.append(this.getName());
        stringBuffer.append("(");
        if (this.parameters != null && this.parameters.size() != 0) {
            for (int i = 0; i < this.parameters.size(); ++i) {
                MethodParam methodParam = (MethodParam)this.parameters.get(i);
                if (i != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(methodParam.getType());
            }
        }
        stringBuffer.append(") throws ");
        stringBuffer.append(this.getExceptionsAsOneStr());
        stringBuffer.append(" \n");
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("public ");
        stringBuffer.append(this.getReturnType().getClassName());
        stringBuffer.append(" ");
        stringBuffer.append(this.getName());
        stringBuffer.append("(");
        if (this.parameters != null && this.parameters.size() != 0) {
            for (int i = 0; i < this.parameters.size(); ++i) {
                MethodParam methodParam = (MethodParam)this.parameters.get(i);
                if (i != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(methodParam.toString());
            }
        }
        stringBuffer.append(") throws ");
        stringBuffer.append(this.getExceptionsAsOneStr());
        stringBuffer.append(" \n");
        return stringBuffer.toString();
    }

    public int compareTo(Object object) {
        if (object == null || !(object instanceof MethodInfo)) {
            return 0;
        }
        String string = ((MethodInfo)object).getName();
        return this.getName().compareTo(string);
    }
}

