/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.ejb;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.netbeans.modules.visualweb.ejb.datamodel.EjbGroup;
import org.netbeans.modules.visualweb.ejb.load.EjbDataSourceXmlCreator;
import org.netbeans.modules.visualweb.ejb.load.EjbDataSourceXmlParser;
import org.netbeans.modules.visualweb.ejb.util.Util;
import org.openide.ErrorManager;

public class EjbRefMaintainer {
    private String xmlFile;

    public EjbRefMaintainer(String string) {
        this.xmlFile = string;
    }

    public void addToEjbRefXml(EjbGroup ejbGroup) {
        try {
            Object object;
            Collection<EjbGroup> collection = null;
            if (new File(this.xmlFile).exists()) {
                object = new EjbDataSourceXmlParser(this.xmlFile);
                collection = ((EjbDataSourceXmlParser)object).parse();
            } else {
                collection = new HashSet();
            }
            object = collection.iterator();
            while (object.hasNext()) {
                if (!Util.getFileName(((EjbGroup)object.next()).getClientWrapperBeanJar()).equals(Util.getFileName(ejbGroup.getClientWrapperBeanJar()))) continue;
                return;
            }
            collection.add(ejbGroup);
            this.writeToFile(collection);
        }
        catch (Exception exception) {
            ErrorManager.getDefault().getInstance("org.netbeans.modules.visualweb.ejb.EjbRefMaintainer").log(65536, exception.getMessage());
            exception.printStackTrace();
        }
    }

    public void removeFromEjbRefXml(ArrayList arrayList) {
        try {
            EjbDataSourceXmlParser ejbDataSourceXmlParser = new EjbDataSourceXmlParser(this.xmlFile);
            Collection collection = ejbDataSourceXmlParser.parse();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                EjbGroup ejbGroup = (EjbGroup)iterator.next();
                boolean bl = true;
                Iterator iterator2 = ejbGroup.getClientJarFiles().iterator();
                while (iterator2.hasNext()) {
                    String string = Util.getFileName((String)iterator2.next());
                    if (arrayList.contains(string)) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                iterator.remove();
            }
            this.writeToFile(collection);
        }
        catch (Exception exception) {
            ErrorManager.getDefault().getInstance("org.netbeans.modules.visualweb.ejb.EjbRefMaintainer").log(65536, exception.getMessage());
            exception.printStackTrace();
        }
    }

    public Collection getRefferedEjbGroups() {
        try {
            EjbDataSourceXmlParser ejbDataSourceXmlParser = new EjbDataSourceXmlParser(this.xmlFile);
            return ejbDataSourceXmlParser.parse();
        }
        catch (Exception exception) {
            ErrorManager.getDefault().getInstance("org.netbeans.modules.visualweb.ejb.EjbRefMaintainer").log(65536, exception.getMessage());
            exception.printStackTrace();
            return null;
        }
    }

    public void updateEjbRefXml(EjbGroup ejbGroup, EjbGroup ejbGroup2) {
        try {
            EjbDataSourceXmlParser ejbDataSourceXmlParser = new EjbDataSourceXmlParser(this.xmlFile);
            Collection collection = ejbDataSourceXmlParser.parse();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                EjbGroup ejbGroup3 = (EjbGroup)iterator.next();
                if (!ejbGroup3.getName().equals(ejbGroup.getName())) continue;
                iterator.remove();
                break;
            }
            collection.add(ejbGroup2);
            this.writeToFile(collection);
        }
        catch (Exception exception) {
            ErrorManager.getDefault().getInstance("org.netbeans.modules.visualweb.ejb.EjbRefMaintainer").log(16, exception.getMessage());
            exception.printStackTrace();
        }
    }

    public void updateEjbRefXml(Collection collection) {
        this.writeToFile(collection);
    }

    private void writeToFile(Collection collection) {
        try {
            File file = new File(this.xmlFile);
            if (!file.exists()) {
                file.createNewFile();
            }
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
            EjbDataSourceXmlCreator ejbDataSourceXmlCreator = new EjbDataSourceXmlCreator(collection, (Writer)bufferedWriter);
            ejbDataSourceXmlCreator.toXml();
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public EjbGroup findReferredEjbGroup(String string) {
        try {
            EjbDataSourceXmlParser ejbDataSourceXmlParser = new EjbDataSourceXmlParser(this.xmlFile);
            Collection collection = ejbDataSourceXmlParser.parse();
            for (EjbGroup ejbGroup : collection) {
                Iterator iterator = ejbGroup.getClientJarFiles().iterator();
                while (iterator.hasNext()) {
                    String string2 = Util.getFileName((String)iterator.next());
                    if (!string2.equals(string)) continue;
                    return ejbGroup;
                }
            }
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

