/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.complib;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.netbeans.modules.visualweb.complib.Complib;
import org.netbeans.modules.visualweb.complib.ComplibManifest;
import org.netbeans.modules.visualweb.complib.IdeUtil;
import org.netbeans.modules.visualweb.complib.api.ComplibException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComplibPackage {
    private ResourceClassLoader resourceClassLoader;
    private ComplibManifest complibManifest;
    private File packageFile;

    public ComplibPackage(File file) throws ComplibException, IOException {
        File file2 = IdeUtil.freeJarFile(file);
        JarFile jarFile = new JarFile(file2);
        Manifest manifest = jarFile.getManifest();
        if (manifest == null) {
            String string = file2.equals(file) ? "" : "' copied from '" + file;
            throw new ComplibException("File '" + file2 + string + "' must contain a complib manifest.");
        }
        URL uRL = file2.toURI().toURL();
        this.resourceClassLoader = new ResourceClassLoader(uRL);
        this.complibManifest = ComplibManifest.getInstance(manifest, (ClassLoader)this.resourceClassLoader);
        jarFile.close();
        this.packageFile = file2;
    }

    public ComplibManifest getManifest() {
        return this.complibManifest;
    }

    public List<Complib.InitialPaletteFolder> getInitialPaletteFolders() {
        return this.complibManifest.getInitialPalette();
    }

    public String getTitle() {
        return this.complibManifest.getTitle();
    }

    public Complib.Identifier getIdentifer() {
        return this.complibManifest.getIdentifier();
    }

    File getPackageFile() {
        return this.packageFile;
    }

    private static class ResourceClassLoader
    extends URLClassLoader {
        public ResourceClassLoader(URL uRL) {
            super(new URL[0], ResourceClassLoader.class.getClassLoader());
            this.addURL(uRL);
        }
    }
}

