/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.complib;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ListResourceBundle;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.netbeans.modules.visualweb.complib.Complib;
import org.netbeans.modules.visualweb.complib.IdeUtil;
import org.netbeans.modules.visualweb.complib.ManifestAttributeException;
import org.netbeans.modules.visualweb.complib.Version;
import org.netbeans.modules.visualweb.complib.XmlException;
import org.netbeans.modules.visualweb.complib.XmlUtil;
import org.netbeans.modules.visualweb.complib.api.ComplibException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ComplibManifest {
    static final String MISSING = "Missing attribute: ";
    static final String PREFIX = "X-Rave-";
    private static final String MISSING_RESOURCE = "Missing resource: ";
    private static final String API_COMPAT_VERSION = "X-Rave-API-Compatibility-Version";
    private static final Version VERSION_1_0_0 = new Version(1, 0, 0);
    private static final Version VERSION_2_0_0 = new Version(2, 0, 0);
    private static final String CONFIGURATION = "X-Rave-Complib-Configuration";
    private static final String ELM_ROOT = "complibConfiguration";
    private static final String ELM_DESIGN_TIME_PATH = "designTimePath";
    private static final String ATT_RESOURCE_BUNDLE = "resourceBundleBaseName";
    private static final String RESOURCE_BUNDLE_PREFIX = "META-INF.";
    private static final String XP_PREFIX = "/complibConfiguration/";
    private static final String XP_CONFIG_VERSION = "/complibConfiguration/@version";
    private static final String XP_IDENTIFIER_URI = "/complibConfiguration/identifier/uri/text()";
    private static final String XP_IDENTIFIER_VERSION = "/complibConfiguration/identifier/version/text()";
    private static final String XP_TITLE_KEY = "/complibConfiguration/titleKey/text()";
    private static final String XP_RUNTIME_PATH = "/complibConfiguration/runtimePath";
    private static final String XP_DESIGN_TIME_PATH = "/complibConfiguration/designTimePath";
    private static final String XP_JAVADOC_PATH = "/complibConfiguration/javadocPath";
    private static final String XP_SOURCE_PATH = "/complibConfiguration/sourcePath";
    private static final String XP_WEB_RESOURCE_PATH = "/complibConfiguration/webResourcePath";
    private static final String XP_HELP_PATH = "/complibConfiguration/helpPath";
    private static final String XP_HELP_PREFIX = "/complibConfiguration/helpPath/@helpPrefix";
    private static final String XP_HELP_SET_FILE = "/complibConfiguration/helpPath/@helpSetFile";
    private static final String XP_INITIAL_PALETTE_FOLDER = "/complibConfiguration/initialPalette/folder";
    private static final String XP_PATH_ELEMENT = "pathElement";
    private static final String XP_EE_SPEC_VERSION = "/complibConfiguration/eeSpecification/@version";
    private static final String XP_SUN_FACES_CONFIG = "/complibConfiguration/sunFacesConfig/text()";
    private static final String ATT_CLASS_NAME = "className";
    private static final String ELM_ITEM = "item";
    private static final String ATT_KEY = "key";
    private static final String REQUIRES = "Complib configuration requires: ";
    private static final String BAD_VALUE = "Complib configuration has invalid value for: ";
    private static String complibConfigAttr;
    private Document doc;
    private ResourceBundle rb;
    private static final EmptyResourceBundle emptyResourceBundle;
    private ArrayList<Complib.InitialPaletteFolder> topFolders = new ArrayList();
    protected Complib.Identifier identifier;
    protected String title;
    protected List<String> runtimePath;
    protected List<String> declaredDesignTimePath;
    protected boolean prependRuntimePath;
    protected List<String> javadocPath;
    protected List<String> sourcePath;
    private List<String> webResourcePath;
    private List<String> helpPath;
    private String helpPrefix;
    private String helpSetFile;
    private String sunFacesConfig;
    private EeSpecVersion eeSpecVersion;
    private static XmlUtil configXmlUtil;
    private static final List<String> EMPTY_LIST;

    static ComplibManifest getInstance(Manifest manifest, ClassLoader classLoader) throws ComplibException, IOException {
        ComplibManifest complibManifest;
        Attributes attributes = manifest.getMainAttributes();
        String string = attributes.getValue(API_COMPAT_VERSION);
        if (string == null) {
            throw new ManifestAttributeException("Missing attribute: X-Rave-API-Compatibility-Version");
        }
        Version version = new Version(string);
        if (VERSION_2_0_0.equals(version)) {
            complibConfigAttr = attributes.getValue(CONFIGURATION);
            if (complibConfigAttr == null) {
                throw new ManifestAttributeException("Missing attribute: X-Rave-Complib-Configuration");
            }
            URL uRL = classLoader.getResource(complibConfigAttr);
            if (uRL == null) {
                throw new ComplibException(MISSING_RESOURCE + complibConfigAttr);
            }
            configXmlUtil = new XmlUtil();
            Document document = configXmlUtil.read(uRL);
            complibManifest = new ComplibManifest(document, classLoader);
        } else if (VERSION_1_0_0.equals(version)) {
            complibManifest = new LegacyManifest(attributes);
        } else {
            throw new ManifestAttributeException("X-Rave-API-Compatibility-Version must be " + VERSION_2_0_0 + " or " + VERSION_1_0_0);
        }
        return complibManifest;
    }

    static ComplibManifest getInstance(URL uRL, ClassLoader classLoader) throws ComplibException, XmlException {
        Document document = new XmlUtil().read(uRL);
        return new ComplibManifest(document, classLoader);
    }

    private ComplibManifest() {
    }

    private ComplibManifest(Document document, ClassLoader classLoader) throws XmlException, ComplibException {
        String string;
        int n;
        this.doc = document;
        Element element = document.getDocumentElement();
        if (!ELM_ROOT.equals(element.getNodeName())) {
            throw new ComplibException("Complib configuration root element must be 'complibConfiguration'");
        }
        Attr attr = (Attr)XmlUtil.selectSingleNode(document, XP_CONFIG_VERSION);
        String string2 = attr.getValue();
        if ("1.0".equals(string2)) {
            n = 1;
        } else if ("1.1".equals(string2)) {
            n = 11;
        } else if ("1.2".equals(string2)) {
            n = 12;
        } else {
            throw new ComplibException("Complib configuration root element @version must be '1.0' or '1.1' or '1.2'");
        }
        this.initResourceBundle(element, classLoader);
        String string3 = this.getRequiredTextNode(XP_IDENTIFIER_URI);
        String string4 = this.getRequiredTextNode(XP_IDENTIFIER_VERSION);
        this.identifier = new Complib.Identifier(string3, string4);
        String string5 = this.getRequiredTextNode(XP_TITLE_KEY);
        this.title = this.getResource(string5);
        this.runtimePath = this.getRequiredConfigPath(XP_RUNTIME_PATH);
        this.declaredDesignTimePath = this.getConfigPath(XP_DESIGN_TIME_PATH);
        this.javadocPath = this.getConfigPath(XP_JAVADOC_PATH);
        this.sourcePath = this.getConfigPath(XP_SOURCE_PATH);
        this.webResourcePath = this.getConfigPath(XP_WEB_RESOURCE_PATH);
        Attr attr2 = (Attr)XmlUtil.selectSingleNode(document, XP_HELP_PREFIX);
        if (attr2 != null) {
            this.helpPrefix = attr2.getValue();
        }
        if ((attr2 = (Attr)XmlUtil.selectSingleNode(document, XP_HELP_SET_FILE)) != null) {
            this.helpSetFile = attr2.getValue();
        }
        this.helpPath = this.getConfigPath(XP_HELP_PATH);
        this.initPaletteData();
        this.eeSpecVersion = EeSpecVersion.J2EE_1_4;
        attr2 = (Attr)XmlUtil.selectSingleNode(document, XP_EE_SPEC_VERSION);
        String string6 = string = attr2 == null ? null : attr2.getValue();
        if (string != null) {
            if ("5".equals(string)) {
                this.eeSpecVersion = EeSpecVersion.JAVA_EE_5;
            } else if (n > 11 && !"1.4".equals(string)) {
                throw new ComplibException("Complib configuration has invalid value for: /complibConfiguration/eeSpecification/@version");
            }
        }
        this.sunFacesConfig = this.getOptionalTextNode(XP_SUN_FACES_CONFIG, null);
    }

    private String getRequiredTextNode(String string) throws XmlException, ComplibException {
        Text text = (Text)XmlUtil.selectSingleNode(this.doc, string);
        if (text == null) {
            throw new ComplibException(REQUIRES + string);
        }
        return text.getNodeValue().trim();
    }

    private String getOptionalTextNode(String string, String string2) throws XmlException {
        Text text = (Text)XmlUtil.selectSingleNode(this.doc, string);
        if (text == null) {
            return string2;
        }
        return text.getNodeValue().trim();
    }

    private List<String> getRequiredConfigPath(String string) throws XmlException, ComplibException {
        List<String> list = this.getConfigPath(string);
        if (list.isEmpty()) {
            throw new ComplibException(REQUIRES + string);
        }
        return list;
    }

    private List<String> getConfigPath(String string) throws XmlException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Element element = (Element)XmlUtil.selectSingleNode(this.doc, string);
        if (element == null) {
            return arrayList;
        }
        NodeList nodeList = XmlUtil.selectNodeList(element, XP_PATH_ELEMENT);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string2;
            Element element2 = (Element)nodeList.item(i);
            Text text = (Text)XmlUtil.selectSingleNode(element2, "text()");
            if (text == null || "" == (string2 = text.getNodeValue()).trim()) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    private boolean getBoolean(String string, boolean bl) throws XmlException {
        Attr attr = (Attr)XmlUtil.selectSingleNode(this.doc, string);
        if (attr == null) {
            return bl;
        }
        return "true".equalsIgnoreCase(attr.getValue().trim());
    }

    private void initPaletteData() throws XmlException {
        NodeList nodeList = XmlUtil.selectNodeList(this.doc, XP_INITIAL_PALETTE_FOLDER);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            Complib.InitialPaletteFolder initialPaletteFolder = this.createFolderRecurse(element);
            this.topFolders.add(initialPaletteFolder);
        }
    }

    private Complib.InitialPaletteFolder createFolderRecurse(Element element) throws XmlException {
        String string = element.getAttribute(ATT_KEY);
        Complib.InitialPaletteFolder initialPaletteFolder = new Complib.InitialPaletteFolder(this.getResource(string));
        NodeList nodeList = XmlUtil.selectNodeList(element, "*");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            String string2 = element2.getNodeName();
            if (ELM_ITEM.equals(string2)) {
                Complib.InitialPaletteItem initialPaletteItem = this.createItemRecurse(element2);
                initialPaletteFolder.appendChild(initialPaletteItem);
                continue;
            }
            IdeUtil.logWarning(new IllegalArgumentException("Skipping invalid element in initial palette: " + string2));
        }
        return initialPaletteFolder;
    }

    private Complib.InitialPaletteItem createItemRecurse(Element element) throws XmlException {
        String string = element.getAttribute(ATT_CLASS_NAME);
        Complib.InitialPaletteItem initialPaletteItem = new Complib.InitialPaletteItem(string);
        NodeList nodeList = XmlUtil.selectNodeList(element, "*");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            String string2 = element2.getNodeName();
            if (ELM_ITEM.equals(string2)) {
                Complib.InitialPaletteItem initialPaletteItem2 = this.createItemRecurse(element2);
                initialPaletteItem.appendChild(initialPaletteItem2);
                continue;
            }
            IdeUtil.logWarning(new IllegalArgumentException("Skipping invalid element in initial palette: " + string2));
        }
        return initialPaletteItem;
    }

    private void initResourceBundle(Element element, ClassLoader classLoader) {
        block7: {
            String string = element.getAttribute(ATT_RESOURCE_BUNDLE);
            if (string.length() != 0) {
                try {
                    if (string.indexOf(".") == -1) {
                        try {
                            this.rb = ResourceBundle.getBundle(RESOURCE_BUNDLE_PREFIX + string, Locale.getDefault(), classLoader);
                        }
                        catch (MissingResourceException missingResourceException) {
                            this.rb = ResourceBundle.getBundle(string, Locale.getDefault(), classLoader);
                        }
                        break block7;
                    }
                    this.rb = ResourceBundle.getBundle(string, Locale.getDefault(), classLoader);
                }
                catch (RuntimeException runtimeException) {
                    IdeUtil.logWarning(runtimeException);
                    this.rb = emptyResourceBundle;
                }
            } else {
                this.rb = emptyResourceBundle;
            }
        }
    }

    private String getResource(String string) {
        try {
            String string2 = this.rb.getString(string);
            return string2;
        }
        catch (RuntimeException runtimeException) {
            if (this.rb != emptyResourceBundle) {
                IdeUtil.logWarning(runtimeException);
            }
            return string;
        }
    }

    List<Complib.InitialPaletteFolder> getInitialPalette() {
        return this.topFolders;
    }

    List<String> getDeclaredDesignTimePath() {
        return this.declaredDesignTimePath;
    }

    List<String> getHelpPath() {
        return this.helpPath == null ? EMPTY_LIST : this.helpPath;
    }

    String getHelpSetFile() {
        return this.helpSetFile;
    }

    String getHelpPrefix() {
        return this.helpPrefix;
    }

    Complib.Identifier getIdentifier() {
        return this.identifier;
    }

    List<String> getJavadocPath() {
        return this.javadocPath == null ? EMPTY_LIST : this.javadocPath;
    }

    List<String> getRuntimePath() {
        return this.runtimePath;
    }

    List<String> getSourcePath() {
        return this.sourcePath == null ? EMPTY_LIST : this.sourcePath;
    }

    String getTitle() {
        return this.title;
    }

    List<String> getWebResourcePath() {
        return this.webResourcePath == null ? EMPTY_LIST : this.webResourcePath;
    }

    public EeSpecVersion getEeSpecVersion() {
        return this.eeSpecVersion;
    }

    String getSunFacesConfig() {
        return this.sunFacesConfig;
    }

    void addDeclaredDesignTimePath(File file) throws XmlException {
        Element element;
        Node node;
        String string = file.getName();
        this.declaredDesignTimePath.add(string);
        Element element2 = (Element)XmlUtil.selectSingleNode(this.doc, XP_DESIGN_TIME_PATH);
        if (element2 == null) {
            element2 = this.doc.createElement(ELM_DESIGN_TIME_PATH);
            node = (Element)XmlUtil.selectSingleNode(this.doc, XP_RUNTIME_PATH);
            element = (Element)node.getParentNode();
            Node node2 = node.getNextSibling();
            element.insertBefore(element2, node2);
        }
        node = this.doc.createTextNode(string);
        element = this.doc.createElement(XP_PATH_ELEMENT);
        element.appendChild(node);
        element2.appendChild(element);
    }

    void saveTo(File file) throws XmlException {
        File file2 = new File(file, complibConfigAttr);
        configXmlUtil.write(file2);
    }

    static {
        emptyResourceBundle = new EmptyResourceBundle();
        EMPTY_LIST = Collections.emptyList();
    }

    private static class EmptyResourceBundle
    extends ListResourceBundle {
        private static final Object[][] contents = new Object[0][];

        private EmptyResourceBundle() {
        }

        protected Object[][] getContents() {
            return contents;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LegacyManifest
    extends ComplibManifest {
        private static final String LIBRARY_URI = "X-Rave-Library-URI";
        private static final String LIBRARY_VERSION = "X-Rave-Library-Version";
        private static final String LIBRARY_TITLE = "X-Rave-Library-Title";
        private static final String RUNTIME_PATH = "X-Rave-Runtime-Path";
        private static final String DESIGN_TIME_PATH = "X-Rave-Design-Time-Path";
        private static final String JAVADOC_PATH = "X-Rave-Javadoc-Path";
        private static final String SOURCE_PATH = "X-Rave-Source-Path";

        public LegacyManifest(Attributes attributes) throws ComplibException {
            String string = attributes.getValue(LIBRARY_URI);
            if (string == null) {
                throw new ManifestAttributeException("Missing attribute: X-Rave-Library-URI");
            }
            String string2 = attributes.getValue(LIBRARY_VERSION);
            if (string2 == null) {
                throw new ManifestAttributeException("Missing attribute: X-Rave-Library-Version");
            }
            this.identifier = new Complib.Identifier(string, string2);
            String string3 = attributes.getValue(LIBRARY_TITLE);
            if (string3 == null) {
                throw new ManifestAttributeException("Missing attribute: X-Rave-Library-Title");
            }
            this.title = string3;
            string3 = attributes.getValue(RUNTIME_PATH);
            if (string3 == null || "".equals(string3.trim())) {
                throw new ManifestAttributeException("Missing attribute: X-Rave-Runtime-Path");
            }
            this.runtimePath = this.splitPath(string3);
            string3 = attributes.getValue(DESIGN_TIME_PATH);
            if (string3 == null || "".equals(string3.trim())) {
                throw new ManifestAttributeException("Missing attribute: X-Rave-Design-Time-Path");
            }
            this.declaredDesignTimePath = this.splitPath(string3);
            ArrayList<String> arrayList = new ArrayList<String>(this.runtimePath);
            arrayList.addAll(this.splitPath(string3));
            this.javadocPath = this.splitPath(attributes.getValue(JAVADOC_PATH));
            this.sourcePath = this.splitPath(attributes.getValue(SOURCE_PATH));
        }

        private List<String> splitPath(String string) {
            if (string == null) {
                return new ArrayList<String>(0);
            }
            String[] stringArray = string.split("\\s");
            return Arrays.asList(stringArray);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EeSpecVersion {
        J2EE_1_4,
        JAVA_EE_5;

    }
}

