/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.libraries.ui.customizer;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractListModel;
import javax.swing.event.TableModelListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.javascript.libraries.util.JSLibraryData;
import org.netbeans.modules.javascript.libraries.util.JSLibraryProjectUtils;
import org.openide.util.NbBundle;

class JavaScriptLibraryListModel
extends AbstractListModel {
    private List<LibraryRow> libraryData = new ArrayList<LibraryRow>();
    private List<TableModelListener> listeners = new ArrayList<TableModelListener>();
    private final Project project;

    public JavaScriptLibraryListModel(Project project) {
        this.project = project;
        this.init();
    }

    private void init() {
        Set<JSLibraryData> set = JSLibraryProjectUtils.getJSLibraryData(this.project);
        for (JSLibraryData jSLibraryData : set) {
            this.libraryData.add(new LibraryRow(jSLibraryData.getLibraryName(), jSLibraryData.getLibraryLocation()));
        }
    }

    public int getSize() {
        return this.libraryData.size();
    }

    public Object getElementAt(int n) {
        return this.libraryData.get(n).getDisplayName();
    }

    public String getLibraryNameAt(int n) {
        return this.libraryData.get(n).getLibraryName();
    }

    public String getLibraryLocationAt(int n) {
        return this.libraryData.get(n).getDisplayLocation();
    }

    public void appendLibrary(String string, String string2) {
        this.libraryData.add(new LibraryRow(string, string2));
        int n = this.libraryData.size() - 1;
        this.fireIntervalAdded(this, n, n);
    }

    public void removeLibrary(int n) {
        this.libraryData.remove(n);
        this.fireIntervalRemoved(this, n, n);
    }

    public void removeLibrary(String string) {
        for (int i = 0; i < this.libraryData.size(); ++i) {
            if (!this.libraryData.get(i).getLibraryName().equals(string)) continue;
            this.removeLibrary(i);
            return;
        }
    }

    public void changeLibrary(int n, String string, String string2) {
        LibraryRow libraryRow = this.libraryData.get(n);
        string = string != null ? string : libraryRow.getLibraryName();
        string2 = string2 != null ? string2 : libraryRow.getLibraryLocation();
        this.libraryData.set(n, new LibraryRow(string, string2));
        this.fireContentsChanged(this, n, n);
    }

    private final class LibraryRow {
        private final String libraryName;
        private final String libraryLocation;
        private final String displayName;
        private final String displayLocation;

        public LibraryRow(String string, String string2) {
            assert (string != null);
            this.libraryName = string;
            this.libraryLocation = string2;
            LibraryManager libraryManager = JSLibraryProjectUtils.getLibraryManager(JavaScriptLibraryListModel.this.project);
            Library library = libraryManager.getLibrary(string);
            this.displayName = library == null ? this.getDefaultDisplayName() : (this.libraryLocation == null ? NbBundle.getMessage(JavaScriptLibraryListModel.class, (String)"CustomizerJSLibraries_NoLocation", (Object)library.getDisplayName()) : (JSLibraryProjectUtils.isLibraryFolderEmpty(JavaScriptLibraryListModel.this.project, library, this.libraryLocation) ? NbBundle.getMessage(JavaScriptLibraryListModel.class, (String)"CustomizerJSLibraries_NoFilesForLibrary", (Object)library.getDisplayName()) : library.getDisplayName()));
            this.displayLocation = this.libraryLocation != null ? this.libraryLocation : NbBundle.getMessage(JavaScriptLibraryListModel.class, (String)"CustomizerJSLibraries_MissingLocation");
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getDisplayLocation() {
            return this.displayLocation;
        }

        public String getLibraryLocation() {
            return this.libraryLocation;
        }

        public String getLibraryName() {
            return this.libraryName;
        }

        private String getDefaultDisplayName() {
            return NbBundle.getMessage(JavaScriptLibraryListModel.class, (String)"CustomizerJSLibraries_MissingReference", (Object)this.libraryName);
        }
    }
}

