/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.libraries.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryChooser;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.javascript.libraries.util.JSLibraryData;
import org.netbeans.modules.javascript.libraries.util.JSLibraryProjectUtils;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AddLibraryTableModel
extends AbstractTableModel
implements PropertyChangeListener {
    private static final int COLUMN_COUNT = 4;
    private final List<LibraryRowModel> tableRows;
    private final LibraryManager manager;
    private final LibraryChooser.Filter filter;
    private final Project project;
    private final Object lock = new Object();

    public AddLibraryTableModel(Project project, LibraryChooser.Filter filter) {
        this.project = project;
        this.manager = JSLibraryProjectUtils.getLibraryManager(project);
        this.tableRows = new ArrayList<LibraryRowModel>();
        this.filter = filter;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        List<LibraryRowModel> list = this.tableRows;
        synchronized (list) {
            List<Library> list2 = this.getFilteredLibraries();
            for (Library library : list2) {
                this.tableRows.add(new LibraryRowModel(library));
            }
        }
        this.manager.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.manager));
    }

    private List<Library> getFilteredLibraries() {
        Library[] libraryArray;
        ArrayList<Library> arrayList = new ArrayList<Library>();
        for (Library library : libraryArray = this.manager.getLibraries()) {
            if (!this.filter.accept(library)) continue;
            arrayList.add(library);
        }
        return arrayList;
    }

    @Override
    public int getRowCount() {
        return this.tableRows.size();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        LibraryRowModel libraryRowModel = this.tableRows.get(n);
        switch (n2) {
            case 0: {
                return libraryRowModel.isSelected();
            }
            case 1: {
                return libraryRowModel.getLibraryDisplayName();
            }
            case 2: {
                return libraryRowModel.getDestination();
            }
        }
        return libraryRowModel;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (n2 == 0) {
            return true;
        }
        boolean bl = this.tableRows.get(n).isSelected();
        return bl && (n2 == 2 || n2 == 3);
    }

    @Override
    public Class<?> getColumnClass(int n) {
        switch (n) {
            case 0: {
                return Boolean.class;
            }
        }
        return Object.class;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        LibraryRowModel libraryRowModel = this.tableRows.get(n);
        if (n2 == 0) {
            assert (object instanceof Boolean);
            libraryRowModel.setSelected((Boolean)object);
        } else {
            libraryRowModel.setDestination((String)object);
        }
    }

    @Override
    public String getColumnName(int n) {
        ResourceBundle resourceBundle = NbBundle.getBundle(AddLibraryTableModel.class);
        switch (n) {
            case 0: {
                return resourceBundle.getString("AddLibraryPanel_AddLabel");
            }
            case 1: {
                return resourceBundle.getString("AddLibraryPanel_NameLabel");
            }
            case 2: {
                return resourceBundle.getString("AddLibraryPanel_LocationLabel");
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("libraries")) {
            Object object = this.lock;
            synchronized (object) {
                ArrayList<LibraryRowModel> arrayList = new ArrayList<LibraryRowModel>();
                arrayList.addAll(this.tableRows);
                this.tableRows.clear();
                List<Library> list = this.getFilteredLibraries();
                for (Library library : list) {
                    boolean bl = false;
                    for (LibraryRowModel libraryRowModel : arrayList) {
                        if (libraryRowModel.getLibrary().equals((Object)library)) {
                            bl = true;
                            this.tableRows.add(libraryRowModel);
                        }
                        if (bl) continue;
                        this.tableRows.add(new LibraryRowModel(library));
                    }
                }
            }
            this.fireTableDataChanged();
        }
    }

    public List<JSLibraryData> getSelectedLibraries() {
        ArrayList<JSLibraryData> arrayList = new ArrayList<JSLibraryData>();
        for (LibraryRowModel libraryRowModel : this.tableRows) {
            if (!libraryRowModel.isSelected()) continue;
            arrayList.add(new JSLibraryData(libraryRowModel.getLibrary().getName(), libraryRowModel.getDestination()));
        }
        return arrayList;
    }

    public LibraryRowModel getLibraryModel(int n) {
        return this.tableRows.get(n);
    }

    final class LibraryRowModel {
        private final Library library;
        private boolean selected;
        private String destination;
        private boolean init;
        private boolean hasError;

        public LibraryRowModel(Library library) {
            this.library = library;
            this.destination = "";
            this.selected = false;
            this.init = false;
            this.hasError = false;
        }

        public String getDestination() {
            return this.destination;
        }

        public Library getLibrary() {
            return this.library;
        }

        public String getLibraryDisplayName() {
            String string = this.library.getDisplayName();
            if (this.hasError) {
                string = "<html><font color=\"#A40000\"><b>" + string + "</b></font></html>";
            }
            return string;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setError(boolean bl) {
            if (bl != this.hasError) {
                this.fireCellUpdate(1);
                this.hasError = bl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int getRowInTable() {
            Object object = AddLibraryTableModel.this.lock;
            synchronized (object) {
                for (int i = 0; i < AddLibraryTableModel.this.tableRows.size(); ++i) {
                    if (AddLibraryTableModel.this.tableRows.get(i) != this) continue;
                    return i;
                }
            }
            return -1;
        }

        public void setDestination(String string) {
            this.init = true;
            this.destination = string;
            this.fireCellUpdate(2);
        }

        public void setSelected(boolean bl) {
            this.selected = bl;
            if (bl && !this.init) {
                this.destination = JSLibraryProjectUtils.getDefaultRelativeLibraryPath(AddLibraryTableModel.this.project, this.library);
            }
            this.fireCellUpdate(0);
            this.fireCellUpdate(2);
            this.fireCellUpdate(3);
        }

        private void fireCellUpdate(final int n) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    int n2 = LibraryRowModel.this.getRowInTable();
                    if (n2 != -1) {
                        AddLibraryTableModel.this.fireTableCellUpdated(n2, n);
                    }
                }
            });
        }
    }
}

