/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.libraries.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.libraries.LibraryChooser;
import org.netbeans.modules.javascript.libraries.ui.AddLibraryTableModel;
import org.netbeans.modules.javascript.libraries.util.JSLibraryData;
import org.netbeans.modules.javascript.libraries.util.JSLibraryProjectUtils;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AddLibraryPanel
extends JPanel {
    private final AddLibraryTableModel model;
    private final File projectFld;
    private final File baseDir;
    private final Project project;
    private final JButton okButton;
    private final CellEditorListener editListener;
    private JLabel errorMessage;
    private JLabel instructionsLabel;
    private JTable librariesTable;
    private JLabel tableLabel;
    private JScrollPane tableScrollPane;

    public AddLibraryPanel(Project project, LibraryChooser.Filter filter, JButton jButton) {
        File file;
        this.project = project;
        this.projectFld = FileUtil.toFile((FileObject)project.getProjectDirectory());
        try {
            file = new File(JSLibraryProjectUtils.getJSLibrarySourcePath(project)).getCanonicalFile();
        }
        catch (IOException iOException) {
            file = new File(JSLibraryProjectUtils.getJSLibrarySourcePath(project));
        }
        this.baseDir = file;
        this.okButton = jButton;
        this.initComponents();
        this.model = new AddLibraryTableModel(project, filter);
        this.librariesTable.setModel(this.model);
        this.editListener = new CellEditorListener(){

            public void editingStopped(ChangeEvent changeEvent) {
                AddLibraryPanel.this.processTextChange();
            }

            public void editingCanceled(ChangeEvent changeEvent) {
            }
        };
        TableColumn tableColumn = this.librariesTable.getColumnModel().getColumn(3);
        tableColumn.setCellRenderer(new ButtonColumnRenderer());
        tableColumn.setCellEditor(new ButtonColumnCellEditor());
        tableColumn.getCellEditor().addCellEditorListener(this.editListener);
        tableColumn = this.librariesTable.getColumnModel().getColumn(2);
        tableColumn.setCellRenderer(new CustomTextRenderer());
        this.librariesTable.getDefaultEditor(Object.class).addCellEditorListener(this.editListener);
        this.librariesTable.getDefaultEditor(Boolean.class).addCellEditorListener(this.editListener);
        this.initTableLayout();
    }

    private void initTableLayout() {
        this.librariesTable.setRowHeight(this.librariesTable.getRowHeight() + 4);
        this.librariesTable.setSelectionMode(0);
        this.librariesTable.setIntercellSpacing(new Dimension(0, 0));
        this.librariesTable.getParent().setBackground(this.librariesTable.getBackground());
        TableColumn tableColumn = this.librariesTable.getColumnModel().getColumn(0);
        JTableHeader jTableHeader = this.librariesTable.getTableHeader();
        tableColumn.setMaxWidth(24 + SwingUtilities.computeStringWidth(jTableHeader.getFontMetrics(jTableHeader.getFont()), String.valueOf(tableColumn.getHeaderValue())));
        this.librariesTable.setAutoResizeMode(4);
        tableColumn = this.librariesTable.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(175);
        tableColumn = this.librariesTable.getColumnModel().getColumn(2);
        tableColumn.setPreferredWidth(700);
        tableColumn.setMinWidth(75);
        tableColumn = this.librariesTable.getColumnModel().getColumn(3);
        tableColumn.setMaxWidth(24 + SwingUtilities.computeStringWidth(jTableHeader.getFontMetrics(jTableHeader.getFont()), String.valueOf(tableColumn.getHeaderValue())));
    }

    private void initComponents() {
        this.tableScrollPane = new JScrollPane();
        this.librariesTable = new JTable();
        this.tableLabel = new JLabel();
        this.errorMessage = new JLabel();
        this.instructionsLabel = new JLabel();
        this.librariesTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3"}));
        this.librariesTable.setAutoResizeMode(4);
        this.librariesTable.setShowHorizontalLines(false);
        this.librariesTable.setShowVerticalLines(false);
        this.tableScrollPane.setViewportView(this.librariesTable);
        this.librariesTable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddLibraryPanel.class, (String)"AddLibraryPanel.librariesTable.AccessibleContext.accessibleDescription"));
        this.tableLabel.setLabelFor(this.librariesTable);
        Mnemonics.setLocalizedText((JLabel)this.tableLabel, (String)NbBundle.getMessage(AddLibraryPanel.class, (String)"AddLibraryPanel.tableLabel.text", (Object[])new Object[0]));
        this.instructionsLabel.setText(NbBundle.getMessage(AddLibraryPanel.class, (String)"AddLibraryPanel.instructionsLabel.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (Component)this.tableScrollPane, -1, 908, Short.MAX_VALUE).add((Component)this.errorMessage).add((Component)this.tableLabel).add((Component)this.instructionsLabel)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.instructionsLabel).add(38, 38, 38).add((Component)this.tableLabel).addPreferredGap(0).add((Component)this.tableScrollPane, -2, 248, -2).addPreferredGap(0, 20, Short.MAX_VALUE).add((Component)this.errorMessage).addContainerGap()));
        this.tableScrollPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddLibraryPanel.class, (String)"AddLibraryPanel.tableScrollPane.AccessibleContext.accessibleName"));
        this.errorMessage.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddLibraryPanel.class, (String)"AddLibraryPanel.errorMessage.AccessibleContext.accessibleName"));
        this.instructionsLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddLibraryPanel.class, (String)"AddLibraryPanel.instructionsLabel.AccessibleContext.accessibleDescription"));
    }

    public List<JSLibraryData> getSelectedLibraries() {
        return this.model.getSelectedLibraries();
    }

    public void folderCreationFailed() {
        this.errorMessage.setText(NbBundle.getMessage(AddLibraryPanel.class, (String)"AddLibraryPanel_CouldNotCreateError"));
        this.errorMessage.setVisible(true);
        this.okButton.setEnabled(false);
    }

    private void processTextChange() {
        boolean bl = false;
        String string = null;
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            AddLibraryTableModel.LibraryRowModel libraryRowModel = this.model.getLibraryModel(i);
            if (!libraryRowModel.isSelected()) continue;
            String string2 = libraryRowModel.getDestination();
            File file = new File(string2);
            File file2 = file.isAbsolute() ? file : new File(this.projectFld, file.getPath());
            try {
                file2 = file2.getCanonicalFile();
            }
            catch (IOException iOException) {
                if (!bl) {
                    bl = true;
                    string = NbBundle.getMessage(AddLibraryPanel.class, (String)"AddLibraryPanel_InvalidFolderError");
                } else {
                    string = NbBundle.getMessage(AddLibraryPanel.class, (String)"AddLibraryPanel_MultipleErrors");
                }
                libraryRowModel.setError(true);
                continue;
            }
            file2 = FileUtil.normalizeFile((File)file2);
            if (!AddLibraryPanel.isParentFolder(this.baseDir, file2) && !AddLibraryPanel.isParentFolder(this.projectFld, file2)) {
                if (!bl) {
                    bl = true;
                    string = NbBundle.getMessage(AddLibraryPanel.class, (String)"AddLibraryPanel_OutOfRangeError");
                } else {
                    string = NbBundle.getMessage(AddLibraryPanel.class, (String)"AddLibraryPanel_MultipleErrors");
                }
                libraryRowModel.setError(true);
                continue;
            }
            libraryRowModel.setError(false);
        }
        if (!bl) {
            this.errorMessage.setText("");
            this.errorMessage.setVisible(false);
            this.okButton.setEnabled(true);
        } else {
            this.errorMessage.setText(string);
            this.errorMessage.setVisible(true);
            this.okButton.setEnabled(false);
        }
    }

    private static boolean isParentFolder(File file, File file2) {
        if (!file.isDirectory()) {
            return false;
        }
        HashSet<File> hashSet = new HashSet<File>();
        for (File file3 = file2; file3 != null && !hashSet.contains(file3); file3 = file3.getParentFile()) {
            hashSet.add(file3);
            if (!file3.equals(file)) continue;
            return true;
        }
        return false;
    }

    private class ButtonColumnCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private final JButton button = new JButton();
        private String lastSelection = "";
        private String currentFileName = "";

        public ButtonColumnCellEditor() {
            this.button.setOpaque(false);
            this.button.addActionListener(new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl = false;
                    try {
                        JFileChooser jFileChooser = new JFileChooser();
                        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
                        jFileChooser.setFileSelectionMode(1);
                        File file = new File(ButtonColumnCellEditor.this.currentFileName);
                        File file2 = file.isAbsolute() ? file : new File(AddLibraryPanel.this.projectFld, file.getPath());
                        jFileChooser.setSelectedFile(file2);
                        if (file2.exists()) {
                            jFileChooser.setSelectedFile(file2);
                        } else {
                            jFileChooser.setSelectedFile(new File(JSLibraryProjectUtils.getJSLibrarySourcePath(AddLibraryPanel.this.project)));
                        }
                        if (0 == jFileChooser.showOpenDialog(AddLibraryPanel.this)) {
                            File file3 = FileUtil.normalizeFile((File)jFileChooser.getSelectedFile());
                            ButtonColumnCellEditor.this.lastSelection = file3.getPath();
                            ButtonColumnCellEditor.this.fireEditingStopped();
                            bl = true;
                        } else {
                            ButtonColumnCellEditor.this.lastSelection = ButtonColumnCellEditor.this.currentFileName;
                            ButtonColumnCellEditor.this.fireEditingCanceled();
                            bl = true;
                        }
                    }
                    finally {
                        if (!bl) {
                            ButtonColumnCellEditor.this.fireEditingCanceled();
                        }
                    }
                }
            });
        }

        public Object getCellEditorValue() {
            return this.lastSelection;
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.currentFileName = AddLibraryPanel.this.model.getValueAt(n, 2).toString();
            boolean bl2 = (Boolean)AddLibraryPanel.this.model.getValueAt(n, 0);
            this.button.setEnabled(bl2);
            return this.button;
        }
    }

    private class CustomTextRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            String string = object != null ? object.toString() : AddLibraryPanel.this.model.getValueAt(n, 2).toString();
            Component component = super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
            boolean bl3 = (Boolean)AddLibraryPanel.this.model.getValueAt(n, 0);
            component.setEnabled(bl3);
            return component;
        }
    }

    private class ButtonColumnRenderer
    extends JButton
    implements TableCellRenderer {
        private JButton renderButton = new JButton(NbBundle.getMessage(AddLibraryPanel.class, (String)"AddLibraryPanel_BrowseButton"));

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            boolean bl3 = (Boolean)AddLibraryPanel.this.model.getValueAt(n, 0);
            this.renderButton.setEnabled(bl3);
            return this.renderButton;
        }
    }
}

