/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.heapwalk;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.netbeans.api.debugger.jpda.Field;
import org.netbeans.api.debugger.jpda.JPDAArrayType;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.lib.profiler.heap.FieldValue;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.Value;
import org.netbeans.modules.debugger.jpda.heapwalk.ArrayItemValueImpl;
import org.netbeans.modules.debugger.jpda.heapwalk.FieldValueImpl;
import org.netbeans.modules.debugger.jpda.heapwalk.HeapImpl;
import org.netbeans.modules.debugger.jpda.heapwalk.JavaClassImpl;
import org.netbeans.modules.debugger.jpda.heapwalk.ObjectArrayInstanceImpl;
import org.netbeans.modules.debugger.jpda.heapwalk.ObjectFieldValueImpl;
import org.netbeans.modules.debugger.jpda.heapwalk.PrimitiveArrayInstanceImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceImpl
implements Instance {
    private ObjectVariable var;
    protected HeapImpl heap;

    protected InstanceImpl(HeapImpl heapImpl, ObjectVariable objectVariable) {
        this.var = objectVariable;
        this.heap = heapImpl;
    }

    public static Instance createInstance(HeapImpl heapImpl, ObjectVariable objectVariable) {
        InstanceImpl instanceImpl;
        JPDAClassType jPDAClassType = objectVariable.getClassType();
        if (jPDAClassType instanceof JPDAArrayType) {
            boolean bl = false;
            boolean bl2 = bl = !(((JPDAArrayType)jPDAClassType).getComponentType() instanceof JPDAClassType);
            instanceImpl = bl ? new PrimitiveArrayInstanceImpl(heapImpl, objectVariable) : new ObjectArrayInstanceImpl(heapImpl, objectVariable);
        } else {
            instanceImpl = new InstanceImpl(heapImpl, objectVariable);
        }
        return instanceImpl;
    }

    public JavaClass getJavaClass() {
        JPDAClassType jPDAClassType = this.var.getClassType();
        if (jPDAClassType != null) {
            return new JavaClassImpl(this.heap, jPDAClassType);
        }
        return new JavaClassImpl(this.var.getType());
    }

    public long getInstanceId() {
        return this.var.getUniqueID();
    }

    public int getInstanceNumber() {
        return (int)this.var.getUniqueID();
    }

    public int getSize() {
        return 0;
    }

    public List<FieldValue> getFieldValues() {
        int n = this.var.getFieldsCount();
        Field[] fieldArray = this.var.getFields(0, n);
        ArrayList<FieldValue> arrayList = new ArrayList<FieldValue>(fieldArray.length);
        for (Field field : fieldArray) {
            if (field.isStatic()) continue;
            if (field instanceof ObjectVariable) {
                Instance instance = ((ObjectVariable)field).getUniqueID() == 0L ? null : InstanceImpl.createInstance(this.heap, (ObjectVariable)field);
                arrayList.add(new ObjectFieldValueImpl(this.heap, this, field, instance));
                continue;
            }
            arrayList.add(new FieldValueImpl(this.heap, this, field));
        }
        return arrayList;
    }

    public Object getValueOfField(String string) {
        return null;
    }

    public List<FieldValue> getStaticFieldValues() {
        return this.getJavaClass().getStaticFieldValues();
    }

    public List<Value> getReferences() {
        List list = this.var.getReferringObjects(0L);
        ArrayList<Value> arrayList = new ArrayList<Value>(list.size());
        HashSet<Field> hashSet = new HashSet<Field>();
        block0: for (ObjectVariable objectVariable : list) {
            Field[] fieldArray;
            int n;
            JPDAClassType jPDAClassType = objectVariable.getClassType();
            if (jPDAClassType instanceof JPDAArrayType) {
                n = objectVariable.getFieldsCount();
                int n2 = 1000;
                for (int i = 0; i < n; i += n2) {
                    int n3 = Math.min(i + n2, n);
                    Instance instance = objectVariable.getFields(i, n3 - i);
                    int n4 = i;
                    for (Field field : instance) {
                        if (this.var.equals(field)) {
                            Instance instance2 = InstanceImpl.createInstance(this.heap, objectVariable);
                            arrayList.add((Value)new ArrayItemValueImpl(instance2, this, n4));
                            break;
                        }
                        ++n4;
                    }
                    if (n4 < n3) continue block0;
                }
                continue;
            }
            n = objectVariable.getFieldsCount();
            for (Field field : fieldArray = objectVariable.getFields(0, n)) {
                if (!(field instanceof ObjectVariable) || hashSet.contains(field) || this.var.getUniqueID() != ((ObjectVariable)field).getUniqueID()) continue;
                hashSet.add(field);
                Instance instance = InstanceImpl.createInstance(this.heap, objectVariable);
                arrayList.add((Value)new ObjectFieldValueImpl(this.heap, instance, field, this));
                continue block0;
            }
        }
        return arrayList;
    }

    public boolean isGCRoot() {
        return false;
    }

    public int getRetainedSize() {
        return 0;
    }

    public int getReachableSize() {
        return 0;
    }

    public Instance getNearestGCRootPointer() {
        return null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof InstanceImpl)) {
            return false;
        }
        return this.var.getUniqueID() == ((InstanceImpl)object).var.getUniqueID();
    }

    public int hashCode() {
        return (int)this.var.getUniqueID();
    }
}

