/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.refactoring;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.layers.LayerUtils;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.apisupport.refactoring.Utility;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.Lookup;

public abstract class AbstractRefactoringPlugin
implements RefactoringPlugin {
    protected static ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.apisupport.refactoring");
    protected AbstractRefactoring refactoring;
    protected Pattern orderingLayerAttrPattern = Pattern.compile("([\\S]+)/([\\S]+)");

    public AbstractRefactoringPlugin(AbstractRefactoring abstractRefactoring) {
        this.refactoring = abstractRefactoring;
    }

    public Problem preCheck() {
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final int checkContentOfFile(FileObject fileObject, String string) {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(fileObject.getInputStream(), "UTF-8"));
            String string2 = bufferedReader.readLine();
            int n = 0;
            while (string2 != null) {
                if (string2.indexOf(string) != -1) {
                    int n2 = n;
                    return n2;
                }
                ++n;
                string2 = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return -1;
    }

    protected final InfoHolder examineLookup(Lookup lookup) throws IOException {
        final TreePathHandle treePathHandle = (TreePathHandle)lookup.lookup(TreePathHandle.class);
        final InfoHolder infoHolder = new InfoHolder();
        CancellableTask<CompilationController> cancellableTask = new CancellableTask<CompilationController>(){

            public void run(CompilationController compilationController) throws Exception {
                compilationController.toPhase(JavaSource.Phase.RESOLVED);
                Element element = treePathHandle.resolveElement((CompilationInfo)compilationController);
                if (element == null) {
                    return;
                }
                infoHolder.name = element.getSimpleName().toString();
                if (element.getKind() == ElementKind.CLASS) {
                    infoHolder.isClass = true;
                    TypeElement typeElement = (TypeElement)element;
                    infoHolder.fullName = typeElement.getQualifiedName().toString();
                } else if (element.getKind() == ElementKind.METHOD) {
                    infoHolder.isMethod = true;
                    ExecutableElement executableElement = (ExecutableElement)element;
                    TypeElement typeElement = (TypeElement)executableElement.getEnclosingElement();
                    infoHolder.fullName = typeElement.getQualifiedName().toString();
                    infoHolder.isPublic = executableElement.getModifiers().contains((Object)Modifier.PUBLIC);
                    infoHolder.isStatic = executableElement.getModifiers().contains((Object)Modifier.STATIC);
                    List<? extends VariableElement> list = executableElement.getParameters();
                    if (list.size() > 1) {
                        infoHolder.hasFileObjectParam = false;
                    } else {
                        if (list.size() == 0) {
                            infoHolder.hasNoParams = true;
                        }
                        for (VariableElement variableElement : list) {
                            TypeElement typeElement2;
                            String string;
                            TypeMirror typeMirror = variableElement.asType();
                            if (typeMirror.getKind() != TypeKind.DECLARED || !"org.openide.filesystems.FileObject".equals(string = (typeElement2 = (TypeElement)((DeclaredType)typeMirror).asElement()).getQualifiedName().toString())) continue;
                            infoHolder.hasFileObjectParam = true;
                        }
                    }
                } else if (element.getKind() == ElementKind.CONSTRUCTOR) {
                    infoHolder.isConstructor = true;
                    ExecutableElement executableElement = (ExecutableElement)element;
                    TypeElement typeElement = (TypeElement)executableElement.getEnclosingElement();
                    infoHolder.fullName = typeElement.getQualifiedName().toString();
                    infoHolder.isPublic = executableElement.getModifiers().contains((Object)Modifier.PUBLIC);
                    List<? extends VariableElement> list = executableElement.getParameters();
                    if (list.size() == 0) {
                        infoHolder.hasNoParams = true;
                    }
                }
            }

            public void cancel() {
            }
        };
        JavaSource javaSource = JavaSource.forFileObject((FileObject)treePathHandle.getFileObject());
        if (javaSource != null) {
            javaSource.runUserActionTask((Task)cancellableTask, true);
        }
        return infoHolder;
    }

    protected final void checkManifest(Project project, String string, RefactoringElementsBag refactoringElementsBag) {
        String string2;
        String string3 = string;
        NbModuleProvider nbModuleProvider = (NbModuleProvider)project.getLookup().lookup(NbModuleProvider.class);
        if (nbModuleProvider == null) {
            return;
        }
        String string4 = string3.replace('.', '/') + ".class";
        Manifest manifest = Util.getManifest((FileObject)nbModuleProvider.getManifestFile());
        if (manifest == null) {
            return;
        }
        Attributes attributes = manifest.getMainAttributes();
        for (Map.Entry<Object, Object> object2 : attributes.entrySet()) {
            String string5 = (String)object2.getValue();
            if (string5.indexOf(string3) == -1 && string5.indexOf(string4) == -1 || (string2 = this.createManifestRefactoring(string3, nbModuleProvider.getManifestFile(), ((Attributes.Name)object2.getKey()).toString(), string5, null)) == null) continue;
            refactoringElementsBag.add(this.refactoring, (RefactoringElementImplementation)string2);
        }
        Map<String, Attributes> map = manifest.getEntries();
        if (map != null) {
            for (Map.Entry<Object, Object> entry : map.entrySet()) {
                attributes = (Attributes)entry.getValue();
                string2 = (String)entry.getKey();
                if (string2.indexOf(string3) == -1 && string2.indexOf(string4) == -1) continue;
                String string6 = attributes.getValue("OpenIDE-Module-Class");
                RefactoringElementImplementation refactoringElementImplementation = this.createManifestRefactoring(string3, nbModuleProvider.getManifestFile(), null, string2, string6);
                if (refactoringElementImplementation == null) continue;
                refactoringElementsBag.add(this.refactoring, refactoringElementImplementation);
            }
        }
    }

    protected final void checkMetaInfServices(Project project, String string, RefactoringElementsBag refactoringElementsBag) {
        FileObject fileObject = Utility.findMetaInfServices(project);
        if (fileObject == null) {
            return;
        }
        String string2 = string;
        FileObject[] fileObjectArray = fileObject.getChildren();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            RefactoringElementImplementation refactoringElementImplementation;
            int n = this.checkContentOfFile(fileObjectArray[i], string2);
            if (n == -1 || (refactoringElementImplementation = this.createMetaInfServicesRefactoring(string, fileObjectArray[i], n)) == null) continue;
            refactoringElementsBag.add(this.refactoring, refactoringElementImplementation);
        }
    }

    protected final void checkLayer(Project project, String string, RefactoringElementsBag refactoringElementsBag) {
        LayerUtils.LayerHandle layerHandle = LayerUtils.layerForProject((Project)project);
        FileSystem fileSystem = layerHandle.layer(false);
        if (fileSystem != null) {
            this.checkFileObject(fileSystem.getRoot(), string, refactoringElementsBag, layerHandle);
        }
    }

    private void checkFileObject(FileObject fileObject, String string, RefactoringElementsBag refactoringElementsBag, LayerUtils.LayerHandle layerHandle) {
        if (fileObject.isFolder()) {
            FileObject[] fileObjectArray = fileObject.getChildren();
            for (int i = 0; i < fileObjectArray.length; ++i) {
                this.checkFileObject(fileObjectArray[i], string, refactoringElementsBag, layerHandle);
            }
            Enumeration enumeration = fileObject.getAttributes();
            while (enumeration.hasMoreElements()) {
                RefactoringElementImplementation refactoringElementImplementation;
                String string2;
                String string3;
                String string4 = (String)enumeration.nextElement();
                Matcher matcher = this.orderingLayerAttrPattern.matcher(string4);
                if (!matcher.matches()) continue;
                String string5 = matcher.group(1);
                if (string5.endsWith(".instance") && (string3 = string5.substring(0, string5.length() - ".instance".length()).replace('-', '.')).equals(string) && (string2 = this.createLayerRefactoring(string, layerHandle, fileObject, string4)) != null) {
                    refactoringElementsBag.add(this.refactoring, (RefactoringElementImplementation)string2);
                }
                if (!(string3 = matcher.group(2)).endsWith(".instance") || !(string2 = string3.substring(0, string3.length() - ".instance".length()).replace('-', '.')).equals(string) || (refactoringElementImplementation = this.createLayerRefactoring(string, layerHandle, fileObject, string4)) == null) continue;
                refactoringElementsBag.add(this.refactoring, refactoringElementImplementation);
            }
        } else if (fileObject.isData()) {
            Object object;
            String string6;
            Enumeration enumeration = fileObject.getAttributes();
            while (enumeration.hasMoreElements()) {
                RefactoringElementImplementation refactoringElementImplementation;
                int n;
                String string7;
                string6 = (String)enumeration.nextElement();
                object = fileObject.getAttribute("literal:" + string6);
                if (!(object instanceof String)) continue;
                String string8 = string7 = (String)object;
                if (string7.startsWith("new:")) {
                    string8 = string7.substring("new:".length());
                }
                if (string7.startsWith("method:") && (n = (string8 = string7.substring("method:".length())).lastIndexOf(46)) > 0) {
                    string8 = string8.substring(0, n);
                }
                String string9 = string.replaceAll("\\.", "\\.");
                String string10 = "[a-zA-Z0-9/-]*" + string.replaceAll("\\.", "-") + "\\.instance";
                if (!string8.matches(string9) && !string8.matches(string10) || (refactoringElementImplementation = this.createLayerRefactoring(string, layerHandle, fileObject, string6)) == null) continue;
                refactoringElementsBag.add(this.refactoring, refactoringElementImplementation);
            }
            if ("instance".equals(fileObject.getExt()) && (string6 = fileObject.getName().replace('-', '.')).equals(string) && (object = this.createLayerRefactoring(string, layerHandle, fileObject, null)) != null) {
                refactoringElementsBag.add(this.refactoring, (RefactoringElementImplementation)object);
            }
            if ("settings".equals(fileObject.getExt())) {
                // empty if block
            }
        }
    }

    protected final Problem checkMethodLayer(InfoHolder infoHolder, FileObject fileObject, RefactoringElementsBag refactoringElementsBag) {
        LayerUtils.LayerHandle layerHandle;
        FileSystem fileSystem;
        Problem problem = null;
        if (!infoHolder.isPublic || !infoHolder.isStatic) {
            return problem;
        }
        if (!infoHolder.hasFileObjectParam && !infoHolder.hasNoParams) {
            return problem;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project != null && (fileSystem = (layerHandle = LayerUtils.layerForProject((Project)project)).layer(false)) != null) {
            this.checkFileObject(fileSystem.getRoot(), infoHolder.name, null, infoHolder.fullName, refactoringElementsBag, layerHandle);
        }
        return problem;
    }

    protected final Problem checkConstructorLayer(InfoHolder infoHolder, FileObject fileObject, RefactoringElementsBag refactoringElementsBag) {
        LayerUtils.LayerHandle layerHandle;
        FileSystem fileSystem;
        Problem problem = null;
        if (!infoHolder.isPublic || !infoHolder.hasNoParams) {
            return problem;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project != null && (fileSystem = (layerHandle = LayerUtils.layerForProject((Project)project)).layer(false)) != null) {
            this.checkFileObject(fileSystem.getRoot(), null, infoHolder.name, infoHolder.fullName, refactoringElementsBag, layerHandle);
        }
        return problem;
    }

    private void checkFileObject(FileObject fileObject, String string, String string2, String string3, RefactoringElementsBag refactoringElementsBag, LayerUtils.LayerHandle layerHandle) {
        block7: {
            block6: {
                if (!fileObject.isFolder()) break block6;
                FileObject[] fileObjectArray = fileObject.getChildren();
                for (int i = 0; i < fileObjectArray.length; ++i) {
                    this.checkFileObject(fileObjectArray[i], string, string2, string3, refactoringElementsBag, layerHandle);
                }
                break block7;
            }
            if (!fileObject.isData()) break block7;
            if ("settings".equals(fileObject.getExt())) {
                // empty if block
            }
            Enumeration enumeration = fileObject.getAttributes();
            while (enumeration.hasMoreElements()) {
                Object object;
                String string4;
                String string5 = (String)enumeration.nextElement();
                Object object2 = fileObject.getAttribute("literal:" + string5);
                if (!(object2 instanceof String)) continue;
                String string6 = (String)object2;
                if (string != null && string6.startsWith("method:") && string6.endsWith(string)) {
                    RefactoringElementImplementation refactoringElementImplementation;
                    string4 = string6.substring("method:".length());
                    object = null;
                    int n = string4.lastIndexOf(46);
                    if (n > 0) {
                        object = string4.substring(n + 1);
                        string4 = string4.substring(0, n);
                    }
                    if (object != null && object.equals(string) && string4.equals(string3) && (refactoringElementImplementation = this.createLayerRefactoring(string, layerHandle, fileObject, string5)) != null) {
                        refactoringElementsBag.add(this.refactoring, refactoringElementImplementation);
                    }
                }
                if (string2 == null || !string6.startsWith("new:") || !(string4 = string6.substring("new:".length())).equals(string3) || (object = this.createLayerRefactoring(string2, layerHandle, fileObject, string5)) == null) continue;
                refactoringElementsBag.add(this.refactoring, object);
            }
        }
    }

    protected abstract RefactoringElementImplementation createMetaInfServicesRefactoring(String var1, FileObject var2, int var3);

    protected abstract RefactoringElementImplementation createManifestRefactoring(String var1, FileObject var2, String var3, String var4, String var5);

    protected RefactoringElementImplementation createLayerRefactoring(String string, LayerUtils.LayerHandle layerHandle, FileObject fileObject, String string2) {
        throw new AssertionError((Object)"if you call checkLayer(), you need to implement this method");
    }

    protected RefactoringElementImplementation createMethodLayerRefactoring(String string, String string2, LayerUtils.LayerHandle layerHandle, FileObject fileObject, String string3) {
        throw new AssertionError((Object)"if you call checkLayer(), you need to implement this method");
    }

    protected RefactoringElementImplementation createConstructorLayerRefactoring(String string, String string2, LayerUtils.LayerHandle layerHandle, FileObject fileObject, String string3) {
        throw new AssertionError((Object)"if you call checkLayer(), you need to implement this method");
    }

    protected static class InfoHolder {
        public String name = null;
        public String fullName = null;
        public boolean isClass = false;
        public boolean isMethod = false;
        public boolean isConstructor = false;
        public boolean isPublic = false;
        public boolean isStatic = false;
        public boolean hasFileObjectParam = false;
        public boolean hasNoParams = false;

        protected InfoHolder() {
        }
    }
}

