/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.impl.xref;

import org.netbeans.api.lexer.Token;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.EditorDebug;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.completion.impl.xref.DocOffsetableImpl;
import org.netbeans.modules.cnd.completion.impl.xref.ReferencesSupport;

public class ReferenceImpl
extends DocOffsetableImpl
implements CsmReference {
    private final Token token;
    private CsmObject target = null;
    private CsmObject owner = null;
    private final int offset;
    private CsmReferenceKind kind;

    public ReferenceImpl(CsmFile csmFile, BaseDocument baseDocument, int n, Token token, CsmReferenceKind csmReferenceKind) {
        super(baseDocument, csmFile, n);
        this.token = token;
        this.offset = n;
        this.kind = csmReferenceKind;
    }

    public CsmObject getReferencedObject() {
        if (this.isValid() && this.target == null) {
            this.target = ReferencesSupport.findReferencedObject(super.getContainingFile(), super.getDocument(), this.offset, (Token<CppTokenId>)this.token);
        }
        return this.target;
    }

    public CsmObject getOwner() {
        if (this.isValid() && this.owner == null) {
            this.owner = ReferencesSupport.findOwnerObject(super.getContainingFile(), super.getDocument(), this.offset, (Token<CppTokenId>)this.token);
        }
        return this.owner;
    }

    public String getText() {
        return ((Object)this.token.text()).toString();
    }

    public String toString() {
        return "'" + EditorDebug.debugString((String)this.getText()) + "', tokenID=" + this.token.id().toString().toLowerCase() + ", offset=" + this.offset + " [" + super.getStartPosition() + "-" + super.getEndPosition() + "]";
    }

    final void setTarget(CsmObject csmObject) {
        this.target = csmObject;
    }

    final CsmObject getTarget() {
        return this.target;
    }

    final int getOffset() {
        return this.offset;
    }

    final Token getToken() {
        return this.token;
    }

    final CsmReferenceKind getKindImpl() {
        return this.kind;
    }

    public CsmReferenceKind getKind() {
        if (this.kind == null) {
            CsmReferenceKind csmReferenceKind;
            this.kind = csmReferenceKind = ReferencesSupport.getReferenceKind(this);
        }
        return this.kind;
    }
}

