/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.impl.xref;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.cnd.api.lexer.CndTokenUtilities;
import org.netbeans.cnd.api.lexer.CppAbstractTokenProcessor;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.cnd.api.lexer.CppTokenProcessor;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.services.CsmFileReferences;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.completion.impl.xref.ReferenceImpl;
import org.netbeans.modules.cnd.completion.impl.xref.ReferencesSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileReferencesImpl
extends CsmFileReferences {
    public void accept(CsmScope csmScope, CsmFileReferences.Visitor visitor) {
        this.accept(csmScope, visitor, CsmReferenceKind.ALL);
    }

    public void accept(CsmScope csmScope, CsmFileReferences.Visitor visitor, Set<CsmReferenceKind> set) {
        int n;
        int n2;
        if (!CsmKindUtilities.isOffsetable((Object)csmScope) && !CsmKindUtilities.isFile((CsmObject)csmScope)) {
            return;
        }
        CsmFile csmFile = null;
        csmFile = CsmKindUtilities.isFile((CsmObject)csmScope) ? (CsmFile)csmScope : ((CsmOffsetable)csmScope).getContainingFile();
        BaseDocument baseDocument = ReferencesSupport.getDocument(csmFile);
        if (baseDocument == null || !csmFile.isValid()) {
            return;
        }
        if (CsmKindUtilities.isFile((CsmObject)csmScope)) {
            n2 = 0;
            n = Math.max(0, baseDocument.getLength() - 1);
        } else {
            n2 = ((CsmOffsetable)csmScope).getStartOffset();
            n = ((CsmOffsetable)csmScope).getEndOffset();
        }
        List<Triple<CsmReference>> list = this.getIdentifierReferences(csmFile, baseDocument, n2, n, set);
        for (Triple<CsmReference> triple : list) {
            visitor.visit(triple.getFirst(), triple.getSecond(), triple.getThird());
        }
    }

    private List<Triple<CsmReference>> getIdentifierReferences(CsmFile csmFile, final BaseDocument baseDocument, final int n, final int n2, Set<CsmReferenceKind> set) {
        boolean bl = set.contains(CsmReferenceKind.AFTER_DEREFERENCE_USAGE);
        boolean bl2 = !set.contains(CsmReferenceKind.IN_PREPROCESSOR_DIRECTIVE);
        List list = !set.contains(CsmReferenceKind.IN_DEAD_BLOCK) ? CsmFileInfoQuery.getDefault().getUnusedCodeBlocks(csmFile) : Collections.emptyList();
        final ReferencesProcessor referencesProcessor = new ReferencesProcessor(csmFile, baseDocument, bl2, bl, list);
        baseDocument.runAtomic(new Runnable(){

            public void run() {
                CndTokenUtilities.processTokens((CppTokenProcessor)referencesProcessor, (Document)baseDocument, (int)n, (int)n2);
            }
        });
        return referencesProcessor.references;
    }

    private static boolean isInDeadBlock(int n, Collection<CsmOffsetable> collection) {
        for (CsmOffsetable csmOffsetable : collection) {
            if (csmOffsetable.getStartOffset() > n) {
                return false;
            }
            if (csmOffsetable.getEndOffset() <= n) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Triple<T> {
        private final T first;
        private final T second;
        private final T third;

        public Triple(T t, T t2, T t3) {
            this.first = t;
            this.second = t2;
            this.third = t3;
        }

        public T getFirst() {
            return this.first;
        }

        public T getSecond() {
            return this.second;
        }

        public T getThird() {
            return this.third;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ReferenceStack {
        private final List<Character> brackets = new ArrayList<Character>();
        private final List<List<CsmReference>> references = new ArrayList<List<CsmReference>>();

        public void open(char c) {
            List<CsmReference> list = ReferenceStack.peek(this.references);
            if (c != '<' || list != null && !list.isEmpty()) {
                this.brackets.add(Character.valueOf(c));
                this.references.add(new ArrayList(1));
            }
        }

        public void close(char c) {
            if (c == '>') {
                char c2;
                char c3 = c2 = this.brackets.isEmpty() ? (char)'\u0000' : ReferenceStack.peek(this.brackets).charValue();
                if (ReferenceStack.match(c2, c)) {
                    ReferenceStack.pop(this.brackets);
                }
                ReferenceStack.pop(this.references);
            } else {
                while (!this.brackets.isEmpty()) {
                    char c4 = this.brackets.get(this.brackets.size() - 1).charValue();
                    ReferenceStack.pop(this.brackets);
                    ReferenceStack.pop(this.references);
                    if (!ReferenceStack.match(c4, c)) continue;
                    break;
                }
            }
        }

        public void semicolon() {
            for (int i = 0; i < this.brackets.size(); ++i) {
                if (this.brackets.get(i).charValue() != '<') continue;
                while (i < this.brackets.size()) {
                    ReferenceStack.pop(this.brackets);
                    ReferenceStack.pop(this.references);
                }
                break;
            }
            this.clearReferences();
        }

        public void clearReferences() {
            if (!this.references.isEmpty()) {
                ReferenceStack.peek(this.references).clear();
            }
        }

        public void addReference(CsmReference csmReference) {
            if (this.references.isEmpty()) {
                this.references.add(new ArrayList(1));
            }
            ReferenceStack.peek(this.references).add(csmReference);
        }

        public Triple<CsmReference> getSnapshot() {
            List<CsmReference> list = ReferenceStack.peek(this.references);
            CsmReference csmReference = ReferenceStack.peek(list);
            CsmReference csmReference2 = ReferenceStack.peek(list, 2);
            CsmReference csmReference3 = ReferenceStack.peek(ReferenceStack.peek(this.references, 2));
            return new Triple<CsmReference>(csmReference, csmReference2, csmReference3);
        }

        private static <T> T peek(List<T> list) {
            return ReferenceStack.peek(list, 1);
        }

        private static <T> T peek(List<T> list, int n) {
            if (list == null || list.size() < n) {
                return null;
            }
            return list.get(list.size() - n);
        }

        private static <T> T pop(List<T> list) {
            if (list == null || list.isEmpty()) {
                return null;
            }
            return list.remove(list.size() - 1);
        }

        private static boolean match(char c, char c2) {
            return c == '(' && c2 == ')' || c == '[' && c2 == ']' || c == '{' && c2 == '}' || c == '<' && c2 == '>';
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ReferencesProcessor
    extends CppAbstractTokenProcessor {
        final List<Triple<CsmReference>> references = new ArrayList<Triple<CsmReference>>();
        private final Collection<CsmOffsetable> deadBlocks;
        private final boolean needAfterDereferenceUsages;
        private final boolean skipPreprocDirectives;
        private final CsmFile csmFile;
        private final BaseDocument doc;
        private final ReferenceStack refStack;
        private boolean afterDereferenceUsage;
        private boolean inAttribute;
        private int parenthesisDepth;

        ReferencesProcessor(CsmFile csmFile, BaseDocument baseDocument, boolean bl, boolean bl2, Collection<CsmOffsetable> collection) {
            this.deadBlocks = collection;
            this.needAfterDereferenceUsages = bl2;
            this.skipPreprocDirectives = bl;
            this.csmFile = csmFile;
            this.doc = baseDocument;
            this.refStack = new ReferenceStack();
        }

        public boolean token(Token<CppTokenId> token, int n) {
            if (this.inAttribute) {
                switch ((CppTokenId)token.id()) {
                    case LPAREN: {
                        ++this.parenthesisDepth;
                        break;
                    }
                    case RPAREN: {
                        --this.parenthesisDepth;
                        this.inAttribute = 0 < this.parenthesisDepth;
                    }
                }
                return false;
            }
            boolean bl = false;
            boolean bl2 = false;
            switch ((CppTokenId)token.id()) {
                case PREPROCESSOR_DIRECTIVE: {
                    bl2 = !this.skipPreprocDirectives;
                    break;
                }
                case IDENTIFIER: 
                case PREPROCESSOR_IDENTIFIER: {
                    boolean bl3 = bl = !this.needAfterDereferenceUsages && this.afterDereferenceUsage;
                    if (!bl && !this.deadBlocks.isEmpty()) {
                        bl = FileReferencesImpl.isInDeadBlock(n, this.deadBlocks);
                    }
                    ReferenceImpl referenceImpl = ReferencesSupport.createReferenceImpl(this.csmFile, this.doc, n, token, this.afterDereferenceUsage ? CsmReferenceKind.AFTER_DEREFERENCE_USAGE : CsmReferenceKind.DIRECT_USAGE);
                    if (!this.afterDereferenceUsage) {
                        this.refStack.clearReferences();
                    }
                    this.refStack.addReference(referenceImpl);
                    this.afterDereferenceUsage = false;
                    if (bl) break;
                    this.references.add(this.refStack.getSnapshot());
                    break;
                }
                case DOT: 
                case DOTMBR: 
                case ARROW: 
                case ARROWMBR: 
                case SCOPE: {
                    this.afterDereferenceUsage = true;
                    break;
                }
                case LPAREN: 
                case LBRACE: 
                case LBRACKET: 
                case LT: {
                    this.refStack.open(token.text().charAt(0));
                    break;
                }
                case RPAREN: 
                case RBRACE: 
                case RBRACKET: 
                case GT: {
                    this.refStack.close(token.text().charAt(0));
                    break;
                }
                case SEMICOLON: {
                    this.refStack.semicolon();
                    break;
                }
                case __ATTRIBUTE__: {
                    this.inAttribute = true;
                    this.parenthesisDepth = 0;
                    break;
                }
                case WHITESPACE: 
                case NEW_LINE: 
                case BLOCK_COMMENT: 
                case LINE_COMMENT: {
                    break;
                }
                default: {
                    this.refStack.clearReferences();
                }
            }
            return bl2;
        }
    }
}

