/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.cplusplus.ext;

import java.util.ArrayList;
import java.util.EnumSet;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;

public class CsmCompletionExpression {
    private static final int INVALID = -1;
    public static final int CONSTANT = 0;
    public static final int VARIABLE = 1;
    public static final int OPERATOR = 2;
    public static final int UNARY_OPERATOR = 3;
    public static final int DOT = 4;
    public static final int DOT_OPEN = 5;
    public static final int ARRAY_OPEN = 6;
    public static final int ARRAY = 7;
    public static final int PARENTHESIS_OPEN = 8;
    public static final int PARENTHESIS = 9;
    public static final int METHOD_OPEN = 10;
    public static final int METHOD = 11;
    public static final int CONSTRUCTOR = 12;
    public static final int CONVERSION = 13;
    public static final int TYPE = 14;
    public static final int NEW = 15;
    public static final int INSTANCEOF = 16;
    public static final int GENERIC_TYPE = 17;
    public static final int GENERIC_TYPE_OPEN = 18;
    public static final int GENERIC_WILD_CHAR = 19;
    public static final int ANNOTATION = 20;
    public static final int ANNOTATION_OPEN = 21;
    public static final int CPPINCLUDE = 22;
    public static final int CPPINCLUDE_NEXT = 23;
    public static final int CASE = 24;
    public static final int ARROW = 25;
    public static final int ARROW_OPEN = 26;
    public static final int SCOPE = 27;
    public static final int SCOPE_OPEN = 28;
    public static final int TYPE_PREFIX = 29;
    public static final int TYPE_POSTFIX = 30;
    public static final int TYPE_REFERENCE = 31;
    public static final int MEMBER_POINTER = 32;
    public static final int MEMBER_POINTER_OPEN = 33;
    public static final int GOTO = 34;
    public static final int LABEL = 35;
    public static final int CLASSIFIER = 36;
    public static final int CONVERSION_OPEN = 37;
    public static final int PREPROC_DIRECTIVE = 38;
    public static final int PREPROC_DIRECTIVE_OPEN = 39;
    private static final int LAST_ID = 39;
    private static final int cppTokenIDsLength = EnumSet.allOf(CppTokenId.class).size();
    private static final int[] OP = new int[cppTokenIDsLength + 39 + 1];
    private static final int RIGHT_ASSOCIATIVE = 32;
    private static final Object[] EMPTY_OBJECT_ARRAY;
    private CsmCompletionExpression parent;
    private int expID;
    private String type;
    private int tokenCountM3;
    private Object[] tokenBlocks = EMPTY_OBJECT_ARRAY;
    private ArrayList prmList;

    CsmCompletionExpression(int n) {
        if (n < 0 || n > 39) {
            throw new IllegalArgumentException("expID=" + n);
        }
        this.expID = n;
    }

    static CsmCompletionExpression createEmptyVariable(int n) {
        CsmCompletionExpression csmCompletionExpression = new CsmCompletionExpression(1);
        csmCompletionExpression.addToken(CppTokenId.IDENTIFIER, n, "");
        return csmCompletionExpression;
    }

    static boolean isSeparatorOrOperator(CppTokenId cppTokenId) {
        return CndLexerUtilities.isSeparatorOrOperator((CppTokenId)cppTokenId);
    }

    static int getOperatorID(CppTokenId cppTokenId) {
        int n = -1;
        if (CsmCompletionExpression.isSeparatorOrOperator(cppTokenId)) {
            n = cppTokenId.ordinal();
        } else {
            switch (cppTokenId) {
                case NEW: {
                    n = cppTokenIDsLength + 15;
                }
            }
        }
        return n;
    }

    static int getOperatorID(CsmCompletionExpression csmCompletionExpression) {
        int n = csmCompletionExpression != null ? csmCompletionExpression.getExpID() : -1;
        switch (n) {
            case 2: {
                return csmCompletionExpression.getTokenID(0).ordinal();
            }
        }
        return cppTokenIDsLength + n;
    }

    static int getOperatorPrecedence(int n) {
        return OP[n] & 0x1F;
    }

    static boolean isOperatorRightAssociative(int n) {
        return (OP[n] & 0x20) != 0;
    }

    static boolean isValidType(CsmCompletionExpression csmCompletionExpression) {
        switch (csmCompletionExpression.getExpID()) {
            case 7: {
                if (csmCompletionExpression.getParameterCount() == 1) {
                    return CsmCompletionExpression.isValidType(csmCompletionExpression.getParameter(0));
                }
                return false;
            }
            case 29: 
            case 30: 
            case 31: {
                if (csmCompletionExpression.getParameterCount() >= 1) {
                    return CsmCompletionExpression.isValidType(csmCompletionExpression.getParameter(0));
                }
                return false;
            }
            case 27: {
                int n = csmCompletionExpression.getParameterCount();
                for (int i = 0; i < n; ++i) {
                    if (csmCompletionExpression.getParameter(i).getExpID() == 1) continue;
                    return false;
                }
                return true;
            }
            case 1: 
            case 14: 
            case 17: {
                return true;
            }
        }
        return false;
    }

    public int getExpID() {
        return this.expID;
    }

    void setExpID(int n) {
        this.expID = n;
    }

    public CsmCompletionExpression getParent() {
        return this.parent;
    }

    void setParent(CsmCompletionExpression csmCompletionExpression) {
        this.parent = csmCompletionExpression;
    }

    public String getType() {
        return this.type;
    }

    void setType(String string) {
        this.type = string;
    }

    public int getTokenCount() {
        return this.tokenCountM3 / 3;
    }

    public String getTokenText(int n) {
        return (String)this.tokenBlocks[(n *= 3) + 2];
    }

    public int getTokenOffset(int n) {
        return (Integer)this.tokenBlocks[(n *= 3) + 1];
    }

    public int getTokenLength(int n) {
        return ((String)this.tokenBlocks[(n *= 3) + 2]).length();
    }

    public CppTokenId getTokenID(int n) {
        return (CppTokenId)this.tokenBlocks[n *= 3];
    }

    void addToken(CppTokenId cppTokenId, int n, String string) {
        if (this.tokenCountM3 == this.tokenBlocks.length) {
            Object[] objectArray = new Object[Math.max(3, this.tokenBlocks.length * 2)];
            if (this.tokenBlocks.length > 0) {
                System.arraycopy(this.tokenBlocks, 0, objectArray, 0, this.tokenBlocks.length);
            }
            this.tokenBlocks = objectArray;
        }
        this.tokenBlocks[this.tokenCountM3++] = cppTokenId;
        this.tokenBlocks[this.tokenCountM3++] = new Integer(n);
        this.tokenBlocks[this.tokenCountM3++] = string;
    }

    public int getParameterCount() {
        return this.prmList != null ? this.prmList.size() : 0;
    }

    public CsmCompletionExpression getParameter(int n) {
        return (CsmCompletionExpression)this.prmList.get(n);
    }

    void addParameter(CsmCompletionExpression csmCompletionExpression) {
        if (this.prmList == null) {
            this.prmList = new ArrayList();
        }
        csmCompletionExpression.setParent(this);
        this.prmList.add(csmCompletionExpression);
    }

    void swapOperatorParms() {
        if ((this.expID == 2 || this.expID == 16) && this.getParameterCount() == 2) {
            CsmCompletionExpression csmCompletionExpression = (CsmCompletionExpression)this.prmList.remove(0);
            this.prmList.add(csmCompletionExpression);
            csmCompletionExpression.swapOperatorParms();
            ((CsmCompletionExpression)this.prmList.get(0)).swapOperatorParms();
        }
    }

    private static void appendSpaces(StringBuilder stringBuilder, int n) {
        while (--n >= 0) {
            stringBuilder.append(' ');
        }
    }

    static String getIDName(int n) {
        switch (n) {
            case 0: {
                return "CONSTANT";
            }
            case 1: {
                return "VARIABLE";
            }
            case 2: {
                return "OPERATOR";
            }
            case 3: {
                return "UNARY_OPERATOR";
            }
            case 4: {
                return "DOT";
            }
            case 5: {
                return "DOT_OPEN";
            }
            case 25: {
                return "ARROW";
            }
            case 26: {
                return "ARROW_OPEN";
            }
            case 27: {
                return "SCOPE";
            }
            case 28: {
                return "SCOPE_OPEN";
            }
            case 7: {
                return "ARRAY";
            }
            case 6: {
                return "ARRAY_OPEN";
            }
            case 8: {
                return "PARENTHESIS_OPEN";
            }
            case 9: {
                return "PARENTHESIS";
            }
            case 10: {
                return "METHOD_OPEN";
            }
            case 11: {
                return "METHOD";
            }
            case 12: {
                return "CONSTRUCTOR";
            }
            case 13: {
                return "CONVERSION";
            }
            case 14: {
                return "TYPE";
            }
            case 15: {
                return "NEW";
            }
            case 16: {
                return "INSTANCEOF";
            }
            case 17: {
                return "GENERIC_TYPE";
            }
            case 18: {
                return "GENERIC_TYPE_OPEN";
            }
            case 19: {
                return "GENERIC_WILD_CHAR";
            }
            case 20: {
                return "ANNOTATION";
            }
            case 21: {
                return "ANNOTATION_OPEN";
            }
            case 22: {
                return "INCLUDE";
            }
            case 24: {
                return "CASE";
            }
            case 29: {
                return "TYPE_PREFIX";
            }
            case 30: {
                return "TYPE_POSTFIX";
            }
            case 31: {
                return "TYPE_REFERENCE";
            }
            case 32: {
                return "MEMBER_POINTER";
            }
            case 33: {
                return "MEMBER_POINTER_OPEN";
            }
            case 34: {
                return "GOTO";
            }
            case 35: {
                return "LABEL";
            }
            case 36: {
                return "CLASSIFIER";
            }
            case 37: {
                return "CONVERSION_OPEN";
            }
            case 38: {
                return "PREPROC_DIRECTIVE";
            }
            case 39: {
                return "PREPROC_DIRECTIVE_OPEN";
            }
        }
        return "Unknown expID " + n;
    }

    public String toString(int n) {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        CsmCompletionExpression.appendSpaces(stringBuilder, n);
        stringBuilder.append("expID=" + CsmCompletionExpression.getIDName(this.expID));
        if (this.type != null) {
            stringBuilder.append(", result type=");
            stringBuilder.append(this.type);
        }
        int n3 = this.getTokenCount();
        stringBuilder.append(", token count=");
        stringBuilder.append(n3);
        if (n3 > 0) {
            n2 = 0;
            while (n2 < this.tokenCountM3) {
                CppTokenId cppTokenId = (CppTokenId)this.tokenBlocks[n2++];
                int n4 = (Integer)this.tokenBlocks[n2++];
                String string = (String)this.tokenBlocks[n2++];
                stringBuilder.append(", token" + (n2 / 3 - 1) + "='" + CsmCompletionExpression.debugString(string) + "'");
            }
        }
        n2 = this.getParameterCount();
        stringBuilder.append(", parm count=");
        stringBuilder.append(n2);
        if (n2 > 0) {
            for (int i = 0; i < n2; ++i) {
                stringBuilder.append('\n');
                CsmCompletionExpression.appendSpaces(stringBuilder, n + 4);
                stringBuilder.append("parm" + i + "=[" + this.getParameter(i).toString(n + 4) + "]");
            }
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.toString(0);
    }

    private static String debugString(String string) {
        return string != null ? CsmCompletionExpression.debugChars(string.toCharArray(), 0, string.length()) : "NULL STRING";
    }

    private static String debugChars(char[] cArray, int n, int n2) {
        if (n2 < 0) {
            return "debugChars() !ERROR! len=" + n2 + " < 0";
        }
        if (n < 0) {
            return "debugChars() !ERROR! offset=" + n + " < 0";
        }
        if (n + n2 > cArray.length) {
            return "debugChars() !ERROR! offset=" + n + " + len=" + n2 + " > chars.length=" + cArray.length;
        }
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n3 = n + n2;
        while (n < n3) {
            switch (cArray[n]) {
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    break;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    break;
                }
                default: {
                    stringBuffer.append(cArray[n]);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    static {
        CsmCompletionExpression.OP[CppTokenId.EQ.ordinal()] = 34;
        CsmCompletionExpression.OP[CppTokenId.LT.ordinal()] = 10;
        CsmCompletionExpression.OP[CppTokenId.GT.ordinal()] = 10;
        CsmCompletionExpression.OP[CppTokenId.LTLT.ordinal()] = 11;
        CsmCompletionExpression.OP[CppTokenId.GTGT.ordinal()] = 11;
        CsmCompletionExpression.OP[CppTokenId.PLUS.ordinal()] = 12;
        CsmCompletionExpression.OP[CppTokenId.MINUS.ordinal()] = 12;
        CsmCompletionExpression.OP[CppTokenId.STAR.ordinal()] = 13;
        CsmCompletionExpression.OP[CppTokenId.SLASH.ordinal()] = 13;
        CsmCompletionExpression.OP[CppTokenId.AMP.ordinal()] = 8;
        CsmCompletionExpression.OP[CppTokenId.BAR.ordinal()] = 6;
        CsmCompletionExpression.OP[CppTokenId.CARET.ordinal()] = 7;
        CsmCompletionExpression.OP[CppTokenId.PERCENT.ordinal()] = 13;
        CsmCompletionExpression.OP[CppTokenId.NOT.ordinal()] = 15;
        CsmCompletionExpression.OP[CppTokenId.TILDE.ordinal()] = 15;
        CsmCompletionExpression.OP[CppTokenId.EQEQ.ordinal()] = 9;
        CsmCompletionExpression.OP[CppTokenId.LTEQ.ordinal()] = 10;
        CsmCompletionExpression.OP[CppTokenId.GTEQ.ordinal()] = 10;
        CsmCompletionExpression.OP[CppTokenId.LTLTEQ.ordinal()] = 34;
        CsmCompletionExpression.OP[CppTokenId.GTGTEQ.ordinal()] = 34;
        CsmCompletionExpression.OP[CppTokenId.PLUSEQ.ordinal()] = 34;
        CsmCompletionExpression.OP[CppTokenId.MINUSEQ.ordinal()] = 34;
        CsmCompletionExpression.OP[CppTokenId.STAREQ.ordinal()] = 34;
        CsmCompletionExpression.OP[CppTokenId.SLASHEQ.ordinal()] = 34;
        CsmCompletionExpression.OP[CppTokenId.AMPEQ.ordinal()] = 34;
        CsmCompletionExpression.OP[CppTokenId.BAREQ.ordinal()] = 34;
        CsmCompletionExpression.OP[CppTokenId.CARETEQ.ordinal()] = 34;
        CsmCompletionExpression.OP[CppTokenId.PERCENTEQ.ordinal()] = 34;
        CsmCompletionExpression.OP[CppTokenId.NOTEQ.ordinal()] = 9;
        CsmCompletionExpression.OP[CppTokenId.DOT.ordinal()] = 16;
        CsmCompletionExpression.OP[CppTokenId.DOTMBR.ordinal()] = 14;
        CsmCompletionExpression.OP[CppTokenId.ARROW.ordinal()] = 16;
        CsmCompletionExpression.OP[CppTokenId.ARROWMBR.ordinal()] = 14;
        CsmCompletionExpression.OP[CppTokenId.SCOPE.ordinal()] = 18;
        CsmCompletionExpression.OP[CppTokenId.COLON.ordinal()] = 35;
        CsmCompletionExpression.OP[CppTokenId.QUESTION.ordinal()] = 35;
        CsmCompletionExpression.OP[CppTokenId.LBRACKET.ordinal()] = 16;
        CsmCompletionExpression.OP[CppTokenId.RBRACKET.ordinal()] = 0;
        CsmCompletionExpression.OP[CppTokenId.PLUSPLUS.ordinal()] = 16;
        CsmCompletionExpression.OP[CppTokenId.MINUSMINUS.ordinal()] = 16;
        CsmCompletionExpression.OP[CppTokenId.AMPAMP.ordinal()] = 5;
        CsmCompletionExpression.OP[CppTokenId.BARBAR.ordinal()] = 4;
        CsmCompletionExpression.OP[CppTokenId.COMMA.ordinal()] = 0;
        CsmCompletionExpression.OP[CppTokenId.SEMICOLON.ordinal()] = 0;
        CsmCompletionExpression.OP[CppTokenId.LPAREN.ordinal()] = 17;
        CsmCompletionExpression.OP[CppTokenId.RPAREN.ordinal()] = 0;
        CsmCompletionExpression.OP[CppTokenId.LBRACE.ordinal()] = 0;
        CsmCompletionExpression.OP[CppTokenId.RBRACE.ordinal()] = 0;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + -1] = 0;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 0] = 1;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 1] = 1;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 3] = 15;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 4] = 1;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 5] = 0;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 25] = 1;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 26] = 0;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 27] = 17;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 28] = 0;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 6] = 0;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 7] = 1;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 8] = 0;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 9] = 1;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 10] = 0;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 11] = 1;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 12] = 1;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 13] = 47;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 14] = 0;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 15] = 0;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 16] = 10;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 22] = 0;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 33] = 0;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 32] = 47;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 31] = 1;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 30] = 1;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 29] = 1;
        EMPTY_OBJECT_ARRAY = new Object[0];
    }
}

