/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.modules.java.navigation.HTMLDocView;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

final class ToolTipManagerEx
extends MouseAdapter
implements MouseMotionListener {
    private static final Logger LOG = Logger.getLogger(ToolTipManagerEx.class.getName());
    private Timer enterTimer;
    private Timer exitTimer;
    private String toolTipText;
    private JComponent insideComponent;
    private MouseEvent mouseEvent;
    private boolean showImmediately;
    private transient Popup tipWindow;
    private Window window;
    private ToolTipEx tip;
    private Rectangle popupRect = null;
    boolean enabled = true;
    private boolean tipShowing = false;
    private MouseMotionListener moveBeforeEnterListener = null;
    private ToolTipProvider provider;
    private static final String WAITING_TEXT = NbBundle.getMessage(ToolTipManagerEx.class, (String)"LBL_PleaseWait");
    private AWTEventListener awtListener;
    private Rectangle lastTooltipForRect;
    private String lastTooltipText;
    private RequestProcessor.Task tooltipTask;
    private static final Object TOOLTIP_DATA_LOCK = new Object();

    public ToolTipManagerEx(ToolTipProvider toolTipProvider) {
        assert (null != toolTipProvider);
        this.provider = toolTipProvider;
        this.enterTimer = new Timer(750, new insideTimerAction());
        this.enterTimer.setRepeats(false);
        this.exitTimer = new Timer(500, new outsideTimerAction());
        this.exitTimer.setRepeats(false);
        this.moveBeforeEnterListener = new MoveBeforeEnterListener();
        this.registerComponent(toolTipProvider.getComponent());
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        if (!bl) {
            this.hideTipWindow();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setInitialDelay(int n) {
        this.enterTimer.setInitialDelay(n);
    }

    public int getInitialDelay() {
        return this.enterTimer.getInitialDelay();
    }

    public void setReshowDelay(int n) {
        this.exitTimer.setInitialDelay(n);
    }

    public int getReshowDelay() {
        return this.exitTimer.getInitialDelay();
    }

    protected void showTipWindow() {
        Serializable serializable;
        if (this.insideComponent == null || !this.insideComponent.isShowing()) {
            return;
        }
        for (serializable = this.insideComponent.getParent(); serializable != null && !(serializable instanceof JPopupMenu); serializable = serializable.getParent()) {
            if (!(serializable instanceof Window)) continue;
            if (((Window)serializable).isFocused()) break;
            return;
        }
        if (this.enabled) {
            this.hideTipWindow();
            this.tip = this.createToolTip();
            this.tip.setTipText(this.toolTipText);
            serializable = this.tip.getPreferredSize();
            Point point = this.provider.getToolTipLocation(this.mouseEvent.getPoint(), (Dimension)serializable);
            if (this.popupRect == null) {
                this.popupRect = new Rectangle();
            }
            this.popupRect.setBounds(point.x, point.y, ((Dimension)serializable).width, ((Dimension)serializable).height);
            PopupFactory popupFactory = PopupFactory.getSharedInstance();
            this.tipWindow = popupFactory.getPopup(this.insideComponent, this.tip, point.x, point.y);
            this.tipWindow.show();
            Window window = SwingUtilities.windowForComponent(this.insideComponent);
            this.window = SwingUtilities.windowForComponent(this.tip);
            if (this.window != null && this.window != window) {
                this.window.addMouseListener(this);
            } else {
                this.window = null;
            }
            Toolkit.getDefaultToolkit().addAWTEventListener(this.getAWTListener(), 8L);
            this.tipShowing = true;
        }
    }

    protected void hideTipWindow() {
        if (this.tipWindow != null) {
            if (this.window != null) {
                this.window.removeMouseListener(this);
                this.window = null;
            }
            this.tipWindow.hide();
            this.tipWindow = null;
            this.tipShowing = false;
            this.tip.getUI().uninstallUI(this.tip);
            this.tip = null;
            if (null != this.awtListener) {
                Toolkit.getDefaultToolkit().removeAWTEventListener(this.getAWTListener());
            }
        }
    }

    protected void registerComponent(JComponent jComponent) {
        jComponent.removeMouseListener(this);
        jComponent.addMouseListener(this);
        jComponent.removeMouseMotionListener(this.moveBeforeEnterListener);
        jComponent.addMouseMotionListener(this.moveBeforeEnterListener);
        if (this.shouldRegisterBindings(jComponent)) {
            InputMap inputMap = jComponent.getInputMap(0);
            ActionMap actionMap = jComponent.getActionMap();
            if (inputMap == null || actionMap != null) {
                // empty if block
            }
        }
    }

    protected void unregisterComponent(JComponent jComponent) {
        jComponent.removeMouseListener(this);
        jComponent.removeMouseMotionListener(this.moveBeforeEnterListener);
        if (this.shouldRegisterBindings(jComponent)) {
            InputMap inputMap = jComponent.getInputMap(0);
            ActionMap actionMap = jComponent.getActionMap();
            if (inputMap == null || actionMap != null) {
                // empty if block
            }
        }
    }

    private boolean shouldRegisterBindings(JComponent jComponent) {
        InputMap inputMap;
        for (inputMap = jComponent.getInputMap(0); inputMap != null && inputMap.size() == 0; inputMap = inputMap.getParent()) {
        }
        return inputMap != null;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.initiateToolTip(mouseEvent);
    }

    private void initiateToolTip(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.window) {
            return;
        }
        JComponent jComponent = (JComponent)mouseEvent.getSource();
        jComponent.removeMouseMotionListener(this.moveBeforeEnterListener);
        this.exitTimer.stop();
        Point point = mouseEvent.getPoint();
        if (point.x < 0 || point.x >= jComponent.getWidth() || point.y < 0 || point.y >= jComponent.getHeight()) {
            return;
        }
        if (this.insideComponent != null) {
            this.enterTimer.stop();
        }
        jComponent.removeMouseMotionListener(this);
        jComponent.addMouseMotionListener(this);
        boolean bl = this.insideComponent == jComponent;
        this.insideComponent = jComponent;
        if (this.tipWindow != null) {
            this.mouseEvent = mouseEvent;
            if (this.showImmediately) {
                Rectangle rectangle = this.provider.getToolTipSourceBounds(mouseEvent.getPoint());
                if (null != rectangle) {
                    String string = this.startToolTipCalculation(rectangle, mouseEvent.getPoint());
                    if (!bl || !this.toolTipText.equals(string)) {
                        this.toolTipText = string;
                        this.showTipWindow();
                    }
                }
            } else {
                this.enterTimer.start();
            }
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        Window window;
        boolean bl = true;
        if (this.insideComponent == null) {
            // empty if block
        }
        if (this.window != null && mouseEvent.getSource() == this.window) {
            Container container = this.insideComponent.getTopLevelAncestor();
            Point point = mouseEvent.getPoint();
            SwingUtilities.convertPointToScreen(point, this.window);
            point.x -= container.getX();
            point.y -= container.getY();
            point = SwingUtilities.convertPoint(null, point, this.insideComponent);
            bl = point.x < 0 || point.x >= this.insideComponent.getWidth() || point.y < 0 || point.y >= this.insideComponent.getHeight();
        } else if (mouseEvent.getSource() == this.insideComponent && this.tipWindow != null && (window = SwingUtilities.getWindowAncestor(this.insideComponent)) != null) {
            Point point = SwingUtilities.convertPoint(this.insideComponent, mouseEvent.getPoint(), window);
            Rectangle rectangle = this.insideComponent.getTopLevelAncestor().getBounds();
            point.x += rectangle.x;
            point.y += rectangle.y;
            Point point2 = new Point(0, 0);
            SwingUtilities.convertPointToScreen(point2, this.tip);
            rectangle.x = point2.x;
            rectangle.y = point2.y;
            rectangle.width = this.tip.getWidth();
            rectangle.height = this.tip.getHeight();
            bl = point.x < rectangle.x || point.x >= rectangle.x + rectangle.width || point.y < rectangle.y || point.y >= rectangle.y + rectangle.height;
        }
        if (bl) {
            this.enterTimer.stop();
            if (this.insideComponent != null) {
                this.insideComponent.removeMouseMotionListener(this);
            }
            this.insideComponent = null;
            this.toolTipText = null;
            this.mouseEvent = null;
            this.hideTipWindow();
            this.exitTimer.restart();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.hideTipWindow();
        this.enterTimer.stop();
        this.showImmediately = false;
        this.insideComponent = null;
        this.mouseEvent = null;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.tipShowing) {
            this.checkForTipChange(mouseEvent);
        } else if (this.showImmediately) {
            Rectangle rectangle = this.provider.getToolTipSourceBounds(mouseEvent.getPoint());
            if (null != rectangle) {
                JComponent jComponent = (JComponent)mouseEvent.getSource();
                this.toolTipText = this.startToolTipCalculation(rectangle, mouseEvent.getPoint());
                if (this.toolTipText != null) {
                    this.mouseEvent = mouseEvent;
                    this.insideComponent = jComponent;
                    this.exitTimer.stop();
                    this.showTipWindow();
                }
            }
        } else {
            this.insideComponent = (JComponent)mouseEvent.getSource();
            this.mouseEvent = mouseEvent;
            this.toolTipText = null;
            this.enterTimer.restart();
        }
    }

    private void checkForTipChange(MouseEvent mouseEvent) {
        JComponent jComponent = (JComponent)mouseEvent.getSource();
        Rectangle rectangle = this.provider.getToolTipSourceBounds(mouseEvent.getPoint());
        if (rectangle != null) {
            this.mouseEvent = mouseEvent;
            if (rectangle.equals(this.lastTooltipForRect)) {
                if (this.tipWindow == null) {
                    this.enterTimer.restart();
                }
            } else {
                this.toolTipText = this.startToolTipCalculation(rectangle, mouseEvent.getPoint());
                if (this.showImmediately) {
                    this.hideTipWindow();
                    this.showTipWindow();
                    this.exitTimer.stop();
                } else {
                    this.enterTimer.restart();
                }
            }
        } else {
            this.toolTipText = null;
            this.mouseEvent = null;
            this.insideComponent = null;
            this.hideTipWindow();
            this.enterTimer.stop();
            this.exitTimer.restart();
        }
    }

    protected ToolTipEx createToolTip() {
        return new ToolTipEx();
    }

    protected AWTEventListener getAWTListener() {
        if (null == this.awtListener) {
            this.awtListener = new AWTEventListener(){
                boolean armed = false;

                public void eventDispatched(AWTEvent aWTEvent) {
                    if (aWTEvent instanceof KeyEvent) {
                        KeyEvent keyEvent = (KeyEvent)aWTEvent;
                        if (keyEvent.getKeyCode() == 112 && (keyEvent.isControlDown() || keyEvent.isMetaDown())) {
                            if (keyEvent.getID() == 401) {
                                this.armed = true;
                                return;
                            }
                            if (keyEvent.getID() == 402 && this.armed) {
                                keyEvent.consume();
                                this.armed = false;
                                ToolTipManagerEx.this.provider.invokeUserAction(ToolTipManagerEx.this.mouseEvent);
                                ToolTipManagerEx.this.hideTipWindow();
                                return;
                            }
                        } else if (keyEvent.getKeyCode() != 17 && keyEvent.getKeyCode() != 157) {
                            this.armed = false;
                        }
                    }
                }
            };
        }
        return this.awtListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String startToolTipCalculation(Rectangle rectangle, Point point) {
        Object object = TOOLTIP_DATA_LOCK;
        synchronized (object) {
            if (rectangle.equals(this.lastTooltipForRect)) {
                return this.lastTooltipText;
            }
            if (this.tooltipTask != null) {
                boolean bl = this.tooltipTask.cancel();
                this.tooltipTask = null;
            }
            this.lastTooltipForRect = new Rectangle(rectangle);
        }
        object = new TooltipCalculator(rectangle, point);
        Object object2 = TOOLTIP_DATA_LOCK;
        synchronized (object2) {
            this.tooltipTask = RequestProcessor.getDefault().post((Runnable)object);
        }
        return WAITING_TEXT;
    }

    private Dimension getDefaultToolTipSize() {
        Preferences preferences = (Preferences)MimeLookup.getLookup((MimePath)MimePath.EMPTY).lookup(Preferences.class);
        String string = preferences.get("javadoc-preferred-size", null);
        Dimension dimension = string == null ? null : ToolTipManagerEx.parseDimension(string);
        return dimension != null ? dimension : new Dimension(500, 300);
    }

    private static Dimension parseDimension(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int[] nArray = new int[2];
        int n = 0;
        while (stringTokenizer.hasMoreElements()) {
            if (n > 1) {
                return null;
            }
            try {
                nArray[n] = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                LOG.log(Level.WARNING, null, numberFormatException);
                return null;
            }
            ++n;
        }
        if (n != 2) {
            return null;
        }
        return new Dimension(nArray[0], nArray[1]);
    }

    private class ToolTipEx
    extends JPanel {
        private HTMLDocView content;
        private JLabel shortcut;

        public ToolTipEx() {
            super(new GridBagLayout());
            this.setPreferredSize(ToolTipManagerEx.this.getDefaultToolTipSize());
            Color color = new JEditorPane().getBackground();
            color = new Color(Math.max(color.getRed() - 8, 0), Math.max(color.getGreen() - 8, 0), color.getBlue());
            this.setBackground(color);
            this.content = new HTMLDocView(color);
            JScrollPane jScrollPane = new JScrollPane(this.content);
            jScrollPane.setHorizontalScrollBarPolicy(31);
            this.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.shortcut = new JLabel(NbBundle.getMessage(ToolTipManagerEx.class, (String)"HINT_EnlargeJavaDocToolip", (Object)(Utilities.isMac() ? KeyEvent.getKeyText(157) + "+F1" : "Ctrl+F1")));
            this.shortcut.setHorizontalAlignment(0);
            this.shortcut.setBorder(BorderFactory.createLineBorder(Color.black));
            this.add((Component)this.shortcut, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        public void setTipText(String string) {
            if (WAITING_TEXT.equals(string)) {
                this.content.setContent(WAITING_TEXT, null);
                this.shortcut.setVisible(false);
            } else {
                this.content.setContent(string, null);
                this.shortcut.setVisible(true);
            }
        }
    }

    private class TooltipCalculator
    implements Runnable {
        private Point location;
        private Rectangle tooltipForRect;

        TooltipCalculator(Rectangle rectangle, Point point) {
            this.tooltipForRect = rectangle;
            this.location = point;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            final String string = ToolTipManagerEx.this.provider.getToolTipText(this.location);
            if (null == string) {
                return;
            }
            Object object = TOOLTIP_DATA_LOCK;
            synchronized (object) {
                ToolTipManagerEx.this.tooltipTask = null;
                if (ToolTipManagerEx.this.lastTooltipForRect == null || !this.tooltipForRect.equals(ToolTipManagerEx.this.lastTooltipForRect)) {
                    return;
                }
                ToolTipManagerEx.this.lastTooltipText = string;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ToolTipManagerEx.this.toolTipText = string;
                    if (null != ToolTipManagerEx.this.tip) {
                        ToolTipManagerEx.this.tip.setTipText(ToolTipManagerEx.this.toolTipText);
                        ToolTipManagerEx.this.tip.invalidate();
                        ToolTipManagerEx.this.tip.revalidate();
                        ToolTipManagerEx.this.tip.repaint();
                    }
                }
            });
        }
    }

    private class MoveBeforeEnterListener
    extends MouseMotionAdapter {
        private MoveBeforeEnterListener() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            ToolTipManagerEx.this.initiateToolTip(mouseEvent);
        }
    }

    protected class outsideTimerAction
    implements ActionListener {
        protected outsideTimerAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ToolTipManagerEx.this.showImmediately = false;
        }
    }

    protected class insideTimerAction
    implements ActionListener {
        protected insideTimerAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ToolTipManagerEx.this.insideComponent != null && ToolTipManagerEx.this.insideComponent.isShowing()) {
                Rectangle rectangle;
                if (ToolTipManagerEx.this.toolTipText == null && ToolTipManagerEx.this.mouseEvent != null && null != (rectangle = ToolTipManagerEx.this.provider.getToolTipSourceBounds(ToolTipManagerEx.this.mouseEvent.getPoint()))) {
                    ToolTipManagerEx.this.toolTipText = ToolTipManagerEx.this.startToolTipCalculation(rectangle, ToolTipManagerEx.this.mouseEvent.getPoint());
                }
                if (ToolTipManagerEx.this.toolTipText != null) {
                    ToolTipManagerEx.this.showImmediately = true;
                    ToolTipManagerEx.this.showTipWindow();
                } else {
                    ToolTipManagerEx.this.insideComponent = null;
                    ToolTipManagerEx.this.toolTipText = null;
                    ToolTipManagerEx.this.mouseEvent = null;
                    ToolTipManagerEx.this.hideTipWindow();
                }
            }
        }
    }

    static interface ToolTipProvider {
        public JComponent getComponent();

        public String getToolTipText(Point var1);

        public Rectangle getToolTipSourceBounds(Point var1);

        public Point getToolTipLocation(Point var1, Dimension var2);

        public void invokeUserAction(MouseEvent var1);
    }
}

