/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.component.vforms;

import com.sun.rave.designtime.DesignBean;
import com.sun.rave.designtime.DesignContext;
import com.sun.rave.designtime.DesignProperty;
import com.sun.rave.designtime.Result;
import com.sun.rave.designtime.ext.componentgroup.ComponentGroupHolder;
import com.sun.rave.designtime.ext.componentgroup.impl.ColorWrapperImpl;
import com.sun.rave.designtime.ext.componentgroup.util.ComponentGroupHelper;
import com.sun.webui.jsf.component.Form;
import com.sun.webui.jsf.component.FormDesignInfo;
import com.sun.webui.jsf.component.vforms.EditVirtualFormsCustomizer;
import com.sun.webui.jsf.component.vforms.HomogonousCellRenderer;
import com.sun.webui.jsf.component.vforms.TextFieldCellEditor;
import com.sun.webui.jsf.component.vforms.VirtualFormsHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.faces.component.ActionSource;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class EditVirtualFormsCustomizerPanel
extends JPanel {
    protected EditVirtualFormsCustomizer customizer;
    protected DesignBean[] beans;
    private DesignBean formBean;
    private List inputBeans = new ArrayList();
    private List actionBeans = new ArrayList();
    private List vformsList = new ArrayList();
    private Map colorMap = new HashMap();
    private FormsTableModel vformsTableModel = new FormsTableModel();
    private boolean canParticipate = true;
    private boolean canSubmit = true;
    private static final String YES = ResourceBundle.getBundle("com/sun/webui/jsf/component/vforms/Bundle").getString("yes");
    private static final String NO = ResourceBundle.getBundle("com/sun/webui/jsf/component/vforms/Bundle").getString("no");
    private static final String SOME_PARTICIPATE = ResourceBundle.getBundle("com/sun/webui/jsf/component/vforms/Bundle").getString("someParticipate");
    private static final String SOME_SUBMIT = ResourceBundle.getBundle("com/sun/webui/jsf/component/vforms/Bundle").getString("someSubmit");
    private static final String[] NO_ONLY = new String[]{NO};
    private static final String[] YES_NO = new String[]{YES, NO};
    private static final String[] YES_NO_SOME_PARTICIPATE = new String[]{YES, NO, SOME_PARTICIPATE};
    private static final String[] YES_NO_SOME_SUBMIT = new String[]{YES, NO, SOME_SUBMIT};
    private JButton btnDelete;
    private JButton btnNew;
    private JScrollPane jScrollPane1;
    private JLabel tableLabel;
    private JTable vformsTable;

    public Result applyChanges() {
        Form.VirtualFormDescriptor[] vforms = this.vformsList.toArray(new Form.VirtualFormDescriptor[this.vformsList.size()]);
        String vfConfig = Form.generateVirtualFormsConfig((Form.VirtualFormDescriptor[])vforms);
        DesignProperty vfcProp = this.formBean.getProperty("virtualFormsConfig");
        vfcProp.setValue((Object)vfConfig);
        DesignContext context = this.customizer.getDesignBean().getDesignContext();
        for (int i = 0; vforms != null && i < vforms.length; ++i) {
            String vfName = vforms[i].getName();
            String key = this.getColorKey(vfName);
            Color c = (Color)this.colorMap.get(key);
            if (c == null) continue;
            context.setContextData(key, (Object)new ColorWrapperImpl(c));
        }
        this.customizer.setModified(false);
        return null;
    }

    public EditVirtualFormsCustomizerPanel(EditVirtualFormsCustomizer customizer) {
        this.customizer = customizer;
        this.beans = customizer.getDesignBeans();
        this.canParticipate = this.initCanParticipate();
        this.canSubmit = this.initCanSubmit();
        this.initComponents();
        this.readVFormInfo();
    }

    public EditVirtualFormsCustomizerPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.tableLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.vformsTable = new JTable();
        this.vformsTable.setSelectionMode(0);
        JTextField textField = new JTextField();
        TextFieldCellEditor cellEditor = new TextFieldCellEditor(this.vformsTable, textField);
        this.vformsTable.setDefaultEditor(String.class, cellEditor);
        ((DefaultCellEditor)this.vformsTable.getDefaultEditor(String.class)).setClickCountToStart(1);
        this.vformsTable.setDefaultRenderer(String.class, new HomogonousCellRenderer());
        this.vformsTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.btnNew = new JButton();
        this.btnDelete = new JButton();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(550, 250));
        this.getAccessibleContext().setAccessibleName("Edit Virtual Forms dialog box");
        this.getAccessibleContext().setAccessibleDescription("Use this table to view and edit properties of the virutal forms defined on this page.");
        this.tableLabel.setDisplayedMnemonic(ResourceBundle.getBundle("com/sun/webui/jsf/component/vforms/Bundle").getString("labelMnemonic").charAt(0));
        this.tableLabel.setLabelFor(this.vformsTable);
        this.tableLabel.setText(MessageFormat.format(ResourceBundle.getBundle("com/sun/webui/jsf/component/vforms/Bundle").getString("editLabel"), this.getSelectedComponentsDisplayText()));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 5, 10);
        this.add((Component)this.tableLabel, gridBagConstraints);
        this.tableLabel.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("com/sun/webui/jsf/component/vforms/Bundle").getString("tableLabelAccessibleName"));
        this.tableLabel.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/webui/jsf/component/vforms/Bundle").getString("editTableLabelAccessibleDescription"));
        this.jScrollPane1.setBackground(SystemColor.window);
        this.jScrollPane1.setViewportView(this.vformsTable);
        this.vformsTable.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("com/sun/webui/jsf/component/vforms/Bundle").getString("vformsTableAccessibleName"));
        this.vformsTable.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/webui/jsf/component/vforms/Bundle").getString("editVformsTableAccessibleDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 5, 5);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jScrollPane1.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("com/sun/webui/jsf/component/vforms/Bundle").getString("vformsTableAccessibleName"));
        this.jScrollPane1.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/webui/jsf/component/vforms/Bundle").getString("editVformsTableAccessibleDescription"));
        this.btnNew.setMnemonic(ResourceBundle.getBundle("com/sun/webui/jsf/component/vforms/Bundle").getString("newButtonMnemonic").charAt(0));
        this.btnNew.setText(ResourceBundle.getBundle("com/sun/webui/jsf/component/vforms/Bundle").getString("New"));
        this.btnNew.setToolTipText(ResourceBundle.getBundle("com/sun/webui/jsf/component/vforms/Bundle").getString("NewVf"));
        this.btnNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditVirtualFormsCustomizerPanel.this.btnNewActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 10);
        this.add((Component)this.btnNew, gridBagConstraints);
        this.btnNew.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("com/sun/webui/jsf/component/vforms/Bundle").getString("btnNewAccessibleName"));
        this.btnNew.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/webui/jsf/component/vforms/Bundle").getString("btnNewAccessibleDescription"));
        this.btnDelete.setMnemonic(ResourceBundle.getBundle("com/sun/webui/jsf/component/vforms/Bundle").getString("deleteButtonMnemonic").charAt(0));
        this.btnDelete.setText(ResourceBundle.getBundle("com/sun/webui/jsf/component/vforms/Bundle").getString("Delete"));
        this.btnDelete.setToolTipText(ResourceBundle.getBundle("com/sun/webui/jsf/component/vforms/Bundle").getString("DeleteVf"));
        this.btnDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditVirtualFormsCustomizerPanel.this.btnDeleteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.add((Component)this.btnDelete, gridBagConstraints);
        this.btnDelete.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("com/sun/webui/jsf/component/vforms/Bundle").getString("btnDeleteAccessibleName"));
        this.btnDelete.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/webui/jsf/component/vforms/Bundle").getString("btnDeleteAccessibleDescription"));
    }

    private void btnDeleteActionPerformed(ActionEvent evt) {
        int vfidx = this.vformsTable.getSelectedRow();
        if (vfidx > -1 && vfidx < this.vformsList.size()) {
            Form.VirtualFormDescriptor vform = (Form.VirtualFormDescriptor)this.vformsList.get(vfidx);
            String title = ResourceBundle.getBundle("com/sun/webui/jsf/component/vforms/Bundle").getString("confirmDeleteTitle");
            String msg = MessageFormat.format(ResourceBundle.getBundle("com/sun/webui/jsf/component/vforms/Bundle").getString("confirmDeleteMessage"), vform.getName());
            if (JOptionPane.showConfirmDialog(this, msg, title, 0) == 0) {
                this.vformsList.remove(vfidx);
                this.vformsTableModel.fireTableDataChanged();
                if (this.vformsList.size() <= vfidx) {
                    --vfidx;
                }
                if (vfidx >= 0) {
                    this.vformsTable.getSelectionModel().setSelectionInterval(vfidx, vfidx);
                }
            }
        }
    }

    private void btnNewActionPerformed(ActionEvent evt) {
        String name = VirtualFormsHelper.getNewVirtualFormName(this.vformsList);
        Form.VirtualFormDescriptor vform = new Form.VirtualFormDescriptor(name);
        this.vformsList.add(vform);
        this.vformsTableModel.fireTableDataChanged();
        this.vformsTable.getSelectionModel().setSelectionInterval(this.vformsList.size() - 1, this.vformsList.size() - 1);
    }

    private boolean initCanParticipate() {
        for (int i = 0; i < this.beans.length; ++i) {
            if (!(this.beans[i].getInstance() instanceof EditableValueHolder)) continue;
            return true;
        }
        return false;
    }

    private String getParticipates(Form.VirtualFormDescriptor vform) {
        boolean atLeastOneParticipates = false;
        boolean atLeastOneDoesNot = false;
        for (int i = 0; i < this.beans.length; ++i) {
            String beanFqId;
            Object beanInstance = this.beans[i].getInstance();
            boolean beanCouldParticipate = beanInstance instanceof EditableValueHolder;
            if (!beanCouldParticipate || (beanFqId = FormDesignInfo.getFullyQualifiedId(this.beans[i])) == null) continue;
            if (vform.hasParticipant(beanFqId)) {
                atLeastOneParticipates = true;
                if (!atLeastOneDoesNot) continue;
                return SOME_PARTICIPATE;
            }
            atLeastOneDoesNot = true;
            if (!atLeastOneParticipates) continue;
            return SOME_PARTICIPATE;
        }
        if (atLeastOneParticipates) {
            return YES;
        }
        return NO;
    }

    private void setParticipates(Form.VirtualFormDescriptor vform, boolean participate) {
        int i;
        String[] pids = vform.getParticipatingIds();
        ArrayList<String> pList = new ArrayList<String>();
        for (i = 0; pids != null && i < pids.length; ++i) {
            pList.add(pids[i]);
        }
        for (i = 0; i < this.beans.length; ++i) {
            boolean contains;
            String fqId;
            Object beanInstance = this.beans[i].getInstance();
            if (!(beanInstance instanceof UIComponent) || (fqId = FormDesignInfo.getFullyQualifiedId(this.beans[i])) == null) continue;
            ArrayList<String> relevantPids = new ArrayList<String>();
            for (String pid : pList) {
                if (!Form.fullyQualifiedIdMatchesPattern((String)fqId, (String)pid)) continue;
                relevantPids.add(pid);
            }
            boolean bl = contains = relevantPids.size() > 0;
            if (participate && !contains && beanInstance instanceof EditableValueHolder) {
                String idToAdd = fqId;
                if (idToAdd.startsWith(String.valueOf(':')) && idToAdd.length() > 1) {
                    idToAdd = idToAdd.substring(1, idToAdd.length());
                }
                pList.add(idToAdd);
                this.customizer.setModified(true);
                continue;
            }
            if (participate || !contains) continue;
            for (Object e : relevantPids) {
                pList.remove(e);
                this.customizer.setModified(true);
            }
        }
        pids = pList.toArray(new String[pList.size()]);
        vform.setParticipatingIds(pids);
    }

    private boolean initCanSubmit() {
        for (int i = 0; i < this.beans.length; ++i) {
            if (!(this.beans[i].getInstance() instanceof ActionSource) && !(this.beans[i].getInstance() instanceof EditableValueHolder)) continue;
            return true;
        }
        return false;
    }

    private String getSubmits(Form.VirtualFormDescriptor vform) {
        boolean atLeastOneSubmits = false;
        boolean atLeastOneDoesNot = false;
        for (int i = 0; i < this.beans.length; ++i) {
            String beanFqId = FormDesignInfo.getFullyQualifiedId(this.beans[i]);
            if (beanFqId == null) continue;
            if (vform.isSubmittedBy(beanFqId)) {
                atLeastOneSubmits = true;
                if (!atLeastOneDoesNot) continue;
                return SOME_SUBMIT;
            }
            atLeastOneDoesNot = true;
            if (!atLeastOneSubmits) continue;
            return SOME_SUBMIT;
        }
        if (atLeastOneSubmits) {
            return YES;
        }
        return NO;
    }

    private void setSubmits(Form.VirtualFormDescriptor vform, boolean submit) {
        int i;
        String[] sids = vform.getSubmittingIds();
        ArrayList<String> sList = new ArrayList<String>();
        for (i = 0; sids != null && i < sids.length; ++i) {
            sList.add(sids[i]);
        }
        for (i = 0; i < this.beans.length; ++i) {
            boolean contains;
            String fqId;
            Object beanInstance = this.beans[i].getInstance();
            if (!(beanInstance instanceof UIComponent) || (fqId = FormDesignInfo.getFullyQualifiedId(this.beans[i])) == null) continue;
            ArrayList<String> relevantSids = new ArrayList<String>();
            for (String sid : sList) {
                if (!Form.fullyQualifiedIdMatchesPattern((String)fqId, (String)sid)) continue;
                relevantSids.add(sid);
            }
            boolean bl = contains = relevantSids.size() > 0;
            if (submit && !contains && (beanInstance instanceof ActionSource || beanInstance instanceof EditableValueHolder)) {
                String idToAdd = fqId;
                if (idToAdd.startsWith(String.valueOf(':')) && idToAdd.length() > 1) {
                    idToAdd = idToAdd.substring(1, idToAdd.length());
                }
                sList.add(idToAdd);
                this.customizer.setModified(true);
                continue;
            }
            if (submit || !contains) continue;
            for (Object e : relevantSids) {
                sList.remove(e);
                this.customizer.setModified(true);
            }
        }
        sids = sList.toArray(new String[sList.size()]);
        vform.setSubmittingIds(sids);
    }

    private void readVFormInfo() {
        this.formBean = VirtualFormsHelper.findFormBean(this.beans);
        DesignContext dcontext = this.formBean.getDesignContext();
        ComponentGroupHolder[] holders = ComponentGroupHelper.getComponentGroupHolders((DesignContext)dcontext);
        ComponentGroupHelper.populateColorMap((DesignContext)dcontext, (ComponentGroupHolder[])holders, (Map)this.colorMap);
        Form form = (Form)this.formBean.getInstance();
        Form.VirtualFormDescriptor[] vforms = form.getVirtualForms();
        for (int i = 0; vforms != null && i < vforms.length; ++i) {
            String vformName = vforms[i].getName();
            Form.VirtualFormDescriptor vformCopy = new Form.VirtualFormDescriptor(vformName);
            vformCopy.setParticipatingIds(vforms[i].getParticipatingIds());
            vformCopy.setSubmittingIds(vforms[i].getSubmittingIds());
            this.vformsList.add(vformCopy);
        }
        this.vformsTable.setModel(this.vformsTableModel);
        this.vformsTable.setSelectionMode(0);
        TableColumn colorCol = this.vformsTable.getColumnModel().getColumn(0);
        colorCol.setCellRenderer(new ColorCellRenderer());
        colorCol.setCellEditor(new DefaultCellEditor(new ColorComboBox()));
        ((DefaultCellEditor)colorCol.getCellEditor()).setClickCountToStart(2);
        TableColumn psCol = this.vformsTable.getColumnModel().getColumn(2);
        psCol.setCellEditor(new DefaultCellEditor(new PSComboBox(true)));
        ((DefaultCellEditor)psCol.getCellEditor()).setClickCountToStart(2);
        psCol = this.vformsTable.getColumnModel().getColumn(3);
        psCol.setCellEditor(new DefaultCellEditor(new PSComboBox(false)));
        ((DefaultCellEditor)psCol.getCellEditor()).setClickCountToStart(2);
        if (this.vformsTableModel.getRowCount() > 0) {
            this.vformsTable.changeSelection(0, 0, false, false);
        }
    }

    private String[] getOptions(boolean participate) {
        if (participate) {
            boolean atLeastOneEvh = false;
            for (int i = 0; i < this.beans.length; ++i) {
                Object instance = this.beans[i].getInstance();
                if (!(instance instanceof EditableValueHolder)) continue;
                atLeastOneEvh = true;
                break;
            }
            if (!atLeastOneEvh) {
                return NO_ONLY;
            }
        }
        return YES_NO;
    }

    private String getSelectedComponentsDisplayText() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; this.beans != null && i < this.beans.length; ++i) {
            sb.append(this.beans[i].getInstanceName());
            sb.append("<br>");
        }
        return sb.toString();
    }

    private String getColorKey(String vfName) {
        String formBeanId = this.formBean.getInstanceName();
        String formIdDotVfName = formBeanId + "." + vfName;
        return ComponentGroupHelper.getComponentGroupColorKey((String)FormDesignInfo.VIRTUAL_FORM_HOLDER_NAME, (String)formIdDotVfName);
    }

    class ColorListRenderer
    extends DefaultListCellRenderer {
        ColorListRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, hasFocus);
            Color c = (Color)value;
            this.setIcon(new ColorIcon(c));
            this.setText(null);
            return this;
        }
    }

    class PSComboBox
    extends JComboBox {
        public PSComboBox(boolean participates) {
            this.setOptions(EditVirtualFormsCustomizerPanel.this.getOptions(participates));
        }

        private void setOptions(String[] options) {
            DefaultComboBoxModel<String> cbm = new DefaultComboBoxModel<String>();
            for (int i = 0; i < options.length; ++i) {
                cbm.addElement(options[i]);
            }
            this.setModel(cbm);
        }
    }

    class ColorComboBox
    extends JComboBox {
        public ColorComboBox() {
            DefaultComboBoxModel<Color> cbm = new DefaultComboBoxModel<Color>();
            for (int i = 0; i < ComponentGroupHelper.DEFAULT_COLOR_SET.length; ++i) {
                Color c = ComponentGroupHelper.DEFAULT_COLOR_SET[i];
                cbm.addElement(c);
            }
            this.setModel(cbm);
            this.setRenderer(new ColorListRenderer());
            this.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("com/sun/webui/jsf/component/vforms/Bundle").getString("colorComboAccessibleName"));
            this.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/webui/jsf/component/vforms/Bundle").getString("colorComboAccessibleDescription"));
        }
    }

    class ColorIcon
    implements Icon {
        private Color color;

        public ColorIcon(Color color) {
            this.color = color;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(this.color);
            g.fillRect(x, y, 8, 8);
            g.setColor(Color.black);
            g.drawRect(x, y, 8, 8);
        }

        public int getIconWidth() {
            return 8;
        }

        public int getIconHeight() {
            return 8;
        }
    }

    class ColorCellRenderer
    extends DefaultTableCellRenderer {
        Color SELECTION_BACKGROUND = UIManager.getDefaults().getColor("TextField.selectionBackground");
        Color SELECTION_FOREGROUND = UIManager.getDefaults().getColor("TextField.selectionForeground");
        Color BACKGROUND = UIManager.getDefaults().getColor("TextField.background");
        Color FOREGROUND = UIManager.getDefaults().getColor("TextField.foreground");

        ColorCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (isSelected) {
                c.setBackground(this.SELECTION_BACKGROUND);
                c.setForeground(this.SELECTION_FOREGROUND);
            } else {
                c.setBackground(this.BACKGROUND);
                c.setForeground(this.FOREGROUND);
            }
            Color color = (Color)value;
            this.setIcon(new ColorIcon(color));
            this.setText(null);
            return this;
        }
    }

    class FormsTableModel
    extends AbstractTableModel {
        public int getRowCount() {
            return EditVirtualFormsCustomizerPanel.this.vformsList.size();
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ResourceBundle.getBundle("com/sun/webui/jsf/component/vforms/Bundle").getString("colorHeader");
                }
                case 1: {
                    return ResourceBundle.getBundle("com/sun/webui/jsf/component/vforms/Bundle").getString("nameHeader");
                }
                case 2: {
                    return ResourceBundle.getBundle("com/sun/webui/jsf/component/vforms/Bundle").getString("participateHeader");
                }
                case 3: {
                    return ResourceBundle.getBundle("com/sun/webui/jsf/component/vforms/Bundle").getString("submitHeader");
                }
            }
            return null;
        }

        public Class getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Color.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return String.class;
                }
                case 3: {
                    return String.class;
                }
            }
            return null;
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            Form.VirtualFormDescriptor vform = (Form.VirtualFormDescriptor)EditVirtualFormsCustomizerPanel.this.vformsList.get(rowIndex);
            if (vform != null) {
                switch (columnIndex) {
                    case 0: {
                        return true;
                    }
                    case 1: {
                        return true;
                    }
                    case 2: {
                        return EditVirtualFormsCustomizerPanel.this.canParticipate;
                    }
                    case 3: {
                        return EditVirtualFormsCustomizerPanel.this.canSubmit;
                    }
                }
            }
            return false;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            Form.VirtualFormDescriptor vform = (Form.VirtualFormDescriptor)EditVirtualFormsCustomizerPanel.this.vformsList.get(rowIndex);
            if (vform != null) {
                switch (columnIndex) {
                    case 0: {
                        String vfName = vform.getName();
                        String key = EditVirtualFormsCustomizerPanel.this.getColorKey(vfName);
                        return ComponentGroupHelper.getMappedColor((String)key, (Map)EditVirtualFormsCustomizerPanel.this.colorMap);
                    }
                    case 1: {
                        return vform.getName();
                    }
                    case 2: {
                        return EditVirtualFormsCustomizerPanel.this.getParticipates(vform);
                    }
                    case 3: {
                        return EditVirtualFormsCustomizerPanel.this.getSubmits(vform);
                    }
                }
            }
            return null;
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            Form.VirtualFormDescriptor vform = (Form.VirtualFormDescriptor)EditVirtualFormsCustomizerPanel.this.vformsList.get(rowIndex);
            if (vform != null) {
                switch (columnIndex) {
                    case 0: {
                        String vfName = vform.getName();
                        String colorKey = EditVirtualFormsCustomizerPanel.this.getColorKey(vfName);
                        EditVirtualFormsCustomizerPanel.this.colorMap.put(colorKey, aValue);
                        EditVirtualFormsCustomizerPanel.this.customizer.setModified(true);
                        return;
                    }
                    case 1: {
                        String name = aValue.toString();
                        name = name.trim();
                        name = name.replaceAll("\\|", "_");
                        name = name.replaceAll(",", "_");
                        if (name.length() < 1) {
                            name = VirtualFormsHelper.getNewVirtualFormName(EditVirtualFormsCustomizerPanel.this.vformsList);
                        }
                        String vfName = vform.getName();
                        String colorKey = EditVirtualFormsCustomizerPanel.this.getColorKey(vfName);
                        Color c = (Color)EditVirtualFormsCustomizerPanel.this.colorMap.get(colorKey);
                        EditVirtualFormsCustomizerPanel.this.colorMap.remove(colorKey);
                        vform.setName(name);
                        colorKey = EditVirtualFormsCustomizerPanel.this.getColorKey(name);
                        EditVirtualFormsCustomizerPanel.this.colorMap.put(colorKey, c);
                        EditVirtualFormsCustomizerPanel.this.customizer.setModified(true);
                        return;
                    }
                    case 2: {
                        String pvalue = (String)aValue;
                        boolean participates = YES.equals(pvalue);
                        EditVirtualFormsCustomizerPanel.this.setParticipates(vform, participates);
                        return;
                    }
                    case 3: {
                        String svalue = (String)aValue;
                        boolean submits = YES.equals(svalue);
                        EditVirtualFormsCustomizerPanel.this.setSubmits(vform, submits);
                        if (submits) {
                            for (Form.VirtualFormDescriptor vf : EditVirtualFormsCustomizerPanel.this.vformsList) {
                                if (vf.getName().equals(vform.getName())) continue;
                                EditVirtualFormsCustomizerPanel.this.setSubmits(vf, false);
                            }
                            this.fireTableDataChanged();
                        }
                        return;
                    }
                }
            }
        }
    }
}

