/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.ajax;

import com.sun.webui.jsf.component.Login;
import com.sun.webui.jsf.model.login.LoginCallback;
import com.sun.webui.jsf.model.login.LoginConstants;
import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LoginRenderer
extends com.sun.webui.jsf.renderkit.widget.LoginRenderer {
    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!(component instanceof Login)) {
            throw new IllegalArgumentException("LoginRenderer can only decode Login components.");
        }
        Login login = (Login)component;
        try {
            ExternalContext ec = context.getExternalContext();
            Map map = ec.getRequestHeaderMap();
            JSONObject xjson = new JSONObject((String)map.get("X-JSON"));
            String id = (String)xjson.get("id");
            if (login.getClientId(context).equals(id)) {
                JSONArray keys;
                String loginState = (String)xjson.get("loginState");
                if (loginState != null) {
                    if (loginState.equalsIgnoreCase("INIT")) {
                        login.setLoginState(LoginConstants.LOGINSTATE.INIT);
                    } else if (loginState.equalsIgnoreCase("CONTINUE")) {
                        login.setLoginState(LoginConstants.LOGINSTATE.CONTINUE);
                    } else if (loginState.equalsIgnoreCase("SUCCESS")) {
                        login.setLoginState(LoginConstants.LOGINSTATE.SUCCESS);
                    } else if (loginState.equalsIgnoreCase("FAILURE")) {
                        login.setLoginState(LoginConstants.LOGINSTATE.FAILURE);
                    }
                } else {
                    login.setLoginState(LoginConstants.LOGINSTATE.INIT);
                }
                if (!login.getLoginState().equals((Object)LoginConstants.LOGINSTATE.INIT) && (keys = (JSONArray)xjson.get("keys")) != null) {
                    Map parmMap = ec.getRequestParameterMap();
                    HashMap<String, Object> hMap = new HashMap<String, Object>();
                    Map keyMap = login.getAuthenticationKeys();
                    int length = keys.length();
                    String[] strKeys = new String[length];
                    for (int i = 0; i < length; ++i) {
                        JSONArray keyArray = (JSONArray)keys.get(i);
                        String key = (String)keyArray.get(0);
                        Object value = keyArray.get(1);
                        hMap.put(key, value);
                    }
                    login.setSubmittedValue(hMap);
                }
            }
        }
        catch (JSONException e) {
            login.setLoginState(LoginConstants.LOGINSTATE.INIT);
        }
        catch (NullPointerException e) {
            login.setLoginState(LoginConstants.LOGINSTATE.INIT);
        }
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            return;
        }
        Login login = (Login)component;
        try {
            LoginCallback lcb = login.getCallbackObject();
            JSONObject json = new JSONObject();
            if (lcb != null) {
                json.put("loginState", (Object)lcb.getLoginState());
                json.put("id", (Object)login.getClientId(context));
                if (login.getLoginState().equals((Object)LoginConstants.LOGINSTATE.FAILURE)) {
                    String msgSummary = lcb.getMessageSummary();
                    if (!login.isValid()) {
                        Iterator it = context.getMessages();
                        while (it.hasNext()) {
                            FacesMessage fm = (FacesMessage)it.next();
                            json.put("alert", (Object)this.getAlertData(context, fm.getSeverity().toString(), fm.getSummary(), fm.getDetail()));
                        }
                    } else if (msgSummary != null && msgSummary.length() > 0) {
                        json.put("alert", (Object)this.getAlertData(context, lcb.getMessageType(), msgSummary, lcb.getMessageDetail()));
                    }
                    Map oldKeyMap = login.getAuthenticationKeys();
                    login.setAuthenticationKeys(oldKeyMap);
                } else {
                    JSONArray keys = new JSONArray();
                    JSONArray userData = new JSONArray();
                    String[] dataKeys = lcb.getDataKeys();
                    HashMap keyMap = new HashMap();
                    for (int i = 0; i < dataKeys.length; ++i) {
                        String key = dataKeys[i];
                        String type = lcb.getCallbackDataType(key);
                        JSONArray content = this.getRenderedWidget(login, context, lcb, key, keys, keyMap);
                        if (content == null) continue;
                        userData.put(i, (Object)content);
                    }
                    String msgSummary = lcb.getMessageSummary();
                    if (msgSummary != null && msgSummary.length() > 0) {
                        json.put("alert", (Object)this.getAlertData(context, lcb.getMessageType(), msgSummary, lcb.getMessageDetail()));
                    }
                    login.setAuthenticationKeys(keyMap);
                    json.put("keys", (Object)keys);
                    json.put("userData", (Object)userData);
                    json.put("redirectURL", (Object)login.getRedirectURL());
                }
            } else if (!login.isValid()) {
                json.put("loginState", (Object)LoginConstants.LOGINSTATE.FAILURE);
                json.put("id", (Object)login.getClientId(context));
                Iterator it = context.getMessages();
                while (it.hasNext()) {
                    FacesMessage fm = (FacesMessage)it.next();
                    json.put("alert", (Object)this.getAlertData(context, fm.getSeverity().toString(), fm.getSummary(), fm.getDetail()));
                }
            }
            json.write((Writer)context.getResponseWriter());
        }
        catch (JSONException je) {
            LogUtil.severe("JSON Exception thrown during rendering");
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
    }

    private JSONArray getRenderedWidget(Login login, FacesContext context, LoginCallback lcb, String key, JSONArray keys, Map keyMap) throws IOException, JSONException {
        JSONArray contentArray = new JSONArray();
        JSONArray keyArray = new JSONArray();
        String widgetType = lcb.getCallbackDataType(key);
        String labelData = lcb.getCallbackDataLabel(key);
        this.setLabelData(labelData, contentArray, login, key, context);
        JSONObject props = new JSONObject();
        props.put("type", (Object)widgetType);
        props.put("id", (Object)key);
        if (widgetType.equalsIgnoreCase("staticText")) {
            props.put("value", (Object)lcb.getCallbackDataValue(key));
            contentArray.put((Object)props);
        } else if (widgetType.equalsIgnoreCase("textField")) {
            props.put("value", (Object)lcb.getCallbackDataValue(key));
            contentArray.put((Object)props);
            keyArray.put((Object)key);
            keyArray.put((Object)lcb.getCallbackDataValue(key));
            keys.put((Object)keyArray);
        } else if (widgetType.equalsIgnoreCase("passwordfield")) {
            contentArray.put((Object)props);
            keyArray.put((Object)key);
            keys.put((Object)keyArray);
        } else if (widgetType.equalsIgnoreCase("dropDown") || widgetType.equalsIgnoreCase("listbox")) {
            String[] list = lcb.getCallbackDataList(key);
            JSONArray optArray = new JSONArray();
            if (list != null && list.length > 0) {
                for (int i = 0; i < list.length; ++i) {
                    JSONObject opt = new JSONObject();
                    opt.put("group", false);
                    opt.put("separator", false);
                    opt.put("value", (Object)list[i]);
                    opt.put("label", (Object)list[i]);
                    optArray.put((Object)opt);
                }
            }
            props.put("options", (Object)optArray);
            contentArray.put((Object)props);
            keyArray.put((Object)key);
            keys.put((Object)keyArray);
        } else if (widgetType.equalsIgnoreCase("image")) {
            props.put("src", (Object)lcb.getCallbackDataValue(key));
            contentArray.put((Object)props);
        }
        if (contentArray.length() > 0) {
            return contentArray;
        }
        return null;
    }

    private void setLabelData(String labelData, JSONArray contentArray, Login login, String key, FacesContext context) throws IOException, JSONException {
        if (labelData != null && labelData.length() > 0) {
            JSONObject stObject = new JSONObject();
            stObject.put("type", (Object)"label");
            stObject.put("id", (Object)(login.getClientId(context) + "_" + key + "_label"));
            stObject.put("value", (Object)labelData);
            contentArray.put((Object)stObject);
        }
    }

    private JSONObject getAlertData(FacesContext context, String type, String summaryKey, String detailKey) {
        JSONObject json = new JSONObject();
        Theme theme = ThemeUtilities.getTheme(context);
        try {
            if (type != null && type.length() > 0) {
                json.put("type", (Object)type);
            }
            if (summaryKey != null && summaryKey.length() > 0) {
                String summary = theme.getMessage(summaryKey);
                if (summary != null) {
                    json.put("summary", (Object)summary);
                } else {
                    json.put("summary", (Object)summaryKey);
                }
            }
            if (detailKey != null && detailKey.length() > 0) {
                String detail = theme.getMessage(detailKey);
                if (detail != null) {
                    json.put("detail", (Object)detail);
                } else {
                    json.put("detail", (Object)detailKey);
                }
            }
            return json;
        }
        catch (JSONException je) {
            return null;
        }
    }
}

