/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.event;

import com.sun.webui.jsf.event.EventListener;
import com.sun.webui.jsf.event.ValueEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.MethodExpression;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;

public class MethodExprEventListener
implements EventListener,
StateHolder {
    private static final Logger LOGGER = Logger.getLogger("javax.faces.event", "javax.faces.LogStrings");
    private MethodExpression methodExpression = null;
    private boolean isTransient;

    public MethodExprEventListener() {
    }

    public MethodExprEventListener(MethodExpression methodExpression) {
        this.methodExpression = methodExpression;
    }

    public void processEvent(ValueEvent valueEvent) throws AbortProcessingException {
        if (valueEvent == null) {
            throw new NullPointerException();
        }
        try {
            FacesContext context = FacesContext.getCurrentInstance();
            ELContext elContext = context.getELContext();
            this.methodExpression.invoke(elContext, new Object[]{valueEvent});
        }
        catch (ELException ee) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, "severe.event.exception_invoking_processaction", new Object[]{ee.getCause().getClass().getName(), this.methodExpression.getExpressionString(), valueEvent.getComponent().getId()});
                StringWriter writer = new StringWriter(1024);
                ee.getCause().printStackTrace(new PrintWriter(writer));
                LOGGER.severe(writer.toString());
            }
            throw new AbortProcessingException(ee.getMessage(), ee.getCause());
        }
    }

    public Object saveState(FacesContext context) {
        return new Object[]{this.methodExpression};
    }

    public void restoreState(FacesContext context, Object state) {
        this.methodExpression = (MethodExpression)((Object[])state)[0];
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public void setTransient(boolean newTransientValue) {
        this.isTransient = newTransientValue;
    }

    public MethodExpression getMethodExpression() {
        return this.methodExpression;
    }

    public boolean equals(Object otherObject) {
        if (!(otherObject instanceof MethodExprEventListener)) {
            return false;
        }
        MethodExprEventListener other = (MethodExprEventListener)otherObject;
        MethodExpression otherMe = other.getMethodExpression();
        return this.methodExpression.equals((Object)otherMe);
    }
}

