/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.codetemplates.textsync;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.lib.editor.codetemplates.textsync.TextRegion;
import org.netbeans.lib.editor.codetemplates.textsync.TextSync;
import org.netbeans.lib.editor.codetemplates.textsync.TextSyncGroup;
import org.netbeans.lib.editor.util.ArrayUtilities;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.lib.editor.util.GapList;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TextRegionManager {
    static final Logger LOG = Logger.getLogger(TextRegionManager.class.getName());
    private TextRegion<?> rootRegion;
    private List<TextSyncGroup> groups;
    private TextSync activeTextSync;
    private EditingNotify editingNotify;
    private int masterRegionStartOffset;
    private int masterRegionEndOffset;
    private int ignoreDocModifications;
    private Document doc;

    public static synchronized TextRegionManager get(Document document) {
        if (document == null) {
            throw new IllegalArgumentException("document cannot be null");
        }
        TextRegionManager textRegionManager = (TextRegionManager)document.getProperty(TextRegionManager.class);
        if (textRegionManager == null) {
            textRegionManager = new TextRegionManager(document);
            document.putProperty(TextRegionManager.class, textRegionManager);
        }
        return textRegionManager;
    }

    TextRegionManager(Document document) {
        this.doc = document;
        this.rootRegion = new TextRegion();
        this.groups = new GapList(2);
        if (document instanceof BaseDocument) {
            ((BaseDocument)document).addPostModificationDocumentListener((DocumentListener)DocListener.INSTANCE);
        }
    }

    public Collection<TextSyncGroup> textSyncGroups() {
        return Collections.unmodifiableList(this.groups);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTextSyncGroup(TextSyncGroup textSyncGroup, int n) throws BadLocationException {
        if (textSyncGroup.textRegionManager() != null) {
            throw new IllegalArgumentException("TextSyncGroup=" + textSyncGroup + " already assigned to " + textSyncGroup.textRegionManager());
        }
        TextRegion<?> textRegion = null;
        try {
            for (TextSync textSync : textSyncGroup.textSyncsModifiable()) {
                for (TextRegion<?> textRegion2 : textSync.regions()) {
                    Position position = this.doc.createPosition(textRegion2.startOffset() + n);
                    Position position2 = this.doc.createPosition(textRegion2.endOffset() + n);
                    textRegion2.setStartPos(position);
                    textRegion2.setEndPos(position2);
                    TextRegionManager.addRegion(this.rootRegion, textRegion2);
                    textRegion = textRegion2;
                }
            }
            textRegion = null;
        }
        finally {
            this.removeAddedSoFar(textSyncGroup, textRegion);
        }
        textSyncGroup.setTextRegionManager(this);
    }

    private void removeAddedSoFar(TextSyncGroup textSyncGroup, TextRegion<?> textRegion) {
        while (textRegion != null) {
            for (TextSync textSync : textSyncGroup.textSyncsModifiable()) {
                for (TextRegion<?> textRegion2 : textSync.regions()) {
                    TextRegionManager.removeRegionFromParent(textRegion2);
                    if (textRegion2 != textRegion) continue;
                    return;
                }
            }
        }
    }

    public void removeTextSyncGroup(TextSyncGroup textSyncGroup) {
        textSyncGroup.setTextRegionManager(null);
        for (TextSync textSync : textSyncGroup.textSyncsModifiable()) {
            for (TextRegion<?> textRegion : textSync.regions()) {
                TextRegionManager.removeRegionFromParent(textRegion);
            }
        }
    }

    void setActiveTextSync(TextSync textSync, EditingNotify editingNotify) {
        if (textSync.masterRegion() == null) {
            throw new IllegalArgumentException("masterRegion expected to be non-null");
        }
        this.activeTextSync = textSync;
        this.editingNotify = editingNotify;
        this.updateMasterRegionBounds();
    }

    List<TextRegion<?>> regions() {
        return this.rootRegion.regions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void insertUpdate(DocumentEvent var1_1) {
        if (this.ignoreDocModifications == 0) {
            if (this.activeTextSync != null) {
                ++this.ignoreDocModifications;
                try {
                    var2_2 = var1_1.getOffset();
                    var3_4 = var1_1.getLength();
                    var4_5 = DocumentUtilities.getModificationText((DocumentEvent)var1_1);
                    if (var4_5 == null) {
                        try {
                            var4_5 = this.doc.getText(var2_2, var3_4);
                        }
                        catch (BadLocationException var5_6) {
                            throw new IllegalStateException(var5_6);
                        }
                    }
                    var5_7 = false;
                    if (var2_2 > this.masterRegionStartOffset) {
                        if (var2_2 <= this.masterRegionEndOffset) {
                            var6_8 = this.activeTextSync.validMasterRegion();
                            var7_10 = var2_2 - var6_8.startOffset();
                            if (!TextRegionManager.$assertionsDisabled && var7_10 <= 0) {
                                throw new AssertionError();
                            }
                            this.beforeDocumentModification();
                            try {
                                for (TextRegion<?> var9_14 : this.activeTextSync.regions()) {
                                    if (var9_14 == var6_8) continue;
                                    this.doc.insertString(var9_14.startOffset() + var7_10, var4_5, null);
                                }
                            }
                            finally {
                                this.afterDocumentModification();
                            }
                            var5_7 = true;
                        }
                    } else if (var2_2 == this.masterRegionStartOffset) {
                        var6_9 = this.activeTextSync.validMasterRegion();
                        this.fixRegionStartOffset(var6_9, var2_2);
                        this.beforeDocumentModification();
                        try {
                            for (TextRegion<?> var8_13 : this.activeTextSync.regions()) {
                                if (var8_13 == var6_9) continue;
                                var9_15 = var8_13.startOffset();
                                this.doc.insertString(var9_15, var4_5, null);
                                this.fixRegionStartOffset(var8_13, var9_15);
                            }
                        }
                        finally {
                            this.afterDocumentModification();
                        }
                        var5_7 = true;
                    }
                    if (var5_7) {
                        this.editingNotify.modified(var1_1);
                    }
                    if (!DocumentUtilities.isTypingModification((Document)this.doc)) ** GOTO lbl68
                    this.outsideModified(var1_1);
                }
                catch (BadLocationException var2_3) {
                    TextRegionManager.LOG.log(Level.WARNING, "Unexpected exception during synchronization", var2_3);
                }
                finally {
                    if (!TextRegionManager.$assertionsDisabled && this.ignoreDocModifications <= 0) {
                        throw new AssertionError();
                    }
                    --this.ignoreDocModifications;
                }
            } else if (DocumentUtilities.isTypingModification((Document)this.doc)) {
                this.outsideModified(var1_1);
            }
        }
lbl68:
        // 9 sources

        this.updateMasterRegionBounds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void removeUpdate(DocumentEvent var1_1) {
        if (this.ignoreDocModifications == 0) {
            if (this.activeTextSync != null) {
                ++this.ignoreDocModifications;
                try {
                    var2_2 = var1_1.getOffset();
                    var3_3 = var1_1.getLength();
                    if (var2_2 >= this.masterRegionStartOffset && var2_2 + var3_3 <= this.masterRegionEndOffset) {
                        var4_4 = this.activeTextSync.validMasterRegion();
                        var5_5 = var2_2 - var4_4.startOffset();
                        this.beforeDocumentModification();
                        try {
                            for (TextRegion<?> var7_8 : this.activeTextSync.regions()) {
                                if (var7_8 == var4_4) continue;
                                this.doc.remove(var7_8.startOffset() + var5_5, var3_3);
                            }
                            this.editingNotify.modified(var1_1);
                        }
                        catch (BadLocationException var6_7) {
                            this.outsideModified(var1_1);
                            TextRegionManager.LOG.log(Level.WARNING, "Unexpected exception during synchronization", var6_7);
                        }
                        finally {
                            this.afterDocumentModification();
                        }
                    }
                    if (!DocumentUtilities.isTypingModification((Document)this.doc)) ** GOTO lbl35
                    this.outsideModified(var1_1);
                }
                finally {
                    if (!TextRegionManager.$assertionsDisabled && this.ignoreDocModifications <= 0) {
                        throw new AssertionError();
                    }
                    --this.ignoreDocModifications;
                }
            } else if (DocumentUtilities.isTypingModification((Document)this.doc)) {
                this.outsideModified(var1_1);
            }
        }
lbl35:
        // 9 sources

        this.updateMasterRegionBounds();
    }

    private void beforeDocumentModification() {
        this.doc.putProperty("abbrev-ignore-modification", Boolean.TRUE);
    }

    private void afterDocumentModification() {
        this.doc.putProperty("abbrev-ignore-modification", Boolean.FALSE);
    }

    private void outsideModified(DocumentEvent documentEvent) {
        EditingNotify editingNotify = this.editingNotify;
        this.clearActiveTextSync();
        if (editingNotify != null) {
            editingNotify.outsideModified(documentEvent);
        }
    }

    void clearActiveTextSync() {
        this.activeTextSync = null;
        this.editingNotify = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void syncByMaster(TextSync textSync) {
        this.beforeDocumentModification();
        ++this.ignoreDocModifications;
        try {
            TextRegion textRegion = textSync.validMasterRegion();
            CharSequence charSequence = DocumentUtilities.getText((Document)this.doc);
            CharSequence charSequence2 = charSequence.subSequence(textRegion.startOffset(), textRegion.endOffset());
            String string = null;
            for (TextRegion<?> textRegion2 : textSync.regionsModifiable()) {
                int n;
                int n2;
                CharSequence charSequence3;
                if (textRegion2 == textRegion || CharSequenceUtilities.textEquals((CharSequence)charSequence2, (CharSequence)(charSequence3 = charSequence.subSequence(n2 = textRegion2.startOffset(), n = textRegion2.endOffset())))) continue;
                if (string == null) {
                    string = ((Object)charSequence2).toString();
                }
                this.doc.remove(n2, n - n2);
                this.doc.insertString(n2, string, null);
                this.fixRegionStartOffset(textRegion2, n2);
            }
        }
        catch (BadLocationException badLocationException) {
            LOG.log(Level.WARNING, "Invalid offset", badLocationException);
        }
        finally {
            assert (this.ignoreDocModifications > 0);
            --this.ignoreDocModifications;
            this.afterDocumentModification();
        }
        this.updateMasterRegionBounds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setText(TextSync textSync, String string) {
        this.beforeDocumentModification();
        ++this.ignoreDocModifications;
        try {
            CharSequence charSequence = DocumentUtilities.getText((Document)this.doc);
            for (TextRegion<?> textRegion : textSync.regionsModifiable()) {
                int n;
                int n2 = textRegion.startOffset();
                CharSequence charSequence2 = charSequence.subSequence(n2, n = textRegion.endOffset());
                if (CharSequenceUtilities.textEquals((CharSequence)string, (CharSequence)charSequence2)) continue;
                this.doc.remove(n2, n - n2);
                this.doc.insertString(n2, string, null);
                this.fixRegionStartOffset(textRegion, n2);
            }
        }
        catch (BadLocationException badLocationException) {
            LOG.log(Level.WARNING, "Invalid offset", badLocationException);
        }
        finally {
            assert (this.ignoreDocModifications > 0);
            --this.ignoreDocModifications;
            this.afterDocumentModification();
        }
        this.updateMasterRegionBounds();
    }

    private void fixRegionStartOffset(TextRegion<?> textRegion, int n) throws BadLocationException {
        Position position = this.doc.createPosition(n);
        textRegion.setStartPos(position);
        TextRegion<?> textRegion2 = textRegion.parent();
        List<TextRegion<?>> list = textRegion2.regions();
        int n2 = TextRegionManager.findRegionIndex(list, textRegion) - 1;
        while (n2 >= 0 && (textRegion = list.get(n2)).endOffset() > n) {
            textRegion.setEndPos(position);
            if (textRegion.startOffset() <= n) break;
            textRegion.setStartPos(position);
        }
        if (n2 < 0 && !this.isRoot(textRegion2) && textRegion2.startOffset() > n) {
            textRegion2.setStartPos(position);
            this.fixRegionStartOffset(textRegion2, n);
        }
    }

    private boolean isRoot(TextRegion textRegion) {
        return textRegion == this.rootRegion;
    }

    private void updateMasterRegionBounds() {
        if (this.activeTextSync != null) {
            this.masterRegionStartOffset = this.activeTextSync.masterRegion().startOffset();
            this.masterRegionEndOffset = this.activeTextSync.masterRegion().endOffset();
        }
    }

    static int findRegionInsertIndex(List<TextRegion<?>> list, int n) {
        int n2 = 0;
        int n3 = list.size() - 1;
        while (n2 <= n3) {
            int n4 = (n2 + n3) / 2;
            TextRegion<?> textRegion = list.get(n4);
            int n5 = textRegion.startOffset();
            if (n5 < n) {
                n2 = n4 + 1;
                continue;
            }
            if (n5 > n) {
                n3 = n4 - 1;
                continue;
            }
            for (n2 = n4 + 1; n2 < list.size() && list.get(n2).startOffset() == n; ++n2) {
            }
        }
        return n2;
    }

    static int findRegionIndex(List<TextRegion<?>> list, TextRegion<?> textRegion) {
        int n = 0;
        int n2 = list.size() - 1;
        int n3 = textRegion.startOffset();
        while (n <= n2) {
            int n4 = (n + n2) / 2;
            TextRegion<?> textRegion2 = list.get(n4);
            int n5 = textRegion2.startOffset();
            if (n5 < n3) {
                n = n4 + 1;
                continue;
            }
            if (n5 > n3) {
                n2 = n4 - 1;
                continue;
            }
            if (textRegion2 == textRegion) {
                return n4;
            }
            for (n = n4 - 1; n >= 0; --n) {
                textRegion2 = list.get(n);
                if (textRegion2 == textRegion) {
                    return n;
                }
                if (textRegion2.startOffset() != n3) break;
            }
            for (n = n4 + 1; n < list.size(); ++n) {
                textRegion2 = list.get(n);
                if (textRegion2 == textRegion) {
                    return n;
                }
                if (textRegion2.startOffset() == n3) continue;
                throw new IllegalStateException("Region: " + textRegion + " not found.");
            }
        }
        throw new IllegalStateException("Region: " + textRegion + " not found.");
    }

    static void addRegion(TextRegion<?> textRegion, TextRegion<?> textRegion2) {
        Object object;
        int n;
        int n2;
        if (textRegion2.parent() != null) {
            throw new IllegalArgumentException("Region:" + textRegion2 + " already added.");
        }
        List<TextRegion<?>> list = textRegion.validRegions();
        int n3 = textRegion2.startOffset();
        int n4 = textRegion2.endOffset();
        for (n2 = n = TextRegionManager.findRegionInsertIndex(list, n3); n2 < list.size(); ++n2) {
            object = list.get(n2);
            if (n4 >= object.endOffset()) continue;
            if (n4 <= object.startOffset()) break;
            throw new IllegalArgumentException("Inserted region " + textRegion2 + " overlaps with region " + object + " at index=" + n2);
        }
        while (n > 0) {
            int n5;
            object = list.get(n - 1);
            if (n3 == object.startOffset()) {
                n5 = object.endOffset();
                if (n4 < n5) {
                    if (n3 != n4) {
                        TextRegionManager.addRegion(object, textRegion2);
                        return;
                    }
                    n2 = --n;
                    break;
                }
            } else {
                n5 = object.endOffset();
                if (n3 >= n5) break;
                if (n4 <= n5) {
                    TextRegionManager.addRegion(object, textRegion2);
                    return;
                }
                throw new IllegalArgumentException("Inserted region " + textRegion2 + " overlaps with region " + object + " at index=" + (n - 1));
            }
            --n;
        }
        if (n2 - n > 0) {
            object = (GapList)list;
            Object[] objectArray = new TextRegion[n2 - n];
            object.copyElements(n, n2, objectArray, 0);
            object.remove(n, objectArray.length);
            textRegion2.initRegions((TextRegion<?>[])objectArray);
            for (Object object2 : objectArray) {
                ((TextRegion)object2).setParent(textRegion2);
            }
        }
        list.add(n, textRegion2);
        textRegion2.setParent(textRegion);
    }

    static void removeRegionFromParent(TextRegion<?> textRegion) {
        TextRegion<?> textRegion2 = textRegion.parent();
        List<TextRegion<?>> list = textRegion2.regions();
        int n = TextRegionManager.findRegionIndex(list, textRegion);
        list.remove(n);
        textRegion.setParent(null);
        List<TextRegion<?>> list2 = textRegion.regions();
        if (list2 != null) {
            for (TextRegion<?> textRegion3 : list2) {
                list.add(n++, textRegion3);
                textRegion3.setParent(textRegion2);
            }
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("Managed regions:\n");
        this.dumpRegions(stringBuilder, this.rootRegion.regions(), 4);
        if (this.activeTextSync != null) {
            stringBuilder.append("  Active textSync: ").append(this.activeTextSync);
        }
        return stringBuilder.toString();
    }

    private void dumpRegions(StringBuilder stringBuilder, List<TextRegion<?>> list, int n) {
        if (list == null) {
            return;
        }
        for (TextRegion<?> textRegion : list) {
            ArrayUtilities.appendSpaces((StringBuilder)stringBuilder, (int)n);
            stringBuilder.append(textRegion).append('\n');
            this.dumpRegions(stringBuilder, textRegion.regions(), n + 4);
        }
    }

    private static final class DocListener
    implements DocumentListener {
        static final DocListener INSTANCE = new DocListener();

        private DocListener() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            TextRegionManager.get(documentEvent.getDocument()).insertUpdate(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            TextRegionManager.get(documentEvent.getDocument()).removeUpdate(documentEvent);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }
    }

    static interface EditingNotify {
        public void modified(DocumentEvent var1);

        public void outsideModified(DocumentEvent var1);
    }
}

