/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.callgraph.impl;

import java.awt.Image;
import java.util.ArrayList;
import javax.swing.Action;
import org.netbeans.modules.cnd.callgraph.api.Call;
import org.netbeans.modules.cnd.callgraph.impl.CallChildren;
import org.netbeans.modules.cnd.callgraph.impl.CallGraphState;
import org.netbeans.modules.cnd.callgraph.impl.GoToReferenceAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class CallNode
extends AbstractNode {
    private Call object;
    private CallGraphState model;
    private boolean isCalls;
    static Image downBadge = Utilities.loadImage((String)"org/netbeans/modules/cnd/callgraph/resources/down_20.png");
    private static Image upBadge = Utilities.loadImage((String)"org/netbeans/modules/cnd/callgraph/resources/up_8.png");
    private static Image emptyBadge = Utilities.loadImage((String)"org/netbeans/modules/cnd/callgraph/resources/empty_20.png");

    public CallNode(Call call, CallGraphState callGraphState, boolean bl) {
        super((Children)new CallChildren(call, callGraphState, bl));
        this.object = call;
        this.model = callGraphState;
        this.isCalls = bl;
        if (bl) {
            this.setName(call.getCallee().getName());
        } else {
            this.setName(call.getCaller().getName());
        }
        ((CallChildren)this.getChildren()).setParent((Node)this);
        callGraphState.addCallToScene(call);
    }

    public String getHtmlDisplayName() {
        String string = this.isCalls ? this.object.getCallee().getHtmlDisplayName() : this.object.getCaller().getHtmlDisplayName();
        if (((CallChildren)this.getChildren()).isRecusion()) {
            return string + NbBundle.getMessage(CallNode.class, (String)"CTL_Recuesion");
        }
        return string;
    }

    public Image getIcon(int n) {
        Image image = null;
        image = this.isCalls ? this.object.getCallee().getIcon() : this.object.getCaller().getIcon();
        if (image == null) {
            image = super.getIcon(n);
        }
        return this.mergeBadge(image);
    }

    private Image mergeBadge(Image image) {
        if (this.isCalls) {
            return Utilities.mergeImages((Image)image, (Image)downBadge, (int)0, (int)0);
        }
        Image image2 = Utilities.mergeImages((Image)emptyBadge, (Image)image, (int)4, (int)0);
        return Utilities.mergeImages((Image)image2, (Image)upBadge, (int)0, (int)0);
    }

    Call getCall() {
        return this.object;
    }

    public Image getOpenedIcon(int n) {
        return this.getIcon(n);
    }

    public Action getPreferredAction() {
        return new GoToReferenceAction(this.object);
    }

    public Action[] getActions(boolean bl) {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        Action action = this.getPreferredAction();
        if (action != null) {
            arrayList.add(action);
            arrayList.add(new GoToReferenceAction(this.object.getCaller(), 1));
            arrayList.add(new GoToReferenceAction(this.object.getCallee(), 2));
            arrayList.add(null);
        }
        for (Action action2 : this.model.getActions()) {
            arrayList.add(action2);
        }
        return arrayList.toArray(new Action[arrayList.size()]);
    }
}

