/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.propertyeditors;

import com.sun.rave.designtime.DesignBean;
import com.sun.rave.designtime.DesignContext;
import com.sun.rave.designtime.DesignProject;
import com.sun.rave.designtime.DesignProperty;
import com.sun.rave.designtime.faces.FacesDesignProject;
import com.sun.rave.designtime.markup.MarkupDesignBean;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.WeakHashMap;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.modules.visualweb.propertyeditors.PropertyPanelBase;
import org.netbeans.modules.visualweb.propertyeditors.UrlFileFilter;
import org.netbeans.modules.visualweb.propertyeditors.UrlPropertyEditor;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.w3c.dom.Element;

public class UrlPropertyPanel
extends PropertyPanelBase {
    protected static ResourceBundle resourceBundle = ResourceBundle.getBundle("org.netbeans.modules.visualweb.propertyeditors.Bundle");
    protected static WeakHashMap directoryMap = new WeakHashMap();
    static FileFilter defaultFileFilter = new FileFilter(){

        public boolean accept(File file) {
            String string = file.getName();
            if (string == null) {
                return false;
            }
            if (file.isDirectory() && string.equals("WEB-INF")) {
                return false;
            }
            return !string.endsWith(".jspf") && !string.endsWith("~");
        }
    };
    UrlPropertyEditor editor;
    DesignContext designContext;
    ResourceNode rootTreeNode;
    DefaultTreeModel treeModel;
    private JButton addButton;
    private ButtonGroup radioButtonGroup;
    private JScrollPane resourceScrollPane;
    private JTree resourceTree;
    private JComboBox urlComboBox;
    private JLabel urlLabel;
    private JPanel urlPanel;

    public UrlPropertyPanel(UrlPropertyEditor urlPropertyEditor) {
        super(urlPropertyEditor);
        Object object;
        this.editor = urlPropertyEditor;
        DesignBean designBean = urlPropertyEditor.getDesignProperty().getDesignBean();
        DesignProperty designProperty = urlPropertyEditor.getDesignProperty();
        this.designContext = designBean.getDesignContext();
        this.rootTreeNode = this.generateTargetTree(this.designContext);
        this.treeModel = new DefaultTreeModel(this.rootTreeNode);
        this.initComponents();
        for (int i = 0; i < this.rootTreeNode.getChildCount(); ++i) {
            object = this.rootTreeNode.getChildAt(i);
            this.resourceTree.expandPath(new TreePath(this.treeModel.getPathToRoot((TreeNode)object)));
        }
        DesignBean[] designBeanArray = this.designContext.getBeansOfType(designBean.getInstance().getClass());
        if (designProperty.getPropertyDescriptor() != null && designBeanArray != null && designBeanArray.length > 0) {
            object = designProperty.getPropertyDescriptor().getName();
            for (int i = 0; i < designBeanArray.length; ++i) {
                String string = (String)designBeanArray[i].getProperty((String)object).getValue();
                if (string == null) continue;
                this.urlComboBox.addItem(string);
            }
        }
        if (urlPropertyEditor.getValue() != null) {
            object = UrlPropertyEditor.decodeUrl(urlPropertyEditor.getValue().toString());
            this.urlComboBox.setSelectedItem(object);
            if (((String)object).indexOf(":") < 0) {
                TreePath treePath = this.urlToTreePath((String)object, this.rootTreeNode);
                this.resourceTree.makeVisible(treePath);
                this.resourceTree.setSelectionPath(treePath);
            }
        } else {
            this.urlComboBox.setSelectedItem("");
        }
    }

    public Object getPropertyValue() throws IllegalArgumentException {
        return UrlPropertyEditor.encodeUrl((String)this.urlComboBox.getSelectedItem());
    }

    protected File getLastDirectory() {
        DesignProject designProject = this.editor.getDesignProperty().getDesignBean().getDesignContext().getProject();
        return (File)directoryMap.get(designProject);
    }

    protected void setLastDirectory(File file) {
        DesignProject designProject = this.editor.getDesignProperty().getDesignBean().getDesignContext().getProject();
        directoryMap.put(designProject, file);
    }

    private void initComponents() {
        this.radioButtonGroup = new ButtonGroup();
        this.resourceScrollPane = new JScrollPane();
        this.resourceTree = new JTree(this.treeModel);
        this.addButton = new JButton();
        this.urlPanel = new JPanel();
        this.urlLabel = new JLabel();
        this.urlComboBox = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.resourceScrollPane.setMinimumSize(new Dimension(120, 80));
        this.resourceTree.setCellRenderer(new NodeRenderer());
        this.resourceTree.setMinimumSize(new Dimension(120, 80));
        this.resourceTree.setRootVisible(false);
        this.resourceTree.setShowsRootHandles(true);
        this.resourceTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                UrlPropertyPanel.this.treeValueChanged(treeSelectionEvent);
            }
        });
        this.resourceScrollPane.setViewportView(this.resourceTree);
        this.resourceTree.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org.netbeans.modules.visualweb.propertyeditors.Bundle").getString("UrlPropertyPanel.resourceTree.AccessibleName"));
        this.resourceTree.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org.netbeans.modules.visualweb.propertyeditors.Bundle").getString("UrlPropertyPanel.resourceTree.AccessibleDescription"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(11, 12, 11, 11);
        this.add((Component)this.resourceScrollPane, gridBagConstraints);
        this.addButton.setMnemonic(ResourceBundle.getBundle("org.netbeans.modules.visualweb.propertyeditors.Bundle").getString("UrlPropertyPanel.add.label.mnemonic").charAt(0));
        this.addButton.setText(ResourceBundle.getBundle("org.netbeans.modules.visualweb.propertyeditors.Bundle").getString("UrlPropertyPanel.add.label"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UrlPropertyPanel.this.addButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(11, 0, 0, 7);
        this.add((Component)this.addButton, gridBagConstraints);
        this.urlPanel.setLayout(new GridBagLayout());
        this.urlLabel.setText(ResourceBundle.getBundle("org.netbeans.modules.visualweb.propertyeditors.Bundle").getString("UrlPropertyPanel.url.label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 16;
        this.urlPanel.add((Component)this.urlLabel, gridBagConstraints);
        this.urlComboBox.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.urlPanel.add((Component)this.urlComboBox, gridBagConstraints);
        this.urlComboBox.getAccessibleContext().setAccessibleName("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(7, 11, 0, 7);
        this.add((Component)this.urlPanel, gridBagConstraints);
    }

    private void treeValueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
        if (treePath != null) {
            ResourceNode resourceNode = (ResourceNode)treePath.getPathComponent(treePath.getPathCount() - 1);
            if (resourceNode instanceof FileNode && !((FileNode)resourceNode).getFile().isDirectory()) {
                this.urlComboBox.setSelectedItem(resourceNode.getUrlPathString());
            } else if (resourceNode instanceof TargetNode) {
                this.urlComboBox.setSelectedItem(resourceNode.getUrlPathString());
            }
        }
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        String string;
        File file;
        JFileChooser jFileChooser = new JFileChooser();
        UrlFileFilter urlFileFilter = this.editor.getFileFilter();
        if (urlFileFilter != null) {
            jFileChooser.addChoosableFileFilter(urlFileFilter);
        }
        if ((file = this.getLastDirectory()) != null) {
            jFileChooser.setCurrentDirectory(file);
        }
        if (jFileChooser.showDialog(this, string = resourceBundle.getString("UrlPropertyPanel.add.label")) == 0) {
            File file2 = jFileChooser.getSelectedFile();
            if (file2 == null || !file2.exists()) {
                return;
            }
            try {
                Object object;
                DesignProject designProject = this.designContext.getProject();
                designProject.addResource(file2.toURI().toURL(), new URI("web/resources/" + UrlPropertyEditor.encodeUrl(file2.getName())));
                String string2 = "/resources/" + file2.getName();
                ResourceNode resourceNode = this.getNode("/resources", this.rootTreeNode);
                if (resourceNode == null) {
                    object = ((FileNode)this.rootTreeNode).getFile();
                    resourceNode = new FileNode(this.rootTreeNode, new File((File)object, "/resources"));
                    this.rootTreeNode.add(resourceNode);
                }
                object = new FileNode(resourceNode, file2);
                this.treeModel.insertNodeInto((MutableTreeNode)object, resourceNode, resourceNode.getChildCount());
                this.resourceTree.setSelectionPath(this.urlToTreePath(string2, this.rootTreeNode));
                this.urlComboBox.setSelectedItem(string2);
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (URISyntaxException uRISyntaxException) {
                uRISyntaxException.printStackTrace();
            }
        }
        this.setLastDirectory(jFileChooser.getCurrentDirectory());
    }

    protected TreePath urlToTreePath(String string, TreeNode treeNode) {
        ResourceNode resourceNode = this.getNode(string, treeNode);
        if (resourceNode == null) {
            return new TreePath(new TreeNode[]{treeNode});
        }
        ArrayList<ResourceNode> arrayList = new ArrayList<ResourceNode>();
        while (resourceNode != null) {
            arrayList.add(0, resourceNode);
            resourceNode = (ResourceNode)resourceNode.getParent();
        }
        return new TreePath(arrayList.toArray());
    }

    protected ResourceNode getNode(String string, TreeNode treeNode) {
        Stack<TreeNode> stack = new Stack<TreeNode>();
        stack.push(treeNode);
        ResourceNode resourceNode = null;
        while (!stack.isEmpty() && resourceNode == null) {
            ResourceNode resourceNode2 = (ResourceNode)stack.pop();
            if (string.equals(resourceNode2.getUrlPathString())) {
                resourceNode = resourceNode2;
            }
            if (resourceNode2.getChildCount() <= 0) continue;
            stack.addAll(Collections.list(resourceNode2.children()));
        }
        return resourceNode;
    }

    ResourceNode generateTargetTree(DesignContext designContext) {
        Object object;
        Object object2;
        Stack<FileNode> stack;
        Object object3;
        Object object4;
        DesignBean designBean;
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>(16);
        DesignContext[] designContextArray = designContext.getProject().getDesignContexts();
        for (int i = 0; i < designContextArray.length; ++i) {
            designBean = designContextArray[i].getRootContainer();
            if (designBean == null || !(designBean.getInstance() instanceof UIViewRoot)) continue;
            object4 = new PageNode(null, designBean);
            object3 = designContextArray[i].getBeans();
            for (int j = 0; j < ((DesignBean[])object3).length; ++j) {
                stack = object3[j].getInstance();
                if (!UIComponent.class.isAssignableFrom(stack.getClass()) || !this.editor.isTargetComponent((UIComponent)stack)) continue;
                ComponentTargetNode componentTargetNode = new ComponentTargetNode((MutableTreeNode)object4, object3[j]);
                ((ResourceNode)object4).add(componentTargetNode);
            }
            if (designBean.getChildBeanCount() > 0 && designBean.getChildBeans()[0] instanceof MarkupDesignBean) {
                Element element = ((MarkupDesignBean)designBean.getChildBeans()[0]).getElement();
                stack = element.getElementsByTagName("a");
                for (int j = 0; j < stack.getLength(); ++j) {
                    object2 = (Element)stack.item(j);
                    if (!object2.hasAttribute("name")) continue;
                    ElementTargetNode elementTargetNode = new ElementTargetNode((MutableTreeNode)object4, (Element)object2);
                    ((ResourceNode)object4).add(elementTargetNode);
                }
            }
            try {
                object = new File(designContextArray[i].resolveResource(".").toURI());
                stack = new File((File)object, designBean.getInstanceName() + ".jsp");
                hashMap.put(stack, object4);
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                ErrorManager.getDefault().notify(1, (Throwable)uRISyntaxException);
            }
        }
        FileNode fileNode = new FileNode();
        try {
            designBean = this.designContext.getProject();
            object4 = designBean.getResourceFile(new URI("web"));
            object3 = defaultFileFilter;
            object = this.editor.getFileFilter();
            if (object != null) {
                object3 = ((UrlFileFilter)object).getIOFileFilter();
            }
            fileNode.setFile((File)object4);
            stack = new Stack<FileNode>();
            stack.push(fileNode);
            while (!stack.isEmpty()) {
                FileNode fileNode2 = (FileNode)stack.pop();
                object4 = fileNode2.getFile();
                if (!((File)object4).isDirectory()) continue;
                object2 = ((File)object4).listFiles((FileFilter)object3);
                for (int i = 0; i < ((File[])object2).length; ++i) {
                    FileNode fileNode3;
                    Object object5 = object2[i];
                    if (hashMap.containsKey(object5)) {
                        fileNode3 = (PageNode)hashMap.get(object5);
                        fileNode3.setParent(fileNode2);
                        fileNode3.setFile((File)object5);
                        fileNode2.add(fileNode3);
                        continue;
                    }
                    fileNode3 = new FileNode(fileNode2, (File)object5);
                    fileNode2.add(fileNode3);
                    stack.push(fileNode3);
                }
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return fileNode;
    }

    private DesignContext[] getDesignContexts(DesignBean designBean) {
        DesignProject designProject = designBean.getDesignContext().getProject();
        DesignContext[] designContextArray = designProject instanceof FacesDesignProject ? ((FacesDesignProject)designProject).findDesignContexts(new String[]{"request", "session", "application"}) : new DesignContext[]{};
        DesignContext[] designContextArray2 = new DesignContext[designContextArray.length + 1];
        designContextArray2[0] = designBean.getDesignContext();
        System.arraycopy(designContextArray, 0, designContextArray2, 1, designContextArray.length);
        return designContextArray2;
    }

    static class NodeRenderer
    extends DefaultTreeCellRenderer {
        NodeRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (object instanceof ComponentTargetNode) {
                this.setIcon(new ImageIcon(((ComponentTargetNode)object).getComponentDesignBean().getBeanInfo().getIcon(1)));
            } else if (object instanceof FileNode) {
                try {
                    FileObject fileObject = FileUtil.toFileObject((File)((FileNode)object).getFile());
                    Image image = DataObject.find((FileObject)fileObject).getNodeDelegate().getIcon(1);
                    this.setIcon(new ImageIcon(image));
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    // empty catch block
                }
            }
            return this;
        }
    }

    static class ComponentTargetNode
    extends TargetNode {
        DesignBean componentBean;

        ComponentTargetNode(MutableTreeNode mutableTreeNode, DesignBean designBean) {
            super(mutableTreeNode);
            this.componentBean = designBean;
            super.setUrlString(((UIComponent)designBean.getInstance()).getId());
        }

        DesignBean getComponentDesignBean() {
            return this.componentBean;
        }

        public String toString() {
            return this.componentBean.getInstanceName();
        }
    }

    static class ElementTargetNode
    extends TargetNode {
        Element element;

        ElementTargetNode(MutableTreeNode mutableTreeNode, Element element) {
            super(mutableTreeNode);
            this.element = element;
            super.setUrlString(element.getAttribute("name"));
        }

        Element getElement() {
            return this.element;
        }

        public String toString() {
            return this.element.getAttribute("name");
        }
    }

    static abstract class TargetNode
    extends ResourceNode {
        TargetNode(MutableTreeNode mutableTreeNode) {
            super(mutableTreeNode);
        }

        char getPathSepChar() {
            return '#';
        }
    }

    static class PageNode
    extends FileNode {
        DesignBean pageBean;

        PageNode(MutableTreeNode mutableTreeNode, DesignBean designBean) {
            super(mutableTreeNode);
            this.pageBean = designBean;
            super.setUrlString(designBean.getInstanceName() + ".jsp");
        }

        public String toString() {
            return this.pageBean.getInstanceName();
        }

        String getUrlPathString() {
            return "/faces" + super.getUrlPathString();
        }
    }

    static class FileNode
    extends ResourceNode {
        String suffix;
        private File file;

        FileNode() {
        }

        FileNode(MutableTreeNode mutableTreeNode) {
            super(mutableTreeNode);
        }

        FileNode(MutableTreeNode mutableTreeNode, File file) {
            super(mutableTreeNode);
            this.setFile(file);
            super.setUrlString(file.getName());
        }

        File getFile() {
            return this.file;
        }

        void setFile(File file) {
            this.file = file;
            String string = this.file.getName();
            if (!file.isDirectory()) {
                int n = string.lastIndexOf(46);
                this.suffix = null;
                if (n >= 0) {
                    this.suffix = string.substring(n + 1);
                }
            }
        }

        String getSuffix() {
            return this.suffix;
        }

        public String toString() {
            return this.file.getName();
        }
    }

    static class ResourceNode
    implements MutableTreeNode {
        ArrayList children = new ArrayList();
        MutableTreeNode parentNode;
        private String urlString;

        ResourceNode() {
        }

        ResourceNode(MutableTreeNode mutableTreeNode) {
            this.parentNode = mutableTreeNode;
        }

        public TreeNode getChildAt(int n) {
            return (TreeNode)this.children.get(n);
        }

        void add(MutableTreeNode mutableTreeNode) {
            this.children.add(mutableTreeNode);
        }

        public void insert(MutableTreeNode mutableTreeNode, int n) {
            this.children.add(n, mutableTreeNode);
        }

        void clear() {
            this.children.clear();
        }

        public int getIndex(TreeNode treeNode) {
            return this.children.indexOf(treeNode);
        }

        public boolean isLeaf() {
            return this.getChildCount() == 0;
        }

        public TreeNode getParent() {
            return this.parentNode;
        }

        public void setParent(MutableTreeNode mutableTreeNode) {
            this.parentNode = mutableTreeNode;
        }

        public int getChildCount() {
            return this.children.size();
        }

        public boolean getAllowsChildren() {
            return true;
        }

        public Enumeration children() {
            return Collections.enumeration(this.children);
        }

        char getPathSepChar() {
            return '/';
        }

        public String toString() {
            return null;
        }

        String getUrlString() {
            return this.urlString;
        }

        void setUrlString(String string) {
            this.urlString = string;
        }

        String getUrlPathString() {
            if (this.getUrlString() == null) {
                return null;
            }
            if (this.getParent() == null) {
                return this.getPathSepChar() + this.getUrlString();
            }
            String string = ((ResourceNode)this.getParent()).getUrlPathString();
            if (string == null) {
                return this.getPathSepChar() + this.getUrlString();
            }
            return string + this.getPathSepChar() + this.getUrlString();
        }

        public void remove(MutableTreeNode mutableTreeNode) {
            this.children.remove(mutableTreeNode);
        }

        public void remove(int n) {
            this.children.remove(n);
        }

        public void removeFromParent() {
            this.parentNode = null;
        }

        public void setUserObject(Object object) {
        }
    }
}

