/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.flow;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import org.netbeans.api.visual.vmd.VMDMinimizeAbility;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.vmd.api.flow.visual.FlowScene;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.DesignDocumentAwareness;
import org.netbeans.modules.vmd.api.io.IOUtils;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.flow.FlowAccessController;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class FlowViewController
implements DesignDocumentAwareness {
    public static final String FLOW_ID = "flow";
    private JComponent loadingPanel = IOUtils.createLoadingPanel();
    private JPanel visual = new JPanel(new BorderLayout()){

        public void requestFocus() {
            super.requestFocus();
            if (FlowViewController.this.view != null) {
                FlowViewController.this.view.requestFocus();
            }
        }

        public boolean requestFocusInWindow() {
            if (FlowViewController.this.view != null) {
                super.requestFocusInWindow();
                return FlowViewController.this.view.requestFocusInWindow();
            }
            return super.requestFocusInWindow();
        }
    };
    private JToolBar toolbar;
    private JButton overviewButton;
    private DesignDocument designDocument;
    private JComponent view;

    public FlowViewController(DataObjectContext dataObjectContext) {
        this.visual.putClientProperty("print.printable", Boolean.TRUE);
        this.toolbar = new JToolBar();
        this.toolbar.setFloatable(false);
        this.toolbar.setRollover(true);
        this.toolbar.setPreferredSize(new Dimension(14, 14));
        this.toolbar.setSize(new Dimension(14, 14));
        JToolBar.Separator separator = new JToolBar.Separator();
        separator.setOrientation(1);
        this.toolbar.add(separator);
        this.addToolbarButton("layout", NbBundle.getMessage(FlowViewController.class, (String)"TTIP_Layout"), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FlowViewController.this.layout();
            }
        });
        this.overviewButton = this.addToolbarButton("overview", NbBundle.getMessage(FlowViewController.class, (String)"TTIP_Overview"), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FlowViewController.this.overview();
            }
        });
        this.addToolbarButton("collapse-all", NbBundle.getMessage(FlowViewController.class, (String)"TTIP_CollapseAll"), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FlowViewController.this.collapseAll();
            }
        });
        this.addToolbarButton("expand-all", NbBundle.getMessage(FlowViewController.class, (String)"TTIP_ExpandAll"), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FlowViewController.this.expandAll();
            }
        });
        dataObjectContext.addDesignDocumentAwareness((DesignDocumentAwareness)this);
    }

    private JButton addToolbarButton(String string, String string2, ActionListener actionListener) {
        JButton jButton = new JButton(new ImageIcon(Utilities.loadImage((String)("org/netbeans/modules/vmd/flow/resources/" + string + ".png"))));
        jButton.setOpaque(false);
        jButton.setToolTipText(string2);
        jButton.setBorderPainted(false);
        jButton.setRolloverEnabled(true);
        jButton.setSize(14, 14);
        jButton.addActionListener(actionListener);
        this.toolbar.add(jButton);
        return jButton;
    }

    private void layout() {
        IOUtils.runInAWTNoBlocking((Runnable)new Runnable(){

            public void run() {
                FlowAccessController flowAccessController;
                FlowAccessController flowAccessController2 = flowAccessController = FlowViewController.this.designDocument != null ? (FlowAccessController)FlowViewController.this.designDocument.getListenerManager().getAccessController(FlowAccessController.class) : null;
                if (flowAccessController == null) {
                    return;
                }
                FlowScene flowScene = flowAccessController.getScene();
                flowScene.layoutScene();
                flowScene.validate();
            }
        });
    }

    private void overview() {
        FlowAccessController flowAccessController;
        DesignDocument designDocument = this.designDocument;
        FlowAccessController flowAccessController2 = flowAccessController = designDocument != null ? (FlowAccessController)designDocument.getListenerManager().getAccessController(FlowAccessController.class) : null;
        if (flowAccessController == null) {
            return;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.setLayout(new BorderLayout());
        JComponent jComponent = flowAccessController.createSatelliteView();
        jPopupMenu.add((Component)jComponent, "Center");
        jPopupMenu.show(this.overviewButton, (this.overviewButton.getSize().width - jComponent.getPreferredSize().width) / 2, this.overviewButton.getSize().height);
    }

    private void collapseAll() {
        IOUtils.runInAWTNoBlocking((Runnable)new Runnable(){

            public void run() {
                FlowAccessController flowAccessController;
                FlowAccessController flowAccessController2 = flowAccessController = FlowViewController.this.designDocument != null ? (FlowAccessController)FlowViewController.this.designDocument.getListenerManager().getAccessController(FlowAccessController.class) : null;
                if (flowAccessController == null) {
                    return;
                }
                FlowScene flowScene = flowAccessController.getScene();
                for (Object e : flowScene.getObjects()) {
                    Widget widget = flowScene.findWidget(e);
                    if (!(widget instanceof VMDMinimizeAbility)) continue;
                    ((VMDMinimizeAbility)widget).collapseWidget();
                }
            }
        });
    }

    private void expandAll() {
        IOUtils.runInAWTNoBlocking((Runnable)new Runnable(){

            public void run() {
                FlowAccessController flowAccessController;
                FlowAccessController flowAccessController2 = flowAccessController = FlowViewController.this.designDocument != null ? (FlowAccessController)FlowViewController.this.designDocument.getListenerManager().getAccessController(FlowAccessController.class) : null;
                if (flowAccessController == null) {
                    return;
                }
                FlowScene flowScene = flowAccessController.getScene();
                for (Object e : flowScene.getObjects()) {
                    Widget widget = flowScene.findWidget(e);
                    if (!(widget instanceof VMDMinimizeAbility)) continue;
                    ((VMDMinimizeAbility)widget).expandWidget();
                }
            }
        });
    }

    public JComponent getVisualRepresentation() {
        return this.visual;
    }

    public JComponent getToolbarRepresentation() {
        return this.toolbar;
    }

    public void setDesignDocument(final DesignDocument designDocument) {
        IOUtils.runInAWTNoBlocking((Runnable)new Runnable(){

            public void run() {
                FlowViewController.this.designDocument = designDocument;
                FlowAccessController flowAccessController = FlowViewController.this.designDocument != null ? (FlowAccessController)FlowViewController.this.designDocument.getListenerManager().getAccessController(FlowAccessController.class) : null;
                FlowViewController.this.view = flowAccessController != null ? flowAccessController.getCreateView() : null;
                FlowViewController.this.visual.removeAll();
                if (FlowViewController.this.view != null) {
                    JScrollPane jScrollPane = new JScrollPane(FlowViewController.this.view);
                    jScrollPane.getHorizontalScrollBar().setUnitIncrement(64);
                    jScrollPane.getHorizontalScrollBar().setBlockIncrement(256);
                    jScrollPane.getVerticalScrollBar().setUnitIncrement(64);
                    jScrollPane.getVerticalScrollBar().setBlockIncrement(256);
                    FlowViewController.this.visual.add((Component)jScrollPane, "Center");
                    if (FlowViewController.this.visual.hasFocus()) {
                        FlowViewController.this.view.requestFocus();
                    }
                } else {
                    FlowViewController.this.visual.add((Component)FlowViewController.this.loadingPanel, "Center");
                }
                FlowViewController.this.visual.validate();
            }
        });
    }
}

