/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xam.ui.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import org.netbeans.modules.xml.xam.ui.layout.JSplitterSpace;
import org.netbeans.modules.xml.xam.ui.layout.SplitterBarMouseListener;
import org.netbeans.modules.xml.xam.ui.layout.SplitterBarMouseMotionListener;
import org.netbeans.modules.xml.xam.ui.layout.SplitterLayout;

public class JSplitterBar
extends JPanel {
    static final long serialVersionUID = 1L;
    static final Cursor VERT_CURSOR = new Cursor(8);
    static final Cursor HORIZ_CURSOR = new Cursor(11);
    static final Cursor DEF_CURSOR = new Cursor(0);
    private int orientation = 1;
    private boolean alreadyDrawn = false;
    private Rectangle originalBounds = null;
    private Window wBar;
    private boolean mouseInside = false;

    public JSplitterBar() {
        this.addMouseMotionListener(new SplitterBarMouseMotionListener(this));
        this.addMouseListener(new SplitterBarMouseListener(this));
    }

    private void checkOtherComponents() {
        block9: {
            Rectangle rectangle;
            int n;
            Component[] componentArray;
            Rectangle rectangle2;
            block8: {
                rectangle2 = this.getBounds();
                componentArray = this.getParent().getComponents();
                if (rectangle2.x >= this.originalBounds.x) break block8;
                int n2 = this.originalBounds.x - rectangle2.x;
                for (int i = 0; i < componentArray.length; ++i) {
                    if (componentArray[i] != this) continue;
                    assert (i - 1 > -1) : "There should be a column to the left of this splitter";
                    if (i - 1 > -1) {
                        Rectangle rectangle3 = componentArray[i - 1].getBounds();
                        componentArray[i - 1].setBounds(rectangle3.x, rectangle3.y, rectangle3.width - n2, rectangle3.height);
                    }
                    for (int j = i + 1; j < componentArray.length; ++j) {
                        Rectangle rectangle4 = componentArray[j].getBounds();
                        componentArray[j].setBounds(rectangle4.x - n2, rectangle4.y, rectangle4.width, rectangle4.height);
                        componentArray[j].setVisible(true);
                    }
                }
                break block9;
            }
            if (rectangle2.x <= this.originalBounds.x) break block9;
            int n3 = rectangle2.x - this.originalBounds.x;
            Component component = null;
            int n4 = -1;
            for (n = 0; n < componentArray.length; ++n) {
                if (componentArray[n] != this) continue;
                n4 = n;
                assert (n > 0) : "There should be a column to the left of this splitter.";
                if (n - 1 <= -1) continue;
                component = componentArray[n - 1];
                rectangle = component.getBounds();
                component.setBounds(rectangle.x, rectangle.y, rectangle.width + n3, rectangle.height);
            }
            if (n4 + 1 < componentArray.length) {
                for (n = n4 + 1; n < componentArray.length; ++n) {
                    rectangle = componentArray[n].getBounds();
                    componentArray[n].setBounds(rectangle.x + n3, rectangle.y, rectangle.width, rectangle.height);
                }
            }
        }
    }

    void mouseDrag(MouseEvent mouseEvent) {
        Component[] componentArray;
        Container container;
        if (SplitterLayout.dragee == null) {
            SplitterLayout.dragee = this;
        } else if (SplitterLayout.dragee != this) {
            return;
        }
        Container container2 = this.getParent();
        Container container3 = container2.getParent();
        Rectangle rectangle = null;
        Rectangle rectangle2 = null;
        Container container4 = null;
        if (container3 instanceof JViewport) {
            container = (JScrollPane)((JViewport)container3).getParent();
            rectangle = ((JViewport)container3).getViewRect();
            container4 = ((JViewport)container3).getParent().getParent();
            if (container4 == null) {
                return;
            }
        } else {
            return;
        }
        rectangle2 = container4.getBounds();
        container = this.getParent();
        while (container.getParent() != null) {
            container = container.getParent();
        }
        if (!this.alreadyDrawn && container instanceof Frame) {
            this.originalBounds = this.getBounds();
            this.wBar = new Window((Frame)container);
            this.wBar.setBackground(this.getBackground().darker());
        }
        Rectangle rectangle3 = container2.getBounds();
        Point point = this.getLocationOnScreen();
        Insets insets = container2.getInsets();
        rectangle3.height -= insets.top + insets.bottom;
        int n = point.x + mouseEvent.getX();
        Point point2 = rectangle.getLocation();
        SwingUtilities.convertPointToScreen(point2, container3);
        Point point3 = rectangle2.getLocation();
        SwingUtilities.convertPointToScreen(point3, container4);
        int n2 = point2.y;
        int n3 = point3.x + rectangle2.width - this.getWidth();
        int n4 = 0;
        Component component = null;
        for (Component component2 : componentArray = this.getParent().getComponents()) {
            if (component2 == this) {
                Dimension dimension = component.getMinimumSize();
                Point point4 = component.getLocationOnScreen();
                n4 = Math.max(point4.x + dimension.width, point3.x);
                break;
            }
            component = component2;
        }
        if (n < n4) {
            n = n4;
        } else if (n > n3) {
            n = n3;
        }
        this.wBar.setBounds(n, n2, 3, rectangle2.height);
        if (!this.alreadyDrawn) {
            this.wBar.setVisible(true);
            this.alreadyDrawn = true;
        }
    }

    void mouseEnter(MouseEvent mouseEvent) {
        if (SplitterLayout.dragee != null) {
            return;
        }
        this.setCursor(HORIZ_CURSOR);
        this.mouseInside = true;
        this.invalidate();
        this.validate();
        this.repaint();
    }

    void mouseExit(MouseEvent mouseEvent) {
        if (SplitterLayout.dragee != null) {
            return;
        }
        this.setCursor(DEF_CURSOR);
        this.mouseInside = false;
        this.invalidate();
        this.validate();
        this.repaint();
    }

    void mouseRelease(MouseEvent mouseEvent) {
        if (this.alreadyDrawn) {
            if (SplitterLayout.dragee != this) {
                return;
            }
            SplitterLayout.dragee = null;
            Point point = this.wBar.getLocationOnScreen();
            SwingUtilities.convertPointFromScreen(point, this.getParent());
            this.wBar.setVisible(false);
            this.wBar.dispose();
            this.wBar = null;
            this.alreadyDrawn = false;
            Rectangle rectangle = this.getBounds();
            rectangle.x += mouseEvent.getX();
            this.setLocation(point.x, rectangle.y);
            this.setCursor(DEF_CURSOR);
            this.checkOtherComponents();
            this.mouseInside = false;
            this.invalidate();
            this.getParent().validate();
            SplitterLayout.dragee = null;
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        graphics.setColor(this.getBackground());
        Component[] componentArray = this.getComponents();
        if (componentArray != null && componentArray.length > 0) {
            for (int i = 0; i < componentArray.length; ++i) {
                if (!(componentArray[i] instanceof JSplitterSpace)) continue;
                Rectangle rectangle = componentArray[i].getBounds();
                graphics.fill3DRect(rectangle.x + rectangle.width / 2 - 1, rectangle.y + 2, 3, rectangle.y + rectangle.height - 5, true);
            }
        } else {
            Rectangle rectangle = this.getBounds();
            graphics.fill3DRect(rectangle.width / 2 - 1, 2, 3, rectangle.height - 5, true);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

