/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.attach.providers;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.api.AntTargetExecutor;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.lib.profiler.common.integration.IntegrationUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.modules.InstalledFileLocator;

public class RemotePackExporter {
    private static final Map<String, String> scriptMapper = new HashMap<String, String>(){
        {
            this.put(IntegrationUtils.PLATFORM_LINUX_AMD64_OS, "linuxamd64");
            this.put(IntegrationUtils.PLATFORM_LINUX_OS, "linux");
            this.put(IntegrationUtils.PLATFORM_MAC_OS, "mac");
            this.put(IntegrationUtils.PLATFORM_SOLARIS_AMD64_OS, "solamd64");
            this.put(IntegrationUtils.PLATFORM_SOLARIS_INTEL_OS, "solx86");
            this.put(IntegrationUtils.PLATFORM_SOLARIS_SPARC_OS, "solsparc");
            this.put(IntegrationUtils.PLATFORM_SOLARIS_SPARC64_OS, "solsparcv9");
            this.put(IntegrationUtils.PLATFORM_WINDOWS_AMD64_OS, "winamd64");
            this.put(IntegrationUtils.PLATFORM_WINDOWS_OS, "win");
        }
    };
    private AntProjectCookie cookie;

    public static final RemotePackExporter getInstance() {
        return Singleton.INSTANCE;
    }

    private RemotePackExporter() throws ExceptionInInitializerError {
        try {
            File file = InstalledFileLocator.getDefault().locate("remote-pack-defs/build.xml", "org-netbeans-lib-profiler", false);
            this.cookie = (AntProjectCookie)DataObject.find((FileObject)FileUtil.toFileObject((File)file)).getCookie(AntProjectCookie.class);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            throw new ExceptionInInitializerError(dataObjectNotFoundException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String export(String string, String string2) throws IOException {
        String string3 = this.getRemotePackPath(string, string2);
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)("Generating Remote Pack to " + string3));
        progressHandle.setInitialDelay(500);
        progressHandle.start();
        try {
            AntTargetExecutor.Env env = new AntTargetExecutor.Env();
            env.setVerbosity(3);
            Properties properties = new Properties();
            properties.setProperty("lib.dir", "../lib");
            properties.setProperty("dest.dir", string != null ? string : System.getProperty("java.io.tmpdir"));
            env.setProperties(properties);
            AntTargetExecutor antTargetExecutor = AntTargetExecutor.createTargetExecutor((AntTargetExecutor.Env)env);
            antTargetExecutor.execute(this.cookie, new String[]{"profiler-server-" + scriptMapper.get(string2) + "-15"}).result();
        }
        finally {
            progressHandle.finish();
        }
        return string3;
    }

    public String getRemotePackPath(String string, String string2) {
        return string + File.separator + "profiler-server-" + scriptMapper.get(string2) + ".zip";
    }

    public void export(String string) throws IOException {
        this.export(null, string);
    }

    private static final class Singleton {
        private static final RemotePackExporter INSTANCE = new RemotePackExporter();

        private Singleton() {
        }
    }
}

