/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.attach.panels;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.modules.profiler.attach.panels.AttachWizardPanel;
import org.netbeans.modules.profiler.attach.panels.ManualIntegrationPanelUI;
import org.netbeans.modules.profiler.attach.providers.RemotePackExporter;
import org.netbeans.modules.profiler.attach.providers.TargetPlatformEnum;
import org.netbeans.modules.profiler.attach.spi.IntegrationProvider;
import org.netbeans.modules.profiler.attach.wizard.AttachWizardContext;
import org.openide.util.HelpCtx;

public class ManualIntegrationPanel
extends AttachWizardPanel {
    AtomicBoolean exportRunning = new AtomicBoolean(false);
    private static final String HELP_CTX_KEY = "ManualIntegrationPanel.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("ManualIntegrationPanel.HelpCtx");
    private ManualIntegrationPanelUI panel = null;
    private Model model = new Model();

    public HelpCtx getHelp() {
        return HELP_CTX;
    }

    public boolean isValid() {
        return !this.exportRunning.get();
    }

    public boolean canBack(AttachWizardContext attachWizardContext) {
        return true;
    }

    public boolean canFinish(AttachWizardContext attachWizardContext) {
        return this.isValid();
    }

    public boolean canNext(AttachWizardContext attachWizardContext) {
        return true;
    }

    public boolean onCancel(AttachWizardContext attachWizardContext) {
        return true;
    }

    public void onEnter(AttachWizardContext attachWizardContext) {
    }

    public void onExit(AttachWizardContext attachWizardContext) {
        this.model.setJvm(null);
    }

    public void onFinish(AttachWizardContext attachWizardContext) {
        this.model.setJvm(null);
    }

    public void onPanelShow() {
        this.panel.refresh();
    }

    protected JPanel getRenderPanel() {
        if (this.panel == null) {
            this.panel = new ManualIntegrationPanelUI(this.model);
        }
        return this.panel;
    }

    class Model {
        private TargetPlatformEnum jvm = null;

        Model() {
        }

        public String getApplication() {
            return ManualIntegrationPanel.this.getContext().getAttachSettings().getServerType();
        }

        public String getApplicationType() {
            return ManualIntegrationPanel.this.getContext().getAttachSettings().getTargetType();
        }

        public IntegrationProvider.IntegrationHints getIntegrationHints() {
            return ManualIntegrationPanel.this.getContext().getIntegrationProvider().getModificationHints(ManualIntegrationPanel.this.getContext().getAttachSettings());
        }

        public boolean isRemote() {
            return ManualIntegrationPanel.this.getContext().getAttachSettings().isRemote();
        }

        public void setJvm(TargetPlatformEnum targetPlatformEnum) {
            this.jvm = targetPlatformEnum;
            if (targetPlatformEnum != null) {
                ManualIntegrationPanel.this.getContext().getIntegrationProvider().setTargetJava(targetPlatformEnum.toString());
            }
        }

        public TargetPlatformEnum getJvm() {
            return this.jvm;
        }

        public List getSupportedJvms() {
            LinkedList<TargetPlatformEnum> linkedList = new LinkedList<TargetPlatformEnum>();
            if (ManualIntegrationPanel.this.getContext() != null) {
                AttachSettings attachSettings = ManualIntegrationPanel.this.getContext().getAttachSettings();
                Iterator iterator = TargetPlatformEnum.iterator();
                while (iterator.hasNext()) {
                    TargetPlatformEnum targetPlatformEnum = (TargetPlatformEnum)iterator.next();
                    if (!attachSettings.isDirect() && !attachSettings.isRemote() && (!attachSettings.isDynamic16() || !targetPlatformEnum.equals(TargetPlatformEnum.JDK6) && !targetPlatformEnum.equals(TargetPlatformEnum.JDK7)) || !ManualIntegrationPanel.this.getContext().getIntegrationProvider().supportsJVM(targetPlatformEnum)) continue;
                    linkedList.add(targetPlatformEnum);
                }
            }
            return linkedList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String exportRemotePack(String string) throws IOException {
            if (ManualIntegrationPanel.this.exportRunning.compareAndSet(false, true)) {
                try {
                    ManualIntegrationPanel.this.publishUpdate(new ChangeEvent(this));
                    String string2 = RemotePackExporter.getInstance().export(string, ManualIntegrationPanel.this.getContext().getAttachSettings().getHostOS());
                    return string2;
                }
                finally {
                    ManualIntegrationPanel.this.exportRunning.compareAndSet(true, false);
                    ManualIntegrationPanel.this.publishUpdate(new ChangeEvent(ManualIntegrationPanel.this.exportRunning));
                }
            }
            throw new IOException();
        }

        public String getRemotePackPath(String string) {
            return RemotePackExporter.getInstance().getRemotePackPath(string, ManualIntegrationPanel.this.getContext().getAttachSettings().getHostOS());
        }
    }
}

