/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.util;

import java.awt.Color;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.netbeans.jemmy.util.AbstractTextStyleChooser;

public class TextStyleChooser
extends AbstractTextStyleChooser {
    Boolean bold = null;
    Boolean italic = null;
    Boolean strike = null;
    Boolean understrike = null;
    Integer fontSize = null;
    String fontFamily = null;
    Integer alignment = null;
    Color background = null;
    Color foreground = null;

    public void setBold(boolean bl) {
        this.bold = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public void unsetBold() {
        this.bold = null;
    }

    public void setItalic(boolean bl) {
        this.italic = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public void unsetItalic() {
        this.italic = null;
    }

    public void setStrike(boolean bl) {
        this.strike = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public void unsetStrike() {
        this.strike = null;
    }

    public void setUnderstrike(boolean bl) {
        this.understrike = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public void unsetUnderstrike() {
        this.understrike = null;
    }

    public void setFontSize(int n) {
        this.fontSize = new Integer(n);
    }

    public void unsetFontSize() {
        this.fontSize = null;
    }

    public void setAlignment(int n) {
        this.alignment = new Integer(n);
    }

    public void unsetAlignment() {
        this.alignment = null;
    }

    public void setFontFamily(String string) {
        this.fontFamily = string;
    }

    public void unsetFontFamily() {
        this.fontFamily = null;
    }

    public void setBackground(Color color) {
        this.background = color;
    }

    public void unsetBackground() {
        this.background = null;
    }

    public void setForeground(Color color) {
        this.foreground = color;
    }

    public void unsetForeground() {
        this.foreground = null;
    }

    public boolean checkElement(StyledDocument styledDocument, Element element, int n) {
        if (this.bold != null && StyleConstants.isBold(element.getAttributes()) != this.bold) {
            return false;
        }
        if (this.italic != null && StyleConstants.isItalic(element.getAttributes()) != this.italic) {
            return false;
        }
        if (this.strike != null && StyleConstants.isStrikeThrough(element.getAttributes()) != this.strike) {
            return false;
        }
        if (this.understrike != null && StyleConstants.isUnderline(element.getAttributes()) != this.understrike) {
            return false;
        }
        if (this.fontSize != null && StyleConstants.getFontSize(element.getAttributes()) != this.fontSize) {
            return false;
        }
        if (this.alignment != null && StyleConstants.getAlignment(element.getAttributes()) != this.alignment) {
            return false;
        }
        if (this.fontFamily != null && !StyleConstants.getFontFamily(element.getAttributes()).equals(this.fontFamily)) {
            return false;
        }
        if (this.background != null && !StyleConstants.getBackground(element.getAttributes()).equals(this.background)) {
            return false;
        }
        return this.foreground == null || StyleConstants.getForeground(element.getAttributes()).equals(this.foreground);
    }

    public String getDescription() {
        String string = "";
        if (this.bold != null) {
            string = string + (this.bold != false ? "" : "not ") + "bold, ";
        }
        if (this.italic != null) {
            string = string + (this.italic != false ? "" : "not ") + "italic, ";
        }
        if (this.strike != null) {
            string = string + (this.strike != false ? "" : "not ") + "strike, ";
        }
        if (this.understrike != null) {
            string = string + (this.understrike != false ? "" : "not ") + "understrike, ";
        }
        if (this.fontSize != null) {
            string = string + this.fontSize.toString() + " size, ";
        }
        if (this.alignment != null) {
            string = string + this.alignment.toString() + " alignment, ";
        }
        if (this.fontFamily != null) {
            string = string + "\"" + this.fontFamily + "\" font family, ";
        }
        if (this.background != null) {
            string = string + this.background.toString() + " background, ";
        }
        if (this.foreground != null) {
            string = string + this.foreground.toString() + " foreground, ";
        }
        if (string.equals("")) {
            string = "any, ";
        }
        return string.substring(0, string.length() - 2) + " font";
    }
}

