/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Hashtable;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.jemmy.util.DumpController;

public class Dumper {
    private static final String tabIncrease = "  ";

    public static void printDTD(PrintWriter printWriter) {
        Dumper.printDTD(printWriter, "");
    }

    public static void printDTD(PrintStream printStream) {
        Dumper.printDTD(new PrintWriter(printStream));
    }

    public static void printDTD(String string) throws FileNotFoundException {
        Dumper.printDTD(new PrintWriter(new FileOutputStream(string)));
    }

    public static void dumpComponent(Component component, final PrintWriter printWriter, final DumpController dumpController) {
        QueueTool queueTool = new QueueTool();
        Component[] componentArray = component != null ? new Component[]{component} : Frame.getFrames();
        final Component[] componentArray2 = componentArray;
        queueTool.invokeAndWait(new QueueTool.QueueAction("dumpComponent"){

            public Object launch() throws Exception {
                Dumper.printHeader(printWriter);
                Dumper.dumpSome("dump", componentArray2, printWriter, "", dumpController);
                printWriter.flush();
                return null;
            }
        });
    }

    public static void dumpComponent(Component component, PrintWriter printWriter) {
        Dumper.dumpComponent(component, printWriter, new DumpController(){

            public boolean onComponentDump(Component component) {
                return true;
            }

            public boolean onPropertyDump(Component component, String string, String string2) {
                return true;
            }
        });
    }

    public static void dumpComponent(Component component, PrintStream printStream) {
        Dumper.dumpComponent(component, new PrintWriter(printStream));
    }

    public static void dumpComponent(Component component, PrintStream printStream, DumpController dumpController) {
        Dumper.dumpComponent(component, new PrintWriter(printStream), dumpController);
    }

    public static void dumpComponent(Component component, String string) throws FileNotFoundException {
        Dumper.dumpComponent(component, new PrintWriter(new FileOutputStream(string)));
    }

    public static void dumpComponent(Component component, String string, DumpController dumpController) throws FileNotFoundException {
        Dumper.dumpComponent(component, new PrintWriter(new FileOutputStream(string)), dumpController);
    }

    public static void dumpAll(PrintWriter printWriter) {
        Dumper.dumpComponent(null, printWriter);
    }

    public static void dumpAll(PrintWriter printWriter, DumpController dumpController) {
        Dumper.dumpComponent(null, printWriter, dumpController);
    }

    public static void dumpAll(PrintStream printStream) {
        Dumper.dumpAll(new PrintWriter(printStream));
    }

    public static void dumpAll(PrintStream printStream, DumpController dumpController) {
        Dumper.dumpAll(new PrintWriter(printStream), dumpController);
    }

    public static void dumpAll(String string) throws FileNotFoundException {
        Dumper.dumpAll(new PrintWriter(new FileOutputStream(string)));
    }

    public static void dumpAll(String string, DumpController dumpController) throws FileNotFoundException {
        Dumper.dumpAll(new PrintWriter(new FileOutputStream(string)), dumpController);
    }

    private static void printTagStart(PrintWriter printWriter, String string, String string2) {
        printWriter.println(string2 + "<" + string + ">");
    }

    private static void printTagOpening(PrintWriter printWriter, String string, String string2) {
        printWriter.print(string2 + "<" + string);
    }

    private static void printTagClosing(PrintWriter printWriter, String string) {
        printWriter.println(">");
    }

    private static void printTagEnd(PrintWriter printWriter, String string, String string2) {
        printWriter.println(string2 + "</" + string + ">");
    }

    private static void printEmptyTagOpening(PrintWriter printWriter, String string, String string2) {
        printWriter.print(string2 + "<" + string);
    }

    private static void printEmptyTagClosing(PrintWriter printWriter, String string) {
        printWriter.println("/>");
    }

    private static void dumpSome(String string, Component[] componentArray, PrintWriter printWriter, String string2, DumpController dumpController) {
        if (componentArray.length > 0) {
            Dumper.printTagStart(printWriter, string, string2);
            for (int i = 0; i < componentArray.length; ++i) {
                Dumper.dumpOne(componentArray[i], printWriter, string2 + tabIncrease, dumpController);
            }
            Dumper.printTagEnd(printWriter, string, string2);
        }
    }

    private static void dumpOne(Component component, PrintWriter printWriter, String string, DumpController dumpController) {
        boolean bl = dumpController.onComponentDump(component);
        if (bl) {
            try {
                ComponentOperator componentOperator = Operator.createOperator(component);
                Hashtable hashtable = ((Operator)componentOperator).getDump();
                Dumper.printTagOpening(printWriter, "component", string);
                printWriter.print(" operator=\"" + componentOperator.getClass().getName() + "\"");
                Dumper.printTagClosing(printWriter, "component");
                Object[] objectArray = hashtable.keySet().toArray();
                Arrays.sort(objectArray);
                for (int i = 0; i < objectArray.length; ++i) {
                    String string2 = (String)objectArray[i];
                    String string3 = (String)hashtable.get(objectArray[i]);
                    if (!dumpController.onPropertyDump(component, string2, string3)) continue;
                    Dumper.printEmptyTagOpening(printWriter, "property", string + tabIncrease);
                    printWriter.print(" name=\"" + Dumper.escape(string2) + "\" value=\"" + Dumper.escape(string3) + "\"");
                    Dumper.printEmptyTagClosing(printWriter, "property");
                }
            }
            catch (Exception exception) {
                JemmyProperties.getCurrentOutput().printStackTrace(exception);
                Dumper.printTagStart(printWriter, "component", string);
                Dumper.printEmptyTagOpening(printWriter, "exception", string + tabIncrease);
                printWriter.print(" toString=\"" + Dumper.escape(exception.toString()) + "\"");
                Dumper.printEmptyTagClosing(printWriter, "exception");
            }
        }
        if (component instanceof Window) {
            Dumper.dumpSome("subwindows", ((Window)component).getOwnedWindows(), printWriter, string + tabIncrease, dumpController);
        }
        if (component instanceof Container) {
            Dumper.dumpSome("subcomponents", ((Container)component).getComponents(), printWriter, string + tabIncrease, dumpController);
        }
        if (bl) {
            Dumper.printTagEnd(printWriter, "component", string);
        }
    }

    private static void printHeader(PrintWriter printWriter) {
        printWriter.println("<?xml version=\"1.0\"?>");
        printWriter.println("<!DOCTYPE dump [");
        Dumper.printDTD(printWriter, tabIncrease);
        printWriter.println("]>");
    }

    private static void printDTD(PrintWriter printWriter, String string) {
        printWriter.println(string + "<!ELEMENT dump (component*)>");
        printWriter.println(string + "<!ELEMENT component (property+, subcomponents?, subwindows?, exception?)>");
        printWriter.println(string + "<!ELEMENT subcomponents (component+)>");
        printWriter.println(string + "<!ELEMENT subwindows (component+)>");
        printWriter.println(string + "<!ELEMENT property EMPTY>");
        printWriter.println(string + "<!ELEMENT exception EMPTY>");
        printWriter.println(string + "<!ATTLIST component");
        printWriter.println(string + "          operator CDATA #IMPLIED>");
        printWriter.println(string + "<!ATTLIST exception");
        printWriter.println(string + "          toString CDATA #REQUIRED>");
        printWriter.println(string + "<!ATTLIST property");
        printWriter.println(string + "          name  CDATA #REQUIRED");
        printWriter.println(string + "          value CDATA #REQUIRED>");
    }

    public static String escape(String string) {
        return string.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "&quot;");
    }
}

