/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.operators;

import java.awt.Container;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentListener;
import org.netbeans.jemmy.Action;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.ComponentSearcher;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Timeoutable;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.drivers.DriverManager;
import org.netbeans.jemmy.drivers.ScrollDriver;
import org.netbeans.jemmy.drivers.scrolling.ScrollAdjuster;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.Operator;

public class ScrollbarOperator
extends ComponentOperator
implements Timeoutable,
Outputable {
    private static final long ONE_SCROLL_CLICK_TIMEOUT = 0L;
    private static final long WHOLE_SCROLL_TIMEOUT = 60000L;
    private static final long BEFORE_DROP_TIMEOUT = 0L;
    private static final long DRAG_AND_DROP_SCROLLING_DELTA = 0L;
    private static final int MINIMAL_PAD_SIZE = 10;
    private static final int MINIMAL_DRAGGER_SIZE = 5;
    private Timeouts timeouts;
    private TestOut output;
    private ScrollDriver driver = DriverManager.getScrollDriver(this.getClass());
    static /* synthetic */ Class class$java$awt$Scrollbar;

    public ScrollbarOperator(Scrollbar scrollbar) {
        super(scrollbar);
    }

    public ScrollbarOperator(ContainerOperator containerOperator, ComponentChooser componentChooser, int n) {
        this((Scrollbar)containerOperator.waitSubComponent(new ScrollbarFinder(componentChooser), n));
        this.copyEnvironment(containerOperator);
    }

    public ScrollbarOperator(ContainerOperator containerOperator, ComponentChooser componentChooser) {
        this(containerOperator, componentChooser, 0);
    }

    public ScrollbarOperator(ContainerOperator containerOperator, int n) {
        this((Scrollbar)ScrollbarOperator.waitComponent(containerOperator, (ComponentChooser)new ScrollbarFinder(), n));
        this.copyEnvironment(containerOperator);
    }

    public ScrollbarOperator(ContainerOperator containerOperator) {
        this(containerOperator, 0);
    }

    public static Scrollbar findScrollbar(Container container, ComponentChooser componentChooser, int n) {
        return (Scrollbar)ScrollbarOperator.findComponent(container, new ScrollbarFinder(componentChooser), n);
    }

    public static Scrollbar findScrollbar(Container container, ComponentChooser componentChooser) {
        return ScrollbarOperator.findScrollbar(container, componentChooser, 0);
    }

    public static Scrollbar findScrollbar(Container container, int n) {
        return ScrollbarOperator.findScrollbar(container, ComponentSearcher.getTrueChooser(Integer.toString(n) + "'th Scrollbar instance"), n);
    }

    public static Scrollbar findScrollbar(Container container) {
        return ScrollbarOperator.findScrollbar(container, 0);
    }

    public static Scrollbar waitScrollbar(Container container, ComponentChooser componentChooser, int n) {
        return (Scrollbar)ScrollbarOperator.waitComponent(container, (ComponentChooser)new ScrollbarFinder(componentChooser), n);
    }

    public static Scrollbar waitScrollbar(Container container, ComponentChooser componentChooser) {
        return ScrollbarOperator.waitScrollbar(container, componentChooser, 0);
    }

    public static Scrollbar waitScrollbar(Container container, int n) {
        return ScrollbarOperator.waitScrollbar(container, ComponentSearcher.getTrueChooser(Integer.toString(n) + "'th Scrollbar instance"), n);
    }

    public static Scrollbar waitScrollbar(Container container) {
        return ScrollbarOperator.waitScrollbar(container, 0);
    }

    public void setOutput(TestOut testOut) {
        this.output = testOut;
        super.setOutput(this.output.createErrorOutput());
    }

    public TestOut getOutput() {
        return this.output;
    }

    public void setTimeouts(Timeouts timeouts) {
        this.timeouts = timeouts;
        super.setTimeouts(timeouts);
    }

    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    public void copyEnvironment(Operator operator) {
        super.copyEnvironment(operator);
        this.driver = (ScrollDriver)DriverManager.getDriver("drivers.scroll", this.getClass(), operator.getProperties());
    }

    public void scrollTo(Waitable waitable, Object object, boolean bl) {
        this.scrollTo(new WaitableChecker(waitable, object, bl, this));
    }

    public void scrollTo(final ScrollAdjuster scrollAdjuster) {
        this.produceTimeRestricted(new Action(){

            public Object launch(Object object) {
                ScrollbarOperator.this.driver.scroll(ScrollbarOperator.this, scrollAdjuster);
                return null;
            }

            public String getDescription() {
                return "Scrolling";
            }
        }, this.getTimeouts().getTimeout("ScrollbarOperator.WholeScrollTimeout"));
    }

    public void scrollToValue(int n) {
        this.output.printTrace("Scroll Scrollbar to " + Integer.toString(n) + " value\n" + this.toStringSource());
        this.output.printGolden("Scroll Scrollbar to " + Integer.toString(n) + " value");
        this.scrollTo(new ValueScrollAdjuster(n));
    }

    public void scrollToValue(double d) {
        this.output.printTrace("Scroll Scrollbar to " + Double.toString(d) + " proportional value\n" + this.toStringSource());
        this.output.printGolden("Scroll Scrollbar to " + Double.toString(d) + " proportional value");
        this.scrollTo(new ValueScrollAdjuster((int)((double)this.getMinimum() + (double)(this.getMaximum() - this.getVisibleAmount() - this.getMinimum()) * d)));
    }

    public void scrollToMinimum() {
        this.output.printTrace("Scroll Scrollbar to minimum value\n" + this.toStringSource());
        this.output.printGolden("Scroll Scrollbar to minimum value");
        this.produceTimeRestricted(new Action(){

            public Object launch(Object object) {
                ScrollbarOperator.this.driver.scrollToMinimum(ScrollbarOperator.this, ScrollbarOperator.this.getOrientation());
                return null;
            }

            public String getDescription() {
                return "Scrolling";
            }
        }, this.getTimeouts().getTimeout("ScrollbarOperator.WholeScrollTimeout"));
    }

    public void scrollToMaximum() {
        this.output.printTrace("Scroll Scrollbar to maximum value\n" + this.toStringSource());
        this.output.printGolden("Scroll Scrollbar to maximum value");
        this.produceTimeRestricted(new Action(){

            public Object launch(Object object) {
                ScrollbarOperator.this.driver.scrollToMaximum(ScrollbarOperator.this, ScrollbarOperator.this.getOrientation());
                return null;
            }

            public String getDescription() {
                return "Scrolling";
            }
        }, this.getTimeouts().getTimeout("ScrollbarOperator.WholeScrollTimeout"));
    }

    public void addAdjustmentListener(final AdjustmentListener adjustmentListener) {
        this.runMapping(new Operator.MapVoidAction("addAdjustmentListener"){

            public void map() {
                ((Scrollbar)ScrollbarOperator.this.getSource()).addAdjustmentListener(adjustmentListener);
            }
        });
    }

    public int getBlockIncrement() {
        return this.runMapping(new Operator.MapIntegerAction("getBlockIncrement"){

            public int map() {
                return ((Scrollbar)ScrollbarOperator.this.getSource()).getBlockIncrement();
            }
        });
    }

    public int getMaximum() {
        return this.runMapping(new Operator.MapIntegerAction("getMaximum"){

            public int map() {
                return ((Scrollbar)ScrollbarOperator.this.getSource()).getMaximum();
            }
        });
    }

    public int getMinimum() {
        return this.runMapping(new Operator.MapIntegerAction("getMinimum"){

            public int map() {
                return ((Scrollbar)ScrollbarOperator.this.getSource()).getMinimum();
            }
        });
    }

    public int getOrientation() {
        return this.runMapping(new Operator.MapIntegerAction("getOrientation"){

            public int map() {
                return ((Scrollbar)ScrollbarOperator.this.getSource()).getOrientation();
            }
        });
    }

    public int getUnitIncrement() {
        return this.runMapping(new Operator.MapIntegerAction("getUnitIncrement"){

            public int map() {
                return ((Scrollbar)ScrollbarOperator.this.getSource()).getUnitIncrement();
            }
        });
    }

    public int getValue() {
        return this.runMapping(new Operator.MapIntegerAction("getValue"){

            public int map() {
                return ((Scrollbar)ScrollbarOperator.this.getSource()).getValue();
            }
        });
    }

    public int getVisibleAmount() {
        return this.runMapping(new Operator.MapIntegerAction("getVisibleAmount"){

            public int map() {
                return ((Scrollbar)ScrollbarOperator.this.getSource()).getVisibleAmount();
            }
        });
    }

    public void removeAdjustmentListener(final AdjustmentListener adjustmentListener) {
        this.runMapping(new Operator.MapVoidAction("removeAdjustmentListener"){

            public void map() {
                ((Scrollbar)ScrollbarOperator.this.getSource()).removeAdjustmentListener(adjustmentListener);
            }
        });
    }

    public void setBlockIncrement(final int n) {
        this.runMapping(new Operator.MapVoidAction("setBlockIncrement"){

            public void map() {
                ((Scrollbar)ScrollbarOperator.this.getSource()).setBlockIncrement(n);
            }
        });
    }

    public void setMaximum(final int n) {
        this.runMapping(new Operator.MapVoidAction("setMaximum"){

            public void map() {
                ((Scrollbar)ScrollbarOperator.this.getSource()).setMaximum(n);
            }
        });
    }

    public void setMinimum(final int n) {
        this.runMapping(new Operator.MapVoidAction("setMinimum"){

            public void map() {
                ((Scrollbar)ScrollbarOperator.this.getSource()).setMinimum(n);
            }
        });
    }

    public void setOrientation(final int n) {
        this.runMapping(new Operator.MapVoidAction("setOrientation"){

            public void map() {
                ((Scrollbar)ScrollbarOperator.this.getSource()).setOrientation(n);
            }
        });
    }

    public void setUnitIncrement(final int n) {
        this.runMapping(new Operator.MapVoidAction("setUnitIncrement"){

            public void map() {
                ((Scrollbar)ScrollbarOperator.this.getSource()).setUnitIncrement(n);
            }
        });
    }

    public void setValue(final int n) {
        this.runMapping(new Operator.MapVoidAction("setValue"){

            public void map() {
                ((Scrollbar)ScrollbarOperator.this.getSource()).setValue(n);
            }
        });
    }

    public void setValues(final int n, final int n2, final int n3, final int n4) {
        this.runMapping(new Operator.MapVoidAction("setValues"){

            public void map() {
                ((Scrollbar)ScrollbarOperator.this.getSource()).setValues(n, n2, n3, n4);
            }
        });
    }

    public void setVisibleAmount(final int n) {
        this.runMapping(new Operator.MapVoidAction("setVisibleAmount"){

            public void map() {
                ((Scrollbar)ScrollbarOperator.this.getSource()).setVisibleAmount(n);
            }
        });
    }

    static {
        Timeouts.initDefault("ScrollbarOperator.OneScrollClickTimeout", 0L);
        Timeouts.initDefault("ScrollbarOperator.WholeScrollTimeout", 60000L);
        Timeouts.initDefault("ScrollbarOperator.BeforeDropTimeout", 0L);
        Timeouts.initDefault("ScrollbarOperator.DragAndDropScrollingDelta", 0L);
    }

    public static class ScrollbarFinder
    extends Operator.Finder {
        public ScrollbarFinder(ComponentChooser componentChooser) {
            super(class$java$awt$Scrollbar == null ? (class$java$awt$Scrollbar = ScrollbarOperator.class$("java.awt.Scrollbar")) : class$java$awt$Scrollbar, componentChooser);
        }

        public ScrollbarFinder() {
            super(class$java$awt$Scrollbar == null ? (class$java$awt$Scrollbar = ScrollbarOperator.class$("java.awt.Scrollbar")) : class$java$awt$Scrollbar);
        }
    }

    private class WaitableChecker
    implements ScrollAdjuster {
        Waitable w;
        Object waitParam;
        boolean increase;
        boolean reached = false;
        ScrollbarOperator oper;

        public WaitableChecker(Waitable waitable, Object object, boolean bl, ScrollbarOperator scrollbarOperator2) {
            this.w = waitable;
            this.waitParam = object;
            this.increase = bl;
            this.oper = scrollbarOperator2;
        }

        public int getScrollDirection() {
            if (!this.reached && this.w.actionProduced(this.waitParam) != null) {
                this.reached = true;
            }
            if (this.reached) {
                return 0;
            }
            return this.increase ? 1 : -1;
        }

        public int getScrollOrientation() {
            return ScrollbarOperator.this.getOrientation();
        }

        public String getDescription() {
            return this.w.getDescription();
        }
    }

    private class ValueScrollAdjuster
    implements ScrollAdjuster {
        int value;

        public ValueScrollAdjuster(int n) {
            this.value = n;
        }

        public int getScrollDirection() {
            if (ScrollbarOperator.this.getValue() == this.value) {
                return 0;
            }
            return ScrollbarOperator.this.getValue() < this.value ? 1 : -1;
        }

        public int getScrollOrientation() {
            return ScrollbarOperator.this.getOrientation();
        }

        public String getDescription() {
            return "Scroll to " + Integer.toString(this.value) + " value";
        }
    }
}

