/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.operators;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.EventObject;
import java.util.Hashtable;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.plaf.TableUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.ComponentSearcher;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Timeoutable;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.drivers.DriverManager;
import org.netbeans.jemmy.drivers.TableDriver;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JComponentOperator;
import org.netbeans.jemmy.operators.JPopupMenuOperator;
import org.netbeans.jemmy.operators.JScrollPaneOperator;
import org.netbeans.jemmy.operators.JTableHeaderOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.jemmy.util.EmptyVisualizer;

public class JTableOperator
extends JComponentOperator
implements Outputable,
Timeoutable {
    public static final String CELL_PREFIX_DPROP = "Cell";
    public static final String COLUMN_PREFIX_DPROP = "Column";
    public static final String SELECTED_COLUMN_PREFIX_DPROP = "SelectedColumn";
    public static final String SELECTED_ROW_PREFIX_DPROP = "SelectedRow";
    public static final String COLUMN_COUNT_DPROP = "Column count";
    public static final String ROW_COUNT_DPROP = "Row count";
    private static final long WAIT_EDITING_TIMEOUT = 60000L;
    private TestOut output;
    private Timeouts timeouts;
    TableDriver driver = DriverManager.getTableDriver(this.getClass());
    static /* synthetic */ Class class$javax$swing$JTable;

    public JTableOperator(JTable jTable) {
        super(jTable);
    }

    public JTableOperator(ContainerOperator containerOperator, ComponentChooser componentChooser, int n) {
        this((JTable)containerOperator.waitSubComponent(new JTableFinder(componentChooser), n));
        this.copyEnvironment(containerOperator);
    }

    public JTableOperator(ContainerOperator containerOperator, ComponentChooser componentChooser) {
        this(containerOperator, componentChooser, 0);
    }

    public JTableOperator(ContainerOperator containerOperator, String string, int n, int n2, int n3) {
        this((JTable)JTableOperator.waitComponent(containerOperator, (ComponentChooser)new JTableByCellFinder(string, n, n2, containerOperator.getComparator()), n3));
        this.copyEnvironment(containerOperator);
    }

    public JTableOperator(ContainerOperator containerOperator, String string, int n, int n2) {
        this(containerOperator, string, n, n2, 0);
    }

    public JTableOperator(ContainerOperator containerOperator, String string, int n) {
        this(containerOperator, string, -1, -1, n);
    }

    public JTableOperator(ContainerOperator containerOperator, String string) {
        this(containerOperator, string, 0);
    }

    public JTableOperator(ContainerOperator containerOperator, int n) {
        this((JTable)JTableOperator.waitComponent(containerOperator, (ComponentChooser)new JTableFinder(), n));
        this.copyEnvironment(containerOperator);
    }

    public JTableOperator(ContainerOperator containerOperator) {
        this(containerOperator, 0);
    }

    public static JTable findJTable(Container container, ComponentChooser componentChooser, int n) {
        return (JTable)JTableOperator.findComponent(container, new JTableFinder(componentChooser), n);
    }

    public static JTable findJTable(Container container, ComponentChooser componentChooser) {
        return JTableOperator.findJTable(container, componentChooser, 0);
    }

    public static JTable findJTable(Container container, String string, boolean bl, boolean bl2, int n, int n2, int n3) {
        return JTableOperator.findJTable(container, new JTableByCellFinder(string, n, n2, new Operator.DefaultStringComparator(bl, bl2)), n3);
    }

    public static JTable findJTable(Container container, String string, boolean bl, boolean bl2, int n, int n2) {
        return JTableOperator.findJTable(container, string, bl, bl2, n, n2, 0);
    }

    public static JTable waitJTable(Container container, ComponentChooser componentChooser, int n) {
        return (JTable)JTableOperator.waitComponent(container, (ComponentChooser)new JTableFinder(componentChooser), n);
    }

    public static JTable waitJTable(Container container, ComponentChooser componentChooser) {
        return JTableOperator.waitJTable(container, componentChooser, 0);
    }

    public static JTable waitJTable(Container container, String string, boolean bl, boolean bl2, int n, int n2, int n3) {
        return JTableOperator.waitJTable(container, new JTableByCellFinder(string, n, n2, new Operator.DefaultStringComparator(bl, bl2)), n3);
    }

    public static JTable waitJTable(Container container, String string, boolean bl, boolean bl2, int n, int n2) {
        return JTableOperator.waitJTable(container, string, bl, bl2, n, n2, 0);
    }

    public void setTimeouts(Timeouts timeouts) {
        this.timeouts = timeouts;
        super.setTimeouts(this.timeouts);
    }

    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    public void setOutput(TestOut testOut) {
        this.output = testOut;
        super.setOutput(this.output);
    }

    public TestOut getOutput() {
        return this.output;
    }

    public void copyEnvironment(Operator operator) {
        super.copyEnvironment(operator);
        this.driver = (TableDriver)DriverManager.getDriver("drivers.table", this.getClass(), operator.getProperties());
    }

    public Point findCell(String string, Operator.StringComparator stringComparator, int n) {
        return this.findCell(new BySubStringTableCellChooser(string, stringComparator), n);
    }

    public Point findCell(String string, Operator.StringComparator stringComparator, int[] nArray, int[] nArray2, int n) {
        return this.findCell(new BySubStringTableCellChooser(string, stringComparator), nArray, nArray2, n);
    }

    public int findCellRow(String string, Operator.StringComparator stringComparator, int n) {
        return this.findCell((String)string, (Operator.StringComparator)stringComparator, (int)n).y;
    }

    public int findCellRow(String string, Operator.StringComparator stringComparator, int n, int n2) {
        return this.findCell((String)string, (Operator.StringComparator)stringComparator, null, (int[])new int[]{n}, (int)n2).y;
    }

    public int findCellColumn(String string, Operator.StringComparator stringComparator, int n) {
        return this.findCell((String)string, (Operator.StringComparator)stringComparator, (int)n).x;
    }

    public int findCellColumn(String string, Operator.StringComparator stringComparator, int n, int n2) {
        return this.findCell((String)string, (Operator.StringComparator)stringComparator, (int[])new int[]{n}, null, (int)n2).x;
    }

    public int findCellRow(String string, boolean bl, boolean bl2, int n) {
        return this.findCell((String)string, (boolean)bl, (boolean)bl2, (int)n).y;
    }

    public int findCellColumn(String string, boolean bl, boolean bl2, int n) {
        return this.findCell((String)string, (boolean)bl, (boolean)bl2, (int)n).x;
    }

    public int findCellRow(String string, boolean bl, boolean bl2) {
        return this.findCellRow(string, bl, bl2, 0);
    }

    public int findCellColumn(String string, boolean bl, boolean bl2) {
        return this.findCellColumn(string, bl, bl2, 0);
    }

    public int findCellRow(String string, Operator.StringComparator stringComparator) {
        return this.findCellRow(string, stringComparator, 0);
    }

    public int findCellColumn(String string, Operator.StringComparator stringComparator) {
        return this.findCellColumn(string, stringComparator, 0);
    }

    public int findCellRow(String string, int n) {
        return this.findCell((String)string, (int)n).y;
    }

    public int findCellRow(String string, int n, int n2) {
        return this.findCell((String)string, null, (int[])new int[]{n}, (int)n2).y;
    }

    public int findCellColumn(String string, int n) {
        return this.findCell((String)string, (int)n).x;
    }

    public int findCellColumn(String string, int n, int n2) {
        return this.findCell((String)string, (int[])new int[]{n}, null, (int)n2).x;
    }

    public Point findCell(String string, int n) {
        return this.findCell(string, this.getComparator(), n);
    }

    public Point findCell(String string, int[] nArray, int[] nArray2, int n) {
        return this.findCell(new BySubStringTableCellChooser(string, this.getComparator()), nArray, nArray2, n);
    }

    public int findCellRow(String string) {
        return this.findCellRow(string, 0);
    }

    public int findCellColumn(String string) {
        return this.findCellColumn(string, 0);
    }

    public int findCellRow(ComponentChooser componentChooser, int n) {
        return this.findCell((ComponentChooser)componentChooser, (int)n).y;
    }

    public int findCellRow(ComponentChooser componentChooser, int n, int n2) {
        return this.findCell((ComponentChooser)componentChooser, null, (int[])new int[]{n}, (int)n2).y;
    }

    public int findCellColumn(ComponentChooser componentChooser, int n) {
        return this.findCell((ComponentChooser)componentChooser, (int)n).x;
    }

    public int findCellColumn(ComponentChooser componentChooser, int n, int n2) {
        return this.findCell((ComponentChooser)componentChooser, (int[])new int[]{n}, null, (int)n2).x;
    }

    public Point findCell(ComponentChooser componentChooser, int n) {
        return this.findCell(new ByRenderedComponentTableCellChooser(componentChooser), n);
    }

    public Point findCell(ComponentChooser componentChooser, int[] nArray, int[] nArray2, int n) {
        return this.findCell(new ByRenderedComponentTableCellChooser(componentChooser), nArray, nArray2, n);
    }

    public int findCellRow(ComponentChooser componentChooser) {
        return this.findCellRow(componentChooser, 0);
    }

    public int findCellColumn(ComponentChooser componentChooser) {
        return this.findCellColumn(componentChooser, 0);
    }

    public Point findCell(ComponentChooser componentChooser) {
        return this.findCell(componentChooser, 0);
    }

    public int findCellRow(TableCellChooser tableCellChooser, int n) {
        return this.findCell((TableCellChooser)tableCellChooser, (int)n).y;
    }

    public int findCellRow(TableCellChooser tableCellChooser, int n, int n2) {
        return this.findCell((TableCellChooser)tableCellChooser, null, (int[])new int[]{n}, (int)n2).y;
    }

    public int findCellColumn(TableCellChooser tableCellChooser, int n) {
        return this.findCell((TableCellChooser)tableCellChooser, (int)n).x;
    }

    public int findCellColumn(TableCellChooser tableCellChooser, int n, int n2) {
        return this.findCell((TableCellChooser)tableCellChooser, (int[])new int[]{n}, null, (int)n2).x;
    }

    public Point findCell(TableCellChooser tableCellChooser, int n) {
        return this.findCell(tableCellChooser, null, null, n);
    }

    public Point findCell(TableCellChooser tableCellChooser, int[] nArray, int[] nArray2, int n) {
        int n2;
        int[] nArray3;
        int[] nArray4;
        TableModel tableModel = this.getModel();
        if (nArray != null) {
            nArray4 = nArray;
        } else {
            nArray4 = new int[tableModel.getRowCount()];
            for (int i = 0; i < tableModel.getRowCount(); ++i) {
                nArray4[i] = i;
            }
        }
        if (nArray2 != null) {
            nArray3 = nArray2;
        } else {
            nArray3 = new int[tableModel.getColumnCount()];
            for (n2 = 0; n2 < tableModel.getColumnCount(); ++n2) {
                nArray3[n2] = n2;
            }
        }
        n2 = 0;
        for (int i = 0; i < nArray4.length; ++i) {
            for (int j = 0; j < nArray3.length; ++j) {
                if (!tableCellChooser.checkCell(this, nArray4[i], nArray3[j])) continue;
                if (n2 == n) {
                    return new Point(nArray3[j], nArray4[i]);
                }
                ++n2;
            }
        }
        return new Point(-1, -1);
    }

    public int findCellRow(TableCellChooser tableCellChooser) {
        return this.findCellRow(tableCellChooser, 0);
    }

    public int findCellColumn(TableCellChooser tableCellChooser) {
        return this.findCellColumn(tableCellChooser, 0);
    }

    public Point findCell(TableCellChooser tableCellChooser) {
        return this.findCell(tableCellChooser, 0);
    }

    public void clickOnCell(final int n, final int n2, final int n3, final int n4, final int n5) {
        this.output.printLine("Click on (" + Integer.toString(n) + ", " + Integer.toString(n2) + ") cell");
        this.output.printGolden("Click on cell");
        this.makeComponentVisible();
        this.scrollToCell(n, n2);
        this.getQueueTool().invokeSmoothly(new QueueTool.QueueAction("Path selecting"){

            public Object launch() {
                Point point = JTableOperator.this.getPointToClick(n, n2);
                JTableOperator.this.clickMouse(point.x, point.y, n3, n4, n5);
                return null;
            }
        });
    }

    public void clickOnCell(int n, int n2, int n3, int n4) {
        this.clickOnCell(n, n2, n3, n4, 0);
    }

    public void clickOnCell(int n, int n2, int n3) {
        this.clickOnCell(n, n2, n3, JTableOperator.getDefaultMouseButton());
    }

    public void clickOnCell(int n, int n2) {
        this.clickOnCell(n, n2, 1);
    }

    public void clickForEdit(int n, int n2) {
        this.clickOnCell(n, n2, 2);
    }

    public void changeCellText(int n, int n2, String string) {
        this.changeCellObject(n, n2, string);
    }

    public void changeCellObject(int n, int n2, Object object) {
        this.driver.editCell(this, n, n2, object);
    }

    public void scrollToCell(int n, int n2) {
        this.output.printTrace("Scroll JTable to (" + Integer.toString(n) + "," + Integer.toString(n2) + ") cell\n    : " + this.toStringSource());
        this.output.printGolden("Scroll JTable to (" + Integer.toString(n) + "," + Integer.toString(n2) + ")");
        this.makeComponentVisible();
        JScrollPane jScrollPane = (JScrollPane)this.getContainer(new JScrollPaneOperator.JScrollPaneFinder(ComponentSearcher.getTrueChooser("JScrollPane")));
        if (jScrollPane == null) {
            return;
        }
        JScrollPaneOperator jScrollPaneOperator = new JScrollPaneOperator(jScrollPane);
        jScrollPaneOperator.copyEnvironment(this);
        jScrollPaneOperator.setVisualizer(new EmptyVisualizer());
        Rectangle rectangle = this.getCellRect(n, n2, false);
        jScrollPaneOperator.scrollToComponentRectangle(this.getSource(), (int)rectangle.getX(), (int)rectangle.getY(), (int)rectangle.getWidth(), (int)rectangle.getHeight());
    }

    public void selectCell(int n, int n2) {
        this.driver.selectCell(this, n, n2);
    }

    public int findColumn(String string, Operator.StringComparator stringComparator) {
        int n = this.getColumnCount();
        for (int i = 0; i < n; ++i) {
            if (!stringComparator.equals(this.getColumnName(i), string)) continue;
            return i;
        }
        return -1;
    }

    public int findColumn(String string) {
        return this.findColumn(string, this.getComparator());
    }

    public JPopupMenu callPopupOnCell(int n, int n2) {
        this.output.printLine("Call popup on (" + n + ", " + n2 + ") cell");
        this.output.printGolden("Call popup on cell");
        this.makeComponentVisible();
        Point point = this.getPointToClick(n, n2);
        return JPopupMenuOperator.callPopup(this.getSource(), (int)point.getX(), (int)point.getY(), JTableOperator.getPopupMouseButton());
    }

    public Component getRenderedComponent(int n, int n2, boolean bl, boolean bl2) {
        return this.getCellRenderer(n, n2).getTableCellRendererComponent((JTable)this.getSource(), this.getValueAt(n, n2), bl, bl2, n, n2);
    }

    public Component getRenderedComponent(int n, int n2) {
        return this.getRenderedComponent(n, n2, this.isCellSelected(n, n2), false);
    }

    public Point getPointToClick(int n, int n2) {
        Rectangle rectangle = this.getCellRect(n, n2, false);
        return new Point((int)(rectangle.getX() + rectangle.getWidth() / 2.0), (int)(rectangle.getY() + rectangle.getHeight() / 2.0));
    }

    public JTableHeaderOperator getHeaderOperator() {
        return new JTableHeaderOperator(this.getTableHeader());
    }

    public Component waitCellComponent(ComponentChooser componentChooser, int n, int n2) {
        CellComponentWaiter cellComponentWaiter = new CellComponentWaiter(componentChooser, n, n2);
        cellComponentWaiter.setOutput(this.getOutput());
        cellComponentWaiter.setTimeouts(this.getTimeouts().cloneThis());
        cellComponentWaiter.getTimeouts().setTimeout("Waiter.WaitingTime", this.getTimeouts().getTimeout("JTableOperator.WaitEditingTimeout"));
        try {
            return (Component)cellComponentWaiter.waitAction(null);
        }
        catch (InterruptedException interruptedException) {
            throw new JemmyException("Waiting has been interrupted", interruptedException);
        }
    }

    public void waitCell(String string, int n, int n2) {
        this.getOutput().printLine("Wait \"" + string + "\" text at (" + Integer.toString(n) + "," + Integer.toString(n2) + ")" + " position in component \n    : " + this.toStringSource());
        this.getOutput().printGolden("Wait  \"" + string + "\" text at (" + Integer.toString(n) + "," + Integer.toString(n2) + ")" + " position");
        this.waitState(new JTableByCellFinder(string, n, n2, this.getComparator()));
    }

    public Hashtable getDump() {
        int n;
        Hashtable hashtable = super.getDump();
        TableModel tableModel = ((JTable)this.getSource()).getModel();
        int n2 = tableModel.getColumnCount();
        int n3 = tableModel.getRowCount();
        Object[][] objectArray = new String[n3][n2];
        for (int i = 0; i < n3; ++i) {
            for (n = 0; n < n2; ++n) {
                objectArray[i][n] = tableModel.getValueAt(i, n) != null ? tableModel.getValueAt(i, n).toString() : "null";
            }
        }
        this.addToDump(hashtable, CELL_PREFIX_DPROP, objectArray);
        Object[] objectArray2 = new String[n2];
        for (n = 0; n < n2; ++n) {
            objectArray2[n] = ((JTable)this.getSource()).getColumnName(n);
        }
        this.addToDump(hashtable, COLUMN_PREFIX_DPROP, objectArray2);
        int[] nArray = ((JTable)this.getSource()).getSelectedColumns();
        Object[] objectArray3 = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            objectArray3[i] = Integer.toString(nArray[i]);
        }
        this.addToDump(hashtable, SELECTED_COLUMN_PREFIX_DPROP, objectArray3);
        int[] nArray2 = ((JTable)this.getSource()).getSelectedRows();
        Object[] objectArray4 = new String[nArray2.length];
        for (int i = 0; i < nArray2.length; ++i) {
            objectArray4[i] = Integer.toString(nArray2[i]);
        }
        this.addToDump(hashtable, SELECTED_ROW_PREFIX_DPROP, objectArray4);
        hashtable.put(COLUMN_COUNT_DPROP, Integer.toString(n2));
        hashtable.put(ROW_COUNT_DPROP, Integer.toString(n3));
        return hashtable;
    }

    public void addColumn(final TableColumn tableColumn) {
        this.runMapping(new Operator.MapVoidAction("addColumn"){

            public void map() {
                ((JTable)JTableOperator.this.getSource()).addColumn(tableColumn);
            }
        });
    }

    public void addColumnSelectionInterval(final int n, final int n2) {
        this.runMapping(new Operator.MapVoidAction("addColumnSelectionInterval"){

            public void map() {
                ((JTable)JTableOperator.this.getSource()).addColumnSelectionInterval(n, n2);
            }
        });
    }

    public void addRowSelectionInterval(final int n, final int n2) {
        this.runMapping(new Operator.MapVoidAction("addRowSelectionInterval"){

            public void map() {
                ((JTable)JTableOperator.this.getSource()).addRowSelectionInterval(n, n2);
            }
        });
    }

    public void clearSelection() {
        this.runMapping(new Operator.MapVoidAction("clearSelection"){

            public void map() {
                ((JTable)JTableOperator.this.getSource()).clearSelection();
            }
        });
    }

    public void columnAdded(final TableColumnModelEvent tableColumnModelEvent) {
        this.runMapping(new Operator.MapVoidAction("columnAdded"){

            public void map() {
                ((JTable)JTableOperator.this.getSource()).columnAdded(tableColumnModelEvent);
            }
        });
    }

    public int columnAtPoint(final Point point) {
        return this.runMapping(new Operator.MapIntegerAction("columnAtPoint"){

            public int map() {
                return ((JTable)JTableOperator.this.getSource()).columnAtPoint(point);
            }
        });
    }

    public void columnMarginChanged(final ChangeEvent changeEvent) {
        this.runMapping(new Operator.MapVoidAction("columnMarginChanged"){

            public void map() {
                ((JTable)JTableOperator.this.getSource()).columnMarginChanged(changeEvent);
            }
        });
    }

    public void columnMoved(final TableColumnModelEvent tableColumnModelEvent) {
        this.runMapping(new Operator.MapVoidAction("columnMoved"){

            public void map() {
                ((JTable)JTableOperator.this.getSource()).columnMoved(tableColumnModelEvent);
            }
        });
    }

    public void columnRemoved(final TableColumnModelEvent tableColumnModelEvent) {
        this.runMapping(new Operator.MapVoidAction("columnRemoved"){

            public void map() {
                ((JTable)JTableOperator.this.getSource()).columnRemoved(tableColumnModelEvent);
            }
        });
    }

    public void columnSelectionChanged(final ListSelectionEvent listSelectionEvent) {
        this.runMapping(new Operator.MapVoidAction("columnSelectionChanged"){

            public void map() {
                ((JTable)JTableOperator.this.getSource()).columnSelectionChanged(listSelectionEvent);
            }
        });
    }

    public int convertColumnIndexToModel(final int n) {
        return this.runMapping(new Operator.MapIntegerAction("convertColumnIndexToModel"){

            public int map() {
                return ((JTable)JTableOperator.this.getSource()).convertColumnIndexToModel(n);
            }
        });
    }

    public int convertColumnIndexToView(final int n) {
        return this.runMapping(new Operator.MapIntegerAction("convertColumnIndexToView"){

            public int map() {
                return ((JTable)JTableOperator.this.getSource()).convertColumnIndexToView(n);
            }
        });
    }

    public void createDefaultColumnsFromModel() {
        this.runMapping(new Operator.MapVoidAction("createDefaultColumnsFromModel"){

            public void map() {
                ((JTable)JTableOperator.this.getSource()).createDefaultColumnsFromModel();
            }
        });
    }

    public boolean editCellAt(final int n, final int n2) {
        return this.runMapping(new Operator.MapBooleanAction("editCellAt"){

            public boolean map() {
                return ((JTable)JTableOperator.this.getSource()).editCellAt(n, n2);
            }
        });
    }

    public boolean editCellAt(final int n, final int n2, final EventObject eventObject) {
        return this.runMapping(new Operator.MapBooleanAction("editCellAt"){

            public boolean map() {
                return ((JTable)JTableOperator.this.getSource()).editCellAt(n, n2, eventObject);
            }
        });
    }

    public void editingCanceled(final ChangeEvent changeEvent) {
        this.runMapping(new Operator.MapVoidAction("editingCanceled"){

            public void map() {
                ((JTable)JTableOperator.this.getSource()).editingCanceled(changeEvent);
            }
        });
    }

    public void editingStopped(final ChangeEvent changeEvent) {
        this.runMapping(new Operator.MapVoidAction("editingStopped"){

            public void map() {
                ((JTable)JTableOperator.this.getSource()).editingStopped(changeEvent);
            }
        });
    }

    public boolean getAutoCreateColumnsFromModel() {
        return this.runMapping(new Operator.MapBooleanAction("getAutoCreateColumnsFromModel"){

            public boolean map() {
                return ((JTable)JTableOperator.this.getSource()).getAutoCreateColumnsFromModel();
            }
        });
    }

    public int getAutoResizeMode() {
        return this.runMapping(new Operator.MapIntegerAction("getAutoResizeMode"){

            public int map() {
                return ((JTable)JTableOperator.this.getSource()).getAutoResizeMode();
            }
        });
    }

    public TableCellEditor getCellEditor() {
        return (TableCellEditor)this.runMapping(new Operator.MapAction("getCellEditor"){

            public Object map() {
                return ((JTable)JTableOperator.this.getSource()).getCellEditor();
            }
        });
    }

    public TableCellEditor getCellEditor(final int n, final int n2) {
        return (TableCellEditor)this.runMapping(new Operator.MapAction("getCellEditor"){

            public Object map() {
                return ((JTable)JTableOperator.this.getSource()).getCellEditor(n, n2);
            }
        });
    }

    public Rectangle getCellRect(final int n, final int n2, final boolean bl) {
        return (Rectangle)this.runMapping(new Operator.MapAction("getCellRect"){

            public Object map() {
                return ((JTable)JTableOperator.this.getSource()).getCellRect(n, n2, bl);
            }
        });
    }

    public TableCellRenderer getCellRenderer(final int n, final int n2) {
        return (TableCellRenderer)this.runMapping(new Operator.MapAction("getCellRenderer"){

            public Object map() {
                return ((JTable)JTableOperator.this.getSource()).getCellRenderer(n, n2);
            }
        });
    }

    public boolean getCellSelectionEnabled() {
        return this.runMapping(new Operator.MapBooleanAction("getCellSelectionEnabled"){

            public boolean map() {
                return ((JTable)JTableOperator.this.getSource()).getCellSelectionEnabled();
            }
        });
    }

    public TableColumn getColumn(final Object object) {
        return (TableColumn)this.runMapping(new Operator.MapAction("getColumn"){

            public Object map() {
                return ((JTable)JTableOperator.this.getSource()).getColumn(object);
            }
        });
    }

    public Class getColumnClass(final int n) {
        return (Class)this.runMapping(new Operator.MapAction("getColumnClass"){

            public Object map() {
                return ((JTable)JTableOperator.this.getSource()).getColumnClass(n);
            }
        });
    }

    public int getColumnCount() {
        return this.runMapping(new Operator.MapIntegerAction("getColumnCount"){

            public int map() {
                return ((JTable)JTableOperator.this.getSource()).getColumnCount();
            }
        });
    }

    public TableColumnModel getColumnModel() {
        return (TableColumnModel)this.runMapping(new Operator.MapAction("getColumnModel"){

            public Object map() {
                return ((JTable)JTableOperator.this.getSource()).getColumnModel();
            }
        });
    }

    public String getColumnName(final int n) {
        return (String)this.runMapping(new Operator.MapAction("getColumnName"){

            public Object map() {
                return ((JTable)JTableOperator.this.getSource()).getColumnName(n);
            }
        });
    }

    public boolean getColumnSelectionAllowed() {
        return this.runMapping(new Operator.MapBooleanAction("getColumnSelectionAllowed"){

            public boolean map() {
                return ((JTable)JTableOperator.this.getSource()).getColumnSelectionAllowed();
            }
        });
    }

    public TableCellEditor getDefaultEditor(final Class clazz) {
        return (TableCellEditor)this.runMapping(new Operator.MapAction("getDefaultEditor"){

            public Object map() {
                return ((JTable)JTableOperator.this.getSource()).getDefaultEditor(clazz);
            }
        });
    }

    public TableCellRenderer getDefaultRenderer(final Class clazz) {
        return (TableCellRenderer)this.runMapping(new Operator.MapAction("getDefaultRenderer"){

            public Object map() {
                return ((JTable)JTableOperator.this.getSource()).getDefaultRenderer(clazz);
            }
        });
    }

    public int getEditingColumn() {
        return this.runMapping(new Operator.MapIntegerAction("getEditingColumn"){

            public int map() {
                return ((JTable)JTableOperator.this.getSource()).getEditingColumn();
            }
        });
    }

    public int getEditingRow() {
        return this.runMapping(new Operator.MapIntegerAction("getEditingRow"){

            public int map() {
                return ((JTable)JTableOperator.this.getSource()).getEditingRow();
            }
        });
    }

    public Component getEditorComponent() {
        return (Component)this.runMapping(new Operator.MapAction("getEditorComponent"){

            public Object map() {
                return ((JTable)JTableOperator.this.getSource()).getEditorComponent();
            }
        });
    }

    public Color getGridColor() {
        return (Color)this.runMapping(new Operator.MapAction("getGridColor"){

            public Object map() {
                return ((JTable)JTableOperator.this.getSource()).getGridColor();
            }
        });
    }

    public Dimension getIntercellSpacing() {
        return (Dimension)this.runMapping(new Operator.MapAction("getIntercellSpacing"){

            public Object map() {
                return ((JTable)JTableOperator.this.getSource()).getIntercellSpacing();
            }
        });
    }

    public TableModel getModel() {
        return (TableModel)this.runMapping(new Operator.MapAction("getModel"){

            public Object map() {
                return ((JTable)JTableOperator.this.getSource()).getModel();
            }
        });
    }

    public Dimension getPreferredScrollableViewportSize() {
        return (Dimension)this.runMapping(new Operator.MapAction("getPreferredScrollableViewportSize"){

            public Object map() {
                return ((JTable)JTableOperator.this.getSource()).getPreferredScrollableViewportSize();
            }
        });
    }

    public int getRowCount() {
        return this.runMapping(new Operator.MapIntegerAction("getRowCount"){

            public int map() {
                return ((JTable)JTableOperator.this.getSource()).getRowCount();
            }
        });
    }

    public int getRowHeight() {
        return this.runMapping(new Operator.MapIntegerAction("getRowHeight"){

            public int map() {
                return ((JTable)JTableOperator.this.getSource()).getRowHeight();
            }
        });
    }

    public int getRowMargin() {
        return this.runMapping(new Operator.MapIntegerAction("getRowMargin"){

            public int map() {
                return ((JTable)JTableOperator.this.getSource()).getRowMargin();
            }
        });
    }

    public boolean getRowSelectionAllowed() {
        return this.runMapping(new Operator.MapBooleanAction("getRowSelectionAllowed"){

            public boolean map() {
                return ((JTable)JTableOperator.this.getSource()).getRowSelectionAllowed();
            }
        });
    }

    public int getScrollableBlockIncrement(final Rectangle rectangle, final int n, final int n2) {
        return this.runMapping(new Operator.MapIntegerAction("getScrollableBlockIncrement"){

            public int map() {
                return ((JTable)JTableOperator.this.getSource()).getScrollableBlockIncrement(rectangle, n, n2);
            }
        });
    }

    public boolean getScrollableTracksViewportHeight() {
        return this.runMapping(new Operator.MapBooleanAction("getScrollableTracksViewportHeight"){

            public boolean map() {
                return ((JTable)JTableOperator.this.getSource()).getScrollableTracksViewportHeight();
            }
        });
    }

    public boolean getScrollableTracksViewportWidth() {
        return this.runMapping(new Operator.MapBooleanAction("getScrollableTracksViewportWidth"){

            public boolean map() {
                return ((JTable)JTableOperator.this.getSource()).getScrollableTracksViewportWidth();
            }
        });
    }

    public int getScrollableUnitIncrement(final Rectangle rectangle, final int n, final int n2) {
        return this.runMapping(new Operator.MapIntegerAction("getScrollableUnitIncrement"){

            public int map() {
                return ((JTable)JTableOperator.this.getSource()).getScrollableUnitIncrement(rectangle, n, n2);
            }
        });
    }

    public int getSelectedColumn() {
        return this.runMapping(new Operator.MapIntegerAction("getSelectedColumn"){

            public int map() {
                return ((JTable)JTableOperator.this.getSource()).getSelectedColumn();
            }
        });
    }

    public int getSelectedColumnCount() {
        return this.runMapping(new Operator.MapIntegerAction("getSelectedColumnCount"){

            public int map() {
                return ((JTable)JTableOperator.this.getSource()).getSelectedColumnCount();
            }
        });
    }

    public int[] getSelectedColumns() {
        return (int[])this.runMapping(new Operator.MapAction("getSelectedColumns"){

            public Object map() {
                return ((JTable)JTableOperator.this.getSource()).getSelectedColumns();
            }
        });
    }

    public int getSelectedRow() {
        return this.runMapping(new Operator.MapIntegerAction("getSelectedRow"){

            public int map() {
                return ((JTable)JTableOperator.this.getSource()).getSelectedRow();
            }
        });
    }

    public int getSelectedRowCount() {
        return this.runMapping(new Operator.MapIntegerAction("getSelectedRowCount"){

            public int map() {
                return ((JTable)JTableOperator.this.getSource()).getSelectedRowCount();
            }
        });
    }

    public int[] getSelectedRows() {
        return (int[])this.runMapping(new Operator.MapAction("getSelectedRows"){

            public Object map() {
                return ((JTable)JTableOperator.this.getSource()).getSelectedRows();
            }
        });
    }

    public Color getSelectionBackground() {
        return (Color)this.runMapping(new Operator.MapAction("getSelectionBackground"){

            public Object map() {
                return ((JTable)JTableOperator.this.getSource()).getSelectionBackground();
            }
        });
    }

    public Color getSelectionForeground() {
        return (Color)this.runMapping(new Operator.MapAction("getSelectionForeground"){

            public Object map() {
                return ((JTable)JTableOperator.this.getSource()).getSelectionForeground();
            }
        });
    }

    public ListSelectionModel getSelectionModel() {
        return (ListSelectionModel)this.runMapping(new Operator.MapAction("getSelectionModel"){

            public Object map() {
                return ((JTable)JTableOperator.this.getSource()).getSelectionModel();
            }
        });
    }

    public boolean getShowHorizontalLines() {
        return this.runMapping(new Operator.MapBooleanAction("getShowHorizontalLines"){

            public boolean map() {
                return ((JTable)JTableOperator.this.getSource()).getShowHorizontalLines();
            }
        });
    }

    public boolean getShowVerticalLines() {
        return this.runMapping(new Operator.MapBooleanAction("getShowVerticalLines"){

            public boolean map() {
                return ((JTable)JTableOperator.this.getSource()).getShowVerticalLines();
            }
        });
    }

    public JTableHeader getTableHeader() {
        return (JTableHeader)this.runMapping(new Operator.MapAction("getTableHeader"){

            public Object map() {
                return ((JTable)JTableOperator.this.getSource()).getTableHeader();
            }
        });
    }

    public TableUI getUI() {
        return (TableUI)this.runMapping(new Operator.MapAction("getUI"){

            public Object map() {
                return ((JTable)JTableOperator.this.getSource()).getUI();
            }
        });
    }

    public Object getValueAt(final int n, final int n2) {
        return this.runMapping(new Operator.MapAction("getValueAt"){

            public Object map() {
                return ((JTable)JTableOperator.this.getSource()).getValueAt(n, n2);
            }
        });
    }

    public boolean isCellEditable(final int n, final int n2) {
        return this.runMapping(new Operator.MapBooleanAction("isCellEditable"){

            public boolean map() {
                return ((JTable)JTableOperator.this.getSource()).isCellEditable(n, n2);
            }
        });
    }

    public boolean isCellSelected(final int n, final int n2) {
        return this.runMapping(new Operator.MapBooleanAction("isCellSelected"){

            public boolean map() {
                return ((JTable)JTableOperator.this.getSource()).isCellSelected(n, n2);
            }
        });
    }

    public boolean isColumnSelected(final int n) {
        return this.runMapping(new Operator.MapBooleanAction("isColumnSelected"){

            public boolean map() {
                return ((JTable)JTableOperator.this.getSource()).isColumnSelected(n);
            }
        });
    }

    public boolean isEditing() {
        return this.runMapping(new Operator.MapBooleanAction("isEditing"){

            public boolean map() {
                return ((JTable)JTableOperator.this.getSource()).isEditing();
            }
        });
    }

    public boolean isRowSelected(final int n) {
        return this.runMapping(new Operator.MapBooleanAction("isRowSelected"){

            public boolean map() {
                return ((JTable)JTableOperator.this.getSource()).isRowSelected(n);
            }
        });
    }

    public void moveColumn(final int n, final int n2) {
        this.runMapping(new Operator.MapVoidAction("moveColumn"){

            public void map() {
                ((JTable)JTableOperator.this.getSource()).moveColumn(n, n2);
            }
        });
    }

    public Component prepareEditor(final TableCellEditor tableCellEditor, final int n, final int n2) {
        return (Component)this.runMapping(new Operator.MapAction("prepareEditor"){

            public Object map() {
                return ((JTable)JTableOperator.this.getSource()).prepareEditor(tableCellEditor, n, n2);
            }
        });
    }

    public Component prepareRenderer(final TableCellRenderer tableCellRenderer, final int n, final int n2) {
        return (Component)this.runMapping(new Operator.MapAction("prepareRenderer"){

            public Object map() {
                return ((JTable)JTableOperator.this.getSource()).prepareRenderer(tableCellRenderer, n, n2);
            }
        });
    }

    public void removeColumn(final TableColumn tableColumn) {
        this.runMapping(new Operator.MapVoidAction("removeColumn"){

            public void map() {
                ((JTable)JTableOperator.this.getSource()).removeColumn(tableColumn);
            }
        });
    }

    public void removeColumnSelectionInterval(final int n, final int n2) {
        this.runMapping(new Operator.MapVoidAction("removeColumnSelectionInterval"){

            public void map() {
                ((JTable)JTableOperator.this.getSource()).removeColumnSelectionInterval(n, n2);
            }
        });
    }

    public void removeEditor() {
        this.runMapping(new Operator.MapVoidAction("removeEditor"){

            public void map() {
                ((JTable)JTableOperator.this.getSource()).removeEditor();
            }
        });
    }

    public void removeRowSelectionInterval(final int n, final int n2) {
        this.runMapping(new Operator.MapVoidAction("removeRowSelectionInterval"){

            public void map() {
                ((JTable)JTableOperator.this.getSource()).removeRowSelectionInterval(n, n2);
            }
        });
    }

    public int rowAtPoint(final Point point) {
        return this.runMapping(new Operator.MapIntegerAction("rowAtPoint"){

            public int map() {
                return ((JTable)JTableOperator.this.getSource()).rowAtPoint(point);
            }
        });
    }

    public void selectAll() {
        this.runMapping(new Operator.MapVoidAction("selectAll"){

            public void map() {
                ((JTable)JTableOperator.this.getSource()).selectAll();
            }
        });
    }

    public void setAutoCreateColumnsFromModel(final boolean bl) {
        this.runMapping(new Operator.MapVoidAction("setAutoCreateColumnsFromModel"){

            public void map() {
                ((JTable)JTableOperator.this.getSource()).setAutoCreateColumnsFromModel(bl);
            }
        });
    }

    public void setAutoResizeMode(final int n) {
        this.runMapping(new Operator.MapVoidAction("setAutoResizeMode"){

            public void map() {
                ((JTable)JTableOperator.this.getSource()).setAutoResizeMode(n);
            }
        });
    }

    public void setCellEditor(final TableCellEditor tableCellEditor) {
        this.runMapping(new Operator.MapVoidAction("setCellEditor"){

            public void map() {
                ((JTable)JTableOperator.this.getSource()).setCellEditor(tableCellEditor);
            }
        });
    }

    public void setCellSelectionEnabled(final boolean bl) {
        this.runMapping(new Operator.MapVoidAction("setCellSelectionEnabled"){

            public void map() {
                ((JTable)JTableOperator.this.getSource()).setCellSelectionEnabled(bl);
            }
        });
    }

    public void setColumnModel(final TableColumnModel tableColumnModel) {
        this.runMapping(new Operator.MapVoidAction("setColumnModel"){

            public void map() {
                ((JTable)JTableOperator.this.getSource()).setColumnModel(tableColumnModel);
            }
        });
    }

    public void setColumnSelectionAllowed(final boolean bl) {
        this.runMapping(new Operator.MapVoidAction("setColumnSelectionAllowed"){

            public void map() {
                ((JTable)JTableOperator.this.getSource()).setColumnSelectionAllowed(bl);
            }
        });
    }

    public void setColumnSelectionInterval(final int n, final int n2) {
        this.runMapping(new Operator.MapVoidAction("setColumnSelectionInterval"){

            public void map() {
                ((JTable)JTableOperator.this.getSource()).setColumnSelectionInterval(n, n2);
            }
        });
    }

    public void setDefaultEditor(final Class clazz, final TableCellEditor tableCellEditor) {
        this.runMapping(new Operator.MapVoidAction("setDefaultEditor"){

            public void map() {
                ((JTable)JTableOperator.this.getSource()).setDefaultEditor(clazz, tableCellEditor);
            }
        });
    }

    public void setDefaultRenderer(final Class clazz, final TableCellRenderer tableCellRenderer) {
        this.runMapping(new Operator.MapVoidAction("setDefaultRenderer"){

            public void map() {
                ((JTable)JTableOperator.this.getSource()).setDefaultRenderer(clazz, tableCellRenderer);
            }
        });
    }

    public void setEditingColumn(final int n) {
        this.runMapping(new Operator.MapVoidAction("setEditingColumn"){

            public void map() {
                ((JTable)JTableOperator.this.getSource()).setEditingColumn(n);
            }
        });
    }

    public void setEditingRow(final int n) {
        this.runMapping(new Operator.MapVoidAction("setEditingRow"){

            public void map() {
                ((JTable)JTableOperator.this.getSource()).setEditingRow(n);
            }
        });
    }

    public void setGridColor(final Color color) {
        this.runMapping(new Operator.MapVoidAction("setGridColor"){

            public void map() {
                ((JTable)JTableOperator.this.getSource()).setGridColor(color);
            }
        });
    }

    public void setIntercellSpacing(final Dimension dimension) {
        this.runMapping(new Operator.MapVoidAction("setIntercellSpacing"){

            public void map() {
                ((JTable)JTableOperator.this.getSource()).setIntercellSpacing(dimension);
            }
        });
    }

    public void setModel(final TableModel tableModel) {
        this.runMapping(new Operator.MapVoidAction("setModel"){

            public void map() {
                ((JTable)JTableOperator.this.getSource()).setModel(tableModel);
            }
        });
    }

    public void setPreferredScrollableViewportSize(final Dimension dimension) {
        this.runMapping(new Operator.MapVoidAction("setPreferredScrollableViewportSize"){

            public void map() {
                ((JTable)JTableOperator.this.getSource()).setPreferredScrollableViewportSize(dimension);
            }
        });
    }

    public void setRowHeight(final int n) {
        this.runMapping(new Operator.MapVoidAction("setRowHeight"){

            public void map() {
                ((JTable)JTableOperator.this.getSource()).setRowHeight(n);
            }
        });
    }

    public void setRowMargin(final int n) {
        this.runMapping(new Operator.MapVoidAction("setRowMargin"){

            public void map() {
                ((JTable)JTableOperator.this.getSource()).setRowMargin(n);
            }
        });
    }

    public void setRowSelectionAllowed(final boolean bl) {
        this.runMapping(new Operator.MapVoidAction("setRowSelectionAllowed"){

            public void map() {
                ((JTable)JTableOperator.this.getSource()).setRowSelectionAllowed(bl);
            }
        });
    }

    public void setRowSelectionInterval(final int n, final int n2) {
        this.runMapping(new Operator.MapVoidAction("setRowSelectionInterval"){

            public void map() {
                ((JTable)JTableOperator.this.getSource()).setRowSelectionInterval(n, n2);
            }
        });
    }

    public void setSelectionBackground(final Color color) {
        this.runMapping(new Operator.MapVoidAction("setSelectionBackground"){

            public void map() {
                ((JTable)JTableOperator.this.getSource()).setSelectionBackground(color);
            }
        });
    }

    public void setSelectionForeground(final Color color) {
        this.runMapping(new Operator.MapVoidAction("setSelectionForeground"){

            public void map() {
                ((JTable)JTableOperator.this.getSource()).setSelectionForeground(color);
            }
        });
    }

    public void setSelectionMode(final int n) {
        this.runMapping(new Operator.MapVoidAction("setSelectionMode"){

            public void map() {
                ((JTable)JTableOperator.this.getSource()).setSelectionMode(n);
            }
        });
    }

    public void setSelectionModel(final ListSelectionModel listSelectionModel) {
        this.runMapping(new Operator.MapVoidAction("setSelectionModel"){

            public void map() {
                ((JTable)JTableOperator.this.getSource()).setSelectionModel(listSelectionModel);
            }
        });
    }

    public void setShowGrid(final boolean bl) {
        this.runMapping(new Operator.MapVoidAction("setShowGrid"){

            public void map() {
                ((JTable)JTableOperator.this.getSource()).setShowGrid(bl);
            }
        });
    }

    public void setShowHorizontalLines(final boolean bl) {
        this.runMapping(new Operator.MapVoidAction("setShowHorizontalLines"){

            public void map() {
                ((JTable)JTableOperator.this.getSource()).setShowHorizontalLines(bl);
            }
        });
    }

    public void setShowVerticalLines(final boolean bl) {
        this.runMapping(new Operator.MapVoidAction("setShowVerticalLines"){

            public void map() {
                ((JTable)JTableOperator.this.getSource()).setShowVerticalLines(bl);
            }
        });
    }

    public void setTableHeader(final JTableHeader jTableHeader) {
        this.runMapping(new Operator.MapVoidAction("setTableHeader"){

            public void map() {
                ((JTable)JTableOperator.this.getSource()).setTableHeader(jTableHeader);
            }
        });
    }

    public void setUI(final TableUI tableUI) {
        this.runMapping(new Operator.MapVoidAction("setUI"){

            public void map() {
                ((JTable)JTableOperator.this.getSource()).setUI(tableUI);
            }
        });
    }

    public void setValueAt(final Object object, final int n, final int n2) {
        this.runMapping(new Operator.MapVoidAction("setValueAt"){

            public void map() {
                ((JTable)JTableOperator.this.getSource()).setValueAt(object, n, n2);
            }
        });
    }

    public void tableChanged(final TableModelEvent tableModelEvent) {
        this.runMapping(new Operator.MapVoidAction("tableChanged"){

            public void map() {
                ((JTable)JTableOperator.this.getSource()).tableChanged(tableModelEvent);
            }
        });
    }

    public void valueChanged(final ListSelectionEvent listSelectionEvent) {
        this.runMapping(new Operator.MapVoidAction("valueChanged"){

            public void map() {
                ((JTable)JTableOperator.this.getSource()).valueChanged(listSelectionEvent);
            }
        });
    }

    private Point findCell(String string, boolean bl, boolean bl2, int n) {
        return this.findCell(string, new Operator.DefaultStringComparator(bl, bl2), n);
    }

    static {
        Timeouts.initDefault("JTableOperator.WaitEditingTimeout", 60000L);
    }

    private class CellComponentWaiter
    extends Waiter {
        private ComponentChooser chooser;
        private int row;
        private int column;

        public CellComponentWaiter(ComponentChooser componentChooser, int n, int n2) {
            this.chooser = componentChooser;
            this.row = n;
            this.column = n2;
        }

        public Object actionProduced(Object object) {
            Point point = JTableOperator.this.getPointToClick(this.row, this.column);
            Component component = JTableOperator.this.getComponentAt(point.x, point.y);
            if (component != null && this.chooser.checkComponent(component)) {
                return component;
            }
            return null;
        }

        public String getDescription() {
            return this.chooser.getDescription();
        }
    }

    public static class JTableFinder
    extends Operator.Finder {
        public JTableFinder(ComponentChooser componentChooser) {
            super(class$javax$swing$JTable == null ? (class$javax$swing$JTable = JTableOperator.class$("javax.swing.JTable")) : class$javax$swing$JTable, componentChooser);
        }

        public JTableFinder() {
            super(class$javax$swing$JTable == null ? (class$javax$swing$JTable = JTableOperator.class$("javax.swing.JTable")) : class$javax$swing$JTable);
        }
    }

    public static class JTableByCellFinder
    implements ComponentChooser {
        String label;
        int row;
        int column;
        Operator.StringComparator comparator;

        public JTableByCellFinder(String string, int n, int n2, Operator.StringComparator stringComparator) {
            this.label = string;
            this.row = n;
            this.column = n2;
            this.comparator = stringComparator;
        }

        public JTableByCellFinder(String string, int n, int n2) {
            this(string, n, n2, Operator.getDefaultStringComparator());
        }

        public boolean checkComponent(Component component) {
            if (component instanceof JTable) {
                if (this.label == null) {
                    return true;
                }
                if (((JTable)component).getRowCount() > this.row && ((JTable)component).getColumnCount() > this.column) {
                    Object object;
                    int n;
                    int n2 = this.row;
                    if (n2 == -1) {
                        int[] nArray = ((JTable)component).getSelectedRows();
                        if (nArray.length != 0) {
                            n2 = nArray[0];
                        } else {
                            return false;
                        }
                    }
                    if ((n = this.column) == -1) {
                        object = ((JTable)component).getSelectedColumns();
                        if (((int[])object).length != 0) {
                            n = object[0];
                        } else {
                            return false;
                        }
                    }
                    if ((object = (Object)((JTable)component).getValueAt(n2, n)) == null) {
                        return false;
                    }
                    return this.comparator.equals(object.toString(), this.label);
                }
            }
            return false;
        }

        public String getDescription() {
            return "JTable with text \"" + this.label + "\" in (" + new Integer(this.row).toString() + ", " + new Integer(this.column).toString() + ") cell";
        }
    }

    private class ByRenderedComponentTableCellChooser
    implements TableCellChooser {
        ComponentChooser chooser;

        public ByRenderedComponentTableCellChooser(ComponentChooser componentChooser) {
            this.chooser = componentChooser;
        }

        public boolean checkCell(JTableOperator jTableOperator, int n, int n2) {
            return this.chooser.checkComponent(jTableOperator.getRenderedComponent(n, n2));
        }

        public String getDescription() {
            return this.chooser.getDescription();
        }
    }

    private class BySubStringTableCellChooser
    implements TableCellChooser {
        String subString;
        Operator.StringComparator comparator;

        public BySubStringTableCellChooser(String string, Operator.StringComparator stringComparator) {
            this.subString = string;
            this.comparator = stringComparator;
        }

        public BySubStringTableCellChooser(String string, boolean bl, boolean bl2) {
            this(string, new Operator.DefaultStringComparator(bl, bl2));
        }

        public boolean checkCell(JTableOperator jTableOperator, int n, int n2) {
            Object object = ((JTable)jTableOperator.getSource()).getModel().getValueAt(n, n2);
            return this.comparator.equals(object != null ? object.toString() : null, this.subString);
        }

        public String getDescription() {
            return "Cell containing \"" + this.subString + "\" string";
        }
    }

    public static interface TableCellChooser {
        public boolean checkCell(JTableOperator var1, int var2, int var3);

        public String getDescription();
    }
}

