/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.operators;

import java.awt.Component;
import java.awt.Container;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JSplitPane;
import javax.swing.plaf.SplitPaneUI;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import org.netbeans.jemmy.Action;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.ComponentSearcher;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Timeoutable;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.drivers.DriverManager;
import org.netbeans.jemmy.drivers.ScrollDriver;
import org.netbeans.jemmy.drivers.scrolling.ScrollAdjuster;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JComponentOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.jemmy.util.EmptyVisualizer;

public class JSplitPaneOperator
extends JComponentOperator
implements Timeoutable,
Outputable {
    public static final String MINIMUM_DPROP = "Minimum";
    public static final String MAXIMUM_DPROP = "Maximum";
    public static final String VALUE_DPROP = "Value";
    public static final String ORIENTATION_DPROP = "Orientation";
    public static final String HORIZONTAL_ORIENTATION_DPROP_VALUE = "HORIZONTAL";
    public static final String VERTICAL_ORIENTATION_DPROP_VALUE = "VERTICAL";
    public static final String IS_ONE_TOUCH_EXPANDABLE_DPROP = "One touch expandable";
    private static final long SCROLL_CLICK_TIMEOUT = 0L;
    private static final long BETWEEN_CLICK_TIMEOUT = 0L;
    private static final long WHOLE_SCROLL_TIMEOUT = 60000L;
    private Timeouts timeouts;
    private TestOut output;
    private ContainerOperator divider;
    private ScrollDriver driver = DriverManager.getScrollDriver(this.getClass());
    static /* synthetic */ Class class$javax$swing$JSplitPane;

    public JSplitPaneOperator(JSplitPane jSplitPane) {
        super(jSplitPane);
    }

    public JSplitPaneOperator(ContainerOperator containerOperator, ComponentChooser componentChooser, int n) {
        this((JSplitPane)containerOperator.waitSubComponent(new JSplitPaneFinder(componentChooser), n));
        this.copyEnvironment(containerOperator);
    }

    public JSplitPaneOperator(ContainerOperator containerOperator, ComponentChooser componentChooser) {
        this(containerOperator, componentChooser, 0);
    }

    public JSplitPaneOperator(ContainerOperator containerOperator, int n) {
        this((JSplitPane)JSplitPaneOperator.waitComponent(containerOperator, (ComponentChooser)new JSplitPaneFinder(), n));
        this.copyEnvironment(containerOperator);
    }

    public JSplitPaneOperator(ContainerOperator containerOperator) {
        this(containerOperator, 0);
    }

    public static JSplitPane findJSplitPane(Container container, ComponentChooser componentChooser, int n) {
        return (JSplitPane)JSplitPaneOperator.findComponent(container, new JSplitPaneFinder(componentChooser), n);
    }

    public static JSplitPane findJSplitPane(Container container, ComponentChooser componentChooser) {
        return JSplitPaneOperator.findJSplitPane(container, componentChooser, 0);
    }

    public static JSplitPane findJSplitPane(Container container, int n) {
        return JSplitPaneOperator.findJSplitPane(container, ComponentSearcher.getTrueChooser(Integer.toString(n) + "'th JSplitPane instance"), n);
    }

    public static JSplitPane findJSplitPane(Container container) {
        return JSplitPaneOperator.findJSplitPane(container, 0);
    }

    public static JSplitPane findJSplitPaneUnder(Component component, ComponentChooser componentChooser) {
        return (JSplitPane)JSplitPaneOperator.findContainerUnder(component, new JSplitPaneFinder(componentChooser));
    }

    public static JSplitPane findJSplitPaneUnder(Component component) {
        return JSplitPaneOperator.findJSplitPaneUnder(component, new JSplitPaneFinder());
    }

    public static JSplitPane waitJSplitPane(Container container, ComponentChooser componentChooser, int n) {
        return (JSplitPane)JSplitPaneOperator.waitComponent(container, (ComponentChooser)new JSplitPaneFinder(componentChooser), n);
    }

    public static JSplitPane waitJSplitPane(Container container, ComponentChooser componentChooser) {
        return JSplitPaneOperator.waitJSplitPane(container, componentChooser, 0);
    }

    public static JSplitPane waitJSplitPane(Container container, int n) {
        return JSplitPaneOperator.waitJSplitPane(container, ComponentSearcher.getTrueChooser(Integer.toString(n) + "'th JSplitPane instance"), n);
    }

    public static JSplitPane waitJSplitPane(Container container) {
        return JSplitPaneOperator.waitJSplitPane(container, 0);
    }

    public void setTimeouts(Timeouts timeouts) {
        this.timeouts = timeouts;
        Timeouts timeouts2 = timeouts;
        timeouts2.setTimeout("ComponentOperator.BeforeDragTimeout", 0L);
        timeouts2.setTimeout("ComponentOperator.AfterDragTimeout", timeouts2.getTimeout("JSplitPaneOperator.ScrollClickTimeout"));
        super.setTimeouts(timeouts2);
    }

    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    public void setOutput(TestOut testOut) {
        this.output = testOut;
        super.setOutput(this.output.createErrorOutput());
    }

    public TestOut getOutput() {
        return this.output;
    }

    public void copyEnvironment(Operator operator) {
        super.copyEnvironment(operator);
        this.driver = (ScrollDriver)DriverManager.getDriver("drivers.scroll", this.getClass(), operator.getProperties());
    }

    public BasicSplitPaneDivider findDivider() {
        return (BasicSplitPaneDivider)this.waitSubComponent(new ComponentChooser(){

            public boolean checkComponent(Component component) {
                return component instanceof BasicSplitPaneDivider;
            }

            public String getDescription() {
                return "";
            }
        });
    }

    public ContainerOperator getDivider() {
        if (this.divider == null) {
            this.divider = new ContainerOperator(this.findDivider());
            this.divider.copyEnvironment(this);
            this.divider.setOutput(this.getOutput().createErrorOutput());
        }
        return this.divider;
    }

    public void scrollTo(final ScrollAdjuster scrollAdjuster) {
        this.produceTimeRestricted(new Action(){

            public Object launch(Object object) {
                JSplitPaneOperator.this.driver.scroll(JSplitPaneOperator.this, scrollAdjuster);
                return null;
            }

            public String getDescription() {
                return "Moving a divider";
            }
        }, this.getTimeouts().getTimeout("JSplitPaneOperator.WholeScrollTimeout"));
    }

    public void moveDivider(int n) {
        this.output.printTrace("Move JSplitPane divider to " + Integer.toString(n) + " location. JSplitPane :    \n" + this.toStringSource());
        this.output.printGolden("Move JSplitPane divider to " + Integer.toString(n) + " location");
        this.scrollTo(new ValueScrollAdjuster(n));
    }

    public void moveDivider(double d) {
        this.output.printTrace("Move JSplitPane divider to " + Double.toString(d) + " proportional location. JSplitPane :    \n" + this.toStringSource());
        this.output.printGolden("Move JSplitPane divider to " + Double.toString(d) + " proportional location");
        this.scrollTo(new ValueScrollAdjuster(this.getMinimumDividerLocation() + (int)(d * (double)(this.getMaximumDividerLocation() - this.getMinimumDividerLocation()))));
    }

    public void moveToMinimum() {
        this.output.printTrace("Scroll JSplitPane to minimum. JSplitPane :    \n" + this.toStringSource());
        this.output.printGolden("Scroll JSplitPane to minimum.");
        this.produceTimeRestricted(new Action(){

            public Object launch(Object object) {
                JSplitPaneOperator.this.driver.scrollToMinimum(JSplitPaneOperator.this, JSplitPaneOperator.this.getOrientation());
                return null;
            }

            public String getDescription() {
                return "Scrolling";
            }
        }, this.getTimeouts().getTimeout("JSplitPaneOperator.WholeScrollTimeout"));
    }

    public void moveToMaximum() {
        this.output.printTrace("Scroll JSplitPane to maximum. JSplitPane :    \n" + this.toStringSource());
        this.output.printGolden("Scroll JSplitPane to maximum.");
        this.produceTimeRestricted(new Action(){

            public Object launch(Object object) {
                JSplitPaneOperator.this.driver.scrollToMaximum(JSplitPaneOperator.this, JSplitPaneOperator.this.getOrientation());
                return null;
            }

            public String getDescription() {
                return "Scrolling";
            }
        }, this.getTimeouts().getTimeout("JSplitPaneOperator.WholeScrollTimeout"));
    }

    public void expandRight() {
        String string = "Expand ";
        string = this.getOrientation() == 1 ? string + "right" : string + "bottom";
        this.output.printTrace(string + " JSplitPane side. JSplitPane :    \n" + this.toStringSource());
        this.output.printGolden(string + " JSplitPane side.");
        this.expandTo(0);
    }

    public void expandLeft() {
        String string = "Expand ";
        string = this.getOrientation() == 1 ? string + "left" : string + "top";
        this.output.printTrace(string + " JSplitPane side. JSplitPane :    \n" + this.toStringSource());
        this.output.printGolden(string + " JSplitPane side.");
        this.expandTo(1);
    }

    public Hashtable getDump() {
        Hashtable hashtable = super.getDump();
        hashtable.put(MINIMUM_DPROP, Integer.toString(((JSplitPane)this.getSource()).getMinimumDividerLocation()));
        hashtable.put(MAXIMUM_DPROP, Integer.toString(((JSplitPane)this.getSource()).getMaximumDividerLocation()));
        hashtable.put(ORIENTATION_DPROP, ((JSplitPane)this.getSource()).getOrientation() == 1 ? HORIZONTAL_ORIENTATION_DPROP_VALUE : VERTICAL_ORIENTATION_DPROP_VALUE);
        hashtable.put(VALUE_DPROP, Integer.toString(((JSplitPane)this.getSource()).getDividerLocation()));
        hashtable.put(IS_ONE_TOUCH_EXPANDABLE_DPROP, ((JSplitPane)this.getSource()).isOneTouchExpandable() ? "true" : "false");
        return hashtable;
    }

    public Component getBottomComponent() {
        return (Component)this.runMapping(new Operator.MapAction("getBottomComponent"){

            public Object map() {
                return ((JSplitPane)JSplitPaneOperator.this.getSource()).getBottomComponent();
            }
        });
    }

    public int getDividerLocation() {
        return this.runMapping(new Operator.MapIntegerAction("getDividerLocation"){

            public int map() {
                return ((JSplitPane)JSplitPaneOperator.this.getSource()).getDividerLocation();
            }
        });
    }

    public int getDividerSize() {
        return this.runMapping(new Operator.MapIntegerAction("getDividerSize"){

            public int map() {
                return ((JSplitPane)JSplitPaneOperator.this.getSource()).getDividerSize();
            }
        });
    }

    public int getLastDividerLocation() {
        return this.runMapping(new Operator.MapIntegerAction("getLastDividerLocation"){

            public int map() {
                return ((JSplitPane)JSplitPaneOperator.this.getSource()).getLastDividerLocation();
            }
        });
    }

    public Component getLeftComponent() {
        return (Component)this.runMapping(new Operator.MapAction("getLeftComponent"){

            public Object map() {
                return ((JSplitPane)JSplitPaneOperator.this.getSource()).getLeftComponent();
            }
        });
    }

    public int getMaximumDividerLocation() {
        return this.runMapping(new Operator.MapIntegerAction("getMaximumDividerLocation"){

            public int map() {
                return ((JSplitPane)JSplitPaneOperator.this.getSource()).getMaximumDividerLocation();
            }
        });
    }

    public int getMinimumDividerLocation() {
        return this.runMapping(new Operator.MapIntegerAction("getMinimumDividerLocation"){

            public int map() {
                return ((JSplitPane)JSplitPaneOperator.this.getSource()).getMinimumDividerLocation();
            }
        });
    }

    public int getOrientation() {
        return this.runMapping(new Operator.MapIntegerAction("getOrientation"){

            public int map() {
                return ((JSplitPane)JSplitPaneOperator.this.getSource()).getOrientation();
            }
        });
    }

    public Component getRightComponent() {
        return (Component)this.runMapping(new Operator.MapAction("getRightComponent"){

            public Object map() {
                return ((JSplitPane)JSplitPaneOperator.this.getSource()).getRightComponent();
            }
        });
    }

    public Component getTopComponent() {
        return (Component)this.runMapping(new Operator.MapAction("getTopComponent"){

            public Object map() {
                return ((JSplitPane)JSplitPaneOperator.this.getSource()).getTopComponent();
            }
        });
    }

    public SplitPaneUI getUI() {
        return (SplitPaneUI)this.runMapping(new Operator.MapAction("getUI"){

            public Object map() {
                return ((JSplitPane)JSplitPaneOperator.this.getSource()).getUI();
            }
        });
    }

    public boolean isContinuousLayout() {
        return this.runMapping(new Operator.MapBooleanAction("isContinuousLayout"){

            public boolean map() {
                return ((JSplitPane)JSplitPaneOperator.this.getSource()).isContinuousLayout();
            }
        });
    }

    public boolean isOneTouchExpandable() {
        return this.runMapping(new Operator.MapBooleanAction("isOneTouchExpandable"){

            public boolean map() {
                return ((JSplitPane)JSplitPaneOperator.this.getSource()).isOneTouchExpandable();
            }
        });
    }

    public void resetToPreferredSizes() {
        this.runMapping(new Operator.MapVoidAction("resetToPreferredSizes"){

            public void map() {
                ((JSplitPane)JSplitPaneOperator.this.getSource()).resetToPreferredSizes();
            }
        });
    }

    public void setBottomComponent(final Component component) {
        this.runMapping(new Operator.MapVoidAction("setBottomComponent"){

            public void map() {
                ((JSplitPane)JSplitPaneOperator.this.getSource()).setBottomComponent(component);
            }
        });
    }

    public void setContinuousLayout(final boolean bl) {
        this.runMapping(new Operator.MapVoidAction("setContinuousLayout"){

            public void map() {
                ((JSplitPane)JSplitPaneOperator.this.getSource()).setContinuousLayout(bl);
            }
        });
    }

    public void setDividerLocation(final double d) {
        this.runMapping(new Operator.MapVoidAction("setDividerLocation"){

            public void map() {
                ((JSplitPane)JSplitPaneOperator.this.getSource()).setDividerLocation(d);
            }
        });
    }

    public void setDividerLocation(final int n) {
        this.runMapping(new Operator.MapVoidAction("setDividerLocation"){

            public void map() {
                ((JSplitPane)JSplitPaneOperator.this.getSource()).setDividerLocation(n);
            }
        });
    }

    public void setDividerSize(final int n) {
        this.runMapping(new Operator.MapVoidAction("setDividerSize"){

            public void map() {
                ((JSplitPane)JSplitPaneOperator.this.getSource()).setDividerSize(n);
            }
        });
    }

    public void setLastDividerLocation(final int n) {
        this.runMapping(new Operator.MapVoidAction("setLastDividerLocation"){

            public void map() {
                ((JSplitPane)JSplitPaneOperator.this.getSource()).setLastDividerLocation(n);
            }
        });
    }

    public void setLeftComponent(final Component component) {
        this.runMapping(new Operator.MapVoidAction("setLeftComponent"){

            public void map() {
                ((JSplitPane)JSplitPaneOperator.this.getSource()).setLeftComponent(component);
            }
        });
    }

    public void setOneTouchExpandable(final boolean bl) {
        this.runMapping(new Operator.MapVoidAction("setOneTouchExpandable"){

            public void map() {
                ((JSplitPane)JSplitPaneOperator.this.getSource()).setOneTouchExpandable(bl);
            }
        });
    }

    public void setOrientation(final int n) {
        this.runMapping(new Operator.MapVoidAction("setOrientation"){

            public void map() {
                ((JSplitPane)JSplitPaneOperator.this.getSource()).setOrientation(n);
            }
        });
    }

    public void setRightComponent(final Component component) {
        this.runMapping(new Operator.MapVoidAction("setRightComponent"){

            public void map() {
                ((JSplitPane)JSplitPaneOperator.this.getSource()).setRightComponent(component);
            }
        });
    }

    public void setTopComponent(final Component component) {
        this.runMapping(new Operator.MapVoidAction("setTopComponent"){

            public void map() {
                ((JSplitPane)JSplitPaneOperator.this.getSource()).setTopComponent(component);
            }
        });
    }

    public void setUI(final SplitPaneUI splitPaneUI) {
        this.runMapping(new Operator.MapVoidAction("setUI"){

            public void map() {
                ((JSplitPane)JSplitPaneOperator.this.getSource()).setUI(splitPaneUI);
            }
        });
    }

    private void expandTo(int n) {
        this.makeComponentVisible();
        JButtonOperator jButtonOperator = new JButtonOperator((JButton)this.getDivider().waitSubComponent(new JButtonOperator.JButtonFinder(ComponentSearcher.getTrueChooser("JButton")), n));
        jButtonOperator.copyEnvironment(this.getDivider());
        jButtonOperator.setVisualizer(new EmptyVisualizer());
        jButtonOperator.push();
    }

    static {
        Timeouts.initDefault("JSplitPaneOperator.ScrollClickTimeout", 0L);
        Timeouts.initDefault("JSplitPaneOperator.BetweenClickTimeout", 0L);
        Timeouts.initDefault("JSplitPaneOperator.WholeScrollTimeout", 60000L);
    }

    private class ValueScrollAdjuster
    implements ScrollAdjuster {
        int value;

        public ValueScrollAdjuster(int n) {
            this.value = n;
        }

        public int getScrollDirection() {
            if (JSplitPaneOperator.this.getDividerLocation() == this.value) {
                return 0;
            }
            return JSplitPaneOperator.this.getDividerLocation() < this.value ? 1 : -1;
        }

        public int getScrollOrientation() {
            return JSplitPaneOperator.this.getOrientation();
        }

        public String getDescription() {
            return "Scroll to " + Integer.toString(this.value) + " value";
        }
    }

    public static class JSplitPaneFinder
    extends Operator.Finder {
        public JSplitPaneFinder(ComponentChooser componentChooser) {
            super(class$javax$swing$JSplitPane == null ? (class$javax$swing$JSplitPane = JSplitPaneOperator.class$("javax.swing.JSplitPane")) : class$javax$swing$JSplitPane, componentChooser);
        }

        public JSplitPaneFinder() {
            super(class$javax$swing$JSplitPane == null ? (class$javax$swing$JSplitPane = JSplitPaneOperator.class$("javax.swing.JSplitPane")) : class$javax$swing$JSplitPane);
        }
    }
}

