/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.operators;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.AdjustmentListener;
import java.util.Hashtable;
import javax.swing.BoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JScrollBar;
import javax.swing.plaf.ScrollBarUI;
import org.netbeans.jemmy.Action;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.ComponentSearcher;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Timeoutable;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.drivers.DriverManager;
import org.netbeans.jemmy.drivers.ScrollDriver;
import org.netbeans.jemmy.drivers.scrolling.ScrollAdjuster;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JComponentOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.jemmy.util.EmptyVisualizer;

public class JScrollBarOperator
extends JComponentOperator
implements Timeoutable,
Outputable {
    public static final String MINIMUM_DPROP = "Minimum";
    public static final String MAXIMUM_DPROP = "Maximum";
    public static final String VALUE_DPROP = "Value";
    public static final String ORIENTATION_DPROP = "Orientation";
    public static final String HORIZONTAL_ORIENTATION_DPROP_VALUE = "HORIZONTAL";
    public static final String VERTICAL_ORIENTATION_DPROP_VALUE = "VERTICAL";
    private static final long ONE_SCROLL_CLICK_TIMEOUT = 0L;
    private static final long WHOLE_SCROLL_TIMEOUT = 60000L;
    private static final long BEFORE_DROP_TIMEOUT = 0L;
    private static final long DRAG_AND_DROP_SCROLLING_DELTA = 0L;
    private static final int MINIMAL_PAD_SIZE = 10;
    private static final int MINIMAL_DRAGGER_SIZE = 5;
    private Timeouts timeouts;
    private TestOut output;
    private JButtonOperator minButtOperator;
    private JButtonOperator maxButtOperator;
    private ScrollDriver driver = DriverManager.getScrollDriver(this.getClass());
    static /* synthetic */ Class class$javax$swing$JScrollBar;

    public JScrollBarOperator(JScrollBar jScrollBar) {
        super(jScrollBar);
    }

    public JScrollBarOperator(ContainerOperator containerOperator, ComponentChooser componentChooser, int n) {
        this((JScrollBar)containerOperator.waitSubComponent(new JScrollBarFinder(componentChooser), n));
        this.copyEnvironment(containerOperator);
    }

    public JScrollBarOperator(ContainerOperator containerOperator, ComponentChooser componentChooser) {
        this(containerOperator, componentChooser, 0);
    }

    public JScrollBarOperator(ContainerOperator containerOperator, int n) {
        this((JScrollBar)JScrollBarOperator.waitComponent(containerOperator, (ComponentChooser)new JScrollBarFinder(), n));
        this.copyEnvironment(containerOperator);
    }

    public JScrollBarOperator(ContainerOperator containerOperator) {
        this(containerOperator, 0);
    }

    public static JScrollBar findJScrollBar(Container container, ComponentChooser componentChooser, int n) {
        return (JScrollBar)JScrollBarOperator.findComponent(container, new JScrollBarFinder(componentChooser), n);
    }

    public static JScrollBar findJScrollBar(Container container, ComponentChooser componentChooser) {
        return JScrollBarOperator.findJScrollBar(container, componentChooser, 0);
    }

    public static JScrollBar findJScrollBar(Container container, int n) {
        return JScrollBarOperator.findJScrollBar(container, ComponentSearcher.getTrueChooser(Integer.toString(n) + "'th JScrollBar instance"), n);
    }

    public static JScrollBar findJScrollBar(Container container) {
        return JScrollBarOperator.findJScrollBar(container, 0);
    }

    public static JScrollBar waitJScrollBar(Container container, ComponentChooser componentChooser, int n) {
        return (JScrollBar)JScrollBarOperator.waitComponent(container, (ComponentChooser)new JScrollBarFinder(componentChooser), n);
    }

    public static JScrollBar waitJScrollBar(Container container, ComponentChooser componentChooser) {
        return JScrollBarOperator.waitJScrollBar(container, componentChooser, 0);
    }

    public static JScrollBar waitJScrollBar(Container container, int n) {
        return JScrollBarOperator.waitJScrollBar(container, ComponentSearcher.getTrueChooser(Integer.toString(n) + "'th JScrollBar instance"), n);
    }

    public static JScrollBar waitJScrollBar(Container container) {
        return JScrollBarOperator.waitJScrollBar(container, 0);
    }

    public void setOutput(TestOut testOut) {
        this.output = testOut;
        super.setOutput(this.output.createErrorOutput());
    }

    public TestOut getOutput() {
        return this.output;
    }

    public void setTimeouts(Timeouts timeouts) {
        this.timeouts = timeouts;
        super.setTimeouts(timeouts);
    }

    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    public void copyEnvironment(Operator operator) {
        super.copyEnvironment(operator);
        this.driver = (ScrollDriver)DriverManager.getDriver("drivers.scroll", this.getClass(), operator.getProperties());
    }

    public void scroll(boolean bl) {
        this.scrollToValue(this.getValue() + (bl ? 1 : -1));
    }

    public void scrollTo(Waitable waitable, Object object, boolean bl) {
        this.scrollTo(new WaitableChecker(waitable, object, bl, this));
    }

    public void scrollTo(ScrollChecker scrollChecker) {
        this.scrollTo(new CheckerAdjustable(scrollChecker, this));
    }

    public void scrollTo(final ScrollAdjuster scrollAdjuster) {
        this.initOperators();
        this.produceTimeRestricted(new Action(){

            public Object launch(Object object) {
                JScrollBarOperator.this.driver.scroll(JScrollBarOperator.this, scrollAdjuster);
                return null;
            }

            public String getDescription() {
                return "Scrolling";
            }
        }, this.getTimeouts().getTimeout("JScrollBarOperator.WholeScrollTimeout"));
    }

    public void scrollToValue(int n) {
        this.output.printTrace("Scroll JScrollBar to " + Integer.toString(n) + " value\n" + this.toStringSource());
        this.output.printGolden("Scroll JScrollBar to " + Integer.toString(n) + " value");
        this.scrollTo(new ValueScrollAdjuster(n));
    }

    public void scrollToValue(double d) {
        this.output.printTrace("Scroll JScrollBar to " + Double.toString(d) + " proportional value\n" + this.toStringSource());
        this.output.printGolden("Scroll JScrollBar to " + Double.toString(d) + " proportional value");
        this.scrollTo(new ValueScrollAdjuster((int)((double)this.getMinimum() + (double)(this.getMaximum() - this.getVisibleAmount() - this.getMinimum()) * d)));
    }

    public void scrollToMinimum() {
        this.output.printTrace("Scroll JScrollBar to minimum value\n" + this.toStringSource());
        this.output.printGolden("Scroll JScrollBar to minimum value");
        this.initOperators();
        this.produceTimeRestricted(new Action(){

            public Object launch(Object object) {
                JScrollBarOperator.this.driver.scrollToMinimum(JScrollBarOperator.this, JScrollBarOperator.this.getOrientation());
                return null;
            }

            public String getDescription() {
                return "Scrolling";
            }
        }, this.getTimeouts().getTimeout("JScrollBarOperator.WholeScrollTimeout"));
    }

    public void scrollToMaximum() {
        this.output.printTrace("Scroll JScrollBar to maximum value\n" + this.toStringSource());
        this.output.printGolden("Scroll JScrollBar to maximum value");
        this.initOperators();
        this.produceTimeRestricted(new Action(){

            public Object launch(Object object) {
                JScrollBarOperator.this.driver.scrollToMaximum(JScrollBarOperator.this, JScrollBarOperator.this.getOrientation());
                return null;
            }

            public String getDescription() {
                return "Scrolling";
            }
        }, this.getTimeouts().getTimeout("JScrollBarOperator.WholeScrollTimeout"));
    }

    public JButtonOperator getDecreaseButton() {
        this.initOperators();
        return this.minButtOperator;
    }

    public JButtonOperator getIncreaseButton() {
        this.initOperators();
        return this.maxButtOperator;
    }

    public Hashtable getDump() {
        Hashtable hashtable = super.getDump();
        hashtable.put(MINIMUM_DPROP, Integer.toString(((JScrollBar)this.getSource()).getMinimum()));
        hashtable.put(MAXIMUM_DPROP, Integer.toString(((JScrollBar)this.getSource()).getMaximum()));
        hashtable.put(ORIENTATION_DPROP, ((JScrollBar)this.getSource()).getOrientation() == 0 ? HORIZONTAL_ORIENTATION_DPROP_VALUE : VERTICAL_ORIENTATION_DPROP_VALUE);
        hashtable.put(VALUE_DPROP, Integer.toString(((JScrollBar)this.getSource()).getValue()));
        return hashtable;
    }

    public void addAdjustmentListener(final AdjustmentListener adjustmentListener) {
        this.runMapping(new Operator.MapVoidAction("addAdjustmentListener"){

            public void map() {
                ((JScrollBar)JScrollBarOperator.this.getSource()).addAdjustmentListener(adjustmentListener);
            }
        });
    }

    public int getBlockIncrement() {
        return this.runMapping(new Operator.MapIntegerAction("getBlockIncrement"){

            public int map() {
                return ((JScrollBar)JScrollBarOperator.this.getSource()).getBlockIncrement();
            }
        });
    }

    public int getBlockIncrement(final int n) {
        return this.runMapping(new Operator.MapIntegerAction("getBlockIncrement"){

            public int map() {
                return ((JScrollBar)JScrollBarOperator.this.getSource()).getBlockIncrement(n);
            }
        });
    }

    public int getMaximum() {
        return this.runMapping(new Operator.MapIntegerAction("getMaximum"){

            public int map() {
                return ((JScrollBar)JScrollBarOperator.this.getSource()).getMaximum();
            }
        });
    }

    public int getMinimum() {
        return this.runMapping(new Operator.MapIntegerAction("getMinimum"){

            public int map() {
                return ((JScrollBar)JScrollBarOperator.this.getSource()).getMinimum();
            }
        });
    }

    public BoundedRangeModel getModel() {
        return (BoundedRangeModel)this.runMapping(new Operator.MapAction("getModel"){

            public Object map() {
                return ((JScrollBar)JScrollBarOperator.this.getSource()).getModel();
            }
        });
    }

    public int getOrientation() {
        return this.runMapping(new Operator.MapIntegerAction("getOrientation"){

            public int map() {
                return ((JScrollBar)JScrollBarOperator.this.getSource()).getOrientation();
            }
        });
    }

    public ScrollBarUI getUI() {
        return (ScrollBarUI)this.runMapping(new Operator.MapAction("getUI"){

            public Object map() {
                return ((JScrollBar)JScrollBarOperator.this.getSource()).getUI();
            }
        });
    }

    public int getUnitIncrement() {
        return this.runMapping(new Operator.MapIntegerAction("getUnitIncrement"){

            public int map() {
                return ((JScrollBar)JScrollBarOperator.this.getSource()).getUnitIncrement();
            }
        });
    }

    public int getUnitIncrement(final int n) {
        return this.runMapping(new Operator.MapIntegerAction("getUnitIncrement"){

            public int map() {
                return ((JScrollBar)JScrollBarOperator.this.getSource()).getUnitIncrement(n);
            }
        });
    }

    public int getValue() {
        return this.runMapping(new Operator.MapIntegerAction("getValue"){

            public int map() {
                return ((JScrollBar)JScrollBarOperator.this.getSource()).getValue();
            }
        });
    }

    public boolean getValueIsAdjusting() {
        return this.runMapping(new Operator.MapBooleanAction("getValueIsAdjusting"){

            public boolean map() {
                return ((JScrollBar)JScrollBarOperator.this.getSource()).getValueIsAdjusting();
            }
        });
    }

    public int getVisibleAmount() {
        return this.runMapping(new Operator.MapIntegerAction("getVisibleAmount"){

            public int map() {
                return ((JScrollBar)JScrollBarOperator.this.getSource()).getVisibleAmount();
            }
        });
    }

    public void removeAdjustmentListener(final AdjustmentListener adjustmentListener) {
        this.runMapping(new Operator.MapVoidAction("removeAdjustmentListener"){

            public void map() {
                ((JScrollBar)JScrollBarOperator.this.getSource()).removeAdjustmentListener(adjustmentListener);
            }
        });
    }

    public void setBlockIncrement(final int n) {
        this.runMapping(new Operator.MapVoidAction("setBlockIncrement"){

            public void map() {
                ((JScrollBar)JScrollBarOperator.this.getSource()).setBlockIncrement(n);
            }
        });
    }

    public void setMaximum(final int n) {
        this.runMapping(new Operator.MapVoidAction("setMaximum"){

            public void map() {
                ((JScrollBar)JScrollBarOperator.this.getSource()).setMaximum(n);
            }
        });
    }

    public void setMinimum(final int n) {
        this.runMapping(new Operator.MapVoidAction("setMinimum"){

            public void map() {
                ((JScrollBar)JScrollBarOperator.this.getSource()).setMinimum(n);
            }
        });
    }

    public void setModel(final BoundedRangeModel boundedRangeModel) {
        this.runMapping(new Operator.MapVoidAction("setModel"){

            public void map() {
                ((JScrollBar)JScrollBarOperator.this.getSource()).setModel(boundedRangeModel);
            }
        });
    }

    public void setOrientation(final int n) {
        this.runMapping(new Operator.MapVoidAction("setOrientation"){

            public void map() {
                ((JScrollBar)JScrollBarOperator.this.getSource()).setOrientation(n);
            }
        });
    }

    public void setUnitIncrement(final int n) {
        this.runMapping(new Operator.MapVoidAction("setUnitIncrement"){

            public void map() {
                ((JScrollBar)JScrollBarOperator.this.getSource()).setUnitIncrement(n);
            }
        });
    }

    public void setValue(final int n) {
        this.runMapping(new Operator.MapVoidAction("setValue"){

            public void map() {
                ((JScrollBar)JScrollBarOperator.this.getSource()).setValue(n);
            }
        });
    }

    public void setValueIsAdjusting(final boolean bl) {
        this.runMapping(new Operator.MapVoidAction("setValueIsAdjusting"){

            public void map() {
                ((JScrollBar)JScrollBarOperator.this.getSource()).setValueIsAdjusting(bl);
            }
        });
    }

    public void setValues(final int n, final int n2, final int n3, final int n4) {
        this.runMapping(new Operator.MapVoidAction("setValues"){

            public void map() {
                ((JScrollBar)JScrollBarOperator.this.getSource()).setValues(n, n2, n3, n4);
            }
        });
    }

    public void setVisibleAmount(final int n) {
        this.runMapping(new Operator.MapVoidAction("setVisibleAmount"){

            public void map() {
                ((JScrollBar)JScrollBarOperator.this.getSource()).setVisibleAmount(n);
            }
        });
    }

    private void initOperators() {
        JButton jButton;
        JButton jButton2;
        if (this.minButtOperator != null && this.maxButtOperator != null) {
            return;
        }
        ComponentChooser componentChooser = new ComponentChooser(){

            public boolean checkComponent(Component component) {
                return component instanceof JButton;
            }

            public String getDescription() {
                return "";
            }
        };
        ComponentSearcher componentSearcher = new ComponentSearcher((Container)this.getSource());
        componentSearcher.setOutput(this.output.createErrorOutput());
        JButton jButton3 = (JButton)componentSearcher.findComponent(componentChooser, 0);
        JButton jButton4 = (JButton)componentSearcher.findComponent(componentChooser, 1);
        if (jButton3 == null || jButton4 == null) {
            this.minButtOperator = null;
            this.maxButtOperator = null;
            return;
        }
        if (((JScrollBar)this.getSource()).getOrientation() == 0) {
            if (jButton3.getX() < jButton4.getX()) {
                jButton2 = jButton3;
                jButton = jButton4;
            } else {
                jButton2 = jButton4;
                jButton = jButton3;
            }
        } else if (jButton3.getY() < jButton4.getY()) {
            jButton2 = jButton3;
            jButton = jButton4;
        } else {
            jButton2 = jButton4;
            jButton = jButton3;
        }
        this.minButtOperator = new JButtonOperator(jButton2);
        this.maxButtOperator = new JButtonOperator(jButton);
        this.minButtOperator.copyEnvironment(this);
        this.maxButtOperator.copyEnvironment(this);
        this.minButtOperator.setOutput(this.output.createErrorOutput());
        this.maxButtOperator.setOutput(this.output.createErrorOutput());
        Timeouts timeouts = this.timeouts.cloneThis();
        timeouts.setTimeout("AbstractButtonOperator.PushButtonTimeout", timeouts.getTimeout("JScrollBarOperator.OneScrollClickTimeout"));
        this.minButtOperator.setTimeouts(timeouts);
        this.maxButtOperator.setTimeouts(timeouts);
        this.minButtOperator.setVisualizer(new EmptyVisualizer());
        this.maxButtOperator.setVisualizer(new EmptyVisualizer());
    }

    static {
        Timeouts.initDefault("JScrollBarOperator.OneScrollClickTimeout", 0L);
        Timeouts.initDefault("JScrollBarOperator.WholeScrollTimeout", 60000L);
        Timeouts.initDefault("JScrollBarOperator.BeforeDropTimeout", 0L);
        Timeouts.initDefault("JScrollBarOperator.DragAndDropScrollingDelta", 0L);
    }

    public static class JScrollBarFinder
    extends Operator.Finder {
        public JScrollBarFinder(ComponentChooser componentChooser) {
            super(class$javax$swing$JScrollBar == null ? (class$javax$swing$JScrollBar = JScrollBarOperator.class$("javax.swing.JScrollBar")) : class$javax$swing$JScrollBar, componentChooser);
        }

        public JScrollBarFinder() {
            super(class$javax$swing$JScrollBar == null ? (class$javax$swing$JScrollBar = JScrollBarOperator.class$("javax.swing.JScrollBar")) : class$javax$swing$JScrollBar);
        }
    }

    private class CheckerAdjustable
    implements ScrollAdjuster {
        ScrollChecker checker;
        JScrollBarOperator oper;

        public CheckerAdjustable(ScrollChecker scrollChecker, JScrollBarOperator jScrollBarOperator2) {
            this.checker = scrollChecker;
            this.oper = jScrollBarOperator2;
        }

        public int getScrollDirection() {
            return this.checker.getScrollDirection(this.oper);
        }

        public int getScrollOrientation() {
            return JScrollBarOperator.this.getOrientation();
        }

        public String getDescription() {
            return this.checker.getDescription();
        }
    }

    private class WaitableChecker
    implements ScrollAdjuster {
        Waitable w;
        Object waitParam;
        boolean increase;
        boolean reached = false;
        JScrollBarOperator oper;

        public WaitableChecker(Waitable waitable, Object object, boolean bl, JScrollBarOperator jScrollBarOperator2) {
            this.w = waitable;
            this.waitParam = object;
            this.increase = bl;
            this.oper = jScrollBarOperator2;
        }

        public int getScrollDirection() {
            if (!this.reached && this.w.actionProduced(this.waitParam) != null) {
                this.reached = true;
            }
            if (this.reached) {
                return 0;
            }
            return this.increase ? 1 : -1;
        }

        public int getScrollOrientation() {
            return JScrollBarOperator.this.getOrientation();
        }

        public String getDescription() {
            return this.w.getDescription();
        }
    }

    private class ValueScrollAdjuster
    implements ScrollAdjuster {
        int value;

        public ValueScrollAdjuster(int n) {
            this.value = n;
        }

        public int getScrollDirection() {
            if (JScrollBarOperator.this.getValue() == this.value) {
                return 0;
            }
            return JScrollBarOperator.this.getValue() < this.value ? 1 : -1;
        }

        public int getScrollOrientation() {
            return JScrollBarOperator.this.getOrientation();
        }

        public String getDescription() {
            return "Scroll to " + Integer.toString(this.value) + " value";
        }
    }

    public static interface ScrollChecker {
        public int getScrollDirection(JScrollBarOperator var1);

        public String getDescription();
    }
}

