/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.operators;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SingleSelectionModel;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.PopupMenuUI;
import org.netbeans.jemmy.Action;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.ComponentSearcher;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Timeoutable;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.WindowWaiter;
import org.netbeans.jemmy.drivers.DriverManager;
import org.netbeans.jemmy.drivers.MenuDriver;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JComponentOperator;
import org.netbeans.jemmy.operators.JMenuItemOperator;
import org.netbeans.jemmy.operators.JMenuOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.jemmy.operators.WindowOperator;

public class JPopupMenuOperator
extends JComponentOperator
implements Outputable,
Timeoutable {
    public static final String LABEL_DPROP = "Label";
    private TestOut output;
    private Timeouts timeouts;
    private MenuDriver driver = DriverManager.getMenuDriver(this.getClass());
    static /* synthetic */ Class class$javax$swing$JPopupMenu;

    public JPopupMenuOperator(JPopupMenu jPopupMenu) {
        super(jPopupMenu);
    }

    public JPopupMenuOperator(ContainerOperator containerOperator, ComponentChooser componentChooser, int n) {
        this((JPopupMenu)containerOperator.waitSubComponent(new JPopupMenuFinder(componentChooser), n));
        this.copyEnvironment(containerOperator);
    }

    public JPopupMenuOperator(ContainerOperator containerOperator, ComponentChooser componentChooser) {
        this(containerOperator, componentChooser, 0);
    }

    public JPopupMenuOperator(Operator operator) {
        this((JPopupMenu)JPopupMenuOperator.waitComponent(WindowOperator.waitWindow(new JPopupWindowFinder(), 0, operator.getTimeouts(), operator.getOutput()), new JPopupMenuFinder(), 0, operator.getTimeouts(), operator.getOutput()));
        this.copyEnvironment(operator);
    }

    public JPopupMenuOperator(ContainerOperator containerOperator) {
        this((JPopupMenu)JPopupMenuOperator.waitComponent(containerOperator, (ComponentChooser)new JPopupMenuFinder(), 0));
        this.copyEnvironment(containerOperator);
    }

    public JPopupMenuOperator() {
        this(Operator.getEnvironmentOperator());
    }

    public static JPopupMenu findJPopupMenu(Container container, ComponentChooser componentChooser, int n) {
        return (JPopupMenu)JPopupMenuOperator.findComponent(container, new JPopupMenuFinder(componentChooser), n);
    }

    public static JPopupMenu findJPopupMenu(Container container, ComponentChooser componentChooser) {
        return JPopupMenuOperator.findJPopupMenu(container, componentChooser, 0);
    }

    public static JPopupMenu waitJPopupMenu(Container container, ComponentChooser componentChooser, int n) {
        return (JPopupMenu)JPopupMenuOperator.waitComponent(container, (ComponentChooser)new JPopupMenuFinder(componentChooser), n);
    }

    public static JPopupMenu waitJPopupMenu(Container container, ComponentChooser componentChooser) {
        return JPopupMenuOperator.waitJPopupMenu(container, componentChooser, 0);
    }

    public static Window findJPopupWindow(ComponentChooser componentChooser) {
        new WindowWaiter();
        return WindowWaiter.getWindow(new JPopupWindowFinder(componentChooser));
    }

    public static Window waitJPopupWindow(ComponentChooser componentChooser) {
        try {
            return new WindowWaiter().waitWindow(new JPopupWindowFinder(componentChooser));
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    public static JPopupMenuOperator waitJPopupMenu(final ComponentChooser componentChooser) {
        try {
            WindowOperator windowOperator = new WindowOperator(new WindowWaiter().waitWindow(new ComponentChooser(){

                public boolean checkComponent(Component component) {
                    ComponentSearcher componentSearcher = new ComponentSearcher((Container)component);
                    componentSearcher.setOutput(JemmyProperties.getCurrentOutput().createErrorOutput());
                    return componentSearcher.findComponent(componentChooser) != null;
                }

                public String getDescription() {
                    return "Window containing \"" + componentChooser.getDescription() + "\" popup";
                }
            }));
            return new JPopupMenuOperator(windowOperator);
        }
        catch (InterruptedException interruptedException) {
            throw new JemmyException("Popup waiting has been interrupted", interruptedException);
        }
    }

    public static JPopupMenuOperator waitJPopupMenu(final String string) {
        return JPopupMenuOperator.waitJPopupMenu(new ComponentChooser(){

            public boolean checkComponent(Component component) {
                if (component instanceof JPopupMenu) {
                    ComponentSearcher componentSearcher = new ComponentSearcher((Container)component);
                    componentSearcher.setOutput(JemmyProperties.getCurrentOutput().createErrorOutput());
                    return componentSearcher.findComponent(new JMenuItemOperator.JMenuItemByLabelFinder(string, Operator.getDefaultStringComparator())) != null;
                }
                return false;
            }

            public String getDescription() {
                return "Popup containing \"" + string + "\" menu item";
            }
        });
    }

    public static JPopupMenu callPopup(final ComponentOperator componentOperator, int n, int n2, int n3) {
        componentOperator.makeComponentVisible();
        if (System.getProperty("java.specification.version").compareTo("1.4") > 0) {
            QueueTool queueTool = new QueueTool();
            queueTool.setOutput(componentOperator.getOutput().createErrorOutput());
            queueTool.waitEmpty(10L);
            queueTool.waitEmpty(10L);
            queueTool.waitEmpty(10L);
        }
        componentOperator.clickForPopup(n, n2, n3);
        componentOperator.getTimeouts().sleep("JMenuOperator.WaitBeforePopupTimeout");
        return JPopupMenuOperator.waitJPopupMenu(JPopupMenuOperator.waitJPopupWindow(new ComponentChooser(){

            public boolean checkComponent(Component component) {
                Component component2 = ((JPopupMenu)component).getInvoker();
                return component2 == componentOperator.getSource() || component2 instanceof Container && ((Container)component2).isAncestorOf(componentOperator.getSource()) || componentOperator.getSource() instanceof Container && ((Container)componentOperator.getSource()).isAncestorOf(component2);
            }

            public String getDescription() {
                return "Popup menu";
            }
        }), ComponentSearcher.getTrueChooser("Popup menu"));
    }

    public static JPopupMenu callPopup(ComponentOperator componentOperator, int n, int n2) {
        return JPopupMenuOperator.callPopup(componentOperator, n, n2, JPopupMenuOperator.getPopupMouseButton());
    }

    public static JPopupMenu callPopup(Component component, int n, int n2, int n3) {
        return JPopupMenuOperator.callPopup(new ComponentOperator(component), n, n2, n3);
    }

    public static JPopupMenu callPopup(Component component, int n, int n2) {
        return JPopupMenuOperator.callPopup(component, n, n2, JPopupMenuOperator.getPopupMouseButton());
    }

    public static JPopupMenu callPopup(Component component, int n) {
        ComponentOperator componentOperator = new ComponentOperator(component);
        componentOperator.makeComponentVisible();
        componentOperator.clickForPopup(n);
        return JPopupMenuOperator.findJPopupMenu(JPopupMenuOperator.waitJPopupWindow(ComponentSearcher.getTrueChooser("Popup menu window")), ComponentSearcher.getTrueChooser("Popup menu"));
    }

    public static JPopupMenu callPopup(Component component) {
        return JPopupMenuOperator.callPopup(component, JPopupMenuOperator.getPopupMouseButton());
    }

    public void setOutput(TestOut testOut) {
        super.setOutput(testOut);
        this.output = testOut;
    }

    public TestOut getOutput() {
        return this.output;
    }

    public void setTimeouts(Timeouts timeouts) {
        super.setTimeouts(timeouts);
        this.timeouts = timeouts;
    }

    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    public void copyEnvironment(Operator operator) {
        super.copyEnvironment(operator);
        this.driver = DriverManager.getMenuDriver(this);
    }

    public JMenuItem pushMenu(final ComponentChooser[] componentChooserArray) {
        return (JMenuItem)this.produceTimeRestricted(new Action(){

            public Object launch(Object object) {
                JPopupMenuOperator.this.getQueueTool().waitEmpty();
                Object object2 = JPopupMenuOperator.this.driver.pushMenu(JPopupMenuOperator.this, JMenuOperator.converChoosers(componentChooserArray));
                JPopupMenuOperator.this.getQueueTool().waitEmpty();
                return object2;
            }

            public String getDescription() {
                return JMenuOperator.createDescription(componentChooserArray);
            }
        }, this.getTimeouts().getTimeout("JMenuOperator.PushMenuTimeout"));
    }

    public void pushMenuNoBlock(final ComponentChooser[] componentChooserArray) {
        this.produceNoBlocking(new Operator.NoBlockingAction("Menu pushing"){

            public Object doAction(Object object) {
                JPopupMenuOperator.this.getQueueTool().waitEmpty();
                Object object2 = JPopupMenuOperator.this.driver.pushMenu(JPopupMenuOperator.this, JMenuOperator.converChoosers(componentChooserArray));
                JPopupMenuOperator.this.getQueueTool().waitEmpty();
                return object2;
            }
        });
    }

    public JMenuItem pushMenu(String[] stringArray, Operator.StringComparator stringComparator) {
        return this.pushMenu(JMenuItemOperator.createChoosers(stringArray, stringComparator));
    }

    public JMenuItem pushMenu(String[] stringArray, boolean bl, boolean bl2) {
        return this.pushMenu(stringArray, (Operator.StringComparator)new Operator.DefaultStringComparator(bl, bl2));
    }

    public void pushMenuNoBlock(String[] stringArray, Operator.StringComparator stringComparator) {
        this.pushMenuNoBlock(JMenuItemOperator.createChoosers(stringArray, stringComparator));
    }

    public void pushMenuNoBlock(String[] stringArray, boolean bl, boolean bl2) {
        this.pushMenuNoBlock(stringArray, (Operator.StringComparator)new Operator.DefaultStringComparator(bl, bl2));
    }

    public JMenuItem pushMenu(String[] stringArray) {
        return this.pushMenu(stringArray, this.getComparator());
    }

    public void pushMenuNoBlock(String[] stringArray) {
        this.pushMenuNoBlock(stringArray, this.getComparator());
    }

    public JMenuItem pushMenu(String string, String string2, Operator.StringComparator stringComparator) {
        return this.pushMenu(this.parseString(string, string2), stringComparator);
    }

    public JMenuItem pushMenu(String string, Operator.StringComparator stringComparator) {
        return this.pushMenu(this.parseString(string), stringComparator);
    }

    public JMenuItem pushMenu(String string, String string2, boolean bl, boolean bl2) {
        return this.pushMenu(this.parseString(string, string2), bl, bl2);
    }

    public void pushMenuNoBlock(String string, String string2, Operator.StringComparator stringComparator) {
        this.pushMenuNoBlock(this.parseString(string, string2), stringComparator);
    }

    public void pushMenuNoBlock(String string, Operator.StringComparator stringComparator) {
        this.pushMenuNoBlock(this.parseString(string), stringComparator);
    }

    public void pushMenuNoBlock(String string, String string2, boolean bl, boolean bl2) {
        this.pushMenuNoBlock(this.parseString(string, string2), bl, bl2);
    }

    public JMenuItem pushMenu(String string, String string2) {
        return this.pushMenu(this.parseString(string, string2));
    }

    public JMenuItem pushMenu(String string) {
        return this.pushMenu(this.parseString(string));
    }

    public void pushMenuNoBlock(String string, String string2) {
        this.pushMenuNoBlock(this.parseString(string, string2));
    }

    public void pushMenuNoBlock(String string) {
        this.pushMenuNoBlock(this.parseString(string));
    }

    public JMenuItemOperator[] showMenuItems(ComponentChooser[] componentChooserArray) {
        if (componentChooserArray == null || componentChooserArray.length == 0) {
            return JMenuItemOperator.getMenuItems((MenuElement)((Object)this.getSource()), (Operator)this);
        }
        return JMenuItemOperator.getMenuItems((JMenu)this.pushMenu(componentChooserArray), (Operator)this);
    }

    public JMenuItemOperator[] showMenuItems(String[] stringArray, Operator.StringComparator stringComparator) {
        if (stringArray == null || stringArray.length == 0) {
            return JMenuItemOperator.getMenuItems((MenuElement)((Object)this.getSource()), (Operator)this);
        }
        return JMenuItemOperator.getMenuItems((JMenu)this.pushMenu(stringArray, stringComparator), (Operator)this);
    }

    public JMenuItemOperator[] showMenuItems(String[] stringArray) {
        return this.showMenuItems(stringArray, this.getComparator());
    }

    public JMenuItemOperator[] showMenuItems(String string, String string2, Operator.StringComparator stringComparator) {
        return this.showMenuItems(this.parseString(string, string2), stringComparator);
    }

    public JMenuItemOperator[] showMenuItems(String string, Operator.StringComparator stringComparator) {
        return this.showMenuItems(this.parseString(string), stringComparator);
    }

    public JMenuItemOperator[] showMenuItems(String string, String string2) {
        return this.showMenuItems(string, string2, this.getComparator());
    }

    public JMenuItemOperator[] showMenuItems(String string) {
        return this.showMenuItems(string, this.getComparator());
    }

    public JMenuItemOperator showMenuItem(ComponentChooser[] componentChooserArray) {
        ContainerOperator containerOperator;
        ComponentChooser[] componentChooserArray2 = this.getParentPath(componentChooserArray);
        if (componentChooserArray2.length > 0) {
            JMenu jMenu = (JMenu)this.pushMenu(this.getParentPath(componentChooserArray));
            containerOperator = new ContainerOperator(jMenu.getPopupMenu());
            containerOperator.copyEnvironment(this);
        } else {
            containerOperator = this;
        }
        JMenuItemOperator jMenuItemOperator = new JMenuItemOperator(containerOperator, componentChooserArray[componentChooserArray.length - 1]);
        jMenuItemOperator.copyEnvironment(this);
        return jMenuItemOperator;
    }

    public JMenuItemOperator showMenuItem(String[] stringArray, Operator.StringComparator stringComparator) {
        ContainerOperator containerOperator;
        String[] stringArray2 = this.getParentPath(stringArray);
        if (stringArray2.length > 0) {
            JMenu jMenu = (JMenu)this.pushMenu(this.getParentPath(stringArray), stringComparator);
            containerOperator = new ContainerOperator(jMenu.getPopupMenu());
            containerOperator.copyEnvironment(this);
        } else {
            containerOperator = this;
        }
        JMenuItemOperator jMenuItemOperator = new JMenuItemOperator(containerOperator, stringArray[stringArray.length - 1]);
        jMenuItemOperator.copyEnvironment(this);
        return jMenuItemOperator;
    }

    public JMenuItemOperator showMenuItem(String[] stringArray) {
        return this.showMenuItem(stringArray, this.getComparator());
    }

    public JMenuItemOperator showMenuItem(String string, String string2, Operator.StringComparator stringComparator) {
        return this.showMenuItem(this.parseString(string, string2), stringComparator);
    }

    public JMenuItemOperator showMenuItem(String string, Operator.StringComparator stringComparator) {
        return this.showMenuItem(this.parseString(string), stringComparator);
    }

    public JMenuItemOperator showMenuItem(String string, String string2) {
        return this.showMenuItem(string, string2, this.getComparator());
    }

    public JMenuItemOperator showMenuItem(String string) {
        return this.showMenuItem(string, this.getComparator());
    }

    public Hashtable getDump() {
        Hashtable hashtable = super.getDump();
        if (((JPopupMenu)this.getSource()).getLabel() != null) {
            hashtable.put(LABEL_DPROP, ((JPopupMenu)this.getSource()).getLabel());
        }
        return hashtable;
    }

    public JMenuItem add(final String string) {
        return (JMenuItem)this.runMapping(new Operator.MapAction("add"){

            public Object map() {
                return ((JPopupMenu)JPopupMenuOperator.this.getSource()).add(string);
            }
        });
    }

    public JMenuItem add(final javax.swing.Action action) {
        return (JMenuItem)this.runMapping(new Operator.MapAction("add"){

            public Object map() {
                return ((JPopupMenu)JPopupMenuOperator.this.getSource()).add(action);
            }
        });
    }

    public JMenuItem add(final JMenuItem jMenuItem) {
        return (JMenuItem)this.runMapping(new Operator.MapAction("add"){

            public Object map() {
                return ((JPopupMenu)JPopupMenuOperator.this.getSource()).add(jMenuItem);
            }
        });
    }

    public void addPopupMenuListener(final PopupMenuListener popupMenuListener) {
        this.runMapping(new Operator.MapVoidAction("addPopupMenuListener"){

            public void map() {
                ((JPopupMenu)JPopupMenuOperator.this.getSource()).addPopupMenuListener(popupMenuListener);
            }
        });
    }

    public void addSeparator() {
        this.runMapping(new Operator.MapVoidAction("addSeparator"){

            public void map() {
                ((JPopupMenu)JPopupMenuOperator.this.getSource()).addSeparator();
            }
        });
    }

    public int getComponentIndex(final Component component) {
        return this.runMapping(new Operator.MapIntegerAction("getComponentIndex"){

            public int map() {
                return ((JPopupMenu)JPopupMenuOperator.this.getSource()).getComponentIndex(component);
            }
        });
    }

    public Component getInvoker() {
        return (Component)this.runMapping(new Operator.MapAction("getInvoker"){

            public Object map() {
                return ((JPopupMenu)JPopupMenuOperator.this.getSource()).getInvoker();
            }
        });
    }

    public String getLabel() {
        return (String)this.runMapping(new Operator.MapAction("getLabel"){

            public Object map() {
                return ((JPopupMenu)JPopupMenuOperator.this.getSource()).getLabel();
            }
        });
    }

    public Insets getMargin() {
        return (Insets)this.runMapping(new Operator.MapAction("getMargin"){

            public Object map() {
                return ((JPopupMenu)JPopupMenuOperator.this.getSource()).getMargin();
            }
        });
    }

    public SingleSelectionModel getSelectionModel() {
        return (SingleSelectionModel)this.runMapping(new Operator.MapAction("getSelectionModel"){

            public Object map() {
                return ((JPopupMenu)JPopupMenuOperator.this.getSource()).getSelectionModel();
            }
        });
    }

    public MenuElement[] getSubElements() {
        return (MenuElement[])this.runMapping(new Operator.MapAction("getSubElements"){

            public Object map() {
                return ((JPopupMenu)JPopupMenuOperator.this.getSource()).getSubElements();
            }
        });
    }

    public PopupMenuUI getUI() {
        return (PopupMenuUI)this.runMapping(new Operator.MapAction("getUI"){

            public Object map() {
                return ((JPopupMenu)JPopupMenuOperator.this.getSource()).getUI();
            }
        });
    }

    public void insert(final Component component, final int n) {
        this.runMapping(new Operator.MapVoidAction("insert"){

            public void map() {
                ((JPopupMenu)JPopupMenuOperator.this.getSource()).insert(component, n);
            }
        });
    }

    public void insert(final javax.swing.Action action, final int n) {
        this.runMapping(new Operator.MapVoidAction("insert"){

            public void map() {
                ((JPopupMenu)JPopupMenuOperator.this.getSource()).insert(action, n);
            }
        });
    }

    public boolean isBorderPainted() {
        return this.runMapping(new Operator.MapBooleanAction("isBorderPainted"){

            public boolean map() {
                return ((JPopupMenu)JPopupMenuOperator.this.getSource()).isBorderPainted();
            }
        });
    }

    public boolean isLightWeightPopupEnabled() {
        return this.runMapping(new Operator.MapBooleanAction("isLightWeightPopupEnabled"){

            public boolean map() {
                return ((JPopupMenu)JPopupMenuOperator.this.getSource()).isLightWeightPopupEnabled();
            }
        });
    }

    public void menuSelectionChanged(final boolean bl) {
        this.runMapping(new Operator.MapVoidAction("menuSelectionChanged"){

            public void map() {
                ((JPopupMenu)JPopupMenuOperator.this.getSource()).menuSelectionChanged(bl);
            }
        });
    }

    public void pack() {
        this.runMapping(new Operator.MapVoidAction("pack"){

            public void map() {
                ((JPopupMenu)JPopupMenuOperator.this.getSource()).pack();
            }
        });
    }

    public void processKeyEvent(final KeyEvent keyEvent, final MenuElement[] menuElementArray, final MenuSelectionManager menuSelectionManager) {
        this.runMapping(new Operator.MapVoidAction("processKeyEvent"){

            public void map() {
                ((JPopupMenu)JPopupMenuOperator.this.getSource()).processKeyEvent(keyEvent, menuElementArray, menuSelectionManager);
            }
        });
    }

    public void processMouseEvent(final MouseEvent mouseEvent, final MenuElement[] menuElementArray, final MenuSelectionManager menuSelectionManager) {
        this.runMapping(new Operator.MapVoidAction("processMouseEvent"){

            public void map() {
                ((JPopupMenu)JPopupMenuOperator.this.getSource()).processMouseEvent(mouseEvent, menuElementArray, menuSelectionManager);
            }
        });
    }

    public void removePopupMenuListener(final PopupMenuListener popupMenuListener) {
        this.runMapping(new Operator.MapVoidAction("removePopupMenuListener"){

            public void map() {
                ((JPopupMenu)JPopupMenuOperator.this.getSource()).removePopupMenuListener(popupMenuListener);
            }
        });
    }

    public void setBorderPainted(final boolean bl) {
        this.runMapping(new Operator.MapVoidAction("setBorderPainted"){

            public void map() {
                ((JPopupMenu)JPopupMenuOperator.this.getSource()).setBorderPainted(bl);
            }
        });
    }

    public void setInvoker(final Component component) {
        this.runMapping(new Operator.MapVoidAction("setInvoker"){

            public void map() {
                ((JPopupMenu)JPopupMenuOperator.this.getSource()).setInvoker(component);
            }
        });
    }

    public void setLabel(final String string) {
        this.runMapping(new Operator.MapVoidAction("setLabel"){

            public void map() {
                ((JPopupMenu)JPopupMenuOperator.this.getSource()).setLabel(string);
            }
        });
    }

    public void setLightWeightPopupEnabled(final boolean bl) {
        this.runMapping(new Operator.MapVoidAction("setLightWeightPopupEnabled"){

            public void map() {
                ((JPopupMenu)JPopupMenuOperator.this.getSource()).setLightWeightPopupEnabled(bl);
            }
        });
    }

    public void setPopupSize(final int n, final int n2) {
        this.runMapping(new Operator.MapVoidAction("setPopupSize"){

            public void map() {
                ((JPopupMenu)JPopupMenuOperator.this.getSource()).setPopupSize(n, n2);
            }
        });
    }

    public void setPopupSize(final Dimension dimension) {
        this.runMapping(new Operator.MapVoidAction("setPopupSize"){

            public void map() {
                ((JPopupMenu)JPopupMenuOperator.this.getSource()).setPopupSize(dimension);
            }
        });
    }

    public void setSelected(final Component component) {
        this.runMapping(new Operator.MapVoidAction("setSelected"){

            public void map() {
                ((JPopupMenu)JPopupMenuOperator.this.getSource()).setSelected(component);
            }
        });
    }

    public void setSelectionModel(final SingleSelectionModel singleSelectionModel) {
        this.runMapping(new Operator.MapVoidAction("setSelectionModel"){

            public void map() {
                ((JPopupMenu)JPopupMenuOperator.this.getSource()).setSelectionModel(singleSelectionModel);
            }
        });
    }

    public void setUI(final PopupMenuUI popupMenuUI) {
        this.runMapping(new Operator.MapVoidAction("setUI"){

            public void map() {
                ((JPopupMenu)JPopupMenuOperator.this.getSource()).setUI(popupMenuUI);
            }
        });
    }

    public void show(final Component component, final int n, final int n2) {
        this.runMapping(new Operator.MapVoidAction("show"){

            public void map() {
                ((JPopupMenu)JPopupMenuOperator.this.getSource()).show(component, n, n2);
            }
        });
    }

    static {
        JMenuOperator.class.getName();
    }

    public static class JPopupWindowFinder
    implements ComponentChooser {
        ComponentChooser subFinder;
        ComponentChooser ppFinder;

        public JPopupWindowFinder(ComponentChooser componentChooser) {
            this.subFinder = new JPopupMenuFinder(componentChooser);
            this.ppFinder = new ComponentChooser(){

                public boolean checkComponent(Component component) {
                    return component.isShowing() && component.isVisible() && JPopupWindowFinder.this.subFinder.checkComponent(component);
                }

                public String getDescription() {
                    return JPopupWindowFinder.this.subFinder.getDescription();
                }
            };
        }

        public JPopupWindowFinder() {
            this(ComponentSearcher.getTrueChooser("Any JPopupWindow"));
        }

        public boolean checkComponent(Component component) {
            if (component.isShowing() && component instanceof Window) {
                ComponentSearcher componentSearcher = new ComponentSearcher((Container)component);
                componentSearcher.setOutput(JemmyProperties.getCurrentOutput().createErrorOutput());
                return componentSearcher.findComponent(this.ppFinder) != null;
            }
            return false;
        }

        public String getDescription() {
            return this.subFinder.getDescription();
        }
    }

    public static class JPopupMenuFinder
    extends Operator.Finder {
        public JPopupMenuFinder(ComponentChooser componentChooser) {
            super(class$javax$swing$JPopupMenu == null ? (class$javax$swing$JPopupMenu = JPopupMenuOperator.class$("javax.swing.JPopupMenu")) : class$javax$swing$JPopupMenu, componentChooser);
        }

        public JPopupMenuFinder() {
            super(class$javax$swing$JPopupMenu == null ? (class$javax$swing$JPopupMenu = JPopupMenuOperator.class$("javax.swing.JPopupMenu")) : class$javax$swing$JPopupMenu);
        }

        public boolean checkComponent(Component component) {
            return component.isShowing() && super.checkComponent(component);
        }
    }
}

