/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.operators;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.VetoableChangeListener;
import java.util.Hashtable;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JRootPane;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.AncestorListener;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.ComponentSearcher;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Timeoutable;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.jemmy.operators.WindowOperator;

public class JComponentOperator
extends ContainerOperator
implements Timeoutable,
Outputable {
    public static final String TOOLTIP_TEXT_DPROP = "Tooltip text";
    public static final String A11Y_DATA = "Accessible data (yes/no)";
    public static final String A11Y_NAME_DPROP = "Accessible name";
    public static final String A11Y_DESCRIPTION_DPROP = "Accessible decription";
    private static final long WAIT_TOOL_TIP_TIMEOUT = 10000L;
    private static final long SHOW_TOOL_TIP_TIMEOUT = 0L;
    private Timeouts timeouts;
    private TestOut output;
    static /* synthetic */ Class class$javax$swing$JComponent;
    static /* synthetic */ Class class$javax$swing$JToolTip;

    public JComponentOperator(JComponent jComponent) {
        super(jComponent);
    }

    public JComponentOperator(ContainerOperator containerOperator, ComponentChooser componentChooser, int n) {
        this((JComponent)containerOperator.waitSubComponent(new JComponentFinder(componentChooser), n));
        this.copyEnvironment(containerOperator);
    }

    public JComponentOperator(ContainerOperator containerOperator, ComponentChooser componentChooser) {
        this(containerOperator, componentChooser, 0);
    }

    public JComponentOperator(ContainerOperator containerOperator, int n) {
        this((JComponent)JComponentOperator.waitComponent(containerOperator, (ComponentChooser)new JComponentFinder(ComponentSearcher.getTrueChooser("Any JComponent")), n));
        this.copyEnvironment(containerOperator);
    }

    public JComponentOperator(ContainerOperator containerOperator) {
        this(containerOperator, 0);
    }

    public static JComponent findJComponent(Container container, ComponentChooser componentChooser, int n) {
        return (JComponent)JComponentOperator.findComponent(container, new JComponentFinder(componentChooser), n);
    }

    public static JComponent findJComponent(Container container, ComponentChooser componentChooser) {
        return JComponentOperator.findJComponent(container, componentChooser, 0);
    }

    public static JComponent findJComponent(Container container, String string, boolean bl, boolean bl2, int n) {
        return JComponentOperator.findJComponent(container, new JComponentByTipFinder(string, new Operator.DefaultStringComparator(bl, bl2)), n);
    }

    public static JComponent findJComponent(Container container, String string, boolean bl, boolean bl2) {
        return JComponentOperator.findJComponent(container, string, bl, bl2, 0);
    }

    public static JComponent waitJComponent(Container container, ComponentChooser componentChooser, int n) {
        return (JComponent)JComponentOperator.waitComponent(container, (ComponentChooser)new JComponentFinder(componentChooser), n);
    }

    public static JComponent waitJComponent(Container container, ComponentChooser componentChooser) {
        return JComponentOperator.waitJComponent(container, componentChooser, 0);
    }

    public static JComponent waitJComponent(Container container, String string, boolean bl, boolean bl2, int n) {
        return JComponentOperator.waitJComponent(container, new JComponentByTipFinder(string, new Operator.DefaultStringComparator(bl, bl2)), n);
    }

    public static JComponent waitJComponent(Container container, String string, boolean bl, boolean bl2) {
        return JComponentOperator.waitJComponent(container, string, bl, bl2, 0);
    }

    public void setTimeouts(Timeouts timeouts) {
        super.setTimeouts(timeouts);
        this.timeouts = timeouts;
    }

    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    public void setOutput(TestOut testOut) {
        this.output = testOut;
        super.setOutput(this.output.createErrorOutput());
    }

    public TestOut getOutput() {
        return this.output;
    }

    public int getCenterXForClick() {
        Rectangle rectangle = this.getVisibleRect();
        return (int)rectangle.getX() + (int)rectangle.getWidth() / 2;
    }

    public int getCenterYForClick() {
        Rectangle rectangle = this.getVisibleRect();
        return (int)rectangle.getY() + (int)rectangle.getHeight() / 2;
    }

    public JToolTip showToolTip() {
        this.enterMouse();
        this.moveMouse(this.getCenterXForClick(), this.getCenterYForClick());
        return this.waitToolTip();
    }

    public JToolTip waitToolTip() {
        return (JToolTip)JComponentOperator.waitComponent(WindowOperator.waitWindow(new JToolTipWindowFinder(), 0, this.getTimeouts(), this.getOutput()), new JToolTipFinder(), 0, this.getTimeouts(), this.getOutput());
    }

    public ContainerOperator getWindowContainerOperator() {
        Component component = this.getSource() instanceof Window ? this.getSource() : this.getContainer(new ComponentChooser(){

            public boolean checkComponent(Component component) {
                return component instanceof Window || component instanceof JInternalFrame;
            }

            public String getDescription() {
                return "";
            }
        });
        ContainerOperator containerOperator = component instanceof Window ? new WindowOperator((Window)component) : new ContainerOperator((Container)component);
        containerOperator.copyEnvironment(this);
        return containerOperator;
    }

    public Hashtable getDump() {
        Hashtable hashtable = super.getDump();
        if (this.getToolTipText() != null) {
            hashtable.put(TOOLTIP_TEXT_DPROP, this.getToolTipText());
        }
        if (System.getProperty("jemmy.dump.a11y") != null && System.getProperty("jemmy.dump.a11y").equals("on")) {
            AccessibleContext accessibleContext = ((JComponent)this.getSource()).getAccessibleContext();
            if (accessibleContext != null) {
                hashtable.put(A11Y_DATA, "yes");
                String string = accessibleContext.getAccessibleName() == null ? "null" : accessibleContext.getAccessibleName();
                String string2 = accessibleContext.getAccessibleDescription() == null ? "null" : accessibleContext.getAccessibleDescription();
                hashtable.put(A11Y_NAME_DPROP, string);
                hashtable.put(A11Y_DESCRIPTION_DPROP, string2);
            } else {
                hashtable.put(A11Y_DATA, "no");
            }
        }
        return hashtable;
    }

    public void addAncestorListener(final AncestorListener ancestorListener) {
        this.runMapping(new Operator.MapVoidAction("addAncestorListener"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).addAncestorListener(ancestorListener);
            }
        });
    }

    public void addVetoableChangeListener(final VetoableChangeListener vetoableChangeListener) {
        this.runMapping(new Operator.MapVoidAction("addVetoableChangeListener"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).addVetoableChangeListener(vetoableChangeListener);
            }
        });
    }

    public void computeVisibleRect(final Rectangle rectangle) {
        this.runMapping(new Operator.MapVoidAction("computeVisibleRect"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).computeVisibleRect(rectangle);
            }
        });
    }

    public JToolTip createToolTip() {
        return (JToolTip)this.runMapping(new Operator.MapAction("createToolTip"){

            public Object map() {
                return ((JComponent)JComponentOperator.this.getSource()).createToolTip();
            }
        });
    }

    public void firePropertyChange(final String string, final byte by, final byte by2) {
        this.runMapping(new Operator.MapVoidAction("firePropertyChange"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).firePropertyChange(string, by, by2);
            }
        });
    }

    public void firePropertyChange(final String string, final char c, final char c2) {
        this.runMapping(new Operator.MapVoidAction("firePropertyChange"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).firePropertyChange(string, c, c2);
            }
        });
    }

    public void firePropertyChange(final String string, final double d, final double d2) {
        this.runMapping(new Operator.MapVoidAction("firePropertyChange"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).firePropertyChange(string, d, d2);
            }
        });
    }

    public void firePropertyChange(final String string, final float f, final float f2) {
        this.runMapping(new Operator.MapVoidAction("firePropertyChange"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).firePropertyChange(string, f, f2);
            }
        });
    }

    public void firePropertyChange(final String string, final int n, final int n2) {
        this.runMapping(new Operator.MapVoidAction("firePropertyChange"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).firePropertyChange(string, n, n2);
            }
        });
    }

    public void firePropertyChange(final String string, final long l, final long l2) {
        this.runMapping(new Operator.MapVoidAction("firePropertyChange"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).firePropertyChange(string, l, l2);
            }
        });
    }

    public void firePropertyChange(final String string, final short s, final short s2) {
        this.runMapping(new Operator.MapVoidAction("firePropertyChange"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).firePropertyChange(string, s, s2);
            }
        });
    }

    public void firePropertyChange(final String string, final boolean bl, final boolean bl2) {
        this.runMapping(new Operator.MapVoidAction("firePropertyChange"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).firePropertyChange(string, bl, bl2);
            }
        });
    }

    public AccessibleContext getAccessibleContext() {
        return (AccessibleContext)this.runMapping(new Operator.MapAction("getAccessibleContext"){

            public Object map() {
                return ((JComponent)JComponentOperator.this.getSource()).getAccessibleContext();
            }
        });
    }

    public ActionListener getActionForKeyStroke(final KeyStroke keyStroke) {
        return (ActionListener)this.runMapping(new Operator.MapAction("getActionForKeyStroke"){

            public Object map() {
                return ((JComponent)JComponentOperator.this.getSource()).getActionForKeyStroke(keyStroke);
            }
        });
    }

    public boolean getAutoscrolls() {
        return this.runMapping(new Operator.MapBooleanAction("getAutoscrolls"){

            public boolean map() {
                return ((JComponent)JComponentOperator.this.getSource()).getAutoscrolls();
            }
        });
    }

    public Border getBorder() {
        return (Border)this.runMapping(new Operator.MapAction("getBorder"){

            public Object map() {
                return ((JComponent)JComponentOperator.this.getSource()).getBorder();
            }
        });
    }

    public Object getClientProperty(final Object object) {
        return this.runMapping(new Operator.MapAction("getClientProperty"){

            public Object map() {
                return ((JComponent)JComponentOperator.this.getSource()).getClientProperty(object);
            }
        });
    }

    public int getConditionForKeyStroke(final KeyStroke keyStroke) {
        return this.runMapping(new Operator.MapIntegerAction("getConditionForKeyStroke"){

            public int map() {
                return ((JComponent)JComponentOperator.this.getSource()).getConditionForKeyStroke(keyStroke);
            }
        });
    }

    public int getDebugGraphicsOptions() {
        return this.runMapping(new Operator.MapIntegerAction("getDebugGraphicsOptions"){

            public int map() {
                return ((JComponent)JComponentOperator.this.getSource()).getDebugGraphicsOptions();
            }
        });
    }

    public Insets getInsets(final Insets insets) {
        return (Insets)this.runMapping(new Operator.MapAction("getInsets"){

            public Object map() {
                return ((JComponent)JComponentOperator.this.getSource()).getInsets(insets);
            }
        });
    }

    public Component getNextFocusableComponent() {
        return (Component)this.runMapping(new Operator.MapAction("getNextFocusableComponent"){

            public Object map() {
                return ((JComponent)JComponentOperator.this.getSource()).getNextFocusableComponent();
            }
        });
    }

    public KeyStroke[] getRegisteredKeyStrokes() {
        return (KeyStroke[])this.runMapping(new Operator.MapAction("getRegisteredKeyStrokes"){

            public Object map() {
                return ((JComponent)JComponentOperator.this.getSource()).getRegisteredKeyStrokes();
            }
        });
    }

    public JRootPane getRootPane() {
        return (JRootPane)this.runMapping(new Operator.MapAction("getRootPane"){

            public Object map() {
                return ((JComponent)JComponentOperator.this.getSource()).getRootPane();
            }
        });
    }

    public Point getToolTipLocation(final MouseEvent mouseEvent) {
        return (Point)this.runMapping(new Operator.MapAction("getToolTipLocation"){

            public Object map() {
                return ((JComponent)JComponentOperator.this.getSource()).getToolTipLocation(mouseEvent);
            }
        });
    }

    public String getToolTipText() {
        return (String)this.runMapping(new Operator.MapAction("getToolTipText"){

            public Object map() {
                return ((JComponent)JComponentOperator.this.getSource()).getToolTipText();
            }
        });
    }

    public String getToolTipText(final MouseEvent mouseEvent) {
        return (String)this.runMapping(new Operator.MapAction("getToolTipText"){

            public Object map() {
                return ((JComponent)JComponentOperator.this.getSource()).getToolTipText(mouseEvent);
            }
        });
    }

    public Container getTopLevelAncestor() {
        return (Container)this.runMapping(new Operator.MapAction("getTopLevelAncestor"){

            public Object map() {
                return ((JComponent)JComponentOperator.this.getSource()).getTopLevelAncestor();
            }
        });
    }

    public String getUIClassID() {
        return (String)this.runMapping(new Operator.MapAction("getUIClassID"){

            public Object map() {
                return ((JComponent)JComponentOperator.this.getSource()).getUIClassID();
            }
        });
    }

    public Rectangle getVisibleRect() {
        return (Rectangle)this.runMapping(new Operator.MapAction("getVisibleRect"){

            public Object map() {
                return ((JComponent)JComponentOperator.this.getSource()).getVisibleRect();
            }
        });
    }

    public void grabFocus() {
        this.runMapping(new Operator.MapVoidAction("grabFocus"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).grabFocus();
            }
        });
    }

    public boolean isFocusCycleRoot() {
        return this.runMapping(new Operator.MapBooleanAction("isFocusCycleRoot"){

            public boolean map() {
                return ((JComponent)JComponentOperator.this.getSource()).isFocusCycleRoot();
            }
        });
    }

    public boolean isManagingFocus() {
        return this.runMapping(new Operator.MapBooleanAction("isManagingFocus"){

            public boolean map() {
                return ((JComponent)JComponentOperator.this.getSource()).isManagingFocus();
            }
        });
    }

    public boolean isOptimizedDrawingEnabled() {
        return this.runMapping(new Operator.MapBooleanAction("isOptimizedDrawingEnabled"){

            public boolean map() {
                return ((JComponent)JComponentOperator.this.getSource()).isOptimizedDrawingEnabled();
            }
        });
    }

    public boolean isPaintingTile() {
        return this.runMapping(new Operator.MapBooleanAction("isPaintingTile"){

            public boolean map() {
                return ((JComponent)JComponentOperator.this.getSource()).isPaintingTile();
            }
        });
    }

    public boolean isRequestFocusEnabled() {
        return this.runMapping(new Operator.MapBooleanAction("isRequestFocusEnabled"){

            public boolean map() {
                return ((JComponent)JComponentOperator.this.getSource()).isRequestFocusEnabled();
            }
        });
    }

    public boolean isValidateRoot() {
        return this.runMapping(new Operator.MapBooleanAction("isValidateRoot"){

            public boolean map() {
                return ((JComponent)JComponentOperator.this.getSource()).isValidateRoot();
            }
        });
    }

    public void paintImmediately(final int n, final int n2, final int n3, final int n4) {
        this.runMapping(new Operator.MapVoidAction("paintImmediately"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).paintImmediately(n, n2, n3, n4);
            }
        });
    }

    public void paintImmediately(final Rectangle rectangle) {
        this.runMapping(new Operator.MapVoidAction("paintImmediately"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).paintImmediately(rectangle);
            }
        });
    }

    public void putClientProperty(final Object object, final Object object2) {
        this.runMapping(new Operator.MapVoidAction("putClientProperty"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).putClientProperty(object, object2);
            }
        });
    }

    public void registerKeyboardAction(final ActionListener actionListener, final String string, final KeyStroke keyStroke, final int n) {
        this.runMapping(new Operator.MapVoidAction("registerKeyboardAction"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).registerKeyboardAction(actionListener, string, keyStroke, n);
            }
        });
    }

    public void registerKeyboardAction(final ActionListener actionListener, final KeyStroke keyStroke, final int n) {
        this.runMapping(new Operator.MapVoidAction("registerKeyboardAction"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).registerKeyboardAction(actionListener, keyStroke, n);
            }
        });
    }

    public void removeAncestorListener(final AncestorListener ancestorListener) {
        this.runMapping(new Operator.MapVoidAction("removeAncestorListener"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).removeAncestorListener(ancestorListener);
            }
        });
    }

    public void removeVetoableChangeListener(final VetoableChangeListener vetoableChangeListener) {
        this.runMapping(new Operator.MapVoidAction("removeVetoableChangeListener"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).removeVetoableChangeListener(vetoableChangeListener);
            }
        });
    }

    public void repaint(final Rectangle rectangle) {
        this.runMapping(new Operator.MapVoidAction("repaint"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).repaint(rectangle);
            }
        });
    }

    public boolean requestDefaultFocus() {
        return this.runMapping(new Operator.MapBooleanAction("requestDefaultFocus"){

            public boolean map() {
                return ((JComponent)JComponentOperator.this.getSource()).requestDefaultFocus();
            }
        });
    }

    public void resetKeyboardActions() {
        this.runMapping(new Operator.MapVoidAction("resetKeyboardActions"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).resetKeyboardActions();
            }
        });
    }

    public void revalidate() {
        this.runMapping(new Operator.MapVoidAction("revalidate"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).revalidate();
            }
        });
    }

    public void scrollRectToVisible(final Rectangle rectangle) {
        this.runMapping(new Operator.MapVoidAction("scrollRectToVisible"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).scrollRectToVisible(rectangle);
            }
        });
    }

    public void setAlignmentX(final float f) {
        this.runMapping(new Operator.MapVoidAction("setAlignmentX"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).setAlignmentX(f);
            }
        });
    }

    public void setAlignmentY(final float f) {
        this.runMapping(new Operator.MapVoidAction("setAlignmentY"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).setAlignmentY(f);
            }
        });
    }

    public void setAutoscrolls(final boolean bl) {
        this.runMapping(new Operator.MapVoidAction("setAutoscrolls"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).setAutoscrolls(bl);
            }
        });
    }

    public void setBorder(final Border border) {
        this.runMapping(new Operator.MapVoidAction("setBorder"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).setBorder(border);
            }
        });
    }

    public void setDebugGraphicsOptions(final int n) {
        this.runMapping(new Operator.MapVoidAction("setDebugGraphicsOptions"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).setDebugGraphicsOptions(n);
            }
        });
    }

    public void setDoubleBuffered(final boolean bl) {
        this.runMapping(new Operator.MapVoidAction("setDoubleBuffered"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).setDoubleBuffered(bl);
            }
        });
    }

    public void setMaximumSize(final Dimension dimension) {
        this.runMapping(new Operator.MapVoidAction("setMaximumSize"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).setMaximumSize(dimension);
            }
        });
    }

    public void setMinimumSize(final Dimension dimension) {
        this.runMapping(new Operator.MapVoidAction("setMinimumSize"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).setMinimumSize(dimension);
            }
        });
    }

    public void setNextFocusableComponent(final Component component) {
        this.runMapping(new Operator.MapVoidAction("setNextFocusableComponent"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).setNextFocusableComponent(component);
            }
        });
    }

    public void setOpaque(final boolean bl) {
        this.runMapping(new Operator.MapVoidAction("setOpaque"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).setOpaque(bl);
            }
        });
    }

    public void setPreferredSize(final Dimension dimension) {
        this.runMapping(new Operator.MapVoidAction("setPreferredSize"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).setPreferredSize(dimension);
            }
        });
    }

    public void setRequestFocusEnabled(final boolean bl) {
        this.runMapping(new Operator.MapVoidAction("setRequestFocusEnabled"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).setRequestFocusEnabled(bl);
            }
        });
    }

    public void setToolTipText(final String string) {
        this.runMapping(new Operator.MapVoidAction("setToolTipText"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).setToolTipText(string);
            }
        });
    }

    public void unregisterKeyboardAction(final KeyStroke keyStroke) {
        this.runMapping(new Operator.MapVoidAction("unregisterKeyboardAction"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).unregisterKeyboardAction(keyStroke);
            }
        });
    }

    public void updateUI() {
        this.runMapping(new Operator.MapVoidAction("updateUI"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).updateUI();
            }
        });
    }

    static {
        Timeouts.initDefault("JComponentOperator.WaitToolTipTimeout", 10000L);
        Timeouts.initDefault("JComponentOperator.ShowToolTipTimeout", 0L);
    }

    class JToolTipFinder
    extends Operator.Finder {
        public JToolTipFinder(ComponentChooser componentChooser) {
            super(class$javax$swing$JToolTip == null ? (class$javax$swing$JToolTip = JComponentOperator.class$("javax.swing.JToolTip")) : class$javax$swing$JToolTip, componentChooser);
        }

        public JToolTipFinder() {
            super(class$javax$swing$JToolTip == null ? (class$javax$swing$JToolTip = JComponentOperator.class$("javax.swing.JToolTip")) : class$javax$swing$JToolTip);
        }
    }

    class JToolTipWindowFinder
    implements ComponentChooser {
        ComponentChooser ppFinder;

        public JToolTipWindowFinder() {
            this.ppFinder = new ComponentChooser(){

                public boolean checkComponent(Component component) {
                    return component.isShowing() && component.isVisible() && component instanceof JToolTip;
                }

                public String getDescription() {
                    return "A tool tip";
                }
            };
        }

        public boolean checkComponent(Component component) {
            if (component.isShowing() && component instanceof Window) {
                ComponentSearcher componentSearcher = new ComponentSearcher((Container)component);
                componentSearcher.setOutput(JemmyProperties.getCurrentOutput().createErrorOutput());
                return componentSearcher.findComponent(this.ppFinder) != null;
            }
            return false;
        }

        public String getDescription() {
            return "A tool tip window";
        }
    }

    public static class JComponentFinder
    extends Operator.Finder {
        public JComponentFinder(ComponentChooser componentChooser) {
            super(class$javax$swing$JComponent == null ? (class$javax$swing$JComponent = JComponentOperator.class$("javax.swing.JComponent")) : class$javax$swing$JComponent, componentChooser);
        }

        public JComponentFinder() {
            super(class$javax$swing$JComponent == null ? (class$javax$swing$JComponent = JComponentOperator.class$("javax.swing.JComponent")) : class$javax$swing$JComponent);
        }
    }

    public static class JComponentByTipFinder
    implements ComponentChooser {
        String label;
        Operator.StringComparator comparator;
        boolean compareExactly;
        boolean compareCaseSensitive;

        public JComponentByTipFinder(String string, Operator.StringComparator stringComparator) {
            this.label = string;
            this.comparator = stringComparator;
        }

        public JComponentByTipFinder(String string) {
            this(string, Operator.getDefaultStringComparator());
        }

        public boolean checkComponent(Component component) {
            if (component instanceof JComponent && ((JComponent)component).getToolTipText() != null) {
                return this.comparator.equals(((JComponent)component).getToolTipText(), this.label);
            }
            return false;
        }

        public String getDescription() {
            return "JComponent with tool tip \"" + this.label + "\"";
        }
    }
}

