/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.operators;

import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ItemListener;
import java.util.Hashtable;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.drivers.ButtonDriver;
import org.netbeans.jemmy.drivers.DriverManager;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.Operator;

public class CheckboxOperator
extends ComponentOperator
implements Outputable {
    public static final String TEXT_DPROP = "Label";
    private TestOut output;
    ButtonDriver driver = DriverManager.getButtonDriver(this.getClass());
    static /* synthetic */ Class class$java$awt$Checkbox;

    public CheckboxOperator(Checkbox checkbox) {
        super(checkbox);
    }

    public CheckboxOperator(ContainerOperator containerOperator, ComponentChooser componentChooser, int n) {
        this((Checkbox)containerOperator.waitSubComponent(new CheckboxFinder(componentChooser), n));
        this.copyEnvironment(containerOperator);
    }

    public CheckboxOperator(ContainerOperator containerOperator, ComponentChooser componentChooser) {
        this(containerOperator, componentChooser, 0);
    }

    public CheckboxOperator(ContainerOperator containerOperator, String string, int n) {
        this((Checkbox)CheckboxOperator.waitComponent(containerOperator, (ComponentChooser)new CheckboxByLabelFinder(string, containerOperator.getComparator()), n));
        this.copyEnvironment(containerOperator);
    }

    public CheckboxOperator(ContainerOperator containerOperator, String string) {
        this(containerOperator, string, 0);
    }

    public CheckboxOperator(ContainerOperator containerOperator, int n) {
        this((Checkbox)CheckboxOperator.waitComponent(containerOperator, (ComponentChooser)new CheckboxFinder(), n));
        this.copyEnvironment(containerOperator);
    }

    public CheckboxOperator(ContainerOperator containerOperator) {
        this(containerOperator, 0);
    }

    public static Checkbox findCheckbox(Container container, ComponentChooser componentChooser, int n) {
        return (Checkbox)CheckboxOperator.findComponent(container, new CheckboxFinder(componentChooser), n);
    }

    public static Checkbox findCheckbox(Container container, ComponentChooser componentChooser) {
        return CheckboxOperator.findCheckbox(container, componentChooser, 0);
    }

    public static Checkbox findCheckbox(Container container, String string, boolean bl, boolean bl2, int n) {
        return CheckboxOperator.findCheckbox(container, new CheckboxByLabelFinder(string, new Operator.DefaultStringComparator(bl, bl2)), n);
    }

    public static Checkbox findCheckbox(Container container, String string, boolean bl, boolean bl2) {
        return CheckboxOperator.findCheckbox(container, string, bl, bl2, 0);
    }

    public static Checkbox waitCheckbox(Container container, ComponentChooser componentChooser, int n) {
        return (Checkbox)CheckboxOperator.waitComponent(container, (ComponentChooser)new CheckboxFinder(componentChooser), n);
    }

    public static Checkbox waitCheckbox(Container container, ComponentChooser componentChooser) {
        return CheckboxOperator.waitCheckbox(container, componentChooser, 0);
    }

    public static Checkbox waitCheckbox(Container container, String string, boolean bl, boolean bl2, int n) {
        return CheckboxOperator.waitCheckbox(container, new CheckboxByLabelFinder(string, new Operator.DefaultStringComparator(bl, bl2)), n);
    }

    public static Checkbox waitCheckbox(Container container, String string, boolean bl, boolean bl2) {
        return CheckboxOperator.waitCheckbox(container, string, bl, bl2, 0);
    }

    public void setOutput(TestOut testOut) {
        this.output = testOut;
        super.setOutput(this.output.createErrorOutput());
    }

    public TestOut getOutput() {
        return this.output;
    }

    public void copyEnvironment(Operator operator) {
        super.copyEnvironment(operator);
        this.driver = (ButtonDriver)DriverManager.getDriver("drivers.button", this.getClass(), operator.getProperties());
    }

    public void changeSelection(boolean bl) {
        this.makeComponentVisible();
        if (this.getState() != bl) {
            try {
                this.waitComponentEnabled();
            }
            catch (InterruptedException interruptedException) {
                throw new JemmyException("Interrupted!", interruptedException);
            }
            this.output.printLine("Change checkbox selection to " + (bl ? "true" : "false") + "\n    :" + this.toStringSource());
            this.output.printGolden("Change checkbox selection to " + (bl ? "true" : "false"));
            this.driver.push(this);
            if (this.getVerification()) {
                this.waitSelected(bl);
            }
        }
    }

    public void changeSelectionNoBlock(boolean bl) {
        this.produceNoBlocking(new Operator.NoBlockingAction("Button selection changing"){

            public Object doAction(Object object) {
                CheckboxOperator.this.changeSelection((Boolean)object);
                return null;
            }
        }, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public void waitSelected(final boolean bl) {
        this.getOutput().printLine("Wait button to be selected \n    : " + this.toStringSource());
        this.getOutput().printGolden("Wait button to be selected");
        this.waitState(new ComponentChooser(){

            public boolean checkComponent(Component component) {
                return CheckboxOperator.this.getState() == bl;
            }

            public String getDescription() {
                return "Items has been " + (bl ? "" : "un") + "selected";
            }
        });
    }

    public Hashtable getDump() {
        Hashtable hashtable = super.getDump();
        hashtable.put(TEXT_DPROP, ((Checkbox)this.getSource()).getLabel());
        return hashtable;
    }

    public void addItemListener(final ItemListener itemListener) {
        this.runMapping(new Operator.MapVoidAction("addItemListener"){

            public void map() {
                ((Checkbox)CheckboxOperator.this.getSource()).addItemListener(itemListener);
            }
        });
    }

    public CheckboxGroup getCheckboxGroup() {
        return (CheckboxGroup)this.runMapping(new Operator.MapAction("getCheckboxGroup"){

            public Object map() {
                return ((Checkbox)CheckboxOperator.this.getSource()).getCheckboxGroup();
            }
        });
    }

    public String getLabel() {
        return (String)this.runMapping(new Operator.MapAction("getLabel"){

            public Object map() {
                return ((Checkbox)CheckboxOperator.this.getSource()).getLabel();
            }
        });
    }

    public boolean getState() {
        return this.runMapping(new Operator.MapBooleanAction("getState"){

            public boolean map() {
                return ((Checkbox)CheckboxOperator.this.getSource()).getState();
            }
        });
    }

    public void removeItemListener(final ItemListener itemListener) {
        this.runMapping(new Operator.MapVoidAction("removeItemListener"){

            public void map() {
                ((Checkbox)CheckboxOperator.this.getSource()).removeItemListener(itemListener);
            }
        });
    }

    public void setCheckboxGroup(final CheckboxGroup checkboxGroup) {
        this.runMapping(new Operator.MapVoidAction("setCheckboxGroup"){

            public void map() {
                ((Checkbox)CheckboxOperator.this.getSource()).setCheckboxGroup(checkboxGroup);
            }
        });
    }

    public void setLabel(final String string) {
        this.runMapping(new Operator.MapVoidAction("setLabel"){

            public void map() {
                ((Checkbox)CheckboxOperator.this.getSource()).setLabel(string);
            }
        });
    }

    public void setState(final boolean bl) {
        this.runMapping(new Operator.MapVoidAction("setState"){

            public void map() {
                ((Checkbox)CheckboxOperator.this.getSource()).setState(bl);
            }
        });
    }

    public static class CheckboxFinder
    extends Operator.Finder {
        public CheckboxFinder(ComponentChooser componentChooser) {
            super(class$java$awt$Checkbox == null ? (class$java$awt$Checkbox = CheckboxOperator.class$("java.awt.Checkbox")) : class$java$awt$Checkbox, componentChooser);
        }

        public CheckboxFinder() {
            super(class$java$awt$Checkbox == null ? (class$java$awt$Checkbox = CheckboxOperator.class$("java.awt.Checkbox")) : class$java$awt$Checkbox);
        }
    }

    public static class CheckboxByLabelFinder
    implements ComponentChooser {
        String label;
        Operator.StringComparator comparator;

        public CheckboxByLabelFinder(String string, Operator.StringComparator stringComparator) {
            this.label = string;
            this.comparator = stringComparator;
        }

        public CheckboxByLabelFinder(String string) {
            this(string, Operator.getDefaultStringComparator());
        }

        public boolean checkComponent(Component component) {
            if (component instanceof Checkbox && ((Checkbox)component).getLabel() != null) {
                return this.comparator.equals(((Checkbox)component).getLabel(), this.label);
            }
            return false;
        }

        public String getDescription() {
            return "Checkbox with label \"" + this.label + "\"";
        }
    }
}

