/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.drivers.scrolling;

import org.netbeans.jemmy.drivers.LightSupportiveDriver;
import org.netbeans.jemmy.drivers.ScrollDriver;
import org.netbeans.jemmy.drivers.scrolling.ScrollAdjuster;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JSpinnerOperator;

public class JSpinnerDriver
extends LightSupportiveDriver
implements ScrollDriver {
    public JSpinnerDriver() {
        super(new String[]{"org.netbeans.jemmy.operators.JSpinnerOperator"});
    }

    public void scrollToMinimum(final ComponentOperator componentOperator, int n) {
        Object object = ((JSpinnerOperator)componentOperator).getMinimum();
        if (object == null) {
            throw new JSpinnerOperator.SpinnerModelException("Impossible to get a minimum of JSpinner model.", componentOperator.getSource());
        }
        this.scroll(componentOperator, new ScrollAdjuster(){

            public int getScrollOrientation() {
                return 1;
            }

            public String getDescription() {
                return "Spin to minimum";
            }

            public int getScrollDirection() {
                if (((JSpinnerOperator)componentOperator).getModel().getPreviousValue() != null) {
                    return -1;
                }
                return 0;
            }
        });
    }

    public void scrollToMaximum(final ComponentOperator componentOperator, int n) {
        Object object = ((JSpinnerOperator)componentOperator).getMaximum();
        if (object == null) {
            throw new JSpinnerOperator.SpinnerModelException("Impossible to get a maximum of JSpinner model.", componentOperator.getSource());
        }
        this.scroll(componentOperator, new ScrollAdjuster(){

            public int getScrollOrientation() {
                return 1;
            }

            public String getDescription() {
                return "Spin to maximum";
            }

            public int getScrollDirection() {
                if (((JSpinnerOperator)componentOperator).getModel().getNextValue() != null) {
                    return 1;
                }
                return 0;
            }
        });
    }

    public void scroll(ComponentOperator componentOperator, ScrollAdjuster scrollAdjuster) {
        JButtonOperator jButtonOperator = ((JSpinnerOperator)componentOperator).getIncreaseOperator();
        JButtonOperator jButtonOperator2 = ((JSpinnerOperator)componentOperator).getDecreaseOperator();
        if (scrollAdjuster.getScrollDirection() == 0) {
            return;
        }
        int n = scrollAdjuster.getScrollDirection();
        while (scrollAdjuster.getScrollDirection() == n) {
            if (n == 1) {
                jButtonOperator.push();
                continue;
            }
            jButtonOperator2.push();
        }
    }
}

