/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.drivers.menus;

import java.awt.Component;
import java.awt.Window;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.MenuElement;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.drivers.DescriptablePathChooser;
import org.netbeans.jemmy.drivers.DriverManager;
import org.netbeans.jemmy.drivers.LightSupportiveDriver;
import org.netbeans.jemmy.drivers.MenuDriver;
import org.netbeans.jemmy.drivers.PathChooser;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.JMenuBarOperator;
import org.netbeans.jemmy.operators.JMenuItemOperator;
import org.netbeans.jemmy.operators.JMenuOperator;
import org.netbeans.jemmy.operators.JPopupMenuOperator;

public class QueueJMenuDriver
extends LightSupportiveDriver
implements MenuDriver {
    QueueTool queueTool = new QueueTool();

    public QueueJMenuDriver() {
        super(new String[]{"org.netbeans.jemmy.operators.JMenuOperator", "org.netbeans.jemmy.operators.JMenuBarOperator", "org.netbeans.jemmy.operators.JPopupMenuOperator"});
    }

    public Object pushMenu(final ComponentOperator componentOperator, PathChooser pathChooser) {
        JMenuItem jMenuItem;
        OneReleaseAction oneReleaseAction;
        this.queueTool.setOutput(componentOperator.getOutput().createErrorOutput());
        this.checkSupported(componentOperator);
        if (componentOperator instanceof JMenuBarOperator) {
            oneReleaseAction = new OneReleaseAction(pathChooser, 0, componentOperator, false){

                protected void pushAlone(JMenuItemOperator jMenuItemOperator) {
                    if (jMenuItemOperator.getSource() instanceof JMenu && QueueJMenuDriver.this.isMenuBarSelected((JMenuBar)componentOperator.getSource())) {
                        DriverManager.getMouseDriver(jMenuItemOperator).enterMouse(jMenuItemOperator);
                    } else {
                        DriverManager.getButtonDriver(jMenuItemOperator).push(jMenuItemOperator);
                    }
                }

                protected boolean inTheMiddle(JMenuOperator jMenuOperator, boolean bl) {
                    if (QueueJMenuDriver.this.isMenuBarSelected((JMenuBar)componentOperator.getSource())) {
                        DriverManager.getMouseDriver(jMenuOperator).enterMouse(jMenuOperator);
                        return false;
                    }
                    return super.inTheMiddle(jMenuOperator, bl);
                }

                protected void process(MenuElement menuElement) {
                    super.process(menuElement);
                }

                public MenuElement getMenuElement() {
                    return (MenuElement)((Object)componentOperator.getSource());
                }
            };
        } else if (componentOperator instanceof JPopupMenuOperator) {
            oneReleaseAction = new OneReleaseAction(pathChooser, 0, componentOperator, false){

                public MenuElement getMenuElement() {
                    return (MenuElement)((Object)componentOperator.getSource());
                }
            };
        } else {
            DriverManager.getButtonDriver(componentOperator).press(componentOperator);
            oneReleaseAction = new OneReleaseAction(pathChooser, 0, componentOperator, false){

                public Object launch() {
                    this.process((MenuElement)((Object)componentOperator.getSource()));
                    return (MenuElement)((Object)componentOperator.getSource());
                }

                public MenuElement getMenuElement() {
                    return null;
                }
            };
        }
        if (System.getProperty("java.specification.version").compareTo("1.4") > 0) {
            this.queueTool.setOutput(componentOperator.getOutput().createErrorOutput());
            this.queueTool.waitEmpty(10L);
            this.queueTool.waitEmpty(10L);
            this.queueTool.waitEmpty(10L);
        }
        if ((jMenuItem = this.runAction(oneReleaseAction, componentOperator, componentOperator.getTimeouts().getTimeout("ComponentOperator.WaitComponentTimeout"), pathChooser instanceof DescriptablePathChooser ? ((DescriptablePathChooser)pathChooser).getDescription() : "Menu pushing")) instanceof JMenu) {
            for (int i = 1; i < pathChooser.getDepth(); ++i) {
                JMenu jMenu = (JMenu)jMenuItem;
                final PopupMenuChooser popupMenuChooser = new PopupMenuChooser(jMenu);
                oneReleaseAction = new OneReleaseAction(pathChooser, i, componentOperator, oneReleaseAction.mousePressed){

                    public MenuElement getMenuElement() {
                        Window window = JPopupMenuOperator.findJPopupWindow(popupMenuChooser);
                        if (window != null && window.isShowing()) {
                            return JPopupMenuOperator.findJPopupMenu(window, popupMenuChooser);
                        }
                        return null;
                    }
                };
                jMenuItem = this.runAction(oneReleaseAction, componentOperator, componentOperator.getTimeouts().getTimeout("JMenuOperator.WaitPopupTimeout"), pathChooser instanceof DescriptablePathChooser ? ((DescriptablePathChooser)pathChooser).getDescription() : "Menu pushing");
            }
        }
        return jMenuItem;
    }

    private JMenuItem runAction(final OneReleaseAction oneReleaseAction, ComponentOperator componentOperator, long l, final String string) {
        Waiter waiter = new Waiter(new Waitable(){

            public Object actionProduced(Object object) {
                return QueueJMenuDriver.this.queueTool.invokeSmoothly(oneReleaseAction);
            }

            public String getDescription() {
                return string;
            }
        });
        waiter.setOutput(componentOperator.getOutput().createErrorOutput());
        waiter.setTimeouts(componentOperator.getTimeouts().cloneThis());
        waiter.getTimeouts().setTimeout("Waiter.WaitingTime", l);
        waiter.getTimeouts().setTimeout("Waiter.TimeDelta", 100L);
        if (System.getProperty("java.specification.version").compareTo("1.4") > 0) {
            this.queueTool.setOutput(componentOperator.getOutput().createErrorOutput());
            this.queueTool.waitEmpty(10L);
            this.queueTool.waitEmpty(10L);
            this.queueTool.waitEmpty(10L);
        }
        try {
            return (JMenuItem)waiter.waitAction(null);
        }
        catch (InterruptedException interruptedException) {
            oneReleaseAction.stop();
            throw new JemmyException("Waiting has been interrupted", interruptedException);
        }
    }

    private boolean isMenuBarSelected(JMenuBar jMenuBar) {
        MenuElement[] menuElementArray = jMenuBar.getSubElements();
        for (int i = 0; i < menuElementArray.length; ++i) {
            if (!(menuElementArray[i] instanceof JMenu) || !((JMenu)menuElementArray[i]).isPopupMenuVisible()) continue;
            return true;
        }
        return false;
    }

    private class PopupMenuChooser
    implements ComponentChooser {
        JMenu menu;

        public PopupMenuChooser(JMenu jMenu) {
            this.menu = jMenu;
        }

        public boolean checkComponent(Component component) {
            return component == this.menu.getPopupMenu() && component.isShowing() && component.isEnabled();
        }

        public String getDescription() {
            return this.menu.getText() + "'s popup";
        }
    }

    private abstract class OneReleaseAction
    extends QueueTool.QueueAction {
        PathChooser chooser;
        int depth;
        ComponentOperator env;
        boolean mousePressed;
        private boolean stopped;

        public OneReleaseAction(PathChooser pathChooser, int n, ComponentOperator componentOperator, boolean bl) {
            super("Menu pushing");
            this.mousePressed = false;
            this.stopped = false;
            this.chooser = pathChooser;
            this.depth = n;
            this.env = componentOperator;
            this.mousePressed = bl;
        }

        protected void pushAlone(JMenuItemOperator jMenuItemOperator) {
            DriverManager.getButtonDriver(jMenuItemOperator).push(jMenuItemOperator);
        }

        protected void pushLast(JMenuItemOperator jMenuItemOperator, boolean bl) {
            DriverManager.getMouseDriver(jMenuItemOperator).enterMouse(jMenuItemOperator);
            DriverManager.getButtonDriver(jMenuItemOperator).release(jMenuItemOperator);
        }

        protected boolean inTheMiddle(JMenuOperator jMenuOperator, boolean bl) {
            if (!jMenuOperator.isPopupMenuVisible()) {
                if (!bl) {
                    DriverManager.getMouseDriver(jMenuOperator).enterMouse(jMenuOperator);
                    DriverManager.getButtonDriver(jMenuOperator).press(jMenuOperator);
                } else {
                    DriverManager.getMouseDriver(jMenuOperator).enterMouse(jMenuOperator);
                }
                return true;
            }
            return bl;
        }

        protected void process(MenuElement menuElement) {
            if (this.depth == this.chooser.getDepth() - 1) {
                JMenuItemOperator jMenuItemOperator = new JMenuItemOperator((JMenuItem)menuElement);
                jMenuItemOperator.copyEnvironment(this.env);
                if (this.depth == 0) {
                    this.pushAlone(jMenuItemOperator);
                } else {
                    this.pushLast(jMenuItemOperator, this.mousePressed);
                }
            } else if (menuElement instanceof JMenu) {
                JMenuOperator jMenuOperator = new JMenuOperator((JMenu)menuElement);
                jMenuOperator.copyEnvironment(this.env);
                this.mousePressed = this.inTheMiddle(jMenuOperator, this.mousePressed);
            } else {
                throw new JemmyException("Menu path too long");
            }
        }

        public Object launch() {
            MenuElement menuElement = this.getMenuElement();
            if (menuElement != null) {
                MenuElement[] menuElementArray = menuElement.getSubElements();
                for (int i = 0; i < menuElementArray.length; ++i) {
                    if (((Component)((Object)menuElementArray[i])).isShowing() && ((Component)((Object)menuElementArray[i])).isEnabled() && this.chooser.checkPathComponent(this.depth, menuElementArray[i])) {
                        this.process(menuElementArray[i]);
                        return menuElementArray[i];
                    }
                    if (!this.stopped) continue;
                    return null;
                }
            }
            return null;
        }

        public abstract MenuElement getMenuElement();

        private void stop() {
            this.stopped = true;
        }
    }
}

