/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.drivers.menus;

import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.MenuElement;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.Timeout;
import org.netbeans.jemmy.TimeoutExpiredException;
import org.netbeans.jemmy.drivers.DescriptablePathChooser;
import org.netbeans.jemmy.drivers.MenuDriver;
import org.netbeans.jemmy.drivers.PathChooser;
import org.netbeans.jemmy.drivers.input.RobotDriver;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.Operator;

public class AppleMenuDriver
extends RobotDriver
implements MenuDriver {
    public AppleMenuDriver() {
        super(new Timeout("apple.system.menu.delay", 100L), new String[]{"org.netbeans.jemmy.operators.JMenuBarOperator"});
    }

    public Object pushMenu(ComponentOperator componentOperator, PathChooser pathChooser) {
        MenuElement menuElement;
        Timeout timeout = componentOperator.getTimeouts().create("ComponentOperator.WaitComponentTimeout");
        JMenuBar jMenuBar = (JMenuBar)componentOperator.getSource();
        this.activateMenu(jMenuBar);
        timeout.start();
        while (!pathChooser.checkPathComponent(0, menuElement = AppleMenuDriver.getSelectedElement(jMenuBar))) {
            this.pressKey(39, 0);
            this.releaseKey(39, 0);
            if (!timeout.expired()) continue;
            throw new TimeoutExpiredException("AppleMenuDriver: can not find an appropriate menu!");
        }
        for (int i = 1; i < pathChooser.getDepth(); ++i) {
            int n;
            int n2 = AppleMenuDriver.getDesiredElementIndex(menuElement, pathChooser, i);
            if (n2 == -1) {
                throw new JemmyException("Unable to find menu (menuitem): " + ((DescriptablePathChooser)pathChooser).getDescription());
            }
            int n3 = n = i == 1 ? 0 : 1;
            while (n <= n2) {
                this.pressKey(40, 0);
                this.releaseKey(40, 0);
                ++n;
            }
            if (i == pathChooser.getDepth() - 1) {
                this.pressKey(10, 0);
                this.releaseKey(10, 0);
                return null;
            }
            this.pressKey(39, 0);
            this.releaseKey(39, 0);
            menuElement = menuElement.getSubElements()[0].getSubElements()[n2];
        }
        return menuElement;
    }

    private void activateMenu(JMenuBar jMenuBar) {
        if (AppleMenuDriver.getSelectedElement(jMenuBar) == null) {
            this.tryToActivate();
            if (AppleMenuDriver.getSelectedElement(jMenuBar) == null) {
                this.tryToActivate();
            }
        }
    }

    private void tryToActivate() {
        this.moveMouse(0, 0);
        this.pressMouse(Operator.getDefaultMouseButton(), 0);
        this.releaseMouse(Operator.getDefaultMouseButton(), 0);
        this.pressKey(39, 0);
        this.releaseKey(39, 0);
        this.pressKey(39, 0);
        this.releaseKey(39, 0);
    }

    private static MenuElement getSelectedElement(MenuElement menuElement) {
        MenuElement[] menuElementArray = menuElement.getSubElements();
        for (int i = 0; i < menuElementArray.length; ++i) {
            if (menuElementArray[i] instanceof JMenu && ((JMenu)menuElementArray[i]).isSelected()) {
                return menuElementArray[i];
            }
            if (!(menuElementArray[i] instanceof JMenuItem) || !((JMenuItem)menuElementArray[i]).isSelected()) continue;
            return menuElementArray[i];
        }
        return null;
    }

    private static int getDesiredElementIndex(MenuElement menuElement, PathChooser pathChooser, int n) {
        MenuElement[] menuElementArray = menuElement.getSubElements()[0].getSubElements();
        int n2 = 0;
        for (int i = 0; i < menuElementArray.length; ++i) {
            if (!(menuElementArray[i] instanceof JMenuItem) || !((JMenuItem)menuElementArray[i]).isVisible() || !((JMenuItem)menuElementArray[i]).isEnabled()) continue;
            if (pathChooser.checkPathComponent(n, menuElementArray[i])) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }
}

