/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.TestOut;

public class ObjectBrowser
implements Outputable {
    private Object object;
    private TestOut output;

    public void setOutput(TestOut testOut) {
        this.output = testOut;
    }

    public TestOut getOutput() {
        return this.output;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public Object getObject() {
        return this.object;
    }

    public void printToString() {
        this.output.printLine(this.object.toString());
    }

    public void printFields() {
        Class<?> clazz = this.object.getClass();
        this.output.printLine("Class: " + clazz.getName());
        this.output.printLine("Fields: ");
        Field[] fieldArray = clazz.getFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            this.output.printLine(Modifier.toString(fieldArray[i].getModifiers()) + " " + fieldArray[i].getType().getName() + " " + fieldArray[i].getName());
            Object object = "Inaccessible";
            try {
                object = fieldArray[i].get(this.object);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            this.output.printLine("    Value: " + object.toString());
        }
    }

    public void printMethods() {
        Class<?> clazz = this.object.getClass();
        this.output.printLine("Class: " + clazz.getName());
        this.output.printLine("Methods: ");
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            this.output.printLine(Modifier.toString(methodArray[i].getModifiers()) + " " + methodArray[i].getReturnType().getName() + " " + methodArray[i].getName());
            Class<?>[] classArray = methodArray[i].getParameterTypes();
            for (int j = 0; j < classArray.length; ++j) {
                this.output.printLine("    " + classArray[j].getName());
            }
        }
    }

    public void printClasses() {
        Class<?> clazz = this.object.getClass();
        do {
            this.output.printLine(clazz.getName());
        } while ((clazz = clazz.getSuperclass()) != null);
    }

    public void printFull() {
        this.printFields();
        this.printMethods();
    }
}

