/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jspparser_ext;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.ExtractPageData;
import org.apache.jasper.compiler.GetParseData;
import org.apache.jasper.compiler.JspRuntimeContext;
import org.apache.jasper.compiler.TldLocationsCache;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jspparser.ContextUtil;
import org.netbeans.modules.web.jspparser.JspParserImpl;
import org.netbeans.modules.web.jspparser.ParserServletContext;
import org.netbeans.modules.web.jspparser.WebAppParseProxy;
import org.netbeans.modules.web.jspparser_ext.OptionsImpl;
import org.netbeans.modules.web.jsps.parserapi.JspParserAPI;
import org.netbeans.modules.web.jsps.parserapi.Node;
import org.netbeans.modules.web.jsps.parserapi.PageInfo;
import org.openide.ErrorManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebAppParseSupport
implements WebAppParseProxy,
PropertyChangeListener,
ParserServletContext.WebModuleProvider {
    static final Logger LOG = Logger.getLogger(WebAppParseSupport.class.getName());
    private static final JspParserAPI.JspOpenInfo DEFAULT_JSP_OPEN_INFO = new JspParserAPI.JspOpenInfo(false, "8859_1");
    final JspParserImpl jspParser;
    private final Reference<WebModule> wm;
    final FileObject wmRoot;
    final FileObject webInf;
    private final FileSystemListener fileSystemListener;
    OptionsImpl editorOptions;
    OptionsImpl diskOptions;
    ServletContext editorContext;
    ServletContext diskContext;
    private JspRuntimeContext rctxt;
    private URLClassLoader waClassLoader;
    URLClassLoader waContextClassLoader;
    final Map<String, String[]> mappings = new HashMap<String, String[]>();
    final AtomicLong cpCurrent = new AtomicLong(0L);
    private static final int REINIT_OPTIONS_DELAY = 2000;
    private static final int REINIT_CACHES_DELAY = 1000;
    private static final int INITIAL_CACHES_DELAY = 2000;
    private final RequestProcessor.Task reinitCachesTask;
    private final RequestProcessor.Task tldChangeTask;

    public WebAppParseSupport(JspParserImpl jspParser, WebModule wm) {
        this.jspParser = jspParser;
        this.wm = new WeakReference<WebModule>(wm);
        this.wmRoot = wm.getDocumentBase();
        this.webInf = wm.getWebInf();
        this.fileSystemListener = new FileSystemListener();
        this.initOptions(true);
        try {
            FileSystem fs = wm.getDocumentBase().getFileSystem();
            fs.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this.fileSystemListener, (Object)fs));
        }
        catch (FileStateInvalidException ex) {
            LOG.log(Level.INFO, null, ex);
        }
        ClassPath compileCP = ClassPath.getClassPath((FileObject)this.wmRoot, (String)"classpath/compile");
        compileCP.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)compileCP));
        ClassPath executeCP = ClassPath.getClassPath((FileObject)this.wmRoot, (String)"classpath/execute");
        executeCP.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)executeCP));
        RequestProcessor requestProcessor = new RequestProcessor("JSP parser :: Reinit caches");
        this.reinitCachesTask = requestProcessor.create((Runnable)new ReinitCaches());
        requestProcessor = new RequestProcessor("JSP parser :: TLD change");
        this.tldChangeTask = requestProcessor.create((Runnable)new TldChange());
        this.reinitCachesTask.schedule(2000);
    }

    public JspParserAPI.JspOpenInfo getJspOpenInfo(FileObject jspFile, boolean useEditor) {
        this.checkReinitCachesTask();
        JspCompilationContext ctxt = this.createCompilationContext(jspFile, useEditor);
        ExtractPageData epd = new ExtractPageData(ctxt);
        try {
            return new JspParserAPI.JspOpenInfo(epd.isXMLSyntax(), epd.getEncoding());
        }
        catch (Exception e) {
            LOG.fine(e.getMessage());
            return DEFAULT_JSP_OPEN_INFO;
        }
    }

    void reinitOptions() {
        assert (Thread.holdsLock(this));
        this.initOptions(false);
    }

    private synchronized void initOptions(boolean firstTime) {
        WebModule webModule;
        long start = 0L;
        if (LOG.isLoggable(Level.FINE)) {
            start = System.currentTimeMillis();
            LOG.fine("JSP parser " + (firstTime ? "" : "re") + "initializing for WM " + FileUtil.toFile((FileObject)this.wmRoot));
        }
        if ((webModule = this.wm.get()) == null) {
            LOG.fine("WebModule already GCed");
            return;
        }
        this.editorContext = new ParserServletContext(this.wmRoot, (ParserServletContext.WebModuleProvider)this, true);
        this.diskContext = new ParserServletContext(this.wmRoot, (ParserServletContext.WebModuleProvider)this, false);
        this.editorOptions = new OptionsImpl(this.editorContext);
        this.diskOptions = new OptionsImpl(this.diskContext);
        this.rctxt = null;
        this.createClassLoaders();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("JSP parser " + (firstTime ? "" : "re") + "initialized in " + (System.currentTimeMillis() - start) + " ms");
        }
    }

    private boolean isUnexpectedLibrary(URL url) {
        return false;
    }

    private void createClassLoaders() {
        FileObject classesDir;
        URL helpurl;
        Hashtable<URL, URL> tomcatTable = new Hashtable<URL, URL>();
        Hashtable<URL, URL> loadingTable = new Hashtable<URL, URL>();
        FileObject actualWebInf = this.getWebInf();
        this.putWebInfLibraries(actualWebInf, tomcatTable, loadingTable);
        ClassPath cp = ClassPath.getClassPath((FileObject)this.wmRoot, (String)"classpath/compile");
        if (cp != null) {
            for (FileObject root : cp.getRoots()) {
                helpurl = this.findInternalURL(root);
                if (loadingTable.get(helpurl) != null || this.isUnexpectedLibrary(helpurl)) continue;
                loadingTable.put(helpurl, helpurl);
                tomcatTable.put(helpurl, this.findExternalURL(root));
            }
        }
        if ((cp = ClassPath.getClassPath((FileObject)this.wmRoot, (String)"classpath/execute")) != null) {
            for (FileObject root : cp.getRoots()) {
                helpurl = this.findInternalURL(root);
                if (loadingTable.get(helpurl) != null || this.isUnexpectedLibrary(helpurl)) continue;
                loadingTable.put(helpurl, helpurl);
                tomcatTable.put(helpurl, this.findExternalURL(root));
            }
        }
        if (actualWebInf != null && (classesDir = actualWebInf.getFileObject("classes")) != null && loadingTable.get(helpurl = this.findInternalURL(classesDir)) == null) {
            loadingTable.put(helpurl, helpurl);
            tomcatTable.put(helpurl, helpurl);
        }
        URL[] loadingURLs = loadingTable.values().toArray(new URL[0]);
        URL[] tomcatURLs = tomcatTable.values().toArray(new URL[0]);
        this.waClassLoader = new ParserClassLoader(loadingURLs, tomcatURLs, this.getClass().getClassLoader());
        this.waContextClassLoader = new ParserClassLoader(loadingURLs, tomcatURLs, this.getClass().getClassLoader());
    }

    private FileObject getWebInf() {
        WebModule webModule = WebModule.getWebModule((FileObject)this.wmRoot);
        if (webModule != null) {
            return webModule.getWebInf();
        }
        return null;
    }

    private void putWebInfLibraries(FileObject webInf, Map<URL, URL> tomcatTable, Map<URL, URL> loadingTable) {
        if (webInf == null) {
            return;
        }
        FileObject libDir = webInf.getFileObject("lib");
        if (libDir == null) {
            return;
        }
        Enumeration libDirKids = libDir.getChildren(false);
        while (libDirKids.hasMoreElements()) {
            URL helpurl;
            FileObject elem = (FileObject)libDirKids.nextElement();
            if (!elem.getExt().equals("jar") || this.isUnexpectedLibrary(helpurl = this.findInternalURL(elem))) continue;
            tomcatTable.put(helpurl, helpurl);
            loadingTable.put(helpurl, helpurl);
        }
    }

    private URL findInternalURL(FileObject fo) {
        URL url = URLMapper.findURL((FileObject)fo, (int)0);
        return url;
    }

    private URL findExternalURL(FileObject fo) {
        URL u;
        URL archiveFile;
        File f = FileUtil.toFile((FileObject)fo);
        if (f != null) {
            try {
                return f.toURI().toURL();
            }
            catch (MalformedURLException e) {
                LOG.log(Level.INFO, null, e);
            }
        }
        if ((archiveFile = FileUtil.getArchiveFile((URL)(u = URLMapper.findURL((FileObject)fo, (int)1)))) != null) {
            return archiveFile;
        }
        return u;
    }

    private synchronized JspCompilationContext createCompilationContext(FileObject jspFile, boolean useEditor) {
        boolean isTagFile = this.determineIsTagFile(jspFile);
        String jspUri = this.getJSPUri(jspFile);
        OptionsImpl options = useEditor ? this.editorOptions : this.diskOptions;
        ServletContext context = useEditor ? this.editorContext : this.diskContext;
        JspCompilationContext clctxt = null;
        try {
            clctxt = isTagFile ? new JspCompilationContext(jspUri, null, (Options)options, context, null, this.rctxt, null) : new JspCompilationContext(jspUri, false, (Options)options, context, null, this.rctxt);
        }
        catch (JasperException ex) {
            LOG.log(Level.INFO, null, ex);
        }
        clctxt.setClassLoader(this.getWAClassLoader());
        return clctxt;
    }

    boolean determineIsTagFile(FileObject fo) {
        if (fo.getExt().startsWith("tag")) {
            return true;
        }
        return "text/x-tag".equals(fo.getMIMEType());
    }

    private String getJSPUri(FileObject jsp) {
        return ContextUtil.findRelativeContextPath((FileObject)this.wmRoot, (FileObject)jsp);
    }

    public JspParserAPI.ParseResult analyzePage(FileObject jspFile, int errorReportingMode) {
        this.checkReinitCachesTask();
        JspCompilationContext ctxt = this.createCompilationContext(jspFile, true);
        return this.callTomcatParser(jspFile, ctxt, this.waContextClassLoader, errorReportingMode);
    }

    public synchronized Map<String, String[]> getTaglibMap(boolean useEditor) throws IOException {
        this.checkReinitCachesTask();
        return new HashMap<String, String[]>(this.mappings);
    }

    public synchronized URLClassLoader getWAClassLoader() {
        if (this.cpCurrent.get() != 0L) {
            this.reinitOptions();
        }
        return this.waClassLoader;
    }

    private JspParserAPI.ParseResult callTomcatParser(final FileObject jspFile, final JspCompilationContext ctxt, ClassLoader contextClassLoader, final int errorReportingMode) {
        final RRef resultRef = new RRef();
        Thread compThread = new Thread("JSP Parsing"){

            private void setResult(GetParseData gpd) {
                PageInfo nbPageInfo = gpd.getNbPageInfo();
                Node.Nodes nbNodes = gpd.getNbNodes();
                Throwable e = gpd.getParseException();
                if (e == null) {
                    resultRef.result = new JspParserAPI.ParseResult(nbPageInfo, nbNodes);
                } else {
                    Exceptions.attachLocalizedMessage((Throwable)e, (String)NbBundle.getMessage(WebAppParseSupport.class, (String)"MSG_errorDuringJspParsing"));
                    LOG.fine(e.getMessage());
                    JspParserAPI.ErrorDescriptor error = WebAppParseSupport.constructErrorDescriptor(e, WebAppParseSupport.this.wmRoot, jspFile);
                    resultRef.result = new JspParserAPI.ParseResult(nbPageInfo, nbNodes, new JspParserAPI.ErrorDescriptor[]{error});
                }
            }

            public void run() {
                GetParseData gpd = null;
                try {
                    gpd = new GetParseData(ctxt, errorReportingMode);
                    gpd.parse();
                    this.setResult(gpd);
                }
                catch (ThreadDeath td) {
                    LOG.log(Level.INFO, null, td);
                    throw td;
                }
                catch (Throwable t) {
                    if (gpd != null) {
                        this.setResult(gpd);
                    }
                    LOG.log(Level.INFO, null, t);
                }
            }
        };
        compThread.setContextClassLoader(contextClassLoader);
        compThread.start();
        try {
            compThread.join();
            return resultRef.result;
        }
        catch (InterruptedException e) {
            JspParserAPI.ErrorDescriptor error = WebAppParseSupport.constructErrorDescriptor(e, this.wmRoot, jspFile);
            return new JspParserAPI.ParseResult(new JspParserAPI.ErrorDescriptor[]{error});
        }
    }

    private static JspParserAPI.ErrorDescriptor constructErrorDescriptor(Throwable e, FileObject wmRoot, FileObject jspPage) {
        JspParserAPI.ErrorDescriptor error = null;
        try {
            error = WebAppParseSupport.constructJakartaErrorDescriptor(wmRoot, jspPage, e);
        }
        catch (FileStateInvalidException e2) {
            LOG.log(Level.INFO, null, e2);
        }
        catch (IOException e2) {
            LOG.log(Level.INFO, null, e2);
        }
        if (error == null) {
            error = new JspParserAPI.ErrorDescriptor(wmRoot, jspPage, -1, -1, ContextUtil.getThrowableMessage((Throwable)e, (!(e instanceof JasperException) ? 1 : 0) != 0), "");
        }
        return error;
    }

    private static JspParserAPI.ErrorDescriptor constructJakartaErrorDescriptor(FileObject wmRoot, FileObject jspPage, Throwable ex) throws IOException {
        String wmFileName;
        String m1;
        Throwable last = ex;
        while (ex instanceof JasperException) {
            last = ex;
            if ((ex = ((JasperException)ex).getRootCause()) == null) continue;
            ErrorManager.getDefault().annotate(last, ex);
        }
        if (ex == null) {
            ex = last;
        }
        if ((m1 = ex.getMessage()) == null) {
            return null;
        }
        int lpar = m1.indexOf(40);
        if (lpar == -1) {
            return null;
        }
        int comma = m1.indexOf(44, lpar);
        if (comma == -1) {
            return null;
        }
        int rpar = m1.indexOf(41, comma);
        if (rpar == -1) {
            return null;
        }
        String line = m1.substring(lpar + 1, comma).trim();
        String col = m1.substring(comma + 1, rpar).trim();
        String fileName = m1.substring(0, lpar);
        File file = FileUtil.toFile((FileObject)wmRoot);
        FileObject errorFile = jspPage;
        if ((fileName = new File(fileName).getCanonicalPath()).startsWith(wmFileName = file.getCanonicalPath())) {
            FileObject errorTemp;
            String errorRes = fileName.substring(wmFileName.length());
            if ((errorRes = errorRes.replace(File.separatorChar, '/')).startsWith("/")) {
                errorRes = errorRes.substring(1);
            }
            if ((errorTemp = wmRoot.getFileObject(errorRes)) != null) {
                errorFile = errorTemp;
            }
        }
        try {
            String errorMessage;
            String errContextPath = ContextUtil.findRelativeContextPath((FileObject)wmRoot, (FileObject)errorFile);
            int index = m1.indexOf("PWC");
            if (index > -1) {
                index = m1.indexOf(58, index);
                errorMessage = m1.substring(index + 2).trim();
            } else {
                errorMessage = errContextPath + " [" + line + ";" + col + "] " + m1.substring(rpar + 1).trim();
            }
            return new JspParserAPI.ErrorDescriptor(wmRoot, errorFile, Integer.parseInt(line), Integer.parseInt(col), errorMessage, "");
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        LOG.fine("Class path has changed");
        this.cpCurrent.incrementAndGet();
        this.reinitCachesTask.schedule(2000);
    }

    private void clearTagLibraryInfoCache() {
        assert (Thread.holdsLock(this));
        ConcurrentHashMap map = (ConcurrentHashMap)this.editorContext.getAttribute("com.sun.jsp.taglibraryCache");
        if (map != null) {
            map.clear();
        }
        if ((map = (ConcurrentHashMap)this.diskContext.getAttribute("com.sun.jsp.taglibraryCache")) != null) {
            map.clear();
        }
    }

    void reinitTagLibMappings() {
        assert (Thread.holdsLock(this));
        try {
            TldLocationsCache lc = this.editorOptions.getTldLocationsCache();
            Field mappingsField = TldLocationsCache.class.getDeclaredField("mappings");
            mappingsField.setAccessible(true);
            Map tmpMappings = (Map)mappingsField.get(lc);
            if (tmpMappings != null) {
                tmpMappings.clear();
            }
            InitTldLocationCacheThread compThread = new InitTldLocationCacheThread(lc);
            compThread.setContextClassLoader(this.waContextClassLoader);
            long start = 0L;
            if (LOG.isLoggable(Level.FINE)) {
                start = System.currentTimeMillis();
                LOG.fine("InitTldLocationCacheThread start");
            }
            compThread.start();
            try {
                compThread.join();
                if (LOG.isLoggable(Level.FINE)) {
                    long end = System.currentTimeMillis();
                    LOG.fine("InitTldLocationCacheThread finished in " + (end - start) + " ms");
                }
            }
            catch (InterruptedException e) {
                LOG.log(Level.INFO, null, e);
            }
            tmpMappings = (Map)mappingsField.get(lc);
            lc = this.diskOptions.getTldLocationsCache();
            mappingsField = TldLocationsCache.class.getDeclaredField("mappings");
            mappingsField.setAccessible(true);
            mappingsField.set(lc, tmpMappings);
            this.mappings.clear();
            this.mappings.putAll(tmpMappings);
            this.mappings.putAll(this.getImplicitLocation());
        }
        catch (NoSuchFieldException e) {
            LOG.log(Level.INFO, null, e);
        }
        catch (IllegalAccessException e) {
            LOG.log(Level.INFO, null, e);
        }
    }

    private Map<String, String[]> getImplicitLocation() {
        assert (Thread.holdsLock(this));
        HashMap<String, String[]> returnMap = new HashMap<String, String[]>();
        if (this.webInf != null && this.webInf.isFolder()) {
            Enumeration en = this.webInf.getChildren(true);
            while (en.hasMoreElements()) {
                FileObject fo = (FileObject)en.nextElement();
                if (!fo.getExt().equals("tld")) continue;
                String path = ContextUtil.isInSubTree((FileObject)this.wmRoot, (FileObject)fo) ? "/" + ContextUtil.findRelativePath((FileObject)this.wmRoot, (FileObject)fo) : "/WEB-INF/" + ContextUtil.findRelativePath((FileObject)this.webInf, (FileObject)fo);
                returnMap.put(path, new String[]{path, null});
            }
        }
        return returnMap;
    }

    private synchronized void checkReinitCachesTask() {
        if (!this.reinitCachesTask.isFinished()) {
            this.reinitCachesTask.cancel();
            this.reinitCaches();
        }
    }

    void reinitCaches() {
        assert (Thread.holdsLock(this));
        long counter = this.cpCurrent.get();
        LOG.fine("Current class path: " + (counter == 0L));
        if (counter != 0L) {
            this.reinitOptions();
            boolean cpSet = this.cpCurrent.compareAndSet(counter, 0L);
            LOG.fine("Class path " + (cpSet ? "" : "*NOT* ") + "set to current");
        }
        this.clearTagLibraryInfoCache();
        this.reinitTagLibMappings();
        this.tldChangeTask.run();
    }

    public WebModule getWebModule() {
        return this.wm.get();
    }

    final class FileSystemListener
    extends FileChangeAdapter {
        FileSystemListener() {
        }

        public void fileChanged(FileEvent fe) {
            this.processFileChange(fe);
        }

        public void fileDataCreated(FileEvent fe) {
            this.processFileChange(fe);
        }

        public void fileDeleted(FileEvent fe) {
            this.processFileChange(fe);
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.processFileChange((FileEvent)fe);
        }

        private void processFileChange(FileEvent fe) {
            FileObject fo = fe.getFile();
            if ((fo.getExt().equals("tld") || fo.getNameExt().equals("web.xml") || WebAppParseSupport.this.determineIsTagFile(fo)) && (FileUtil.isParentOf((FileObject)WebAppParseSupport.this.wmRoot, (FileObject)fo) || FileUtil.isParentOf((FileObject)WebAppParseSupport.this.webInf, (FileObject)fo))) {
                LOG.fine("File " + fo + " has changed, reinitCaches() called");
                if (fo.getNameExt().equals("web.xml")) {
                    WebAppParseSupport.this.cpCurrent.incrementAndGet();
                }
                WebAppParseSupport.this.reinitCachesTask.schedule(1000);
            }
        }
    }

    private static class InitTldLocationCacheThread
    extends Thread {
        private final TldLocationsCache cache;

        InitTldLocationCacheThread(TldLocationsCache lc) {
            super("Init TldLocationCache");
            this.cache = lc;
        }

        public void run() {
            try {
                Field initialized = TldLocationsCache.class.getDeclaredField("initialized");
                initialized.setAccessible(true);
                initialized.setBoolean(this.cache, false);
                this.cache.getLocation("");
            }
            catch (JasperException e) {
                LOG.log(Level.INFO, null, e);
            }
            catch (NoSuchFieldException e) {
                LOG.log(Level.INFO, null, e);
            }
            catch (IllegalAccessException e) {
                LOG.log(Level.INFO, null, e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ParserClassLoader
    extends URLClassLoader {
        private static final Logger LOGGER = Logger.getLogger(ParserClassLoader.class.getName());
        private static final AllPermission ALL_PERM = new AllPermission();
        private static final String LOGGING_CONFIG = "commons-logging.properties";
        private static final String SERVICES_FOLDER = "META-INF/services/";
        private static final Set<String> FORBIDDEN_PACKAGES = new HashSet<String>();
        private static final List<String> LOG4J_CONFIGS = Arrays.asList("log4j.properties", "log4j.xml");
        private final URL[] tomcatURLs;
        private final ClassLoader parent;

        public ParserClassLoader(URL[] classLoadingURLs, URL[] tomcatURLs, ClassLoader parent) {
            super(classLoadingURLs, parent);
            this.parent = parent;
            this.tomcatURLs = tomcatURLs;
        }

        @Override
        public URL[] getURLs() {
            return this.tomcatURLs;
        }

        @Override
        protected PermissionCollection getPermissions(CodeSource codesource) {
            PermissionCollection perms = super.getPermissions(codesource);
            perms.add(ALL_PERM);
            return perms;
        }

        @Override
        public URL getResource(String name) {
            if (LOG4J_CONFIGS.contains(name)) {
                return null;
            }
            URL url = this.parent != null ? this.parent.getResource(name) : this.findResource(name);
            return url;
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            if (!name.equals("META-INF/services/javax.xml.stream.XMLInputFactory") && name.startsWith("META-INF/services/javax.xml.")) {
                return new ByteArrayInputStream(new byte[0]);
            }
            URL url = this.getResource(name);
            try {
                if (url != null) {
                    URLConnection conn = url.openConnection();
                    conn.setUseCaches(false);
                    return conn.getInputStream();
                }
                return null;
            }
            catch (IOException e) {
                return null;
            }
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            boolean forbidden = false;
            for (String packageName : FORBIDDEN_PACKAGES) {
                if (!name.startsWith(packageName)) continue;
                forbidden = true;
                break;
            }
            if (forbidden) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.log(Level.FINER, "Denying access to " + name);
                }
                throw new ClassNotFoundException(name);
            }
            return super.findClass(name);
        }

        @Override
        public URL findResource(String name) {
            if (LOGGING_CONFIG.equals(name) || name.startsWith(SERVICES_FOLDER)) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.log(Level.FINER, "Discarding request for " + name);
                }
                return null;
            }
            return super.findResource(name);
        }

        @Override
        public Enumeration<URL> findResources(String name) throws IOException {
            if (LOGGING_CONFIG.equals(name) || name.startsWith(SERVICES_FOLDER)) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.log(Level.FINEST, "Discarding request for " + name);
                }
                return Collections.enumeration(Collections.emptyList());
            }
            return super.findResources(name);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.toString());
            sb.append(", parent : ");
            sb.append(this.getParent().toString());
            return sb.toString();
        }
    }

    public static class JasperSystemClassLoader
    extends URLClassLoader {
        private static final AllPermission ALL_PERM = new AllPermission();

        public JasperSystemClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        protected PermissionCollection getPermissions(CodeSource codesource) {
            PermissionCollection perms = super.getPermissions(codesource);
            perms.add(ALL_PERM);
            return perms;
        }
    }

    final class TldChange
    implements Runnable {
        TldChange() {
        }

        public void run() {
            WebModule webModule = (WebModule)WebAppParseSupport.this.wm.get();
            if (webModule == null) {
                return;
            }
            LOG.fine("TLD change fired");
            WebAppParseSupport.this.jspParser.fireChange(webModule);
        }
    }

    final class ReinitCaches
    implements Runnable {
        ReinitCaches() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            WebAppParseSupport webAppParseSupport = WebAppParseSupport.this;
            synchronized (webAppParseSupport) {
                LOG.fine("ReinitCaches task started");
                WebAppParseSupport.this.reinitCaches();
                LOG.fine("ReinitCaches task finished");
            }
        }
    }

    public class RRef {
        JspParserAPI.ParseResult result;
    }
}

