/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.File;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagFileInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.BeanRepository;
import org.apache.jasper.compiler.Collector;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.CompilerHacks;
import org.apache.jasper.compiler.ELFunctionMapper;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.ImplicitTagLibraryInfo;
import org.apache.jasper.compiler.JspConfig;
import org.apache.jasper.compiler.JspProperty;
import org.apache.jasper.compiler.JspUtil;
import org.apache.jasper.compiler.NbValidator;
import org.apache.jasper.compiler.Node;
import org.apache.jasper.compiler.NodeConverterVisitor;
import org.apache.jasper.compiler.PageInfo;
import org.apache.jasper.compiler.ParserController;
import org.apache.jasper.compiler.ScriptingVariabler;
import org.apache.jasper.compiler.TagPluginManager;
import org.netbeans.modules.web.jsps.parserapi.Node;
import org.netbeans.modules.web.jsps.parserapi.PageInfo;

public class GetParseData {
    private static final Logger LOGGER = Logger.getLogger(GetParseData.class.getName());
    private final JspCompilationContext ctxt;
    private final Options options;
    private final CompilerHacks compHacks;
    private int errorReportingMode;
    private Node.Nodes nbNodes;
    private org.netbeans.modules.web.jsps.parserapi.PageInfo nbPageInfo;
    private Throwable parseException;
    private static Field sessionBeansF;
    private static Field pageBeansF;
    private static Field appBeansF;
    private static Field requestBeansF;
    private static Field beanTypesF;
    private static Field pluginDclsF;
    private static Field prefixesF;
    private static Field taglibsMapF;
    private static Field jspPrefixMapperF;
    private static Field xmlPrefixMapperF;
    private static Hashtable<URL, TagFileInfoCacheRecord> tagFileInfoCache;

    public GetParseData(JspCompilationContext ctxt, int errorReportingMode) {
        this.ctxt = ctxt;
        this.errorReportingMode = errorReportingMode;
        this.options = ctxt.getOptions();
        this.compHacks = new CompilerHacks(ctxt);
    }

    public Node.Nodes getNbNodes() {
        return this.nbNodes;
    }

    public org.netbeans.modules.web.jsps.parserapi.PageInfo getNbPageInfo() {
        return this.nbPageInfo;
    }

    public Throwable getParseException() {
        return this.parseException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void parse() {
        block25: {
            Throwable e2;
            String xmlView;
            PageInfo pageInfo;
            Node.Nodes pageNodes;
            block24: {
                pageNodes = null;
                pageInfo = null;
                xmlView = null;
                Compiler comp = this.compHacks.getCompiler();
                pageInfo = comp.getPageInfo();
                ErrorDispatcher errDispatcher = comp.getErrorDispatcher();
                JspConfig jspConfig = this.options.getJspConfig();
                JspProperty jspProperty = jspConfig.findJspProperty(this.ctxt.getJspFile());
                pageInfo.setELIgnored(JspUtil.booleanValue((String)jspProperty.isELIgnored()));
                pageInfo.setScriptingInvalid(JspUtil.booleanValue((String)jspProperty.isScriptingInvalid()));
                if (jspProperty.getIncludePrelude() != null) {
                    pageInfo.setIncludePrelude(jspProperty.getIncludePrelude());
                }
                if (jspProperty.getIncludeCoda() != null) {
                    pageInfo.setIncludeCoda(jspProperty.getIncludeCoda());
                }
                JspUtil.resetTemporaryVariableName();
                ParserController parserCtl = new ParserController(this.ctxt, comp);
                pageNodes = parserCtl.parse(this.ctxt.getJspFile());
                xmlView = NbValidator.validate(comp, pageNodes);
                Collector.collect((Compiler)comp, (Node.Nodes)pageNodes);
                if (this.ctxt.isTagFile()) {
                    String tagDir = this.ctxt.getJspFile();
                    int lastIndex = tagDir.lastIndexOf(47);
                    int lastDotIndex = tagDir.lastIndexOf(46);
                    String tagName = lastDotIndex > 0 ? tagDir.substring(lastIndex + 1, lastDotIndex) : tagDir.substring(lastIndex + 1);
                    tagDir = tagDir.substring(0, tagDir.lastIndexOf(47) + 1);
                    ImplicitTagLibraryInfo tagLibrary = new ImplicitTagLibraryInfo(this.ctxt, parserCtl, "virtual", tagDir, errDispatcher);
                    this.ctxt.setTagInfo(tagLibrary.getTagFile(tagName).getTagInfo());
                }
                ScriptingVariabler.set((Node.Nodes)pageNodes, (ErrorDispatcher)errDispatcher);
                TagPluginManager tagPluginManager = this.options.getTagPluginManager();
                tagPluginManager.apply(pageNodes, errDispatcher, pageInfo);
                ELFunctionMapper.map((Compiler)comp, (Node.Nodes)pageNodes);
                Object var15_16 = null;
                try {
                    if (pageNodes != null) {
                        this.nbNodes = GetParseData.convertNodes(pageNodes);
                    }
                }
                catch (JasperException e2) {
                    if (this.parseException != null) break block24;
                    this.parseException = e2;
                }
            }
            try {
                if (pageInfo != null) {
                    this.nbPageInfo = GetParseData.convertPageInfo(pageInfo, xmlView, this.ctxt);
                }
                break block25;
            }
            catch (JspException e2) {
                if (this.parseException == null) {
                    this.parseException = e2;
                }
                break block25;
            }
            {
                catch (ThreadDeath t) {
                    throw t;
                }
                catch (Throwable t) {
                    block26: {
                        this.parseException = t;
                        Object var15_17 = null;
                        try {
                            if (pageNodes != null) {
                                this.nbNodes = GetParseData.convertNodes(pageNodes);
                            }
                        }
                        catch (JasperException e2) {
                            if (this.parseException != null) break block26;
                            this.parseException = e2;
                        }
                    }
                    try {
                        if (pageInfo != null) {
                            this.nbPageInfo = GetParseData.convertPageInfo(pageInfo, xmlView, this.ctxt);
                        }
                        break block25;
                    }
                    catch (JspException e2) {
                        if (this.parseException == null) {
                            this.parseException = e2;
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block28: {
                    block27: {
                        Object var15_18 = null;
                        try {
                            if (pageNodes != null) {
                                this.nbNodes = GetParseData.convertNodes(pageNodes);
                            }
                        }
                        catch (JasperException e2) {
                            if (this.parseException != null) break block27;
                            this.parseException = e2;
                        }
                    }
                    try {
                        if (pageInfo != null) {
                            this.nbPageInfo = GetParseData.convertPageInfo(pageInfo, xmlView, this.ctxt);
                        }
                    }
                    catch (JspException e2) {
                        if (this.parseException != null) break block28;
                        this.parseException = e2;
                    }
                }
                throw throwable;
            }
        }
    }

    private static Node.Nodes convertNodes(Node.Nodes nodes) throws JasperException {
        Node.Nodes nbNodes = NodeConverterVisitor.convertNodes(nodes);
        return nbNodes;
    }

    private static org.netbeans.modules.web.jsps.parserapi.PageInfo convertPageInfo(PageInfo pageInfo, String xmlView, JspCompilationContext ctxt) throws JspException {
        PageInfoImpl nbPageInfo = new PageInfoImpl(GetParseData.getTaglibsMapReflect(pageInfo, ctxt), GetParseData.getJSPPrefixMapperReflect(pageInfo), GetParseData.getXMLPrefixMapperReflect(pageInfo), ((CompilerHacks.HackPageInfo)pageInfo).getApproxXmlPrefixMapper(), pageInfo.getImports(), pageInfo.getDependants(), pageInfo.getIncludePrelude(), pageInfo.getIncludeCoda(), GetParseData.getPluginDclsReflect(pageInfo), GetParseData.getPrefixesReflect(pageInfo));
        nbPageInfo.setLanguage(pageInfo.getLanguage());
        nbPageInfo.setExtends(pageInfo.getExtends());
        nbPageInfo.setContentType(pageInfo.getContentType());
        nbPageInfo.setSession(pageInfo.getSession());
        nbPageInfo.setBufferValue(pageInfo.getBufferValue());
        nbPageInfo.setAutoFlush(pageInfo.getAutoFlush());
        nbPageInfo.setIsThreadSafe(pageInfo.getIsThreadSafe());
        nbPageInfo.setIsErrorPage(pageInfo.getIsErrorPage());
        nbPageInfo.setErrorPage(pageInfo.getErrorPage());
        nbPageInfo.setScriptless(pageInfo.isScriptless());
        nbPageInfo.setScriptingInvalid(pageInfo.isScriptingInvalid());
        nbPageInfo.setELIgnored(pageInfo.isELIgnored());
        nbPageInfo.setOmitXmlDecl(pageInfo.getOmitXmlDecl());
        nbPageInfo.setIsJspPrefixHijacked(pageInfo.isJspPrefixHijacked());
        nbPageInfo.setDoctypeName(pageInfo.getDoctypeName());
        nbPageInfo.setDoctypeSystem(pageInfo.getDoctypeSystem());
        nbPageInfo.setDoctypePublic(pageInfo.getDoctypePublic());
        nbPageInfo.setHasJspRoot(pageInfo.hasJspRoot());
        nbPageInfo.setBeans(GetParseData.createBeanData(pageInfo.getBeanRepository()));
        nbPageInfo.setXMLView(xmlView);
        nbPageInfo.setTagFile(ctxt.isTagFile());
        nbPageInfo.setTagInfo(ctxt.getTagInfo());
        return nbPageInfo;
    }

    private static PageInfo.BeanData[] createBeanData(BeanRepository rep) {
        try {
            GetParseData.initBeanRepositoryFields();
            Vector sessionBeans = (Vector)sessionBeansF.get(rep);
            Vector pageBeans = (Vector)pageBeansF.get(rep);
            Vector appBeans = (Vector)appBeansF.get(rep);
            Vector requestBeans = (Vector)requestBeansF.get(rep);
            Hashtable beanTypes = (Hashtable)beanTypesF.get(rep);
            int size = beanTypes.size();
            PageInfo.BeanData[] bd = new PageInfo.BeanData[size];
            Iterator it = beanTypes.keySet().iterator();
            int index = 0;
            while (it.hasNext()) {
                String id = (String)it.next();
                String type = (String)beanTypes.get(id);
                int scope = 1;
                if (sessionBeans.contains(id)) {
                    scope = 3;
                }
                if (appBeans.contains(id)) {
                    scope = 4;
                }
                if (requestBeans.contains(id)) {
                    scope = 2;
                }
                bd[index] = new BeanDataImpl(id, scope, type);
                ++index;
            }
            return bd;
        }
        catch (IllegalAccessException e) {
            LOGGER.log(Level.INFO, null, e);
            throw new RuntimeException();
        }
    }

    private static void initBeanRepositoryFields() {
        if (sessionBeansF == null) {
            try {
                sessionBeansF = BeanRepository.class.getDeclaredField("sessionBeans");
                sessionBeansF.setAccessible(true);
                pageBeansF = BeanRepository.class.getDeclaredField("pageBeans");
                pageBeansF.setAccessible(true);
                appBeansF = BeanRepository.class.getDeclaredField("appBeans");
                appBeansF.setAccessible(true);
                requestBeansF = BeanRepository.class.getDeclaredField("requestBeans");
                requestBeansF.setAccessible(true);
                beanTypesF = BeanRepository.class.getDeclaredField("beanTypes");
                beanTypesF.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                LOGGER.log(Level.INFO, null, e);
            }
        }
    }

    private static void initPageInfoFields() {
        if (pluginDclsF == null) {
            try {
                pluginDclsF = PageInfo.class.getDeclaredField("pluginDcls");
                pluginDclsF.setAccessible(true);
                prefixesF = PageInfo.class.getDeclaredField("prefixes");
                prefixesF.setAccessible(true);
                taglibsMapF = PageInfo.class.getDeclaredField("taglibsMap");
                taglibsMapF.setAccessible(true);
                jspPrefixMapperF = PageInfo.class.getDeclaredField("jspPrefixMapper");
                jspPrefixMapperF.setAccessible(true);
                xmlPrefixMapperF = PageInfo.class.getDeclaredField("xmlPrefixMapper");
                xmlPrefixMapperF.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                LOGGER.log(Level.INFO, null, e);
            }
        }
    }

    private static Vector getPluginDclsReflect(PageInfo pageInfo) {
        GetParseData.initPageInfoFields();
        try {
            return (Vector)pluginDclsF.get(pageInfo);
        }
        catch (IllegalAccessException e) {
            LOGGER.log(Level.INFO, null, e);
            throw new RuntimeException();
        }
    }

    private static HashSet getPrefixesReflect(PageInfo pageInfo) {
        GetParseData.initPageInfoFields();
        try {
            return (HashSet)prefixesF.get(pageInfo);
        }
        catch (IllegalAccessException e) {
            LOGGER.log(Level.INFO, null, e);
            throw new RuntimeException();
        }
    }

    private static Map getTaglibsMapReflect(PageInfo pageInfo, JspCompilationContext ctxt) {
        GetParseData.initPageInfoFields();
        try {
            Map taglibs = (Map)taglibsMapF.get(pageInfo);
            for (TagLibraryInfo libInfo : taglibs.values()) {
                try {
                    if (!(libInfo instanceof ImplicitTagLibraryInfo)) continue;
                    Field tagFileMapF = ImplicitTagLibraryInfo.class.getDeclaredField("tagFileMap");
                    tagFileMapF.setAccessible(true);
                    Hashtable tagFileMap = (Hashtable)tagFileMapF.get(libInfo);
                    TagFileInfo[] tagFiles = new TagFileInfo[tagFileMap.size()];
                    int index = 0;
                    Enumeration e = tagFileMap.keys();
                    while (e.hasMoreElements()) {
                        String name = (String)e.nextElement();
                        String filePath = (String)tagFileMap.get(name);
                        URL path = ctxt.getResource(filePath);
                        File file = new File(new URI(path.toExternalForm()));
                        if (tagFileInfoCache.containsKey(path)) {
                            TagFileInfoCacheRecord r = tagFileInfoCache.get(path);
                            if (r.time < file.lastModified()) {
                                tagFileInfoCache.put(path, new TagFileInfoCacheRecord(file.lastModified(), libInfo.getTagFile(name)));
                            }
                        } else {
                            tagFileInfoCache.put(path, new TagFileInfoCacheRecord(file.lastModified(), libInfo.getTagFile(name)));
                        }
                        tagFiles[index++] = GetParseData.tagFileInfoCache.get((Object)path).tagFileInfo;
                    }
                    Field tagInfosF = ImplicitTagLibraryInfo.class.getSuperclass().getDeclaredField("tagFiles");
                    tagInfosF.setAccessible(true);
                    tagInfosF.set(libInfo, tagFiles);
                }
                catch (NoSuchFieldException e) {
                    LOGGER.log(Level.INFO, null, e);
                }
                catch (MalformedURLException e) {
                    LOGGER.log(Level.INFO, null, e);
                }
                catch (URISyntaxException e) {
                    LOGGER.log(Level.INFO, null, e);
                }
            }
            return taglibs;
        }
        catch (IllegalAccessException e) {
            LOGGER.log(Level.INFO, null, e);
            throw new RuntimeException();
        }
    }

    private static Map getJSPPrefixMapperReflect(PageInfo pageInfo) {
        GetParseData.initPageInfoFields();
        try {
            return (Map)jspPrefixMapperF.get(pageInfo);
        }
        catch (IllegalAccessException e) {
            LOGGER.log(Level.INFO, null, e);
            throw new RuntimeException();
        }
    }

    private static Map getXMLPrefixMapperReflect(PageInfo pageInfo) {
        GetParseData.initPageInfoFields();
        try {
            return (Map)xmlPrefixMapperF.get(pageInfo);
        }
        catch (IllegalAccessException e) {
            LOGGER.log(Level.INFO, null, e);
            throw new RuntimeException();
        }
    }

    static {
        tagFileInfoCache = new Hashtable();
    }

    private static class TagFileInfoCacheRecord {
        final long time;
        final TagFileInfo tagFileInfo;

        public TagFileInfoCacheRecord(long time, TagFileInfo info) {
            this.tagFileInfo = info;
            this.time = time;
        }
    }

    static class BeanDataImpl
    implements PageInfo.BeanData {
        private final String id;
        private final int scope;
        private final String className;

        BeanDataImpl(String id, int scope, String className) {
            this.id = id;
            this.scope = scope;
            this.className = className;
        }

        public String getId() {
            return this.id;
        }

        public int getScope() {
            return this.scope;
        }

        public String getClassName() {
            return this.className;
        }
    }

    static class PageInfoImpl
    extends org.netbeans.modules.web.jsps.parserapi.PageInfo {
        private String xmlView;

        public PageInfoImpl(Map taglibsMap, Map jspPrefixMapper, Map xmlPrefixMapper, Map approxXmlPrefixMapper, List imports, List dependants, List includePrelude, List includeCoda, List pluginDcls, Set prefixes) {
            super(taglibsMap, jspPrefixMapper, xmlPrefixMapper, approxXmlPrefixMapper, imports, dependants, includePrelude, includeCoda, pluginDcls, prefixes);
        }

        public void setXMLView(String xmlView) {
            this.xmlView = xmlView;
        }

        public String getXMLView() {
            return this.xmlView;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.toString());
            sb.append(" ------- XML View (constructed from the original data structure) -----\n");
            if (this.xmlView == null) {
                sb.append("no XML view\n");
            } else {
                sb.append(this.getXMLView());
            }
            return sb.toString();
        }
    }
}

