/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.debugger.pem;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.netbeans.modules.bpel.debugger.api.pem.PemEntity;
import org.netbeans.modules.bpel.debugger.api.pem.ProcessExecutionModel;
import org.netbeans.modules.bpel.debugger.api.psm.ProcessStaticModel;
import org.netbeans.modules.bpel.debugger.api.psm.PsmEntity;
import org.netbeans.modules.bpel.debugger.bdiclient.impl.ProcessInstanceImpl;
import org.netbeans.modules.bpel.debugger.eventlog.ActivityCompletedRecord;
import org.netbeans.modules.bpel.debugger.eventlog.ActivityStartedRecord;
import org.netbeans.modules.bpel.debugger.eventlog.ActivityTerminatedRecord;
import org.netbeans.modules.bpel.debugger.eventlog.BranchCompletedRecord;
import org.netbeans.modules.bpel.debugger.eventlog.BranchStartedRecord;
import org.netbeans.modules.bpel.debugger.eventlog.EventLog;
import org.netbeans.modules.bpel.debugger.eventlog.EventRecord;
import org.netbeans.modules.bpel.debugger.eventlog.ProcessInstanceCompletedRecord;
import org.netbeans.modules.bpel.debugger.eventlog.ProcessInstanceStartedRecord;
import org.netbeans.modules.bpel.debugger.pem.PemEntityImpl;
import org.netbeans.modules.bpel.debugger.pem.PemLoopEntityImpl;
import org.netbeans.modules.bpel.debugger.pem.PemNonLoopEntityImpl;

public class ProcessExecutionModelImpl
implements ProcessExecutionModel {
    private final ProcessInstanceImpl myProcessInstance;
    private final ProcessStaticModel myPsm;
    private final Map<String, BranchImpl> myBranches = new HashMap<String, BranchImpl>();
    private BranchImpl myCurrentBranch;
    private final List<ProcessExecutionModel.Listener> myListeners = new LinkedList<ProcessExecutionModel.Listener>();
    private PemEntityImpl myRoot;
    private PemEntityImpl myLastStartedEntity;
    private final EventLog myEventLog;
    private final EventLogListener myEventLogListener;
    private int myLastEventIndex = -1;

    public static ProcessExecutionModelImpl build(ProcessInstanceImpl processInstanceImpl) {
        if (processInstanceImpl.getEventLog() == null) {
            return null;
        }
        if (processInstanceImpl.getProcess().getProcessStaticModel() == null) {
            return null;
        }
        ProcessExecutionModelImpl processExecutionModelImpl = new ProcessExecutionModelImpl(processInstanceImpl);
        processExecutionModelImpl.update();
        return processExecutionModelImpl;
    }

    private ProcessExecutionModelImpl(ProcessInstanceImpl processInstanceImpl) {
        this.myProcessInstance = processInstanceImpl;
        this.myPsm = this.myProcessInstance.getProcess().getProcessStaticModel();
        this.myEventLog = this.myProcessInstance.getEventLog();
        this.myEventLogListener = new EventLogListener();
        this.myEventLog.addListener(this.myEventLogListener);
    }

    public ProcessStaticModel getProcessStaticModel() {
        return this.myPsm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PemEntityImpl getRoot() {
        ProcessExecutionModelImpl processExecutionModelImpl = this;
        synchronized (processExecutionModelImpl) {
            return this.myRoot;
        }
    }

    public PemEntityImpl getLastStartedEntity() {
        return this.myLastStartedEntity;
    }

    public ProcessExecutionModel.Branch[] getBranches() {
        return this.myBranches.values().toArray(new ProcessExecutionModel.Branch[this.myBranches.size()]);
    }

    public ProcessExecutionModel.Branch[] getBranches(ProcessExecutionModel.Branch branch) {
        LinkedList<BranchImpl> linkedList = new LinkedList<BranchImpl>();
        for (BranchImpl branchImpl : this.myBranches.values()) {
            if (branch == null && branchImpl.getParent() == null) {
                linkedList.add(branchImpl);
                continue;
            }
            if (branch == null || branchImpl.getParent() == null || !branchImpl.getParent().equals(branch)) continue;
            linkedList.add(branchImpl);
        }
        return linkedList.toArray(new ProcessExecutionModel.Branch[linkedList.size()]);
    }

    public ProcessExecutionModel.Branch getCurrentBranch() {
        return this.myCurrentBranch;
    }

    public void setCurrentBranch(String string) {
        this.myCurrentBranch = this.myBranches.get(string);
        this.myProcessInstance.stepInto();
    }

    public void setCurrentBranchWithoutResume(String string) {
        this.myCurrentBranch = this.myBranches.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ProcessExecutionModel.Listener listener) {
        List<ProcessExecutionModel.Listener> list = this.myListeners;
        synchronized (list) {
            this.myListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ProcessExecutionModel.Listener listener) {
        List<ProcessExecutionModel.Listener> list = this.myListeners;
        synchronized (list) {
            this.myListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() {
        boolean bl = false;
        ProcessExecutionModelImpl processExecutionModelImpl = this;
        synchronized (processExecutionModelImpl) {
            EventRecord[] eventRecordArray;
            int n = this.myEventLog.getSize();
            if (n <= this.myLastEventIndex + 1) {
                return;
            }
            for (EventRecord eventRecord : eventRecordArray = this.myEventLog.getRecords(this.myLastEventIndex + 1, n)) {
                ++this.myLastEventIndex;
                if (eventRecord instanceof ActivityStartedRecord) {
                    this.update((ActivityStartedRecord)eventRecord);
                } else if (eventRecord instanceof ActivityCompletedRecord) {
                    this.update((ActivityCompletedRecord)eventRecord);
                } else if (eventRecord instanceof ActivityTerminatedRecord) {
                    this.update((ActivityTerminatedRecord)eventRecord);
                } else if (eventRecord instanceof BranchStartedRecord) {
                    this.update((BranchStartedRecord)eventRecord);
                } else if (eventRecord instanceof BranchCompletedRecord) {
                    this.update((BranchCompletedRecord)eventRecord);
                } else if (eventRecord instanceof ProcessInstanceStartedRecord) {
                    this.update((ProcessInstanceStartedRecord)eventRecord);
                } else if (eventRecord instanceof ProcessInstanceCompletedRecord) {
                    this.update((ProcessInstanceCompletedRecord)eventRecord);
                }
                bl = true;
            }
        }
        if (bl) {
            this.fireModelUpdated();
        }
    }

    private void update(ActivityStartedRecord activityStartedRecord) {
        PsmEntity psmEntity = this.myPsm.find(activityStartedRecord.getActivityXpath());
        if (psmEntity == null) {
            return;
        }
        BranchImpl branchImpl = this.myBranches.get(activityStartedRecord.getBranchId());
        if (branchImpl == null) {
            return;
        }
        branchImpl.activityStarted(psmEntity);
    }

    private void update(ActivityCompletedRecord activityCompletedRecord) {
        PsmEntity psmEntity = this.myPsm.find(activityCompletedRecord.getActivityXpath());
        if (psmEntity == null) {
            return;
        }
        BranchImpl branchImpl = this.myBranches.get(activityCompletedRecord.getBranchId());
        if (branchImpl == null) {
            return;
        }
        branchImpl.activityCompleted(psmEntity);
    }

    private void update(ActivityTerminatedRecord activityTerminatedRecord) {
        PsmEntity psmEntity = this.myPsm.find(activityTerminatedRecord.getActivityXpath());
        if (psmEntity == null) {
            return;
        }
        BranchImpl branchImpl = this.myBranches.get(activityTerminatedRecord.getBranchId());
        if (branchImpl == null) {
            return;
        }
        branchImpl.activityTerminated(psmEntity);
    }

    private void update(BranchStartedRecord branchStartedRecord) {
        BranchImpl branchImpl;
        BranchImpl branchImpl2;
        String string = branchStartedRecord.getParentBranchId();
        BranchImpl branchImpl3 = null;
        if (string != null) {
            branchImpl3 = this.myBranches.get(string);
        }
        if ((branchImpl2 = (branchImpl = new BranchImpl(branchStartedRecord.getBranchId(), branchImpl3)).getParent()) == null && this.myCurrentBranch == null || branchImpl2 != null && branchImpl2.equals(this.myCurrentBranch)) {
            this.myCurrentBranch = branchImpl;
        }
        branchImpl.setState(ProcessExecutionModel.Branch.State.ACTIVE);
        this.myBranches.put(branchStartedRecord.getBranchId(), branchImpl);
    }

    private void update(BranchCompletedRecord branchCompletedRecord) {
        BranchImpl branchImpl = this.myBranches.get(branchCompletedRecord.getBranchId());
        if (branchImpl != null) {
            branchImpl.setState(ProcessExecutionModel.Branch.State.COMPLETED);
            if (this.myCurrentBranch != null && branchImpl.equals(this.myCurrentBranch)) {
                this.myCurrentBranch = branchImpl.getParent();
                if (this.myCurrentBranch == null) {
                    for (BranchImpl branchImpl2 : this.myBranches.values()) {
                        if (branchImpl2.getParent() != null || branchImpl2.getState() != ProcessExecutionModel.Branch.State.ACTIVE) continue;
                        this.myCurrentBranch = branchImpl2;
                        break;
                    }
                }
            }
        }
    }

    private void update(ProcessInstanceStartedRecord processInstanceStartedRecord) {
        PsmEntity psmEntity = this.myPsm.getRoot();
        this.myRoot = this.createEntity(psmEntity, null, true);
        this.myRoot.setState(PemEntity.State.STARTED);
        this.myRoot.setLastStartedEventIndex(this.myLastEventIndex);
    }

    private void update(ProcessInstanceCompletedRecord processInstanceCompletedRecord) {
        this.myRoot.setState(PemEntity.State.COMPLETED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireModelUpdated() {
        ProcessExecutionModel.Listener[] listenerArray = this.myListeners;
        synchronized (this.myListeners) {
            ProcessExecutionModel.Listener[] listenerArray2 = this.myListeners.toArray(new ProcessExecutionModel.Listener[this.myListeners.size()]);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            for (ProcessExecutionModel.Listener listener : listenerArray2) {
                listener.modelUpdated();
            }
            return;
        }
    }

    private PemEntityImpl createEntity(PsmEntity psmEntity, String string, boolean bl) {
        if (psmEntity.isLoop()) {
            return new PemLoopEntityImpl(this, psmEntity, string, bl);
        }
        return new PemNonLoopEntityImpl(this, psmEntity, string, bl);
    }

    private PemEntityImpl[] find(PsmEntity psmEntity) {
        LinkedList<PemEntityImpl> linkedList = new LinkedList<PemEntityImpl>();
        LinkedList<PemEntityImpl> linkedList2 = new LinkedList<PemEntityImpl>();
        linkedList.offer(this.myRoot);
        while (linkedList.peek() != null) {
            PemEntityImpl pemEntityImpl = (PemEntityImpl)linkedList.poll();
            if (pemEntityImpl.getPsmEntity().equals(psmEntity)) {
                linkedList2.add(pemEntityImpl);
            }
            for (PemEntityImpl pemEntityImpl2 : pemEntityImpl.getChildren()) {
                linkedList.offer(pemEntityImpl2);
            }
        }
        return linkedList2.toArray(new PemEntityImpl[linkedList2.size()]);
    }

    private class EventLogListener
    implements EventLog.Listener {
        private EventLogListener() {
        }

        public void recordAdded(EventRecord eventRecord) {
            ProcessExecutionModelImpl.this.update();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BranchImpl
    implements ProcessExecutionModel.Branch {
        private String myId;
        private BranchImpl myParent;
        private Stack<PemEntityImpl> myCallStack = new Stack();
        private ProcessExecutionModel.Branch.State myState;

        public BranchImpl(String string, BranchImpl branchImpl) {
            this.myId = string;
            this.myParent = branchImpl;
        }

        public String getId() {
            return this.myId;
        }

        public BranchImpl getParent() {
            return this.myParent;
        }

        public ProcessExecutionModel.Branch.State getState() {
            return this.myState;
        }

        public PemEntityImpl getCurrentActivity() {
            if (!this.myCallStack.empty()) {
                return this.myCallStack.peek();
            }
            return null;
        }

        public Stack<PemEntity> getCallStack() {
            Stack<PemEntity> stack = new Stack<PemEntity>();
            stack.addAll(this.myCallStack);
            return stack;
        }

        public void activityStarted(PsmEntity psmEntity) {
            PsmEntity psmEntity2 = psmEntity.getParent();
            PemEntityImpl pemEntityImpl = ProcessExecutionModelImpl.this.createEntity(psmEntity, this.myId, true);
            String string = psmEntity2.getTag();
            if (string.equals("compensationHandler") || string.equals("terminationHandler")) {
                PsmEntity psmEntity3 = psmEntity2;
                PsmEntity psmEntity4 = psmEntity2.getParent();
                PemEntityImpl pemEntityImpl2 = ProcessExecutionModelImpl.this.createEntity(psmEntity3, this.myId, true);
                pemEntityImpl2.addChild(pemEntityImpl);
                PemEntityImpl[] pemEntityImplArray = ProcessExecutionModelImpl.this.find(psmEntity4);
                if (pemEntityImplArray.length == 0) {
                    return;
                }
                PemEntityImpl pemEntityImpl3 = pemEntityImplArray[0];
                for (int i = 1; i < pemEntityImplArray.length; ++i) {
                    if (pemEntityImplArray[i].getIndex() <= pemEntityImpl3.getIndex() || pemEntityImplArray[i].getChildren(psmEntity3).length != 0) continue;
                    pemEntityImpl3 = pemEntityImplArray[i];
                }
                pemEntityImpl3.addChild(pemEntityImpl2);
                this.myCallStack.push(pemEntityImpl2);
            } else if (!this.myCallStack.empty()) {
                PemEntityImpl pemEntityImpl4 = this.myCallStack.peek();
                if (pemEntityImpl4.getPsmEntity() == psmEntity) {
                    ProcessExecutionModelImpl.this.myLastStartedEntity = pemEntityImpl4;
                    return;
                }
                PemEntityImpl pemEntityImpl5 = this.buildSyntheticEntities(pemEntityImpl4, pemEntityImpl);
                if (pemEntityImpl5 != null) {
                    if (pemEntityImpl5.getPsmEntity().getTag().equals("faultHandlers")) {
                        this.addEventHandlersToParent(pemEntityImpl5);
                    } else {
                        pemEntityImpl4.addChild(pemEntityImpl5);
                    }
                }
            } else if (this.myParent == null) {
                if (psmEntity.getTag().equals("onAlarm") || psmEntity.getTag().equals("onEvent")) {
                    PemEntityImpl pemEntityImpl6;
                    PemEntityImpl[] pemEntityImplArray = ProcessExecutionModelImpl.this.find(psmEntity2);
                    if (pemEntityImplArray.length == 0) {
                        pemEntityImpl6 = ProcessExecutionModelImpl.this.createEntity(psmEntity2, this.myId, true);
                        pemEntityImplArray = ProcessExecutionModelImpl.this.find(psmEntity2.getParent());
                        if (pemEntityImplArray.length == 0) {
                            return;
                        }
                        PemEntityImpl pemEntityImpl7 = pemEntityImplArray[0];
                        for (int i = 1; i < pemEntityImplArray.length; ++i) {
                            if (pemEntityImplArray[i].getIndex() <= pemEntityImpl7.getIndex() || pemEntityImplArray[i].getChildren(psmEntity).length != 0) continue;
                            pemEntityImpl7 = pemEntityImplArray[i];
                        }
                        pemEntityImpl7.addChild(pemEntityImpl6);
                    } else {
                        pemEntityImpl6 = pemEntityImplArray[0];
                    }
                    pemEntityImplArray = pemEntityImpl6.getChildren(psmEntity);
                    if (pemEntityImplArray.length == 0) {
                        pemEntityImpl6.addChild(pemEntityImpl);
                    } else {
                        pemEntityImpl = pemEntityImplArray[0];
                    }
                    this.myCallStack.push(pemEntityImpl6);
                } else {
                    ProcessExecutionModelImpl.this.myRoot.addChild(pemEntityImpl);
                }
            } else if (psmEntity2.getTag().equals("flow")) {
                this.myParent.getCurrentActivity().addChild(pemEntityImpl);
            }
            pemEntityImpl.setState(PemEntity.State.STARTED);
            pemEntityImpl.setLastStartedEventIndex(ProcessExecutionModelImpl.this.myLastEventIndex);
            ProcessExecutionModelImpl.this.myLastStartedEntity = pemEntityImpl;
            this.myCallStack.push(pemEntityImpl);
        }

        public void activityCompleted(PsmEntity psmEntity) {
            PemEntityImpl pemEntityImpl;
            if (!this.myCallStack.isEmpty() && (pemEntityImpl = this.myCallStack.peek()).getPsmEntity() == psmEntity) {
                this.myCallStack.pop();
                if (pemEntityImpl == ProcessExecutionModelImpl.this.myLastStartedEntity) {
                    ProcessExecutionModelImpl.this.myLastStartedEntity = null;
                }
                pemEntityImpl.setState(PemEntity.State.COMPLETED);
                if (this.myCallStack.size() == 0) {
                    return;
                }
                pemEntityImpl = this.myCallStack.peek();
                String string = pemEntityImpl.getPsmEntity().getTag();
                if (string.equals("terminationHandler") || string.equals("compensationHandler") || string.equals("eventHandlers")) {
                    this.myCallStack.pop();
                    pemEntityImpl.setState(PemEntity.State.COMPLETED);
                }
            }
        }

        public void activityTerminated(PsmEntity psmEntity) {
            if (!this.myCallStack.isEmpty()) {
                PsmEntity psmEntity2 = this.myCallStack.peek().getPsmEntity();
                while (psmEntity2 != null && psmEntity2.getXpath().startsWith(psmEntity.getXpath())) {
                    PemEntityImpl pemEntityImpl = this.myCallStack.pop();
                    pemEntityImpl.setState(PemEntity.State.COMPLETED);
                    if (this.myCallStack.isEmpty()) {
                        psmEntity2 = null;
                        continue;
                    }
                    psmEntity2 = this.myCallStack.peek().getPsmEntity();
                }
            }
        }

        private void setState(ProcessExecutionModel.Branch.State state) {
            this.myState = state;
        }

        private PemEntityImpl findInCallStack(PsmEntity psmEntity) {
            if (this.myCallStack.isEmpty()) {
                return null;
            }
            for (PemEntityImpl pemEntityImpl : this.myCallStack) {
                if (pemEntityImpl.getPsmEntity() != psmEntity) continue;
                return pemEntityImpl;
            }
            return null;
        }

        private PemEntityImpl findInUpperCallStacks(PsmEntity psmEntity) {
            PemEntityImpl pemEntityImpl = this.findInCallStack(psmEntity);
            if (pemEntityImpl != null) {
                return pemEntityImpl;
            }
            if (this.myParent != null) {
                return this.myParent.findInUpperCallStacks(psmEntity);
            }
            return null;
        }

        private PemEntityImpl buildSyntheticEntities(PemEntityImpl pemEntityImpl, PemEntityImpl pemEntityImpl2) {
            PemEntityImpl pemEntityImpl3 = pemEntityImpl2;
            while (pemEntityImpl3.getPsmEntity().getParent() != pemEntityImpl.getPsmEntity()) {
                PsmEntity psmEntity = pemEntityImpl3.getPsmEntity().getParent();
                if (psmEntity == null) {
                    return null;
                }
                PemEntityImpl pemEntityImpl4 = ProcessExecutionModelImpl.this.createEntity(psmEntity, this.myId, false);
                pemEntityImpl4.addChild(pemEntityImpl3);
                pemEntityImpl3 = pemEntityImpl4;
                if (!psmEntity.getTag().equals("faultHandlers")) continue;
                break;
            }
            return pemEntityImpl3;
        }

        private void addEventHandlersToParent(PemEntityImpl pemEntityImpl) {
            PemEntityImpl pemEntityImpl2 = pemEntityImpl.getPsmEntity().getParent().getTag().equals("process") ? ProcessExecutionModelImpl.this.myRoot : this.findInUpperCallStacks(pemEntityImpl.getPsmEntity().getParent());
            if (pemEntityImpl2 != null) {
                pemEntityImpl2.addChild(pemEntityImpl);
            }
        }
    }
}

